/*
 * Decompiled with CFR 0.152.
 */
package cc.jmap.games;

import cc.jmap.games.Actor;
import cc.jmap.games.GameEngine;
import cc.jmap.games.GameObject;
import cc.jmap.games.I18NResource;
import cc.jmap.games.JumpUpMidlet;
import cc.jmap.games.Platform;
import cc.jmap.games.SoundPlayer;
import java.util.Random;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import javax.microedition.lcdui.game.GameCanvas;

public class GameLogic {
    public static final boolean DEBUG = false;
    public static final int SCREEN_HEIGHT = 680;
    public static final int SCREEN_WIDTH = 360;
    public static int platScreenTopIndex = 0;
    public static int platScreenBotIndex = 0;
    public static int platNextUpdateIndex = 0;
    public static final int PLATFORM_SIZE = 25;
    public static Platform[] platforms = new Platform[25];
    public static int height = 0;
    public static int bonusScore = 0;
    public static int gameOverScore = 0;
    public static int gameOverHeight = 0;
    public static GameLogic instance = null;
    public static final int STATE_GAME_GO_BFORE_PLAY = 0;
    public static final int STATE_GAME_PLAY = 1;
    public static final int STATE_GAME_PLAY_PAUSED = 2;
    public static final int STATE_GAME_ENDING = 3;
    public static final int STATE_GAME_END = 4;
    public static int state = 1;
    private static boolean goShown = false;
    public static Actor actor = new Actor();
    public static long startTime = 0L;
    public static long pauseTime = 0L;
    static Random ran = new Random();
    final int stepH;
    private int oldState;
    public static long now = 0L;
    private long goTimeStamp = 0L;
    private int goCount = 0;
    private int[] goIndexes;
    private int diffStageH;

    public GameLogic() {
        this.stepH = 50;
        int[] nArray = new int[4];
        nArray[1] = 1;
        nArray[2] = 2;
        nArray[3] = 1;
        this.goIndexes = nArray;
        this.diffStageH = 0;
        instance = this;
        this.createPlatforms();
    }

    public static void setGameOverScore() {
        gameOverScore = height * 3 / 10 + bonusScore;
        gameOverHeight = height - 1000;
    }

    public static void restartGame() {
        if (state == 4) {
            instance.GoToPlay();
            System.out.println("GmaeLogic restartGame()");
        }
    }

    public static void backToMenu() {
        if (state == 4 || state == 2) {
            JumpUpMidlet.instance.gotoMain();
        }
    }

    public static void uploadScore() {
        JumpUpMidlet.submitScore(gameOverScore);
    }

    public void pauseGame() {
        if (state == 1) {
            this.oldState = state;
            state = 2;
            SoundPlayer.pause();
            JumpUpMidlet.engine.pauseEngine();
            GameEngine.repaint();
        }
    }

    public void resumeGame() {
        if (state == 2) {
            state = this.oldState;
            SoundPlayer.resume();
            JumpUpMidlet.engine.resumeEngine();
            GameEngine.repaint();
            System.out.println("GmaeLogic resumeGame()");
        }
    }

    public void startGame() {
        if (goShown) {
            this.GoToPlay();
            return;
        }
        state = 0;
        goShown = true;
        GameEngine.repaint();
    }

    public void GoToPlay() {
        platScreenTopIndex = 0;
        platScreenBotIndex = 0;
        platNextUpdateIndex = 0;
        height = 0;
        gameOverScore = 0;
        bonusScore = 0;
        gameOverHeight = 0;
        pauseTime = 0L;
        this.initPlatformsData();
        actor.reset();
        Platform.reset();
        startTime = System.currentTimeMillis();
        state = 1;
        SoundPlayer.playFile(4);
        JumpUpMidlet.instance.openSensor();
    }

    public void endGame() {
        state = 4;
        JumpUpMidlet.instance.closeSensor();
    }

    public int getState() {
        return state;
    }

    public void createPlatforms() {
        if (platforms[0] == null) {
            int i = 0;
            while (i < 25) {
                GameLogic.platforms[i] = new Platform(i, 0, 180, 0);
                ++i;
            }
        }
    }

    public void initPlatformsData() {
        int prevX = 0;
        platScreenBotIndex = 0;
        platforms[0].setValues(0, 0, 180, 10);
        platforms[1].setValues(1, 0, 110, 50);
        platforms[2].setValues(2, 0, 250, 100);
        platforms[3].setValues(3, 0, 40, 150);
        Platform cfr_ignored_0 = platforms[0];
        Platform.ran.setSeed(System.currentTimeMillis());
        int i = 4;
        while (i < 25) {
            int posX = 180 + (ran.nextInt(280) - 130);
            int diff = posX - prevX;
            if (diff < 35 && diff > -35) {
                posX = (posX + 100) % 360;
            }
            if (posX < 40) {
                posX += 42;
            } else if (posX > 320) {
                posX -= 42;
            }
            platforms[i].setValues(i, 0, posX, i * 50);
            prevX = posX;
            ++i;
        }
        platScreenTopIndex = 14;
    }

    public void renewPlatforms(int oldPlatScreenBotIndex, int newPlatScreenBotIndex) {
        long i = oldPlatScreenBotIndex;
        while (i < (long)newPlatScreenBotIndex) {
            int idx = (int)i % 25;
            int prevIdx = (int)(i + 25L - 1L) % 25;
            Platform p = platforms[(int)i % 25];
            p.refreshNextPlatform(idx, prevIdx);
            ++i;
        }
    }

    public void drawPlatform(Graphics g, GameCanvas canvas) {
        int tmp_top = -1;
        int tmp_bottom = -1;
        int oldPlatScreenBotIndex = platScreenBotIndex;
        int i = platScreenTopIndex + 2;
        while (i >= platScreenBotIndex) {
            Platform p = platforms[i % 25];
            if (p.posH >= height - 64 && p.posH <= height + 640 + 30) {
                if (tmp_top == -1) {
                    tmp_top = i;
                }
                tmp_bottom = i;
                p.draw(g, canvas);
            }
            --i;
        }
        if (height >= 250 && tmp_top != -1 && tmp_bottom != -1) {
            platScreenTopIndex = tmp_top;
            platScreenBotIndex = tmp_bottom;
        }
        if (height >= 250 && platScreenBotIndex != oldPlatScreenBotIndex) {
            int lastH = 1250;
            int idx = (oldPlatScreenBotIndex - 1) % 25;
            this.renewPlatforms(oldPlatScreenBotIndex, platScreenBotIndex);
        }
    }

    public void drawBackground(Graphics g, GameCanvas canvas) {
        int ht = height + 160000;
        int h = ht / 4 % 320;
        int bt = ht / 1280;
        Image bg0 = GameObject.bgImgs[(bt + 3) % 6];
        Image bg1 = GameObject.bgImgs[(bt + 2) % 6];
        Image bg2 = GameObject.bgImgs[(bt + 1) % 6];
        Image bg3 = GameObject.bgImgs[(bt + 0) % 6];
        g.drawImage(bg0, 0, h - 320, 20);
        g.drawImage(bg1, 0, h + 0, 20);
        g.drawImage(bg2, 0, h + 320, 20);
        g.drawImage(bg3, 0, h + 640, 20);
    }

    public void drawActor(Graphics g, GameCanvas canvas) {
        actor.draw(g, canvas);
    }

    public void drawScore(Graphics g, GameCanvas canvas) {
        this.drawScore(g, canvas, 360, 10);
    }

    public void drawScore(Graphics g, GameCanvas canvas, int x, int y) {
        int sco = height * 3 / 10 + bonusScore;
        if (actor.getState() == 2) {
            sco = gameOverScore;
        }
        if (sco >= 1000000) {
            g.drawImage(GameObject.scoreImgs[sco / 1000000 % 10], x - 240, y, 20);
            g.drawImage(GameObject.scoreImgs[sco / 100000 % 10], x - 240, y, 20);
            g.drawImage(GameObject.scoreImgs[sco / 10000 % 10], x - 200, y, 20);
            g.drawImage(GameObject.scoreImgs[sco / 1000 % 10], x - 160, y, 20);
            g.drawImage(GameObject.scoreImgs[sco / 100 % 10], x - 120, y, 20);
            g.drawImage(GameObject.scoreImgs[sco / 10 % 10], x - 80, y, 20);
            g.drawImage(GameObject.scoreImgs[sco % 10], x - 40, y, 20);
        } else if (sco >= 100000) {
            g.drawImage(GameObject.scoreImgs[sco / 100000 % 10], x - 240, y, 20);
            g.drawImage(GameObject.scoreImgs[sco / 10000 % 10], x - 200, y, 20);
            g.drawImage(GameObject.scoreImgs[sco / 1000 % 10], x - 160, y, 20);
            g.drawImage(GameObject.scoreImgs[sco / 100 % 10], x - 120, y, 20);
            g.drawImage(GameObject.scoreImgs[sco / 10 % 10], x - 80, y, 20);
            g.drawImage(GameObject.scoreImgs[sco % 10], x - 40, y, 20);
        } else if (sco >= 10000) {
            g.drawImage(GameObject.scoreImgs[sco / 10000 % 10], x - 200, y, 20);
            g.drawImage(GameObject.scoreImgs[sco / 1000 % 10], x - 160, y, 20);
            g.drawImage(GameObject.scoreImgs[sco / 100 % 10], x - 120, y, 20);
            g.drawImage(GameObject.scoreImgs[sco / 10 % 10], x - 80, y, 20);
            g.drawImage(GameObject.scoreImgs[sco % 10], x - 40, y, 20);
        } else if (sco >= 1000) {
            g.drawImage(GameObject.scoreImgs[sco / 1000 % 10], x - 160, y, 20);
            g.drawImage(GameObject.scoreImgs[sco / 100 % 10], x - 120, y, 20);
            g.drawImage(GameObject.scoreImgs[sco / 10 % 10], x - 80, y, 20);
            g.drawImage(GameObject.scoreImgs[sco % 10], x - 40, y, 20);
        } else if (sco >= 100) {
            g.drawImage(GameObject.scoreImgs[sco / 100 % 10], x - 120, y, 20);
            g.drawImage(GameObject.scoreImgs[sco / 10 % 10], x - 80, y, 20);
            g.drawImage(GameObject.scoreImgs[sco % 10], x - 40, y, 20);
        } else if (sco >= 10) {
            g.drawImage(GameObject.scoreImgs[sco / 10 % 10], x - 80, y, 20);
            g.drawImage(GameObject.scoreImgs[sco % 10], x - 40, y, 20);
        } else {
            g.drawImage(GameObject.scoreImgs[sco], x - 40, y, 20);
        }
    }

    public void drawSoundBtn(Graphics g, GameCanvas canvas) {
        g.drawImage(GameObject.iconImgs[4], 10, 10, 20);
        Image mimg = null;
        mimg = SoundPlayer.musicFlag ? GameObject.iconImgs[1] : GameObject.iconImgs[0];
        g.drawImage(mimg, 260, 60, 20);
        Image simg = null;
        simg = SoundPlayer.soundFlag ? GameObject.iconImgs[3] : GameObject.iconImgs[2];
        g.drawImage(simg, 310, 60, 20);
    }

    public void drawGameOverBtn(Graphics g, GameCanvas canvas) {
        Image aimg = GameObject.gameOverImgs[1];
        g.drawImage(aimg, 0, 640 - aimg.getHeight(), 20);
        aimg = GameObject.gameOverImgs[2];
        g.drawImage(aimg, (360 - aimg.getWidth()) / 2, 640 - aimg.getHeight(), 20);
        aimg = GameObject.gameOverImgs[3];
        g.drawImage(aimg, 360 - aimg.getWidth(), 640 - aimg.getHeight(), 20);
    }

    public void drawGameOver(Graphics g, GameCanvas canvas) {
        if (actor.getState() == 2 && this.diffStageH <= 0) {
            Image aimg = GameObject.gameOverImgs[0];
            g.drawImage(aimg, (360 - aimg.getWidth()) / 2, height - gameOverHeight + 100, 20);
            aimg = GameObject.gameOverImgs[4];
            g.drawImage(aimg, (360 - aimg.getWidth()) / 2, height - gameOverHeight + 260, 20);
            int x = 20;
            int sco = gameOverScore;
            if (sco < 10) {
                x = 200;
            } else if (sco < 100) {
                x = 220;
            } else if (sco < 1000) {
                x = 240;
            } else if (sco < 10000) {
                x = 260;
            } else if (sco < 100000) {
                x = 280;
            } else if (sco < 1000000) {
                x = 300;
            } else if (sco < 10000000) {
                x = 320;
            }
            this.drawScore(g, canvas, x, height - gameOverHeight + 305);
            if (height - gameOverHeight == 0) {
                this.drawGameOverBtn(g, canvas);
                this.endGame();
            }
        }
    }

    public void drawPause(Graphics g, GameCanvas canvas) {
        Image aimg = I18NResource.i18Imgs[8];
        g.drawImage(aimg, (360 - aimg.getWidth()) / 2, (640 - aimg.getHeight()) / 2, 20);
        Font font = Font.getFont((int)0, (int)0, (int)8);
    }

    public void drawGo(Graphics g, GameCanvas canvas) {
        if (now > this.goTimeStamp && this.goCount < 10) {
            this.goTimeStamp = now + 600L;
            ++this.goCount;
        }
        int index = this.goIndexes[this.goCount % this.goIndexes.length];
        Image aimg = GameObject.goImgs[index];
        g.drawImage(aimg, (360 - aimg.getWidth()) / 2, (640 - aimg.getHeight()) / 2, 20);
        aimg = I18NResource.i18Imgs[9];
        g.drawImage(aimg, (360 - aimg.getWidth()) / 2, 147, 20);
    }

    public void step() {
        if (actor.getState() == 0 || actor.getState() == 1) {
            if (actor.getState() == 0) {
                this.checkHit();
            }
            actor.step();
            long i = platScreenTopIndex;
            while (i >= (long)platScreenBotIndex) {
                Platform p = platforms[(int)i % 25];
                if (p.posH >= height && p.posH <= height + 640 + 30 && p.ptype == 2) {
                    p.step();
                }
                --i;
            }
            this.checkJump();
            actor.checkFall();
            this.moveStage();
        } else if (actor.getState() == 2) {
            actor.step();
            this.moveStage();
        }
    }

    public void checkJump() {
        if (actor.isDown() && actor.getState() == 0) {
            long i = platScreenTopIndex;
            while (i >= (long)platScreenBotIndex) {
                boolean ret;
                Platform p = platforms[(int)i % 25];
                if (p.posH >= height && p.posH <= height + 640 + 30 && (ret = actor.checkBounce(p))) {
                    return;
                }
                --i;
            }
        }
    }

    public void checkHit() {
        long i = platScreenTopIndex;
        while (i >= (long)platScreenBotIndex) {
            boolean ret;
            Platform p = platforms[(int)i % 25];
            if (p.enemy != -1 && (ret = actor.checkHit(p))) {
                return;
            }
            if (p.bonus != -1 && (ret = actor.checkEat(p))) {
                return;
            }
            --i;
        }
    }

    private void moveStage() {
        if (actor.getState() == 2 || actor.getState() == 1) {
            int diff = GameLogic.actor.posH - height;
            int h = (diff - -100) / 3;
            if (h > 25) {
                h = 25;
            } else if (h < -90) {
                h = -90;
            }
            this.diffStageH = h;
            if ((height += h) < gameOverHeight) {
                height = gameOverHeight;
                GameLogic.actor.velocityH = 0;
            }
        } else if (actor.getState() == 0) {
            int diff = GameLogic.actor.posH - height;
            int h = (diff - 250) / 3;
            if (h > 44) {
                h = 44;
            } else if (h < 0) {
                h = 0;
            }
            height += h;
        }
    }

    public void paint(Graphics g, GameCanvas canvas) {
        now = System.currentTimeMillis();
        if (state == 4) {
            return;
        }
        if (state == 0) {
            this.drawBackground(g, canvas);
            this.drawGo(g, canvas);
            return;
        }
        if (state != 2 && state != 0) {
            this.step();
        }
        this.drawBackground(g, canvas);
        this.drawPlatform(g, canvas);
        this.drawActor(g, canvas);
        if (actor.getState() == 0) {
            this.drawScore(g, canvas);
            this.drawSoundBtn(g, canvas);
        }
        this.drawGameOver(g, canvas);
        if (state == 2) {
            this.drawPause(g, canvas);
        }
    }

    public int getHeight() {
        return height;
    }
}

