/*
 * Decompiled with CFR 0.152.
 */
package cc.jmap.games;

import cc.jmap.games.GCanvas;
import cc.jmap.games.GameLogic;
import cc.jmap.games.ParatrooperMidlet;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Graphics;

public class GameEngine
implements Runnable {
    private GCanvas canvas;
    private int fps;
    private static GameEngine instance = null;
    GameLogic logic;
    private Thread thread = null;
    private boolean pauseEngineFlag = true;
    private boolean threadRunning = true;
    public static double currentFps = 0.0;
    private int fpscount = 0;

    public GameEngine(int fps) {
        instance = this;
        this.canvas = new GCanvas();
        this.fps = fps;
        this.logic = new GameLogic();
        this.logic.initLevel();
        this.threadRunning = true;
        this.pauseEngineFlag = true;
        this.thread = new Thread(this);
        this.thread.start();
    }

    public Displayable getDrawingArea() {
        return this.canvas;
    }

    public void startEngine() {
        this.fpscount = 0;
        this.pauseEngineFlag = false;
    }

    public void stopEngine() {
        try {
            this.threadRunning = false;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void resumeEngine() {
        this.pauseEngineFlag = false;
        this.fpscount = 0;
    }

    public void pauseEngine() {
        this.pauseEngineFlag = true;
        this.logic.pauseGame();
    }

    public void paint(Graphics g) {
        int keys = this.canvas.getKeyStates();
        if (keys != 2) {
            if (keys == 32) {
                GameLogic.sensorValue += 8;
            } else if (keys == 4) {
                GameLogic.sensorValue -= 8;
            }
        }
        this.logic.paint(g, this.canvas);
    }

    public static void repaint() {
        if (instance != null) {
            instance.paint(GameEngine.instance.canvas.getGraphics());
            GameEngine.instance.canvas.flushGraphics();
        }
    }

    public void checkPause() {
        long now = System.currentTimeMillis();
        if (now - ParatrooperMidlet.gameDisplaytime < 1000L) {
            return;
        }
        if (now - GameLogic.startTime <= 5000L && GameLogic.playerMode != 0) {
            return;
        }
        if (GameLogic.state == 1 || GameLogic.state == 5) {
            if (!this.pauseEngineFlag && !this.canvas.isShown()) {
                this.pauseEngineFlag = true;
                GameLogic.instance.pauseGame();
                GameLogic.pauseTime = System.currentTimeMillis();
            } else if (this.pauseEngineFlag && this.canvas.isShown()) {
                this.pauseEngineFlag = false;
                GameLogic.instance.resumeGame();
                if (GameLogic.pauseTime > 0L) {
                    now = System.currentTimeMillis();
                    GameLogic.startTime += now - GameLogic.pauseTime;
                    GameLogic.pauseTime = 0L;
                }
            }
        }
    }

    /*
     * Exception decompiling
     */
    public void run() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }
}

