/*
 * Decompiled with CFR 0.152.
 */
package cc.jmap.games;

import cc.jmap.games.Actor;
import cc.jmap.games.GameLogic;
import cc.jmap.games.GameObject;
import cc.jmap.games.GameSync;
import cc.jmap.games.net.GameCommand;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import javax.microedition.lcdui.game.GameCanvas;

public class Flying
extends GameObject {
    public static final int FEA_NO = 6;
    public static final int UFO_NO = 8;
    public static final int CRATE_NO = 2;
    public static final int TOTAL_NO = 16;
    static Flying[] flyings = new Flying[16];
    public static final int TYPE_FEATHER = 0;
    public static final int TYPE_UFO = 1;
    public static final int TYPE_CRATE = 2;
    private int type = 0;
    public static final int MOTION_TYPE_FLOAT = 0;
    public static final int MOTION_TYPE_UP_DIRECT = 1;
    public static final int MOTION_TYPE_UP_SLOW_FAST = 2;
    public static final int MOTION_TYPE_TRIANGLE = 3;
    public static final int MOTION_TYPE_SINE_STOP = 4;
    public static final int MOTION_TYPE_CIRCLE_WAVE = 5;
    private int motion = 0;
    public static final int IMG_CRATE_START = 0;
    public static final int IMG_CRATE_NO = 1;
    public static final int IMG_FEATHER_START = 1;
    public static final int IMG_FEATHER_NO = 5;
    public static final int IMG_UFO_START = 6;
    public static final int IMG_UFO_NO = 6;
    public static final int IMG_FLASH = 12;
    private int img_index = 0;
    private int id = 0;
    private static final int IMG_FEATHERS_NO = 10;
    private static final int[] IMG_FEATHERS;
    public static int featherEnableCount;
    public static int featherEnableLimit;
    private static long featherNextEnableTime;
    public static int ufoEnableCount;
    public static int ufoEnableLimit;
    private static long ufoNextEnableTime;
    public static int crateEnableCount;
    public static int crateEnableLimit;
    private static long crateNextEnableTime;
    private int posH = 110;
    private long height = 0L;
    private boolean enable = false;
    private double motionSpeed1 = 10.0;
    private double motionSpeed2 = 10.0;
    private double motionV1 = 100.0;
    private double motionV2 = 100.0;
    private double motionV3 = 1000.0;
    private double motionV4 = 1000.0;
    private int renderCount = 0;
    private static final int[] F_NUM;
    private static final int[] F_NXT_TIME;
    private static final int[][] F_RAN;
    private static final int[] U_NUM;
    private static final int[] U_NXT_TIME;
    private static final int[][] U_RAN;

    static {
        int[] nArray = new int[10];
        nArray[1] = 1;
        nArray[2] = 2;
        nArray[3] = 3;
        nArray[4] = 4;
        nArray[5] = 4;
        nArray[6] = 3;
        nArray[7] = 2;
        nArray[8] = 1;
        IMG_FEATHERS = nArray;
        featherEnableCount = 0;
        featherEnableLimit = 6;
        featherNextEnableTime = 0L;
        ufoEnableCount = 0;
        ufoEnableLimit = 6;
        ufoNextEnableTime = 0L;
        crateEnableCount = 0;
        crateEnableLimit = 1;
        crateNextEnableTime = 0L;
        F_NUM = new int[]{1, 2, 2, 2, 3, 3, 3, 4, 4, 4};
        F_NXT_TIME = new int[]{30, 25, 25, 25, 25, 25, 25, 25, 20, 30};
        int[][] nArrayArray = new int[10][];
        nArrayArray[0] = new int[]{100, 100};
        nArrayArray[1] = new int[]{80, 100};
        nArrayArray[2] = new int[]{70, 100};
        nArrayArray[3] = new int[]{50, 100};
        nArrayArray[4] = new int[]{50, 100};
        nArrayArray[5] = new int[]{40, 100};
        nArrayArray[6] = new int[]{30, 100};
        nArrayArray[7] = new int[]{30, 100};
        nArrayArray[8] = new int[]{20, 100};
        int[] nArray2 = new int[2];
        nArray2[1] = 100;
        nArrayArray[9] = nArray2;
        F_RAN = nArrayArray;
        U_NUM = new int[]{1, 2, 3, 4, 5, 6, 7, 8, 8, 8};
        U_NXT_TIME = new int[]{15, 15, 15, 12, 10, 10, 10, 10, 10, 8};
        U_RAN = new int[][]{{100, 100, 100, 100, 100}, {50, 100, 100, 100, 100}, {30, 70, 100, 100, 100}, {25, 50, 80, 100, 100}, {20, 40, 60, 80, 100}, {5, 20, 60, 80, 100}, {5, 30, 70, 85, 100}, {10, 30, 40, 85, 100}, {10, 30, 50, 70, 100}, {10, 40, 80, 90, 100}};
    }

    static void initAll() {
        int i = 0;
        while (i < 6) {
            Flying.flyings[i] = new Flying(0);
            Flying.flyings[i].height = 500000 * i;
            Flying.flyings[i].posX = 180;
            Flying.flyings[i].posH = GameLogic.getPosYFromH(Flying.flyings[i].height);
            Flying.flyings[i].enable = false;
            Flying.flyings[i].img_index = 1;
            Flying.flyings[i].id = i;
            ++i;
        }
        i = 6;
        while (i < 14) {
            Flying.flyings[i] = new Flying(1);
            Flying.flyings[i].height = 500000 * i;
            Flying.flyings[i].posX = 180;
            Flying.flyings[i].posH = GameLogic.getPosYFromH(Flying.flyings[i].height);
            Flying.flyings[i].enable = false;
            Flying.flyings[i].img_index = 6;
            Flying.flyings[i].id = i;
            ++i;
        }
        i = 14;
        while (i < 16) {
            Flying.flyings[i] = new Flying(2);
            Flying.flyings[i].height = 500000 * i;
            Flying.flyings[i].posX = 180;
            Flying.flyings[i].posH = GameLogic.getPosYFromH(Flying.flyings[i].height);
            Flying.flyings[i].enable = false;
            Flying.flyings[i].img_index = 0;
            Flying.flyings[i].id = i;
            ++i;
        }
        featherNextEnableTime = GameLogic.now + 5000L;
        ufoNextEnableTime = GameLogic.now + 15000L;
        if (GameLogic.playerMode != 0) {
            crateNextEnableTime = GameLogic.now + 25000L;
        }
    }

    static void resetAll() {
        int i = 0;
        while (i < 6) {
            Flying.flyings[i].type = 0;
            Flying.flyings[i].height = 500000 * i;
            Flying.flyings[i].posX = 180;
            Flying.flyings[i].posH = GameLogic.getPosYFromH(Flying.flyings[i].height);
            Flying.flyings[i].enable = false;
            Flying.flyings[i].img_index = 1;
            Flying.flyings[i].renderCount = 0;
            Flying.flyings[i].id = i;
            ++i;
        }
        i = 6;
        while (i < 14) {
            Flying.flyings[i].type = 1;
            Flying.flyings[i].height = 500000 * i;
            Flying.flyings[i].posX = 180;
            Flying.flyings[i].posH = GameLogic.getPosYFromH(Flying.flyings[i].height);
            Flying.flyings[i].enable = false;
            Flying.flyings[i].img_index = 6;
            Flying.flyings[i].renderCount = 0;
            Flying.flyings[i].id = i;
            ++i;
        }
        i = 14;
        while (i < 16) {
            Flying.flyings[i].type = 2;
            Flying.flyings[i].height = 500000 * i;
            Flying.flyings[i].posX = 180;
            Flying.flyings[i].posH = GameLogic.getPosYFromH(Flying.flyings[i].height);
            Flying.flyings[i].enable = false;
            Flying.flyings[i].img_index = 0;
            Flying.flyings[i].renderCount = 0;
            Flying.flyings[i].id = i;
            ++i;
        }
        featherEnableCount = 0;
        ufoEnableCount = 0;
        crateEnableCount = 0;
        featherNextEnableTime = GameLogic.now + 5000L;
        ufoNextEnableTime = GameLogic.now + 15000L;
        if (GameLogic.playerMode != 0) {
            crateNextEnableTime = GameLogic.now + 25000L;
        }
    }

    public Flying(int type) {
        this.type = type;
    }

    public void disable() {
        this.enable = false;
        if (this.type == 0) {
            --featherEnableCount;
        } else if (this.type == 1) {
            --ufoEnableCount;
        } else if (this.type == 2) {
            --crateEnableCount;
        }
    }

    public boolean collisionCheck(Actor actor) {
        if (this.enable && actor.isActiveSide() && actor.getHitState() == 10) {
            int off_h;
            int off_x;
            long dist_pow;
            if (this.type == 0) {
                int off_h2;
                int off_x2 = (int)(actor.getPosX() - (double)this.posX);
                long dist_pow2 = off_x2 * off_x2 + (off_h2 = actor.getPosY() - this.posH) * off_h2;
                if (dist_pow2 < 2704L) {
                    this.disable();
                    actor.setFeatherHit(this.id);
                    return true;
                }
            } else if (this.type == 1) {
                int off_h3;
                int off_x3 = (int)(actor.getPosX() - (double)this.posX);
                long dist_pow3 = off_x3 * off_x3 + (off_h3 = actor.getPosY() - this.posH) * off_h3;
                if (dist_pow3 < 3249L) {
                    this.disable();
                    actor.setUfoHit(this.id);
                    return true;
                }
            } else if (this.type == 2 && (dist_pow = (long)((off_x = (int)(actor.getPosX() - (double)this.posX)) * off_x + (off_h = actor.getPosY() - this.posH) * off_h)) < 3249L) {
                boolean caneat = actor.setCrateHit(this.id);
                if (caneat) {
                    this.disable();
                }
                return true;
            }
        }
        return false;
    }

    private void setMotionType() {
        int level = GameLogic.getGameLevel();
        int r = GameLogic.ran.nextInt(99);
        if (this.type == 0) {
            this.motion = r < F_RAN[level][0] ? 1 : (r < F_RAN[level][1] ? 2 : 1);
            featherNextEnableTime = GameLogic.now + (long)(1000 * (15 + GameLogic.ran.nextInt(F_NXT_TIME[level])));
            featherEnableLimit = F_NUM[level];
        } else if (this.type == 1) {
            this.motion = r < U_RAN[level][0] ? 1 : (r < U_RAN[level][1] ? 2 : (r < U_RAN[level][2] ? 3 : (r < U_RAN[level][3] ? 4 : (r < U_RAN[level][4] ? 5 : 1))));
            ufoNextEnableTime = GameLogic.now + (long)(1000 * (8 + GameLogic.ran.nextInt(U_NXT_TIME[level])));
            ufoEnableLimit = U_NUM[level];
        } else if (GameLogic.playerMode != 0) {
            this.motion = r < 30 ? 1 : (r < 70 ? 2 : (r < 100 ? 4 : 1));
            crateNextEnableTime = GameLogic.now + (long)(1000 * (8 + GameLogic.ran.nextInt(U_NXT_TIME[level])));
            crateEnableLimit = U_NUM[level];
            crateNextEnableTime = GameLogic.now + 1000L;
        }
    }

    private void setMotionVars() {
        this.posX = 30 + GameLogic.ran.nextInt(310);
        this.height = GameLogic.height + 6400 + 600;
        this.posH = GameLogic.getPosYFromH(this.height);
        if (this.type == 0) {
            if (this.motion == 1) {
                this.img_index = 1;
                this.motionSpeed1 = 10 + GameLogic.ran.nextInt(20);
            } else if (this.motion == 2) {
                this.img_index = 1;
                this.motionSpeed1 = 10 + GameLogic.ran.nextInt(10);
                this.motionSpeed2 = 30 + GameLogic.ran.nextInt(30);
            }
        } else if (this.type == 1) {
            if (this.motion == 1) {
                this.img_index = 10;
                this.motionSpeed1 = 20 + GameLogic.ran.nextInt(22);
            } else if (this.motion == 2) {
                this.img_index = 8;
                this.motionSpeed1 = 15.0;
                this.motionSpeed2 = 25 + GameLogic.ran.nextInt(40);
            } else if (this.motion == 3) {
                this.img_index = 7;
                this.motionV4 = 40 + GameLogic.ran.nextInt(280);
                this.motionSpeed1 = 20 + GameLogic.ran.nextInt(20);
                this.motionSpeed2 = 100 + GameLogic.ran.nextInt(150);
                this.motionV1 = 30 + GameLogic.ran.nextInt(30);
                this.motionV2 = 0.0;
                this.motionV3 = 1.0;
            } else if (this.motion == 4) {
                this.img_index = 6;
                this.motionV4 = 30 + GameLogic.ran.nextInt(300);
                this.motionSpeed1 = 3 + GameLogic.ran.nextInt(6);
                this.motionSpeed2 = 1000 + GameLogic.ran.nextInt(800);
                this.motionV1 = 0.0;
                this.motionV2 = 800 + GameLogic.ran.nextInt(1000);
                this.motionV3 = 180.0;
            } else if (this.motion == 5) {
                this.img_index = 6;
                this.motionV4 = 20 + GameLogic.ran.nextInt(320);
                this.motionSpeed1 = 3 + GameLogic.ran.nextInt(6);
                this.motionSpeed2 = 800 + GameLogic.ran.nextInt(400);
                this.motionV1 = 30 + GameLogic.ran.nextInt(35);
                this.motionV2 = 700 + GameLogic.ran.nextInt(500);
                this.motionV3 = 180.0;
            }
        } else if (this.motion == 1) {
            this.img_index = 10;
            this.motionSpeed1 = 20 + GameLogic.ran.nextInt(22);
        } else if (this.motion == 2) {
            this.img_index = 8;
            this.motionSpeed1 = 15.0;
            this.motionSpeed2 = 25 + GameLogic.ran.nextInt(40);
        } else if (this.motion == 4) {
            this.img_index = 6;
            this.motionV4 = 30 + GameLogic.ran.nextInt(300);
            this.motionSpeed1 = 3 + GameLogic.ran.nextInt(6);
            this.motionSpeed2 = 1000 + GameLogic.ran.nextInt(800);
            this.motionV1 = 0.0;
            this.motionV2 = 800 + GameLogic.ran.nextInt(1000);
            this.motionV3 = 180.0;
        }
    }

    public static void syncStep(int flyingID, int posX, int height, int motion, int mSpeed1, int mSpeed2, int motionV1, int motionV2, int motionV3, int motionV4) {
        Flying f = flyings[flyingID];
        f.posX = posX;
        f.height = height;
        f.posH = GameLogic.getPosYFromH(f.height);
    }

    private void motionStep() {
        if (this.motion == 1) {
            this.height = (long)((double)this.height - this.motionSpeed1);
        } else if (this.motion == 2) {
            if (this.motionSpeed2 > this.motionSpeed1) {
                this.motionSpeed1 += 0.5;
            }
            this.height = (long)((double)this.height - this.motionSpeed1);
        } else if (this.motion == 3) {
            this.height = (long)((double)this.height - this.motionSpeed1);
            if (this.motionV3 > 0.0) {
                if (this.motionV1 > this.motionV2) {
                    this.motionV2 += this.motionSpeed2 / 100.0;
                } else {
                    this.motionV3 = -1.0;
                    this.motionV1 *= -1.0;
                }
            } else if (this.motionV3 < 0.0) {
                if (this.motionV1 < this.motionV2) {
                    this.motionV2 -= this.motionSpeed2 / 100.0;
                } else {
                    this.motionV3 = 1.0;
                    this.motionV1 *= -1.0;
                }
            }
            this.posX = (int)(this.motionV4 + this.motionV2);
        } else if (this.motion == 5 || this.motion == 4) {
            this.motionV3 += this.motionSpeed1;
            if (this.motionV3 > 360.0) {
                this.motionV3 -= 360.0;
            }
            double x = this.motionV1 * Math.cos(this.motionV3 * Math.PI / 180.0);
            double y = this.motionV2 * Math.sin(this.motionV3 * Math.PI / 180.0);
            this.height = (long)((double)this.height - (this.motionSpeed2 + y) / 100.0);
            this.posX = (int)(this.motionV4 + x);
        }
    }

    public static void syncReset(int flyingID, int posX, int height, int motion, int mSpeed1, int mSpeed2, int motionV1, int motionV2, int motionV3, int motionV4) {
        System.out.println("syncReset: " + posX + "/1:" + motionV1 + "/2:" + motionV2 + "/3:" + motionV3 + "/4:" + motionV4);
        Flying f = flyings[flyingID];
        f.posX = posX;
        f.height = height;
        f.motion = motion;
        f.motionSpeed1 = mSpeed1;
        f.motionSpeed2 = mSpeed2;
        f.motionV1 = motionV1;
        f.motionV2 = motionV2;
        f.motionV3 = motionV3;
        f.motionV4 = motionV4;
        f.posH = GameLogic.getPosYFromH(f.height);
        if (f.type == 0) {
            if (f.motion == 1) {
                f.img_index = 1;
            } else if (f.motion == 2) {
                f.img_index = 1;
            }
        } else if (f.type == 1) {
            if (f.motion == 1) {
                f.img_index = 10;
            } else if (f.motion == 2) {
                f.img_index = 8;
            } else if (f.motion == 3) {
                f.img_index = 7;
            } else if (f.motion == 4) {
                f.img_index = 6;
            } else if (f.motion == 5) {
                f.img_index = 11;
            }
        } else if (f.type == 2) {
            if (f.motion == 1) {
                f.img_index = 1;
            } else if (f.motion == 2) {
                f.img_index = 1;
            } else if (f.motion == 4) {
                f.img_index = 6;
            }
        }
        f.enable = true;
    }

    public void reset() {
        if (GameLogic.player.isActiveSide()) {
            if (this.type == 0) {
                this.setMotionType();
                this.setMotionVars();
                this.enable = true;
                ++featherEnableCount;
                featherNextEnableTime = GameLogic.now + (long)(1000 * GameLogic.ran.nextInt(5));
            } else if (this.type == 1) {
                this.setMotionType();
                this.setMotionVars();
                this.enable = true;
                ++ufoEnableCount;
                ufoNextEnableTime = GameLogic.now + (long)(3000 * GameLogic.ran.nextInt(3));
            } else if (this.type == 2 && GameLogic.playerMode != 0) {
                this.setMotionType();
                this.setMotionVars();
                this.enable = true;
                ++crateEnableCount;
                crateNextEnableTime = GameLogic.now + (long)(1000 * GameLogic.ran.nextInt(5));
            }
            this.sendResetState(9);
        }
    }

    public boolean isEnabled() {
        return this.enable;
    }

    public void step() {
        if (this.type == 0) {
            if (this.enable) {
                this.motionStep();
                this.posH = GameLogic.getPosYFromH(this.height);
                if (this.posH < -30) {
                    this.disable();
                }
            } else if (featherEnableCount < featherEnableLimit && GameLogic.now - featherNextEnableTime > 0L) {
                this.reset();
            }
        } else if (this.type == 1) {
            if (this.enable) {
                this.motionStep();
                this.posH = GameLogic.getPosYFromH(this.height);
                if (this.posH < -30) {
                    this.disable();
                }
            } else if (ufoEnableCount < ufoEnableLimit && GameLogic.now - ufoNextEnableTime > 0L) {
                this.reset();
            }
        } else if (this.type == 2) {
            if (this.enable) {
                this.motionStep();
                this.posH = GameLogic.getPosYFromH(this.height);
                if (this.posH < -30) {
                    this.disable();
                }
            } else if (GameLogic.playerMode != 0 && crateEnableCount < crateEnableLimit && GameLogic.now - crateNextEnableTime > 0L) {
                this.reset();
            }
        }
    }

    public void render(Graphics g, GameCanvas canvas) {
        Image aImg = null;
        if (this.isEnabled()) {
            ++this.renderCount;
            if (this.type == 0) {
                int offset = IMG_FEATHERS[this.renderCount % 10];
                aImg = (Image)GameObject.flyingImgVec.elementAt(1 + offset);
                g.drawImage(aImg, this.posX - 26, this.posH - 22, 20);
            } else if (this.type == 1) {
                aImg = (Image)GameObject.flyingImgVec.elementAt(this.img_index);
                g.drawImage(aImg, this.posX - 24, this.posH - 24, 20);
            } else if (this.type == 2) {
                aImg = (Image)GameObject.flyingImgVec.elementAt(0);
                g.drawImage(aImg, this.posX - 24, this.posH - 24, 20);
            }
            if (this.renderCount % 30 == 29) {
                this.sendStepState(10);
            }
        }
    }

    private void sendResetState(int cmdType) {
        if (GameSync.masterFlag) {
            GameCommand cmd = GameCommand.newInstance();
            cmd.setFlyingReset(cmdType, this.id, this.posX, (int)this.height, this.motion, (int)this.motionSpeed1, (int)this.motionSpeed2, (int)this.motionV1, (int)this.motionV2, (int)this.motionV3, (int)this.motionV4);
            GameLogic.instance.sync.sendGameCommand(cmd);
        }
    }

    private void sendStepState(int cmdType) {
        if (GameSync.masterFlag) {
            GameCommand cmd = GameCommand.newInstance();
            cmd.setFlyingReset(cmdType, this.id, this.posX, (int)this.height, this.motion, (int)this.motionSpeed1, (int)this.motionSpeed2, (int)this.motionV1, (int)this.motionV2, (int)this.motionV3, (int)this.motionV4);
            GameLogic.instance.sync.sendGameCommand(cmd);
        }
    }
}

