/*
 * Decompiled with CFR 0.152.
 */
package cc.jmap.games;

import cc.jmap.games.Actor;
import cc.jmap.games.Cloud;
import cc.jmap.games.Flying;
import cc.jmap.games.GameEngine;
import cc.jmap.games.GameObject;
import cc.jmap.games.GameSync;
import cc.jmap.games.I18NResource;
import cc.jmap.games.PageCanvas;
import cc.jmap.games.ParatrooperMidlet;
import cc.jmap.games.SoundPlayer;
import cc.jmap.games.net.BTClient;
import cc.jmap.games.net.BTServer;
import cc.jmap.games.net.GameCommand;
import java.util.Random;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import javax.microedition.lcdui.game.GameCanvas;

public class GameLogic {
    public static final int SCREEN_HEIGHT = 680;
    public static final int SCREEN_WIDTH = 340;
    public static int score = 0;
    public static int itemScore = 0;
    public static long now = 0L;
    public static int sensorValue = 0;
    public static int sensorValue2 = 0;
    public static long startTime = 0L;
    public static long pauseTime = 0L;
    public static GameLogic instance = null;
    public static final int MODE_SINGLE = 0;
    public static final int MODE_DUAL_MASTER = 2;
    public static final int MODE_DUAL_SLAVE = 3;
    public static int playerMode = 2;
    public static final int STATE_GAME_GO_BFORE_PLAY = 0;
    public static final int STATE_GAME_PLAY = 1;
    public static final int STATE_GAME_PAUSED = 2;
    public static final int STATE_GAME_PASSIVE_PAUSED = 3;
    public static final int STATE_GAME_PLAY_BT_ERROR = 4;
    public static final int STATE_GAME_ENDING = 5;
    public static final int STATE_GAME_END = 6;
    public static int state = 1;
    public static boolean goShown = false;
    public static int gameOverScore = 0;
    public static long gameOverH = 0L;
    public static double stickAccInReal = 0.0;
    public static double stickVelInReal = 0.0;
    public static double gAccOnStick = 0.0;
    public static int height = 0;
    public static int HEIGHT_INC = 1;
    private static long gameLevelTime = 0L;
    private static int gameLevel = 0;
    public static Random ran = new Random(System.currentTimeMillis());
    public GameSync sync = null;
    static Actor player = null;
    static Actor opponent = null;
    public static int btGap = 0;
    private int oldState;
    public static int svalue1;
    public static int rvalue1;
    private long goTimeStamp = 0L;
    private int goCount = 0;
    private int[] goIndexes;

    public GameLogic() {
        int[] nArray = new int[4];
        nArray[1] = 1;
        nArray[2] = 2;
        nArray[3] = 1;
        this.goIndexes = nArray;
        instance = this;
        this.sync = new GameSync();
        if (playerMode == 0 || playerMode == 2) {
            Cloud.initAll();
            Flying.initAll();
        }
        player = new Actor(true);
        opponent = new Actor(false);
    }

    public Actor getIdleActor() {
        if (GameSync.masterFlag) {
            return opponent;
        }
        return player;
    }

    public Actor getActiveActor() {
        if (GameSync.masterFlag) {
            return player;
        }
        return opponent;
    }

    public static void setGameOverScore() {
        gameOverScore = score + itemScore;
    }

    public void startMaster() {
        GameSync.masterFlag = true;
        this.sync.startMaster();
    }

    public void startSlave(String serverUrl) {
        GameSync.masterFlag = false;
        this.sync.startSlave(serverUrl);
    }

    public static int getGameLevel() {
        int v = height / 600;
        if (v < 1) {
            gameLevel = 0;
        } else if (v < 2) {
            gameLevel = 1;
        } else if (v < 3) {
            gameLevel = 2;
        } else if (v < 4) {
            gameLevel = 3;
        } else if (v < 5) {
            gameLevel = 4;
        } else if (v < 6) {
            gameLevel = 5;
        } else if (v < 7) {
            gameLevel = 6;
        } else if (v < 8) {
            gameLevel = 7;
        } else if (v < 10) {
            gameLevel = 8;
        } else if (v < 12) {
            gameLevel = 9;
        } else if (now - gameLevelTime > 25000L) {
            gameLevelTime = now;
            gameLevel = 7 + ran.nextInt(100) % 3;
        }
        return gameLevel;
    }

    public static int getPosYFromH(long height_in) {
        return (int)(height_in - (long)height) / 10;
    }

    public static int getHFromPosY(long pY) {
        return (int)(pY * 10L + (long)height);
    }

    public void onBTError(String reason) {
        SoundPlayer.pause();
        PageCanvas.setBTStatus("onBTError." + reason);
        state = 4;
        GameEngine.repaint();
    }

    public static void restartGame() {
        if (state == 6) {
            instance.GoToPlay();
            if (playerMode != 0) {
                GameLogic.sendSystemStatus(2, 102);
            }
        }
    }

    public static void backToMenu() {
        if (state == 6 || state == 2 || state == 3 || state == 4) {
            ParatrooperMidlet.instance.gotoMain();
        }
    }

    public static void uploadScore() {
        ParatrooperMidlet.submitScore(gameOverScore);
    }

    public void syncPauseGame() {
        if (state == 1) {
            this.oldState = state;
            state = 3;
            SoundPlayer.pause();
            ParatrooperMidlet.engine.pauseEngine();
            GameEngine.repaint();
            System.out.println("GmaeLogic pauseGame()");
        }
    }

    public void pauseGame() {
        if (state == 1) {
            this.oldState = state;
            state = 2;
            SoundPlayer.pause();
            ParatrooperMidlet.engine.pauseEngine();
            GameEngine.repaint();
            System.out.println("GmaeLogic pauseGame()");
            if (playerMode != 0) {
                GameLogic.sendSystemStatus(2, 103);
            }
        }
    }

    public void syncResumeGame() {
        if (state == 3) {
            state = this.oldState;
            BTServer.resetTimer();
            BTClient.resetTimer();
            SoundPlayer.resume();
            ParatrooperMidlet.engine.resumeEngine();
            GameEngine.repaint();
            System.out.println("GmaeLogic resumeGame()");
        }
    }

    public void resumeGame() {
        if (state == 2) {
            state = this.oldState;
            BTServer.resetTimer();
            BTClient.resetTimer();
            SoundPlayer.resume();
            ParatrooperMidlet.engine.resumeEngine();
            GameEngine.repaint();
            System.out.println("GmaeLogic resumeGame()");
            if (playerMode != 0) {
                GameLogic.sendSystemStatus(2, 104);
            }
        }
    }

    public void syncEndingGame() {
        GameLogic.player.winnerFlag = GameSync.masterFlag;
        GameLogic.opponent.winnerFlag = !GameLogic.player.winnerFlag;
        GameLogic.setGameOverScore();
        state = 5;
        SoundPlayer.playStop(1);
        SoundPlayer.playFile(2);
        gameOverH = height + 9000;
    }

    public void endingGame() {
        GameLogic.player.winnerFlag = !GameSync.masterFlag;
        GameLogic.opponent.winnerFlag = !GameLogic.player.winnerFlag;
        GameLogic.setGameOverScore();
        state = 5;
        SoundPlayer.playStop(1);
        SoundPlayer.playFile(2);
        gameOverH = height + 9000;
        GameLogic.sendSystemStatus(2, 105);
    }

    public void syncAbortGame() {
        PageCanvas.setBTStatus("syncAbortGame()");
        GameLogic.backToMenu();
    }

    public static void abortGame() {
        PageCanvas.setBTStatus("abortGame()");
        GameLogic.sendSystemStatus(2, 106);
    }

    public void syncReplayGame() {
        this.GoToPlay();
    }

    public void startGame() {
        if (goShown) {
            this.GoToPlay();
            return;
        }
        state = 0;
        goShown = true;
        GameEngine.repaint();
    }

    public void GoToPlay() {
        gameOverH = 0L;
        sensorValue = 0;
        gameOverScore = 0;
        score = 0;
        itemScore = 0;
        height = 0;
        pauseTime = 0L;
        startTime = System.currentTimeMillis();
        BTServer.resetTimer();
        BTClient.resetTimer();
        state = 1;
        player.reset();
        if (playerMode != 0) {
            opponent.reset();
        }
        Flying.resetAll();
        SoundPlayer.playFile(1);
        ParatrooperMidlet.instance.openSensor();
    }

    public void endGame() {
        state = 6;
        ParatrooperMidlet.instance.closeSensor();
    }

    public int getState() {
        return state;
    }

    public void initLevel() {
    }

    public void drawBackground(Graphics g, GameCanvas canvas) {
        Image bg0 = (Image)GameObject.bgImgVec.elementAt(0);
        g.drawImage(bg0, 0, 0, 20);
    }

    public void drawCloud(Graphics g, GameCanvas canvas, boolean isBack) {
        int i = 0;
        while (i < 15) {
            Cloud.clouds[i].render(g, canvas, isBack);
            ++i;
        }
    }

    public void drawFlying(Graphics g, GameCanvas canvas) {
        int i = 0;
        while (i < 16) {
            Flying.flyings[i].render(g, canvas);
            ++i;
        }
    }

    public void drawActor(Graphics g, GameCanvas canvas) {
        player.render(g, canvas);
    }

    public void drawOpponent(Graphics g, GameCanvas canvas) {
        opponent.render(g, canvas);
    }

    public void drawScore(Graphics g, GameCanvas canvas) {
        this.drawScore(g, canvas, 355, 20);
    }

    public void drawScore(Graphics g, GameCanvas canvas, int x, int y) {
        int sco = score + itemScore;
        int W = 45;
        boolean DW = false;
        if (sco >= 1000) {
            g.drawImage(GameObject.scoreImgs[sco / 1000 % 10], x - 180 - 0, y, 20);
            g.drawImage(GameObject.scoreImgs[sco / 100 % 10], x - 135 - 0, y, 20);
            g.drawImage(GameObject.scoreImgs[sco / 10 % 10], x - 90 - 0, y, 20);
            g.drawImage(GameObject.scoreImgs[sco % 10], x - 45, y, 20);
        } else if (sco >= 100) {
            g.drawImage(GameObject.scoreImgs[sco / 100 % 10], x - 135 - 0, y, 20);
            g.drawImage(GameObject.scoreImgs[sco / 10 % 10], x - 90 - 0, y, 20);
            g.drawImage(GameObject.scoreImgs[sco % 10], x - 45, y, 20);
        } else if (sco >= 10) {
            g.drawImage(GameObject.scoreImgs[sco / 10 % 10], x - 90 - 0, y, 20);
            g.drawImage(GameObject.scoreImgs[sco % 10], x - 45, y, 20);
        } else {
            g.drawImage(GameObject.scoreImgs[sco % 10], x - 45, y, 20);
        }
    }

    public void drawOverScore(Graphics g, GameCanvas canvas, int x, int y, int score) {
        int sco = score;
        int W = 45;
        boolean DW = false;
        if (sco >= 1000) {
            g.drawImage(GameObject.scoreImgs[sco / 1000 % 10], x - 180 - 0, y, 20);
            g.drawImage(GameObject.scoreImgs[sco / 100 % 10], x - 135 - 0, y, 20);
            g.drawImage(GameObject.scoreImgs[sco / 10 % 10], x - 90 - 0, y, 20);
            g.drawImage(GameObject.scoreImgs[sco % 10], x - 45, y, 20);
        } else if (sco >= 100) {
            g.drawImage(GameObject.scoreImgs[sco / 100 % 10], x - 135 - 0, y, 20);
            g.drawImage(GameObject.scoreImgs[sco / 10 % 10], x - 90 - 0, y, 20);
            g.drawImage(GameObject.scoreImgs[sco % 10], x - 45, y, 20);
        } else if (sco >= 10) {
            g.drawImage(GameObject.scoreImgs[sco / 10 % 10], x - 90 - 0, y, 20);
            g.drawImage(GameObject.scoreImgs[sco % 10], x - 45, y, 20);
        } else {
            g.drawImage(GameObject.scoreImgs[sco % 10], x - 45, y, 20);
        }
    }

    public void drawDebug(Graphics g, GameCanvas canvas) {
        g.drawString("h:" + String.valueOf(height), 10, 10, 0);
        g.drawString("sensor:" + String.valueOf(sensorValue), 10, 25, 0);
        g.drawString("memory:" + String.valueOf(String.valueOf(Runtime.getRuntime().freeMemory()) + "/" + Runtime.getRuntime().totalMemory()), 10, 70, 0);
        g.drawString("r.seq:" + String.valueOf(rvalue1), 10, 115, 0);
        g.drawString("bt:" + PageCanvas.btstatus, 10, 130, 0);
        g.drawString("state:" + String.valueOf(state), 10, 175, 0);
    }

    public void drawSoundBtn(Graphics g, GameCanvas canvas) {
        g.drawImage(GameObject.iconImgs[4], 10, 10, 20);
        Image mimg = null;
        mimg = SoundPlayer.musicFlag ? GameObject.iconImgs[1] : GameObject.iconImgs[0];
        g.drawImage(mimg, 260, 70, 20);
        Image simg = null;
        simg = SoundPlayer.soundFlag ? GameObject.iconImgs[3] : GameObject.iconImgs[2];
        g.drawImage(simg, 310, 70, 20);
    }

    public void drawGameOverBtn(Graphics g, GameCanvas canvas) {
        Image aimg = GameObject.gameOverImgs[1];
        g.drawImage(aimg, 0, 640 - aimg.getHeight(), 20);
        if (playerMode == 0) {
            aimg = GameObject.gameOverImgs[2];
            g.drawImage(aimg, (360 - aimg.getWidth()) / 2, 640 - aimg.getHeight(), 20);
        }
        aimg = GameObject.gameOverImgs[3];
        g.drawImage(aimg, 360 - aimg.getWidth(), 640 - aimg.getHeight(), 20);
    }

    public void drawGameOver(Graphics g, GameCanvas canvas) {
        this.drawGameOverBtn(g, canvas);
        int ybase = GameLogic.getPosYFromH(gameOverH);
        int gap = 60;
        int ystart = 70;
        int ygap = 100;
        if (playerMode == 0) {
            Image aimg = GameObject.gameOverImgs[0];
            g.drawImage(aimg, (360 - aimg.getWidth()) / 2, ybase, 20);
            aimg = GameObject.gameOverImgs[4];
            g.drawImage(aimg, (360 - aimg.getWidth()) / 2, ybase + 170, 20);
            int x = 213;
            int XW = 25;
            int sco = gameOverScore;
            if (sco < 10) {
                x = 205;
            } else if (sco < 100) {
                x = 230;
            } else if (sco < 1000) {
                x = 255;
            } else if (sco < 10000) {
                x = 280;
            }
            this.drawOverScore(g, canvas, x, ybase + 170 + 50, sco);
        } else {
            Image winOrLose = null;
            Image aimg = GameObject.gameOverImgs[9];
            if (aimg != null) {
                g.drawImage(aimg, (360 - aimg.getWidth()) / 2, ybase - 30, 20);
            }
            if (GameSync.masterFlag) {
                if (GameLogic.player.winnerFlag) {
                    winOrLose = GameObject.gameOverImgs[10];
                    aimg = GameObject.gameOverImgs[5];
                    g.drawImage(aimg, (360 - aimg.getWidth()) / 2 - 60, ybase + 70, 20);
                    aimg = GameObject.gameOverImgs[8];
                    g.drawImage(aimg, (360 - aimg.getWidth()) / 2 + 60, ybase + 70 + 100, 20);
                } else {
                    winOrLose = GameObject.gameOverImgs[11];
                    aimg = GameObject.gameOverImgs[7];
                    g.drawImage(aimg, (360 - aimg.getWidth()) / 2 - 60, ybase + 70 + 100, 20);
                    aimg = GameObject.gameOverImgs[6];
                    g.drawImage(aimg, (360 - aimg.getWidth()) / 2 + 60, ybase + 70, 20);
                }
            } else if (GameLogic.player.winnerFlag) {
                winOrLose = GameObject.gameOverImgs[11];
                aimg = GameObject.gameOverImgs[5];
                g.drawImage(aimg, (360 - aimg.getWidth()) / 2 - 60, ybase + 70 + 100, 20);
                aimg = GameObject.gameOverImgs[8];
                g.drawImage(aimg, (360 - aimg.getWidth()) / 2 + 60, ybase + 70, 20);
            } else {
                winOrLose = GameObject.gameOverImgs[10];
                aimg = GameObject.gameOverImgs[7];
                g.drawImage(aimg, (360 - aimg.getWidth()) / 2 - 80, ybase + 70, 20);
                aimg = GameObject.gameOverImgs[6];
                g.drawImage(aimg, (360 - aimg.getWidth()) / 2 + 80, ybase + 70 + 100, 20);
            }
            if (winOrLose != null) {
                g.drawImage(winOrLose, (360 - winOrLose.getWidth()) / 2, ybase + 35, 20);
            }
        }
    }

    public void drawPause(Graphics g, GameCanvas canvas) {
        Image aimg = I18NResource.i18Imgs[8];
        if (aimg != null) {
            g.drawImage(aimg, (360 - aimg.getWidth()) / 2, (640 - aimg.getHeight()) / 2, 20);
        }
    }

    public void drawPassivePause(Graphics g, GameCanvas canvas) {
        Image aimg = I18NResource.i18Imgs[16];
        if (aimg != null) {
            g.drawImage(aimg, (360 - aimg.getWidth()) / 2, (640 - aimg.getHeight()) / 2, 20);
        }
        g.setFont(PageCanvas.sfont);
        g.setColor(0xFFFFFF);
        int ygap = 27;
        int ystart = 268;
        this.drawCenterString(g, I18NResource.btLines[24], ystart);
        this.drawCenterString(g, I18NResource.btLines[25], ystart + ygap * 1);
    }

    private void drawCenterString(Graphics g, String str, int y) {
        int x = (360 - PageCanvas.sfont.stringWidth(str)) / 2;
        g.drawString(str, x, y, 0);
    }

    public void drawBtError(Graphics g, GameCanvas canvas) {
        g.setFont(PageCanvas.sfont);
        g.setColor(0xFFFFFF);
        Image aimg = I18NResource.i18Imgs[16];
        if (aimg != null) {
            g.drawImage(aimg, (360 - aimg.getWidth()) / 2, (640 - aimg.getHeight()) / 2, 20);
        }
        int ygap = 27;
        int ystart = 268;
        this.drawCenterString(g, I18NResource.btLines[10], ystart);
        this.drawCenterString(g, I18NResource.btLines[11], ystart + ygap * 1);
        this.drawCenterString(g, I18NResource.btLines[12], ystart + ygap * 2);
    }

    public void drawGo(Graphics g, GameCanvas canvas) {
        if (now > this.goTimeStamp && this.goCount < 10) {
            this.goTimeStamp = now + 600L;
            ++this.goCount;
        }
        int index = this.goIndexes[this.goCount % this.goIndexes.length];
        Image aimg = GameObject.goImgs[index];
        g.drawImage(aimg, (360 - aimg.getWidth()) / 2, (640 - aimg.getHeight()) / 2, 20);
        aimg = I18NResource.i18Imgs[9];
        g.drawImage(aimg, (360 - aimg.getWidth()) / 2, 147, 20);
    }

    public void syncGameState() {
        this.sync.recvGameState();
    }

    public void step() {
        block6: {
            block5: {
                now = System.currentTimeMillis();
                if (state != 1) break block5;
                score = (height += HEIGHT_INC) * 3 / 10;
                if (score >= 999999) {
                    score = 999999;
                }
                opponent.step();
                player.step();
                int i = 0;
                while (i < 15) {
                    Cloud.clouds[i].step();
                    ++i;
                }
                i = 0;
                while (i < 16) {
                    Flying f = Flying.flyings[i];
                    f.step();
                    f.collisionCheck(opponent);
                    f.collisionCheck(player);
                    ++i;
                }
                break block6;
            }
            if (state != 5) break block6;
            height += 150;
            player.step();
            int i = 0;
            while (i < 15) {
                Cloud.clouds[i].step();
                ++i;
            }
            i = 0;
            while (i < 16) {
                Flying f = Flying.flyings[i];
                f.step();
                ++i;
            }
        }
    }

    public void setSensorValue(int value1_raw, int value2) {
        sensorValue2 = value2;
        sensorValue = (int)((double)value1_raw * (1.0 + (double)value2 / 60.0) + 0.5);
    }

    public void paint(Graphics g, GameCanvas canvas) {
        now = System.currentTimeMillis();
        if (state == 6) {
            return;
        }
        if (state == 0) {
            this.drawBackground(g, canvas);
            this.drawGo(g, canvas);
            return;
        }
        if (state == 1 || state == 2 || state == 3 || state == 5) {
            this.step();
        }
        this.drawBackground(g, canvas);
        this.drawCloud(g, canvas, true);
        if (state != 5 || playerMode == 0) {
            this.drawFlying(g, canvas);
        }
        if (playerMode != 0 && state != 5) {
            this.drawOpponent(g, canvas);
        }
        if (state != 5 && state != 6 || playerMode == 0) {
            this.drawActor(g, canvas);
        }
        this.drawCloud(g, canvas, false);
        if (state == 1) {
            this.drawScore(g, canvas);
            this.drawSoundBtn(g, canvas);
        } else if (state == 5 && (long)height > gameOverH - 1500L) {
            this.endGame();
            this.drawGameOver(g, canvas);
        }
        if (state == 2) {
            this.drawPause(g, canvas);
        } else if (state == 3) {
            this.drawPassivePause(g, canvas);
        } else if (state == 4) {
            this.drawBtError(g, canvas);
        }
    }

    public static void sendSystemStatus(int cmdType, int status) {
        GameCommand cmd = GameCommand.newInstance();
        cmd.setSystemState(cmdType, status);
        GameLogic.instance.sync.sendGameCommand(cmd);
    }
}

