/*
 * Decompiled with CFR 0.152.
 */
package cc.jmap.games.net;

import cc.jmap.games.GameLogic;
import cc.jmap.games.PageCanvas;
import cc.jmap.games.ParatrooperMidlet;
import cc.jmap.games.net.GameCommand;
import cc.jmap.games.net.MatchService;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Hashtable;
import java.util.Timer;
import java.util.TimerTask;
import java.util.Vector;
import javax.bluetooth.BluetoothStateException;
import javax.bluetooth.DeviceClass;
import javax.bluetooth.DiscoveryAgent;
import javax.bluetooth.DiscoveryListener;
import javax.bluetooth.LocalDevice;
import javax.bluetooth.RemoteDevice;
import javax.bluetooth.ServiceRecord;
import javax.bluetooth.UUID;
import javax.microedition.io.Connector;
import javax.microedition.io.StreamConnection;
import javax.microedition.rms.RecordStore;
import javax.microedition.rms.RecordStoreException;
import javax.microedition.rms.RecordStoreFullException;
import javax.microedition.rms.RecordStoreNotFoundException;

public class BTClient
implements Runnable,
DiscoveryListener {
    private static final String RMS_NAME = "bt";
    private static final int RECORD_ID = 1;
    public static String lastServerFriendlyName = "";
    public static String lastServerUrl = "";
    public static String lastFoundDeviceName = "";
    public static String lastSelectDeviceName = "";
    private StreamConnection conn = null;
    private InputStream in = null;
    private OutputStream out = null;
    private static final UUID SERVER_UUID = new UUID("F0E0D0C0B0A000908070605040302222", false);
    private static final int SRV_NAMES_ATTRIBUTE_ID = 17185;
    private static final int READY = 0;
    private static final int DEVICE_SEARCH = 1;
    private static final int SERVICE_SEARCH = 2;
    private int state = 0;
    public DiscoveryAgent discoveryAgent;
    private ParatrooperMidlet parent;
    private boolean isClosed;
    private Thread clientThread;
    private Vector records = new Vector();
    private int discType;
    private int[] searchIDs;
    private Hashtable base = null;
    private UUID[] uuidSet;
    private int[] attrSet;
    private boolean isDeviceSearch = false;
    private boolean isServiceSearch = false;
    private MatchService service = null;
    public static Vector devices = new Vector();
    public static BTClient instance = null;
    private static long lastRecvTimestamp = 0L;

    BTClient(ParatrooperMidlet parent, MatchService service) {
        this.parent = parent;
        this.service = service;
        devices.removeAllElements();
        this.records.removeAllElements();
        this.searchIDs = null;
        this.base = new Hashtable();
        instance = this;
        this.clientThread = new Thread(this);
    }

    public static void resetTimer() {
        lastRecvTimestamp = System.currentTimeMillis();
    }

    public static void initData() {
        BTClient.restoreData();
    }

    public static boolean canCancel() {
        return devices.size() > 0;
    }

    public void run() {
        boolean isBTReady = false;
        try {
            LocalDevice localDevice = LocalDevice.getLocalDevice();
            this.discoveryAgent = localDevice.getDiscoveryAgent();
            isBTReady = true;
        }
        catch (Exception e) {
            System.err.println("Can't initialize bluetooth: " + e);
        }
        if (!isBTReady) {
            return;
        }
        this.uuidSet = new UUID[2];
        this.uuidSet[0] = new UUID(4353L);
        this.uuidSet[1] = SERVER_UUID;
        this.attrSet = new int[1];
        this.attrSet[0] = 17185;
        this.processMessage();
    }

    public static String getFriendlyName(RemoteDevice btDevice) {
        String name = null;
        try {
            name = btDevice.getFriendlyName(false);
            if (name == null) {
                lastFoundDeviceName = "UNKNOWN";
            }
            if (name.trim().equals("")) {
                name = btDevice.getBluetoothAddress();
            }
        }
        catch (IOException ioe) {
            name = "UNKNOWN";
        }
        return name;
    }

    public void deviceDiscovered(RemoteDevice btDevice, DeviceClass cod) {
        if (devices.size() > 20) {
            return;
        }
        if (devices.indexOf(btDevice) == -1) {
            devices.addElement(btDevice);
            try {
                lastFoundDeviceName = BTClient.getFriendlyName(btDevice);
                PageCanvas.btDeviceDiscovered();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void cancelDeviceDiscovered() {
        CancelTimerTask task = new CancelTimerTask();
        Timer timer = new Timer();
        timer.schedule((TimerTask)task, 400L);
    }

    public static void cancelDeviceDiscoveredImpl() {
        try {
            if (BTClient.instance.discoveryAgent != null) {
                BTClient.instance.discoveryAgent.cancelInquiry((DiscoveryListener)instance);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void inquiryCompleted(int discType) {
        this.discType = discType;
        PageCanvas.setBTStatus("bt inquiryCompleted()");
        PageCanvas.btInquiryCompleted();
    }

    public void servicesDiscovered(int transID, ServiceRecord[] servRecord) {
        int i = 0;
        while (i < servRecord.length) {
            this.records.addElement(servRecord[i]);
            ++i;
        }
        PageCanvas.setBTStatus("servicesDiscovered size:" + servRecord.length);
        PageCanvas.btServicesDiscovered();
    }

    public void serviceSearchCompleted(int transID, int respCode) {
        int index = -1;
        int i = 0;
        while (i < this.searchIDs.length) {
            if (this.searchIDs[i] == transID) {
                index = i;
                break;
            }
            ++i;
        }
        if (index != -1) {
            this.searchIDs[index] = -1;
        }
    }

    void requestSearch(String serverUrl) {
        if (serverUrl.equals("")) {
            this.clientThread.start();
        } else {
            ConnectTask task = new ConnectTask(serverUrl);
            Timer timer = new Timer();
            timer.schedule((TimerTask)task, 200L);
        }
        PageCanvas.setBTStatus("bt requestSearch() #N");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void cancelSearch() {
        BTClient bTClient = this;
        synchronized (bTClient) {
            if (this.state == 1) {
                this.discoveryAgent.cancelInquiry((DiscoveryListener)this);
            } else if (this.state == 2) {
                int i = 0;
                while (i < this.searchIDs.length) {
                    this.discoveryAgent.cancelServiceSearch(this.searchIDs[i]);
                    ++i;
                }
            }
        }
    }

    void destroy() {
        this.isClosed = true;
        try {
            if (this.in != null) {
                this.in.close();
            }
            this.in = null;
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            if (this.out != null) {
                this.out.close();
            }
            this.out = null;
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            if (this.conn != null) {
                this.conn.close();
            }
            this.conn = null;
        }
        catch (Exception exception) {
            // empty catch block
        }
        lastFoundDeviceName = "";
        if (this.discoveryAgent != null) {
            try {
                this.discoveryAgent.cancelInquiry((DiscoveryListener)this);
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                int i = 0;
                while (i < this.searchIDs.length) {
                    this.discoveryAgent.cancelServiceSearch(this.searchIDs[i]);
                    ++i;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.records.removeAllElements();
        this.searchIDs = null;
        this.base = new Hashtable();
    }

    private synchronized void processMessage() {
        while (!this.isClosed) {
            this.state = 0;
            if (this.isClosed) {
                System.out.println("processImagesSearchDownload #2A");
                return;
            }
            if (this.isDeviceSearch) continue;
            this.isDeviceSearch = true;
            if (!this.searchDevices()) {
                System.out.println("processImagesSearchDownload #2B");
                return;
            }
            if (devices.size() != 0) continue;
            System.out.println("processImagesSearchDownload #2C");
        }
    }

    public void searchServicesAndConnect(int index) throws IOException {
        if (!this.isServiceSearch) {
            this.isServiceSearch = true;
            if (!this.searchServices(index)) {
                return;
            }
        }
        this.openServiceConnection();
    }

    public void serviceConnect() throws IOException {
        PageCanvas.setBTStatus("#1 serviceConnect()");
        this.openServiceConnection();
    }

    private boolean searchDevices() {
        this.state = 1;
        devices.removeAllElements();
        try {
            this.discoveryAgent.startInquiry(10390323, (DiscoveryListener)this);
        }
        catch (BluetoothStateException e) {
            PageCanvas.goError("e11." + e.getMessage());
            return true;
        }
        try {
            this.wait();
        }
        catch (InterruptedException e) {
            System.err.println("Unexpected interruption: " + e);
            return false;
        }
        System.out.println("searchDevices() #4");
        if (this.isClosed) {
            return false;
        }
        switch (this.discType) {
            case 7: {
                System.out.println("searchDevices() INQUIRY_ERROR");
                PageCanvas.goError("e12.INQUIRY_ERROR");
            }
            case 5: {
                System.out.println("searchDevices() INQUIRY_TERMINATED");
                devices.removeAllElements();
                break;
            }
            case 0: {
                System.out.println("searchDevices() INQUIRY_COMPLETED");
                if (devices.size() != 0) break;
                PageCanvas.goError("e12.INQUIRY_COMPLETED");
                break;
            }
            default: {
                this.destroy();
                return false;
            }
        }
        return true;
    }

    private boolean searchServices(int index) {
        this.state = 2;
        this.records.removeAllElements();
        this.searchIDs = new int[devices.size()];
        boolean isSearchStarted = false;
        int i = 0;
        while (i < devices.size()) {
            block5: {
                if (index == -1 || index == i) {
                    RemoteDevice rd = (RemoteDevice)devices.elementAt(i);
                    System.out.println("searchServices device:" + rd);
                    try {
                        this.searchIDs[i] = this.discoveryAgent.searchServices(this.attrSet, this.uuidSet, rd, (DiscoveryListener)this);
                    }
                    catch (BluetoothStateException e) {
                        System.err.println("Can't search services for: " + rd.getBluetoothAddress() + " due to " + (Object)((Object)e));
                        this.searchIDs[i] = -1;
                        break block5;
                    }
                    isSearchStarted = true;
                }
            }
            ++i;
        }
        if (!isSearchStarted) {
            PageCanvas.setBTStatus("Can't search services.");
            PageCanvas.goError("e13.not search services");
            return false;
        }
        SearchServiceTimerTask task = new SearchServiceTimerTask();
        Timer timer = new Timer();
        timer.schedule((TimerTask)task, 7000L);
        return true;
    }

    public void checkIfNoServiceError() {
        if (this.records.size() == 0 && this.out == null) {
            PageCanvas.goError("e14.checkIfNoServiceError");
        }
    }

    private void handleMessageLoop() {
        int BUF_SIZE = 1000;
        boolean count = false;
        byte[] data = new byte[1000];
        boolean length = false;
        GameCommand cmd = null;
        int dataLen = 0;
        int avail = 0;
        int startOffset = 0;
        int lastSeq = 0;
        long now = 0L;
        try {
            try {
                this.out = this.conn.openOutputStream();
                this.in = this.conn.openInputStream();
                PageCanvas.setBTStatus("connected openConnection()");
                PageCanvas.btClientConnected();
                while (!this.isClosed) {
                    now = System.currentTimeMillis();
                    if (lastRecvTimestamp + 10000L < now && GameLogic.state == 1) {
                        GameLogic.instance.onBTError("timeout");
                    }
                    if ((avail = this.in.available()) > 1000) {
                        avail = 1000;
                    }
                    if (avail > 0) {
                        dataLen = this.in.read(data, 0, avail);
                        lastRecvTimestamp = now;
                        startOffset = 0;
                        while (startOffset < dataLen) {
                            int offset = GameCommand.dividBytes(data, dataLen, startOffset);
                            if (offset >= 0) {
                                byte l = data[offset + 1];
                                startOffset = offset + l;
                                cmd = this.service.enqueueRecvCommand(data, dataLen, offset);
                                if (cmd == null) continue;
                                if (lastSeq != cmd.getSeq() - 1) {
                                    GameLogic.btGap = lastSeq;
                                }
                                GameLogic.rvalue1 = cmd.getSeq();
                                lastSeq = cmd.getSeq();
                                continue;
                            }
                            startOffset = dataLen;
                        }
                    }
                    cmd = this.service.dequeueSendCommand();
                    while (cmd != null) {
                        GameLogic.svalue1 = cmd.getSeq();
                        dataLen = cmd.length();
                        System.arraycopy(cmd.getBytes(), 0, data, 0, dataLen);
                        try {
                            this.out.write(data, 0, dataLen);
                            this.out.flush();
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                        }
                        cmd = this.service.dequeueSendCommand();
                    }
                    try {
                        Thread.sleep(50L);
                    }
                    catch (Exception e) {
                        PageCanvas.goError("e15." + e.getMessage());
                    }
                }
            }
            catch (IOException e) {
                e.printStackTrace();
                GameLogic.instance.onBTError("ioe");
                try {
                    if (this.in != null) {
                        this.in.close();
                    }
                    this.in = null;
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    if (this.out != null) {
                        this.out.close();
                    }
                    this.out = null;
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    if (this.conn != null) {
                        this.conn.close();
                    }
                    this.conn = null;
                }
                catch (Exception exception) {}
            }
        }
        finally {
            try {
                if (this.in != null) {
                    this.in.close();
                }
                this.in = null;
            }
            catch (Exception exception) {}
            try {
                if (this.out != null) {
                    this.out.close();
                }
                this.out = null;
            }
            catch (Exception exception) {}
            try {
                if (this.conn != null) {
                    this.conn.close();
                }
                this.conn = null;
            }
            catch (Exception exception) {}
        }
    }

    /*
     * Loose catch block
     */
    private boolean openConnection(String url) {
        boolean ret = false;
        try {
            try {
                this.conn = (StreamConnection)Connector.open((String)url);
                lastServerFriendlyName = lastSelectDeviceName;
                lastServerUrl = url;
                BTClient.saveData();
                this.handleMessageLoop();
                ret = true;
            }
            catch (IllegalArgumentException e) {
                PageCanvas.setBTStatus("run() IllegalArgumentException");
                this.isClosed = true;
                PageCanvas.goError("e16." + e.getMessage());
                try {
                    if (this.conn != null) {
                        this.conn.close();
                    }
                }
                catch (Exception exception) {}
            }
            catch (IOException e) {
                PageCanvas.setBTStatus("run() IOException");
                this.isClosed = true;
                PageCanvas.goError("e17." + e.getMessage());
                try {
                    if (this.conn != null) {
                        this.conn.close();
                    }
                }
                catch (Exception exception) {}
            }
            catch (SecurityException e) {
                PageCanvas.setBTStatus("run() SecurityException");
                this.isClosed = true;
                PageCanvas.goError("e18." + e.getMessage());
                {
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
                try {
                    if (this.conn != null) {
                        this.conn.close();
                    }
                }
                catch (Exception exception) {}
            }
        }
        finally {
            try {
                if (this.conn != null) {
                    this.conn.close();
                }
            }
            catch (Exception exception) {}
        }
        return ret;
    }

    private void openServiceConnection() throws IOException {
        int i = 0;
        while (i < this.records.size()) {
            ServiceRecord sr = (ServiceRecord)this.records.elementAt(i);
            Object conn = null;
            String url = null;
            url = sr.getConnectionURL(0, false);
            PageCanvas.setBTStatus("bt url():" + url);
            boolean ret = this.openConnection(url);
            if (ret) break;
            ++i;
        }
    }

    public static void saveData() {
        if (lastServerFriendlyName.length() > 20) {
            lastServerFriendlyName = lastServerFriendlyName.substring(0, 19);
        }
        try {
            RecordStore rs = RecordStore.openRecordStore((String)RMS_NAME, (boolean)true);
            if (rs.getNextRecordID() == 1) {
                int recordID = rs.addRecord(lastServerFriendlyName.getBytes(), 0, lastServerFriendlyName.getBytes().length);
                recordID = rs.addRecord(lastServerUrl.getBytes(), 0, lastServerUrl.getBytes().length);
            } else {
                rs.setRecord(1, lastServerFriendlyName.getBytes(), 0, lastServerFriendlyName.getBytes().length);
                rs.setRecord(2, lastServerUrl.getBytes(), 0, lastServerUrl.getBytes().length);
            }
            rs.closeRecordStore();
        }
        catch (RecordStoreFullException e) {
            e.printStackTrace();
        }
        catch (RecordStoreNotFoundException e) {
            e.printStackTrace();
        }
        catch (RecordStoreException e) {
            e.printStackTrace();
        }
        System.out.println("saveData #N");
    }

    public static void restoreData() {
        try {
            RecordStore rs = RecordStore.openRecordStore((String)RMS_NAME, (boolean)true);
            byte[] d = rs.getRecord(1);
            byte[] d2 = rs.getRecord(2);
            rs.closeRecordStore();
            lastServerFriendlyName = new String(d);
            lastServerUrl = new String(d2);
            System.out.println("restoreData() friendlynane:" + lastServerFriendlyName + "/url:" + lastServerUrl);
        }
        catch (Exception e) {
            e.printStackTrace();
            BTClient.saveData();
        }
        System.out.println("restoreData #N");
    }

    private class CancelTimerTask
    extends TimerTask {
        private CancelTimerTask() {
        }

        public void run() {
            try {
                if (BTClient.instance.discoveryAgent != null) {
                    BTClient.cancelDeviceDiscoveredImpl();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private class ConnectTask
    extends TimerTask {
        private String url = null;

        public ConnectTask(String url) {
            this.url = url;
        }

        public void run() {
            try {
                BTClient.this.openConnection(this.url);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private class SearchServiceTimerTask
    extends TimerTask {
        private SearchServiceTimerTask() {
        }

        public void run() {
            try {
                BTClient.this.checkIfNoServiceError();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

