/*
 * Decompiled with CFR 0.152.
 */
class Car {
    public int MAX_VEL = 4;
    public static final int MAX_FRAMES = 8;
    public static MazeRaceCanvas canvas;
    protected static int screenmode;
    public int posx;
    public int posy;
    int tempposx;
    int tempposy;
    int speed;
    static int acceleration;
    public int direction;
    int spr;
    int pal;
    protected int[] MOVE_TABLE;
    protected int[] TRANSFORM_TABLE;
    public static Engine engine;
    static final int[] xtable;
    static final int[] ytable;
    static int xtrans;
    static int ytrans;
    static int xlimit;
    static int ylimit;
    public int movedirection = -1;
    public int direction_Sanjay = -1;
    public int flipDir_Sanjay = 0;
    public int directionFlip_Sanjay = 0;
    public int counter_sanjay = 0;
    protected static final int CHECK_LIMIT = 10;
    boolean showTurn = false;
    int targetdirection = 0;
    static final int[] road;
    protected static final int AHEAD = 8;

    Car(int n, int n2) {
        this(0, 0, n, n2);
    }

    Car(int n, int n2, int n3, int n4) {
        int n5;
        if (canvas == null) {
            canvas = MazeRaceApp.canvas;
        }
        screenmode = MazeRaceApp.screenmode;
        this.tempposx = this.posx = n;
        this.tempposy = this.posy = n2;
        this.direction = 0;
        this.spr = n3;
        this.pal = n4;
        this.speed = 0;
        this.MOVE_TABLE = new int[]{this.spr + 2, this.spr + 1, this.spr + 4, this.spr + 3, this.spr, this.spr + 1, this.spr + 4, this.spr + 3};
        this.TRANSFORM_TABLE = new int[this.MOVE_TABLE.length];
        for (n5 = 0; n5 < 5; ++n5) {
            this.TRANSFORM_TABLE[n5] = 0;
        }
        for (n5 = 5; n5 < this.MOVE_TABLE.length; ++n5) {
            this.TRANSFORM_TABLE[n5] = 4;
        }
    }

    public void draw() {
        this.speed = this.MAX_VEL;
        this.update();
        if (this.posx > MazeRaceApp.POSX - 150 && this.posx < MazeRaceApp.POSX + 150 && this.posy > MazeRaceApp.POSY - 300 && this.posy < MazeRaceApp.POSY + 300) {
            if (this.direction_Sanjay == -1) {
                MazeRaceApp.engine.addSprite(this.posx + xtrans, this.posy + ytrans, this.MOVE_TABLE[this.direction], this.pal, this.TRANSFORM_TABLE[this.direction]);
            }
            if (this.direction_Sanjay != -1) {
                MazeRaceApp.engine.addSprite(this.posx + xtrans, this.posy + ytrans, this.direction_Sanjay, this.pal, this.flipDir_Sanjay);
                ++this.counter_sanjay;
                if (this.counter_sanjay > 3) {
                    this.direction_Sanjay = -1;
                    this.counter_sanjay = 0;
                }
            }
        }
    }

    protected void controlTurning(int n, int n2) {
        this.direction = n;
        if (this.canProceed(10)) {
            this.targetdirection = this.direction;
            this.direction = 0;
            this.showTurn = true;
            return;
        }
        this.direction = n2;
        if (this.canProceed(10)) {
            this.targetdirection = this.direction;
            this.direction = 0;
            this.showTurn = true;
            return;
        }
    }

    private boolean collide(Car car) {
        int n = 0;
        int n2 = 0;
        if (car.spr >= 15) {
            n = 2;
            n2 = 4;
        }
        return car.direction == 0 || car.direction == 4 ? this.posx >= car.posx - 8 - n && this.posx <= car.posx + 8 + n && this.posy >= car.posy - 16 - n2 && this.posy <= car.posy + 16 + n2 : (car.direction == 2 || car.direction == 6) && this.posx >= car.posx - 20 - n && this.posx <= car.posx + 20 + n && this.posy >= car.posy - 8 - n2 && this.posy <= car.posy + 8 + n2;
    }

    protected synchronized void controlMove(int n, int n2, int n3) {
        if (Math.abs(this.direction - n) == 4) {
            int n4 = this.direction;
            this.direction = n;
            if (!this.canProceed(2)) {
                this.direction = n4;
                this.direction_Sanjay = -1;
            }
            return;
        }
        this.movedirection = n;
        if (this.direction == n) {
            this.direction_Sanjay = -1;
            if (this.canProceed(2)) {
                this.move();
            } else {
                int n5 = this.direction;
                this.controlTurning(n2, n3);
                this.direction = n5;
                this.direction_Sanjay = -1;
            }
            return;
        }
        int n6 = this.direction;
        this.direction = n;
        if (!this.canProceed(10)) {
            int n7 = this.direction = n6;
            if (this.direction == n2 || this.direction == n3) {
                this.direction = n;
                if (this.canProceed(2)) {
                    this.move();
                }
                this.direction = n7;
            }
            this.direction_Sanjay = -1;
        } else {
            this.move();
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    protected synchronized void update() {
        block30: {
            block36: {
                block35: {
                    block34: {
                        block33: {
                            block32: {
                                block31: {
                                    if (this.showTurn) break block30;
                                    this.flipDir_Sanjay = this.TRANSFORM_TABLE[this.direction];
                                    if (canvas.getLeft()) break block31;
                                    if (!canvas.getFour()) break block32;
                                }
                                if (MazeRaceCanvas.gameintro) return;
                                if (this.MOVE_TABLE[this.direction] == 0) {
                                    this.direction_Sanjay = 3;
                                    this.directionFlip_Sanjay = 0;
                                } else if (this.MOVE_TABLE[this.direction] == 2) {
                                    this.direction_Sanjay = 1;
                                    this.directionFlip_Sanjay = 4;
                                } else if (this.MOVE_TABLE[this.direction] == 4) {
                                    this.direction_Sanjay = 1;
                                    this.directionFlip_Sanjay = 0;
                                }
                                this.controlMove(6, 0, 4);
                                return;
                            }
                            if (canvas.getRight()) break block33;
                            if (!canvas.getSix()) break block34;
                        }
                        if (MazeRaceCanvas.gameintro) return;
                        if (this.MOVE_TABLE[this.direction] == 0) {
                            this.direction_Sanjay = 3;
                            this.directionFlip_Sanjay = 4;
                        } else if (this.MOVE_TABLE[this.direction] == 2) {
                            this.direction_Sanjay = 1;
                            this.directionFlip_Sanjay = 0;
                        } else if (this.MOVE_TABLE[this.direction] == 4) {
                            this.direction_Sanjay = 3;
                            this.directionFlip_Sanjay = 0;
                        }
                        this.controlMove(2, 0, 4);
                        return;
                    }
                    if (canvas.getUp()) break block35;
                    if (!canvas.getTwo()) break block36;
                }
                if (MazeRaceCanvas.gameintro) return;
                if (this.MOVE_TABLE[this.direction] == 4) {
                    this.direction_Sanjay = 1;
                    this.directionFlip_Sanjay = 0;
                } else if (this.MOVE_TABLE[this.direction] == 0) {
                    this.direction_Sanjay = 1;
                    this.directionFlip_Sanjay = 0;
                }
                this.controlMove(0, 6, 2);
                return;
            }
            if (!MazeRaceCanvas.getDown()) {
                if (!MazeRaceCanvas.getEight()) return;
            }
            if (MazeRaceCanvas.gameintro) return;
            if (this.MOVE_TABLE[this.direction] == 4) {
                this.direction_Sanjay = 3;
                this.directionFlip_Sanjay = 0;
            } else if (this.MOVE_TABLE[this.direction] == 2) {
                this.direction_Sanjay = 3;
                this.directionFlip_Sanjay = 0;
            }
            this.controlMove(4, 6, 2);
            return;
        }
        if (this.direction > this.targetdirection) {
            --this.direction;
        } else if (this.direction < this.targetdirection) {
            ++this.direction;
        } else {
            this.showTurn = false;
        }
        if (this.direction != 8) return;
        this.direction = 0;
        this.showTurn = false;
    }

    public boolean checkOthers() {
        for (int i = 0; i < MazeRaceApp.enemies.length; ++i) {
            if (this == MazeRaceApp.enemies[i]) continue;
            this.posx += this.speed * xtable[this.direction];
            this.posy += this.speed * ytable[this.direction];
            if (this.collide(MazeRaceApp.enemies[i])) {
                this.posx -= this.speed * xtable[this.direction];
                this.posy -= this.speed * ytable[this.direction];
                return true;
            }
            this.posx -= this.speed * xtable[this.direction];
            this.posy -= this.speed * ytable[this.direction];
        }
        return false;
    }

    public void move() {
        int n;
        for (n = 0; n < MazeRaceApp.enemies.length; ++n) {
            this.posx += this.speed * xtable[this.direction];
            this.posy += this.speed * ytable[this.direction];
            if (this.collide(MazeRaceApp.enemies[n])) {
                this.posx -= this.speed * xtable[this.direction];
                this.posy -= this.speed * ytable[this.direction];
                return;
            }
            this.posx -= this.speed * xtable[this.direction];
            this.posy -= this.speed * ytable[this.direction];
            if (MazeRaceApp.enemies[n].blockdirection != this.movedirection) continue;
            this.posx -= this.speed * xtable[this.movedirection];
            this.posy -= this.speed * ytable[this.movedirection];
            return;
        }
        for (n = 0; n < MazeRaceApp.obstacles.length; ++n) {
            this.posx += this.speed * xtable[this.direction];
            this.posy += this.speed * ytable[this.direction];
            if (MazeRaceApp.obstacles[n].blockdirection == this.movedirection) {
                this.posx -= this.speed * xtable[this.movedirection];
                this.posy -= this.speed * ytable[this.movedirection];
                return;
            }
            this.posx -= this.speed * xtable[this.direction];
            this.posy -= this.speed * ytable[this.direction];
        }
        for (n = 0; n < MazeRaceApp.obstacles_tyres.length; ++n) {
            this.posx += this.speed * xtable[this.direction];
            this.posy += this.speed * ytable[this.direction];
            if (MazeRaceApp.obstacles_tyres[n].blockdirection == this.movedirection) {
                this.posx -= this.speed * xtable[this.movedirection];
                this.posy -= this.speed * ytable[this.movedirection];
                return;
            }
            this.posx -= this.speed * xtable[this.direction];
            this.posy -= this.speed * ytable[this.direction];
        }
        this.posx += this.speed * xtable[this.direction];
        this.posy += this.speed * ytable[this.direction];
    }

    public boolean getUp() {
        return MazeRaceCanvas.pressed[1];
    }

    public boolean getRight() {
        return MazeRaceCanvas.pressed[5];
    }

    public boolean getDown() {
        return MazeRaceCanvas.pressed[6];
    }

    public boolean getLeft() {
        return MazeRaceCanvas.pressed[2];
    }

    protected boolean canProceed(int n) {
        int n2 = this.posx;
        int n3 = this.posy;
        this.posx += xtable[this.direction] * this.speed;
        this.posy += ytable[this.direction] * this.speed;
        for (int i = 0; i < n; ++i) {
            int n4 = this.getMapTile(0, 0);
            if (this.posx <= -xtrans || this.posx >= xlimit || this.posy <= -ytrans || this.posy >= ylimit || !this.isValid(n4)) {
                this.posx = n2;
                this.posy = n3;
                return false;
            }
            this.posx += xtable[this.direction] * this.speed;
            this.posy += ytable[this.direction] * this.speed;
        }
        this.posx = n2;
        this.posy = n3;
        return true;
    }

    protected boolean isValid(int n) {
        for (int i = 0; i < road.length; ++i) {
            if (n != road[i]) continue;
            return true;
        }
        return false;
    }

    protected boolean canProceed() {
        return this.canProceed(1);
    }

    protected int getMapTile(int n, int n2) {
        int n3 = this.posy + ytrans + n2 >> 3;
        int n4 = this.posx + xtrans + n >> 3;
        try {
            return (short)(MazeRaceApp.map[n3 * MazeRaceApp.engine.map_width_blocks + n4] & Short.MAX_VALUE);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return -1;
        }
    }

    public boolean collide() {
        return false;
    }

    protected void move_diff() {
        this.posx += this.speed * xtable[this.direction];
        this.posy += this.speed * ytable[this.direction];
        if (this.collide()) {
            this.posx -= this.speed * xtable[this.direction];
            this.posy -= this.speed * ytable[this.direction];
        }
    }

    public void move_back() {
        this.posx -= xtable[this.movedirection];
        this.posy -= ytable[this.movedirection];
    }

    static {
        acceleration = 1;
        engine = MazeRaceApp.engine;
        xtable = new int[]{0, 0, 1, 0, 0, 0, -1, 0};
        ytable = new int[]{-1, 0, 0, 0, 1, 0, 0, 0};
        road = new int[]{64, 66, 67, 65, 68, 69};
    }
}

