/*
 * Decompiled with CFR 0.152.
 */
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class Engine {
    public static final int MODE_NORMAL = 0;
    public static final int TRANSFORM_IDENTITY = 0;
    public static final int TRANSFORM_ROTATE90 = 1;
    public static final int TRANSFORM_ROTATE180 = 2;
    public static final int TRANSFORM_ROTATE270 = 3;
    public static final int TRANSFORM_FLIPX = 4;
    public static final int TRANSFORM_FLIPY = 5;
    public static final int TRANSFORM_FLIPXEQUALY = 6;
    public static final int TRANSFORM_FLIPXEQUALMINUSY = 7;
    private int img_width_blocks;
    private int img_height_blocks;
    private int img_width_pixels;
    private int img_height_pixels;
    private int mode;
    public Image img0;
    public Image img1;
    private Graphics gfx0;
    private Graphics gfx1;
    private int img_x;
    private int img_y;
    public int pos_x;
    public int pos_y;
    public Image til;
    public byte[][] spr;
    public byte[][] pal;
    public short[] map;
    public int map_width_blocks;
    public int map_height_blocks;
    public int map_width_pixels;
    public int map_height_pixels;
    public Image[][] imgcache;
    private short[] draw;
    public int drawpos;
    private static final byte[] MAGIC = new byte[]{-119, 80, 78, 71, 13, 10, 26, 10};
    private static final byte[] tRNS = new byte[]{0, 0, 0, 1, 116, 82, 78, 83, 0, 64, -26, -40, 102};
    private static final byte[] IEND = new byte[]{0, 0, 0, 0, 73, 69, 78, 68, -82, 66, 96, -126};

    public void init() {
        this.imgcache = new Image[this.pal.length][this.spr.length];
        this.draw = new short[255];
    }

    public void acquire(int n, int n2, int n3) {
        this.img_width_blocks = n + 2;
        this.img_height_blocks = n2 + 2;
        this.img_width_pixels = n + 2 << 3;
        this.img_height_pixels = n2 + 2 << 3;
        this.mode = n3;
        this.img0 = null;
        this.img1 = null;
        this.gfx0 = null;
        this.gfx1 = null;
        switch (this.mode) {
            case 0: {
                this.img0 = Image.createImage((int)this.img_width_pixels, (int)this.img_height_pixels);
                this.img1 = Image.createImage((int)(this.img_width_pixels - 16), (int)(this.img_height_pixels - 16));
            }
        }
        switch (this.mode) {
            default: 
        }
        this.gfx0 = this.img0.getGraphics();
        this.gfx1 = this.img1.getGraphics();
    }

    private void validateRect(int n, int n2, int n3, int n4, int n5) {
        int n6 = (this.img_x >> 3) % this.img_width_blocks;
        int n7 = (this.img_y >> 3) % this.img_height_blocks;
        int n8 = (this.img_x & 7) * this.img_height_blocks >> 3;
        int n9 = (this.img_y & 7) * this.img_width_blocks >> 3;
        int n10 = (this.img_x >> 3) - n6;
        int n11 = (this.img_y >> 3) - n7;
        int n12 = n2;
        while (n4 > 0) {
            int n13;
            int n14 = 8 - (n12 & 7);
            if (n14 > n4) {
                n14 = n4;
            }
            switch (this.mode) {
                case 0: {
                    this.gfx0.setClip(0, n12, this.img_width_pixels, n14);
                }
            }
            int n15 = n;
            for (int i = n3; i > 0; i -= n13) {
                n13 = 8 - (n15 & 7);
                if (n13 > i) {
                    n13 = i;
                }
                int n16 = n10 + (n15 >> 3);
                int n17 = n11 + (n12 >> 3);
                if (n15 >> 3 < n6 || n15 >> 3 == n6 && n12 >> 3 < n8) {
                    n16 += this.img_width_blocks;
                }
                if (n12 >> 3 < n7 || n12 >> 3 == n7 && n15 >> 3 < n9) {
                    n17 += this.img_height_blocks;
                }
                int n18 = n16 + n17 * this.map_width_blocks;
                short s = this.map[n18];
                if (n5 == 0 || s != this.map[n18 + n5]) {
                    switch (this.mode) {
                        case 0: {
                            this.gfx0.drawImage(this.til, n15 & 0xFFFFFFF8, (n12 & 0xFFFFFFF8) - (s << 3 & 0x3FFF8), 20);
                        }
                    }
                }
                if ((n15 += n13) < this.img_width_pixels) continue;
                n15 -= this.img_width_pixels;
            }
            if ((n12 += n14) >= this.img_height_pixels) {
                n12 -= this.img_height_pixels;
            }
            n4 -= n14;
        }
    }

    public void redrawRect(int n, int n2, int n3, int n4) {
        if (n < this.pos_x - 16) {
            n3 -= this.pos_x - 16 - n;
            n = this.pos_x - 16;
        }
        if (n + n3 > this.pos_x + this.img_width_pixels) {
            n3 = this.pos_x + this.img_width_pixels - n;
        }
        if (n3 <= 0) {
            return;
        }
        if (n2 < this.pos_y - 16) {
            n4 -= this.pos_y - 16 - n2;
            n2 = this.pos_y - 16;
        }
        if (n2 + n4 > this.pos_y + this.img_height_pixels) {
            n4 = this.pos_y + this.img_height_pixels - n;
        }
        if (n4 <= 0) {
            return;
        }
        this.validateRect(n % this.img_width_pixels, n2 % this.img_height_pixels, n3, n4, 0);
    }

    private int clamp(int n, int n2, int n3) {
        if (n < n2) {
            return n2;
        }
        if (n > n3) {
            return n3;
        }
        return n;
    }

    public void moveTo(int n, int n2) {
        this.pos_x = (short)this.clamp(n, 0, this.map_width_pixels - this.img_width_pixels + 16);
        this.pos_y = (short)this.clamp(n2, 0, this.map_height_pixels - this.img_height_pixels + 16);
        this.img_x = (short)this.clamp(n - 8, 0, this.map_width_pixels - this.img_width_pixels);
        this.img_y = (short)this.clamp(n2 - 8, 0, this.map_height_pixels - this.img_height_pixels);
        this.validateRect(0, 0, this.img_width_pixels, this.img_height_pixels, 0);
    }

    public void scrollTo(int n, int n2) {
        int n3;
        int n4;
        int n5;
        int n6;
        n = this.clamp(n, 0, this.map_width_pixels - this.img_width_pixels + 16);
        while (this.pos_x > n) {
            n6 = this.pos_x - (this.pos_x - 1 & 0xFFFFFFF8);
            if (n6 > this.pos_x - n) {
                n6 = this.pos_x - n;
            }
            this.pos_x -= n6;
            if (this.pos_x < 8 || this.pos_x >= this.map_width_pixels - this.img_width_pixels + 8) continue;
            this.img_x -= n6;
            n5 = (this.img_x & 7) * this.img_height_blocks & 0xFFFFFFF8;
            n4 = ((this.img_x & 7) + n6) * this.img_height_blocks & 0xFFFFFFF8;
            this.validateRect((this.img_x & 0xFFFFFFF8) % this.img_width_pixels, n5, 8, n4 - n5, this.img_width_blocks);
        }
        while (this.pos_x < n) {
            n6 = (this.pos_x + 8 & 0xFFFFFFF8) - this.pos_x;
            if (n6 > n - this.pos_x) {
                n6 = n - this.pos_x;
            }
            this.pos_x += n6;
            if (this.pos_x <= 8 || this.pos_x > this.map_width_pixels - this.img_width_pixels + 8) continue;
            n5 = (this.img_x & 7) * this.img_height_blocks & 0xFFFFFFF8;
            n4 = ((this.img_x & 7) + n6) * this.img_height_blocks & 0xFFFFFFF8;
            n3 = this.img_x;
            this.img_x += n6;
            this.validateRect((n3 & 0xFFFFFFF8) % this.img_width_pixels, n5, 8, n4 - n5, -this.img_width_blocks);
        }
        n2 = this.clamp(n2, 0, this.map_height_pixels - this.img_height_pixels + 16);
        while (this.pos_y > n2) {
            n6 = this.pos_y - (this.pos_y - 1 & 0xFFFFFFF8);
            if (n6 > this.pos_y - n2) {
                n6 = this.pos_y - n2;
            }
            this.pos_y -= n6;
            if (this.pos_y < 8 || this.pos_y >= this.map_height_pixels - this.img_height_pixels + 8) continue;
            this.img_y -= n6;
            n5 = (this.img_y & 7) * this.img_width_blocks & 0xFFFFFFF8;
            n4 = ((this.img_y & 7) + n6) * this.img_width_blocks & 0xFFFFFFF8;
            this.validateRect(n5, (this.img_y & 0xFFFFFFF8) % this.img_height_pixels, n4 - n5, 8, this.map_width_blocks * this.img_height_blocks);
        }
        while (this.pos_y < n2) {
            n6 = (this.pos_y + 8 & 0xFFFFFFF8) - this.pos_y;
            if (n6 > n2 - this.pos_y) {
                n6 = n2 - this.pos_y;
            }
            this.pos_y += n6;
            if (this.pos_y <= 8 || this.pos_y > this.map_height_pixels - this.img_height_pixels + 8) continue;
            n5 = (this.img_y & 7) * this.img_width_blocks & 0xFFFFFFF8;
            n4 = ((this.img_y & 7) + n6) * this.img_width_blocks & 0xFFFFFFF8;
            n3 = this.img_y;
            this.img_y += n6;
            this.validateRect(n5, (n3 & 0xFFFFFFF8) % this.img_height_pixels, n4 - n5, 8, -this.map_width_blocks * this.img_height_blocks);
        }
    }

    public void cacheSprite(int n, int n2) {
        int n3;
        byte[] byArray = this.spr[n];
        byte[] byArray2 = this.pal[n2];
        int n4 = (byArray[0] + 1) * byArray[1] + 15;
        byte[] byArray3 = new byte[826 + n4 + 20];
        for (n3 = 0; n3 < 8; ++n3) {
            byArray3[n3] = MAGIC[n3];
        }
        for (n3 = 0; n3 < 25; ++n3) {
            byArray3[n3 + 8] = byArray[n3 + 4];
        }
        for (n3 = 0; n3 < 780; ++n3) {
            byArray3[n3 + 33] = byArray2[n3];
        }
        for (n3 = 0; n3 < 13; ++n3) {
            byArray3[n3 + 813] = tRNS[n3];
        }
        for (n3 = 0; n3 < 15; ++n3) {
            byArray3[n3 + 826] = byArray[n3 + 29];
        }
        for (n3 = 0; n3 < byArray[1]; ++n3) {
            for (int i = 0; i < byArray[0]; ++i) {
                byArray3[i + n3 * (byArray[0] + 1) + 842] = byArray[44 + i + n3 * byArray[0]];
            }
        }
        for (n3 = 0; n3 < 8; ++n3) {
            byArray3[n3 + 826 + n4] = byArray[n3 + 44 + byArray[0] * byArray[1]];
        }
        for (n3 = 0; n3 < 12; ++n3) {
            byArray3[n3 + 826 + n4 + 8] = IEND[n3];
        }
        this.imgcache[n2][n] = Image.createImage((byte[])byArray3, (int)0, (int)byArray3.length);
    }

    public synchronized void addSprite(int n, int n2, int n3, int n4, int n5) {
        this.draw[this.drawpos++] = (short)n;
        this.draw[this.drawpos++] = (short)n2;
        this.draw[this.drawpos++] = (short)n3;
        this.draw[this.drawpos++] = (short)n4;
        this.draw[this.drawpos++] = (short)n5;
    }

    public synchronized void removeSprites() {
        this.drawpos = 0;
    }

    static void flipX(Graphics graphics, Image image, int n, int n2, int n3, int n4, int n5) {
        int n6 = n4 >> 1;
        int n7 = n6 + 1;
        int n8 = n4 * (n3 + 1);
        for (int i = 0; i < n7; ++i) {
            graphics.setClip(i + n, n2, 1, n5);
            graphics.drawImage(image, n + 0 + 2 * i - n8, n2, 20);
            graphics.setClip(i + n6 + n, n2, 1, n5);
            graphics.drawImage(image, n + 0 + 2 * (i + n6) - n8, n2, 20);
        }
        graphics.setClip(0, 0, 240, 320);
    }

    public synchronized void paint(Graphics graphics, int n, int n2) {
        if (this.img1 != null) {
            int n3;
            int n4;
            for (n4 = -this.pos_y % this.img_height_pixels; n4 < this.img_height_pixels - 16; n4 += this.img_height_pixels) {
                for (n3 = -this.pos_x % this.img_width_pixels; n3 < this.img_width_pixels - 16; n3 += this.img_width_pixels) {
                    switch (this.mode) {
                        case 0: {
                            this.gfx1.drawImage(this.img0, n3, n4, 20);
                        }
                    }
                }
            }
            n4 = 0;
            while (n4 < this.drawpos) {
                n3 = this.draw[n4++];
                short s = this.draw[n4++];
                short s2 = this.draw[n4++];
                short s3 = this.draw[n4++];
                short s4 = this.draw[n4++];
                byte[] byArray = this.spr[s2];
                if (this.imgcache[s3][s2] == null) {
                    this.cacheSprite(s2, s3);
                }
                switch (this.mode) {
                    case 0: {
                        if (s4 == 0) {
                            this.gfx1.drawImage(this.imgcache[s3][s2], n3 - this.pos_x - byArray[2], s - this.pos_y - byArray[3], 20);
                            break;
                        }
                        int n5 = 0;
                        byte by = 0;
                        n5 = byArray[0] - byArray[2];
                        by = byArray[3];
                        Engine.flipX(this.gfx1, this.imgcache[s3][s2], n3 - this.pos_x - n5, s - this.pos_y - by, 0, this.imgcache[s3][s2].getWidth(), this.imgcache[s3][s2].getHeight());
                    }
                }
            }
            graphics.drawImage(this.img1, n, n2, 20);
        }
    }
}

