/*
 * Decompiled with CFR 0.152.
 */
package com.jarbull.jbf;

import com.jarbull.jbf.JBAction;
import com.jarbull.jbf.JBImage;
import com.jarbull.jbf.JBMIDlet;
import com.jarbull.jbf.JBRecordStore;
import com.jarbull.jbf.gadget.ScoreCheckerThread;
import com.jarbull.jbf.gadget.VersionCheckerThread;
import com.jarbull.jbf.menu.JBElement;
import com.jarbull.jbf.menu.JBMenuNode;
import com.jarbull.jbf.util.JBGameConfig;
import com.jarbull.jbf.util.JBMenuXmlParser;
import com.jarbull.jbf.util.JBUtil;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.microedition.lcdui.Image;
import javax.microedition.midlet.MIDletStateChangeException;

public class JBManager
implements Runnable {
    private static final JBManager JB_MANAGER = new JBManager();
    protected JBMIDlet jBMIDlet;
    private Hashtable hash_menu_nodes = new Hashtable();
    private Hashtable hash_image = new Hashtable();
    private boolean isRunning = true;
    private Vector actionQueue = new Vector();
    public final JBRecordStore menuSettings = new JBRecordStore("MENU_SETTINGS");
    public final JBRecordStore gameSettings = new JBRecordStore("GAME_SETTINGS");
    private JBGameConfig jbGameConfig;
    private boolean isMenuLoaded = false;

    private JBManager() {
        new Thread(this).start();
    }

    public static JBManager getInstance() {
        return JB_MANAGER;
    }

    public JBMIDlet getjBMIDlet() {
        return this.jBMIDlet;
    }

    public void addAction(JBAction jbAction) {
        this.actionQueue.addElement(jbAction);
    }

    public void handleEvent(JBAction jbAction) {
        block36: {
            System.gc();
            Object caller = jbAction.getCaller();
            String[] values = JBUtil.splitText(jbAction.getValue(), ':');
            try {
                if (values[0].equals("load_config_xml")) {
                    this.loadConfigXML();
                    break block36;
                }
                if (values[0].equals("load_menu_xml")) {
                    this.loadMenuXML();
                    this.isMenuLoaded = true;
                    break block36;
                }
                if (values[0].equals("si") || values[0].equals("mi")) {
                    String imgPath = values[1];
                    Hashtable<String, JBImage> img_hash = (Hashtable<String, JBImage>)this.hash_image.get(values[0]);
                    if (img_hash == null) {
                        img_hash = new Hashtable<String, JBImage>();
                        this.hash_image.put(values[0], img_hash);
                    }
                    if (img_hash.get(imgPath) == null) {
                        JBImage jBImage = new JBImage(imgPath);
                        img_hash.put(imgPath, jBImage);
                        jBImage.createImage();
                    }
                    break block36;
                }
                if (values[0].equals("clearti")) {
                    ((Hashtable)this.hash_image.get("ti")).clear();
                    break block36;
                }
                if (values[0].equals("VN")) {
                    this.jBMIDlet.jbMainMenuCanvas.setCurrentNode((JBMenuNode)this.hash_menu_nodes.get(values[1]), null);
                    this.addAction(new JBAction(this, "clearti"));
                    break block36;
                }
                if (values[0].equals("CHECK")) {
                    JBMenuNode node = (JBMenuNode)this.hash_menu_nodes.get(values[1]);
                    this.jBMIDlet.jbMainMenuCanvas.setCurrentNode(node, "check:start");
                    this.addAction(new JBAction(this, "clearti"));
                    VersionCheckerThread versionCheckerThread = new VersionCheckerThread(node);
                    versionCheckerThread.start();
                    break block36;
                }
                if (values[0].equals("GO")) {
                    if (values[1].equals("download")) {
                        this.jBMIDlet.platformRequest(VersionCheckerThread.UPDATED_VERSION_URL);
                    } else if (values[1].equals("related")) {
                        this.jBMIDlet.platformRequest(VersionCheckerThread.GAME_LIKE_THIS_URL);
                    }
                    this.addAction(new JBAction(this, "EG:"));
                    break block36;
                }
                if (values[0].equals("MG")) {
                    String url = "http://seclub.org/dn.php?" + this.jbGameConfig.getJbfVersion() + "&vc=" + this.jbGameConfig.getCoreVersion() + "&vg=" + this.jbGameConfig.getGameVersion() + "&id=" + this.jbGameConfig.getGameId() + "&p=" + this.jbGameConfig.getPartnerId() + "&u=" + this.jbGameConfig.getUserId();
                    this.jBMIDlet.platformRequest(url);
                    this.addAction(new JBAction(this, "EG:"));
                    break block36;
                }
                if (values[0].equals("TOP")) {
                    JBMenuNode node = (JBMenuNode)this.hash_menu_nodes.get(values[1]);
                    this.jBMIDlet.jbMainMenuCanvas.setCurrentNode(node, "top:start");
                    this.addAction(new JBAction(this, "clearti"));
                    break block36;
                }
                if (values[0].equals("SUBMIT")) {
                    String myName = this.gameSettings.get("score:myname");
                    if (myName == null) {
                        this.jBMIDlet.switchToSubmitForm();
                    } else {
                        ScoreCheckerThread scoreCheckerThread = new ScoreCheckerThread(this.jBMIDlet.jbMainMenuCanvas.getCurrentNode());
                        scoreCheckerThread.start();
                    }
                    this.addAction(new JBAction(this, "clearti"));
                    break block36;
                }
                if (values[0].equals("RG")) {
                    this.jBMIDlet.jbMainMenuCanvas.isPaused = true;
                    this.clearFonts();
                    Hashtable siHash = (Hashtable)this.hash_image.get("si");
                    Enumeration elements = siHash.elements();
                    while (elements.hasMoreElements()) {
                        ((JBImage)elements.nextElement()).clearImage();
                    }
                    Hashtable miHash = (Hashtable)this.hash_image.get("mi");
                    elements = miHash.elements();
                    while (elements.hasMoreElements()) {
                        ((JBImage)elements.nextElement()).clearImage();
                    }
                    ((Hashtable)this.hash_image.get("ti")).clear();
                    System.gc();
                    try {
                        Thread.sleep(500L);
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                    this.jBMIDlet.resumeGame(values[1]);
                    break block36;
                }
                if (values[0].equals("MM")) {
                    this.clearFonts();
                    this.jBMIDlet.jbMainMenuCanvas.setCurrentNode((JBMenuNode)this.hash_menu_nodes.get("M0"), null);
                    this.jBMIDlet.jbGameCanvas.isPaused = true;
                    this.jBMIDlet.destroyJBApp(true, values[1]);
                    this.jBMIDlet.jbGameCanvas.isRunning = false;
                    this.jBMIDlet.jbGameCanvas = null;
                    this.addAction(new JBAction(this, "clearti"));
                    break block36;
                }
                if (values[0].equals("SG")) {
                    if (this.jBMIDlet.jbMainMenuCanvas.isPaused) {
                        return;
                    }
                    this.jBMIDlet.jbMainMenuCanvas.isPaused = true;
                    this.clearFonts();
                    Hashtable siHash = (Hashtable)this.hash_image.get("si");
                    Enumeration elements = siHash.elements();
                    while (elements.hasMoreElements()) {
                        ((JBImage)elements.nextElement()).clearImage();
                    }
                    Hashtable miHash = (Hashtable)this.hash_image.get("mi");
                    elements = miHash.elements();
                    while (elements.hasMoreElements()) {
                        ((JBImage)elements.nextElement()).clearImage();
                    }
                    ((Hashtable)this.hash_image.get("ti")).clear();
                    System.gc();
                    try {
                        Thread.sleep(250L);
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                    this.jBMIDlet.startGame(values[1]);
                    break block36;
                }
                if (values[0].equals("EG")) {
                    try {
                        this.jBMIDlet.destroyApp(true);
                    }
                    catch (MIDletStateChangeException ex) {
                        ex.printStackTrace();
                    }
                } else if (values[0].equals("ED")) {
                    this.addAction(new JBAction(this, "MM:"));
                    this.addAction(new JBAction(this, "EG:"));
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    private void loadConfigXML() throws IOException {
        String partnerId = this.jBMIDlet.getAppProperty("p");
        String userId = this.jBMIDlet.getAppProperty("u");
        this.jbGameConfig = new JBGameConfig(partnerId, userId);
    }

    public Image getImage(String imagePath) {
        String[] values = JBUtil.splitText(imagePath, ':');
        Hashtable hash = (Hashtable)this.hash_image.get(values[0]);
        if (hash == null) {
            return null;
        }
        JBImage jBImage = (JBImage)hash.get(values[1]);
        if (jBImage == null) {
            return null;
        }
        Image img = jBImage.getImage();
        if (img == null) {
            jBImage.createImage();
            img = jBImage.getImage();
        }
        return img;
    }

    public Image getTextImage(String text) {
        Image image;
        Hashtable ti_hash = (Hashtable)this.hash_image.get("ti");
        if (ti_hash == null) {
            ti_hash = new Hashtable();
            this.hash_image.put("ti", ti_hash);
        }
        if ((image = (Image)ti_hash.get(text)) == null) {
            image = this.jbGameConfig.getJBFont().getImage(text);
            ((Hashtable)this.hash_image.get("ti")).put(text, image);
        }
        return image;
    }

    public Image getTextImage(String text, String fontKey) {
        Image image;
        Hashtable ti_hash = (Hashtable)this.hash_image.get("ti");
        if (ti_hash == null) {
            ti_hash = new Hashtable();
            this.hash_image.put("ti", ti_hash);
        }
        if ((image = (Image)ti_hash.get(text + fontKey)) == null) {
            image = this.jbGameConfig.getJBFont(fontKey).getImage(text);
            ((Hashtable)this.hash_image.get("ti")).put(text + fontKey, image);
        }
        return image;
    }

    public void clearFonts() {
        this.jbGameConfig.clearFonts();
    }

    public JBMenuNode getMenuNode(String id) {
        return (JBMenuNode)this.hash_menu_nodes.get(id);
    }

    private void loadMenuXML() throws IOException {
        new JBMenuXmlParser(this.hash_menu_nodes);
        this.syncronizeMenuAndRecordStore();
    }

    private void syncronizeMenuAndRecordStore() {
        Enumeration keys = this.hash_menu_nodes.keys();
        while (keys.hasMoreElements()) {
            Object key = keys.nextElement();
            JBMenuNode node = (JBMenuNode)this.hash_menu_nodes.get(key);
            for (int i = 0; i < node.getElements().size(); ++i) {
                JBElement jBelement = (JBElement)node.getElements().elementAt(i);
                if (jBelement.getAction() != null) continue;
                String hashKey = node.getId() + "-" + jBelement.getKey();
                String savedValue = this.menuSettings.get(hashKey);
                if (savedValue != null) {
                    jBelement.selectOption(savedValue);
                    continue;
                }
                this.menuSettings.put(hashKey, jBelement.getSelectedOption());
            }
        }
        this.menuSettings.saveRecords();
    }

    public void run() {
        while (this.isRunning) {
            while (this.actionQueue.size() > 0) {
                JBAction jbAction = (JBAction)this.actionQueue.elementAt(0);
                this.actionQueue.removeElementAt(0);
                this.handleEvent(jbAction);
            }
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
    }

    public void stopProcessing() {
        this.isRunning = false;
    }

    public void saveMenuOption(JBMenuNode node, JBElement jBElement, String value) {
        String hashKey = node.getId() + "-" + jBElement.getKey();
        this.menuSettings.putAndSave(hashKey, value);
    }

    public JBGameConfig getJbGameConfig() {
        return this.jbGameConfig;
    }

    public boolean isMenuLoaded() {
        return this.isMenuLoaded;
    }
}

