/*
 * Decompiled with CFR 0.152.
 */
package com.topisystems.midp.goldrush;

import com.topisystems.midp.goldrush.GoldRushConstants;
import com.topisystems.shared.ui.Location;

public final class Player
implements GoldRushConstants {
    static final int PLAYER_REST = 0;
    static final int PLAYER_WAVE = 1;
    static final int PLAYER_LIGHT = 2;
    static final int PLAYER_SLEEP = 3;
    static final int PLAYER_WALK = 4;
    static final int PLAYER_WALK_BETWEEN = 5;
    static final int PLAYER_HACK = 6;
    static final int PLAYER_EXPLODED = 7;
    static final int PLAYER_DROWNED = 8;
    static final int PLAYER_CART = 9;
    static final int REST_COUNT = 20;
    static final int SLEEP_COUNT = 40;
    static final int WAVE_COUNT = 8;
    static final int LIGHT_COUNT = 4;
    static final int[] HACK_EAST = new int[]{36, 35, 34, 35, 36, 51};
    static final int[] HACK_NORTH = new int[]{39, 38, 37, 38, 39, 53};
    static final int[] HACK_SOUTH = new int[]{42, 41, 40, 41, 42, 55};
    static final int[] HACK_WEST = new int[]{45, 44, 43, 44, 45, 57};
    int[] imageArray;
    int state;
    int dir;
    int pos;
    int xOffset;
    int yOffset;
    Location loc;
    Location prevLoc;
    int image;
    int restCount;
    int origImage;

    public Player(Location location, int n, int n2, int n3, int n4) {
        this.loc = location;
        this.state = n2;
        this.dir = n;
        this.image = n4;
        this.prevLoc = new Location(location.x, location.y, location.index);
    }

    public void restore() {
        if (this.state == 3 || this.state == 1 || this.state == 2) {
            this.image = this.origImage;
            this.state = 0;
        }
    }

    public void handleRest() {
        switch (this.state) {
            case 0: {
                this.origImage = this.image;
                if (this.restCount++ != 20) break;
                this.restCount = 0;
                this.state = 1;
                return;
            }
            case 1: {
                if (this.restCount++ == 8) {
                    this.restCount = 0;
                    this.image = 50;
                    this.state = 2;
                    return;
                }
                this.image = this.image == 46 ? 47 : 46;
                return;
            }
            case 2: {
                if (this.restCount++ == 4) {
                    this.restCount = 0;
                    this.image = 48;
                    this.state = 3;
                    return;
                }
                this.image = this.image == 49 ? 50 : 49;
                return;
            }
            case 3: {
                if (this.restCount++ == 40) {
                    this.restCount = 0;
                    this.image = 46;
                    this.state = 1;
                    return;
                }
                this.image = 48;
            }
        }
    }

    public void setHack() {
        switch (this.dir) {
            case 0: {
                this.imageArray = HACK_WEST;
                break;
            }
            case 3: {
                this.imageArray = HACK_EAST;
                break;
            }
            case 1: {
                this.imageArray = HACK_SOUTH;
                break;
            }
            case 2: {
                this.imageArray = HACK_NORTH;
            }
        }
        this.state = 6;
        this.pos = 0;
        this.image = this.imageArray[this.pos++];
    }

    public void setWalk(int n, int n2, int n3, int n4, int n5, int n6) {
        this.xOffset = n5;
        this.yOffset = n6;
        this.prevLoc.index = this.loc.index;
        this.prevLoc.x = this.loc.x;
        this.prevLoc.y = this.loc.y;
        this.loc.x = n2;
        this.loc.y = n3;
        this.loc.index = n4;
        this.dir = n;
        this.state = 5;
    }
}

