/*
 * Decompiled with CFR 0.152.
 */
import java.io.DataInputStream;
import java.io.IOException;
import javax.microedition.lcdui.Graphics;

public class Animation {
    private int mX;
    private int mY;
    private int mWidth;
    private int mHeight;
    private AnimationFrame[] mFrame;
    private int[] mFrameDuration;
    private int[] mFrameStartTime;
    private int[] mFrameReference;
    private int mAnimationDuration = Integer.MAX_VALUE;
    private boolean mLoopPreference;
    private boolean mContinuousNestedAnimations;
    private TimelineChannel[] mTimeline;
    private int mTimelineX;
    private int mTimelineY;
    private int mTimelineWidth;
    private int mTimelineHeight;
    private boolean mFrameBufferCaching = true;
    private int mAlignment;
    public static final int ALIGNMENT_TOP = 1;
    public static final int ALIGNMENT_LEFT = 2;
    public static final int ALIGNMENT_VCENTER = 4;
    public static final int ALIGNMENT_BOTTOM = 8;
    public static final int ALIGNMENT_HCENTER = 16;
    public static final int ALIGNMENT_RIGHT = 32;
    private int mDebugRid;
    private static final int[] INT_ARRAY_SIZE_1 = new int[1];
    private static final int[] MAX_DURATION_FOR_FRAME = new int[]{Integer.MAX_VALUE};
    private static AnimationFrame[] smEmptyFrame;

    private void createEmptyAnimation() {
        if (smEmptyFrame == null) {
            smEmptyFrame = new AnimationFrame[1];
            Animation.smEmptyFrame[0] = new AnimationFrame(true, this);
        }
        this.mFrame = smEmptyFrame;
        this.mFrameDuration = MAX_DURATION_FOR_FRAME;
        this.mFrameReference = INT_ARRAY_SIZE_1;
        this.mFrameStartTime = INT_ARRAY_SIZE_1;
    }

    public int getRID() {
        return this.mDebugRid;
    }

    public Animation(int n, boolean bl) throws IOException {
        int n2;
        int n3;
        int n4;
        int n5;
        if (n == -1) {
            this.createEmptyAnimation();
            return;
        }
        if (!bl) {
            DavinciUtilities.resetLoading();
        }
        DataInputStream dataInputStream = Toolkit.getResourceStream(n);
        int n6 = dataInputStream.read();
        boolean bl2 = (n6 & 1) == 0;
        boolean bl3 = (n6 & 2) == 0;
        int n7 = dataInputStream.read();
        this.mFrameDuration = new int[n7];
        this.mFrameStartTime = new int[n7];
        if (n7 > 1) {
            this.mFrameReference = new int[n7];
        }
        this.mFrame = new AnimationFrame[n7];
        this.mLoopPreference = dataInputStream.read() == 1;
        boolean bl4 = this.mContinuousNestedAnimations = dataInputStream.read() == 1;
        if (bl2) {
            this.mX = dataInputStream.readByte();
            this.mY = dataInputStream.readByte();
            this.mWidth = dataInputStream.read();
            this.mHeight = dataInputStream.read();
        } else {
            this.mX = dataInputStream.readShort();
            this.mY = dataInputStream.readShort();
            this.mWidth = dataInputStream.readShort();
            this.mHeight = dataInputStream.readShort();
        }
        this.mAlignment = dataInputStream.read();
        for (n5 = 0; n5 < n7; ++n5) {
            n4 = dataInputStream.read();
            if (n7 > 1) {
                this.mFrameReference[n5] = n4;
            }
            if (this.isFrameReference(n5)) continue;
            this.mFrame[n5] = new AnimationFrame(false, this);
        }
        n5 = 0;
        n4 = 0;
        for (n3 = 0; n3 < n7; ++n3) {
            n2 = bl3 ? dataInputStream.read() : dataInputStream.readShort() & 0xFFFF;
            if (n2 == 0) {
                n2 = Integer.MAX_VALUE;
                n5 = 1;
            }
            this.mFrameDuration[n3] = n2;
            this.mFrameStartTime[n3] = n4;
            n4 += n2;
        }
        if (n5 == 0) {
            this.mAnimationDuration = this.mFrameStartTime[n7 - 1] + this.mFrameDuration[n7 - 1];
        }
        n3 = dataInputStream.read() == 1 ? 1 : 0;
        this.mTimelineX = this.mX;
        this.mTimelineY = this.mY;
        this.mTimelineWidth = this.mWidth;
        this.mTimelineHeight = this.mHeight;
        if (n3 != 0) {
            if (bl2) {
                this.mTimelineX = dataInputStream.readByte();
                this.mTimelineY = dataInputStream.readByte();
                this.mTimelineWidth = dataInputStream.read();
                this.mTimelineHeight = dataInputStream.read();
            } else {
                this.mTimelineX = dataInputStream.readShort();
                this.mTimelineY = dataInputStream.readShort();
                this.mTimelineWidth = dataInputStream.readShort();
                this.mTimelineHeight = dataInputStream.readShort();
            }
            this.mTimeline = new TimelineChannel[6];
            for (n2 = 0; n2 < 6; ++n2) {
                this.mTimeline[n2] = new TimelineChannel(n2, this.getDuration());
                this.mTimeline[n2].load(dataInputStream, bl2);
            }
        }
        for (n2 = 0; n2 < n7; ++n2) {
            if (this.isFrameReference(n2)) continue;
            this.mFrame[n2].loadFrameData(dataInputStream, bl2, bl);
        }
        dataInputStream.close();
        if (n7 > 1) {
            for (n2 = 0; n2 < n7; ++n2) {
                int n8 = this.mFrameReference[n2];
                if (!this.isFrameReference(n2)) continue;
                this.mFrame[n2] = this.mFrame[n8];
            }
        }
    }

    public int getWithoutTimelineX() {
        return this.mX;
    }

    public int getWithoutTimelineY() {
        return this.mY;
    }

    public int getWithoutTimelineWidth() {
        return this.mWidth;
    }

    public int getWithoutTimelineHeight() {
        return this.mHeight;
    }

    public int getX() {
        return this.mTimelineX;
    }

    public int getY() {
        return this.mTimelineY;
    }

    public int getWidth() {
        return this.mTimelineWidth;
    }

    public int getHeight() {
        return this.mTimelineHeight;
    }

    public int getFrameCount() {
        return this.mFrame.length;
    }

    public boolean isLoopingPreferenced() {
        return this.mLoopPreference;
    }

    public boolean continuousNestedAnimations() {
        return this.mContinuousNestedAnimations;
    }

    public int getFrameColorModification(int n) {
        if (this.hasTimeline()) {
            return this.getTimelineValue(0, this.getFrameStartTime(n), this.isLoopingPreferenced());
        }
        return -8355712;
    }

    public int getDuration() {
        return this.mAnimationDuration;
    }

    public int getFrameStartTime(int n) {
        return this.mFrameStartTime[n];
    }

    public int getFrameDuration(int n) {
        return this.mFrameDuration[n];
    }

    public int getFrameInTime(int n) {
        int n2 = this.mFrameDuration.length;
        while (--n2 >= 0) {
            if (n < this.mFrameStartTime[n2]) continue;
            return n2;
        }
        return -1;
    }

    public void doDraw(Graphics graphics, int n, int n2, int n3) {
        Toolkit.getRenderingPlatform().setGraphicsContext(graphics);
        this.doDraw(n, n2, n3);
    }

    public void doDraw(int n, int n2, int n3) {
        int n4 = this.getFrameInTime(n3);
        int n5 = n3;
        if (!this.continuousNestedAnimations()) {
            n5 -= this.getFrameStartTime(n4);
        }
        this.mFrame[n4].doDraw(n, n2, n5);
    }

    public AnimationFrame getFrame(int n) {
        return this.mFrame[n];
    }

    public boolean isFrameReference(int n) {
        return this.getFrameCount() > 1 && this.mFrameReference[n] != 255;
    }

    public int getTimelineValue(int n, int n2, boolean bl) {
        return this.mTimeline[n].getValue(n2, bl);
    }

    public boolean hasTimeline() {
        if (this.mTimeline != null) {
            int n = 6;
            while (--n >= 0) {
                if (this.mTimeline[n].getEventCount() <= 0) continue;
                return true;
            }
        }
        return false;
    }

    public boolean hasNestedAnimations(int n) {
        return this.getFrame(n).hasNestedAnimations();
    }

    public void freeResources() {
        int n = this.mFrame.length;
        while (--n >= 0) {
            this.mFrame[n].freeFrameBufferResources();
        }
        DavinciUtilities.modRefCounters(this, -1);
    }

    public void setFrameBufferCaching(boolean bl) {
        this.mFrameBufferCaching = bl;
    }

    public boolean isFrameBufferCachingEnabled() {
        return this.mFrameBufferCaching;
    }

    public int getAlignment() {
        return this.mAlignment;
    }
}

