/*
 * Decompiled with CFR 0.152.
 */
import java.util.Vector;
import javax.microedition.lcdui.Graphics;

public class Fisherman {
    public static final int FISHERMAN_ANIM_NONE = -1;
    public static final int FISHERMAN_ANIM_CHARGING = 0;
    public static final int FISHERMAN_ANIM_THROWING = 1;
    public static final int FISHERMAN_ANIM_RELEASING = 2;
    public static final int FISHERMAN_ANIM_BROKENLINE = 3;
    public static final int FISHERMAN_ANIM_HAPPY = 4;
    public static final int FISHERMAN_ANIM_COUNT = 5;
    public int mFishermanId;
    public static final int TRIG_PRECISSION = 10;
    public SpriteObject mBoatBackSpr;
    public SpriteObject mBoatFrontSpr;
    private SpriteObject mFishermanSpr;
    private SpriteObject mFishermanHandsSpr;
    public int mCurrentFishermanAnim;
    public int mBoatWorldPosX;
    public int mBoatWorldPosY;
    public int mRodAngle;
    public int mRodBottomPartId;
    public int mRodBasePartId;
    public int mRodCenterPartId;
    public int mRodTopPartId;
    public int mRodSupportPartId;
    public int mCanvasBoatX;
    public int mCanvasBoatY;
    public int mHookedFishID;
    public int mThiefFish;
    public boolean mFishedLegendaryFish;
    public int[] mConstraints = new int[7];
    public static final int ROD_CONST_BOTTOM_BASE = 0;
    public static final int ROD_CONST_REFERENCE_CENTER = 3;
    public static final int ROD_CONST_BASE_CENTER = 4;
    public static final int ROD_CONST_REFERENCE_TOP = 5;
    public static final int ROD_CONST_CENTER_TOP = 6;
    public static final int CONST_COUNT = 7;
    public Displace mBoatDisplaceY = new Displace();
    public boolean mHasSomeFishBiting;
    public int mBaitType;
    public int mLineStrengthType;
    public int mLineLenType;
    private SpriteObject mSparklesSpr;
    private SpriteObject mBaitSpr;
    private SpriteObject mRadarSpr;
    private SpriteObject mPowerbar;
    private int[] mBackupRodSegmentX;
    private int[] mBackupRodSegmentY;
    public static int smRopeSegmentLength;
    public int mRopeActiveParticles;
    public int mRopeActiveSegments;
    public int mRopeLen;
    public int[] mRopeParticle = new int[30];
    public int[] mRopeSegment = new int[30];
    public static final int HOOK_STATE_NONE = -1;
    public static final int HOOK_STATE_WAITING_NEXT_THROW = 0;
    public static final int HOOK_STATE_CHARGING = 1;
    public static final int HOOK_STATE_THROWING = 2;
    public static final int HOOK_STATE_FISHING = 3;
    public static final int HOOK_FISH_FALLING_IN_BOAT = 4;
    public static final int HOOK_STATE_BREAKING_HOOK = 5;
    public static final int HOOK_STATE_SAD = 6;
    public static final int HOOK_STATE_HAPPY = 7;
    private static final int LINE_COLOR = 0xEAEAEA;
    public int mHookState;
    public boolean mActionButtonIsPressed;
    private int mLaunchStrength;
    private int mLaunchStrengthDir;
    int mLineTension;
    public boolean mIsLineBroken;
    public boolean mIsPerfectThrow;
    public int throwingLoops;
    public boolean mMustWaitEndTurn;
    public boolean mHookWasUnderWater;
    public boolean mHookIsUnderWater;
    public static String smDistanceFeedbackStr;
    private static int smDistanceFeedbackX;
    private static int smDistanceFeedbackY;
    private static int smDistanceFeedbackInitY;
    private static int smDistanceFeedbackFinalY;
    private int mTimeElapsed;
    private static final int TIME_FEEDBACK_DISTANCE = 1000;
    private int mAiTimerElapsed;
    private int mAiTimerMax;
    private int mAiTimerState;
    private int mFishedTextStartX;
    private int mFishedTextStartY;
    private int mFishedTextStartId;
    private Displace mFishedTextDisplace;
    public boolean mFishedTextEnabled;
    private static Vector smSpriteObjectCache;

    public Fisherman(int n) {
        this.mFishermanId = n;
    }

    public void boatLoad() {
        if (this.mFishermanId == 0) {
            this.mBoatBackSpr = Fisherman.loadSpriteObject(458824, false);
            this.mBoatFrontSpr = Fisherman.loadSpriteObject(458819, false);
            this.mFishermanSpr = Fisherman.loadSpriteObject(new int[]{458821, 458821, 458823, 458873, 458820}, false);
            this.mFishermanHandsSpr = Fisherman.loadSpriteObject(new int[]{458883, 458883, 458818, 458886, 458884}, false);
            this.mPowerbar = Fisherman.loadSpriteObject(589944, false);
        } else {
            this.mBoatBackSpr = Fisherman.loadSpriteObject(458878, false);
            this.mBoatFrontSpr = Fisherman.loadSpriteObject(458879, false);
            this.mFishermanSpr = Fisherman.loadSpriteObject(new int[]{458880, 458880, 458876, 458874, 458875}, false);
            this.mFishermanHandsSpr = Fisherman.loadSpriteObject(new int[]{458882, 458882, 458881, 458885, 458887}, false);
        }
    }

    public void boatAndRodInit(int n, int n2, int n3, int n4, int n5) {
        this.mBoatBackSpr.setAnimation(0, -1, true);
        this.mBoatFrontSpr.setAnimation(0, -1, true);
        this.mBaitType = n3;
        this.mLineStrengthType = n4;
        this.mLineLenType = n5;
        this.mBoatDisplaceY.create(4, 500, true, 3);
        this.mRodBottomPartId = World.smPhysics.addParticle(FP.toFP(n), FP.toFP(n2 - 20), 0);
        this.mRodBasePartId = World.smPhysics.addParticle(FP.toFP(n), FP.toFP(n2), 0);
        this.mRodAngle = 220;
        this.boatRefreshWordPos(n, n2);
        int n6 = World.smPhysics.pX[this.mRodBasePartId] + FP.toFP(Trigonometry.cos(this.mRodAngle) * 50 / 2 >> 10);
        int n7 = World.smPhysics.pY[this.mRodBasePartId] + FP.toFP(Trigonometry.sin(this.mRodAngle) * 50 / 2 >> 10);
        this.mRodCenterPartId = World.smPhysics.addParticle(n6, n7, 262144);
        n6 = World.smPhysics.pX[this.mRodCenterPartId] + FP.toFP(Trigonometry.cos(this.mRodAngle) * 50 / 3 >> 10);
        n7 = World.smPhysics.pY[this.mRodCenterPartId] + FP.toFP(Trigonometry.sin(this.mRodAngle) * 50 / 3 >> 10);
        this.mRodTopPartId = World.smPhysics.addParticle(n6, n7, 262144);
        int n8 = PhysicsFP.distance(World.smPhysics.pX[this.mRodBottomPartId], World.smPhysics.pY[this.mRodBottomPartId], World.smPhysics.pX[this.mRodBasePartId], World.smPhysics.pY[this.mRodBasePartId]);
        int n9 = PhysicsFP.distance(World.smPhysics.pX[this.mRodBasePartId], World.smPhysics.pY[this.mRodBasePartId], World.smPhysics.pX[this.mRodCenterPartId], World.smPhysics.pY[this.mRodCenterPartId]);
        int n10 = PhysicsFP.distance(World.smPhysics.pX[this.mRodCenterPartId], World.smPhysics.pY[this.mRodCenterPartId], World.smPhysics.pX[this.mRodTopPartId], World.smPhysics.pY[this.mRodTopPartId]);
        int n11 = PhysicsFP.distance(World.smPhysics.pX[this.mRodBottomPartId], World.smPhysics.pY[this.mRodBottomPartId], World.smPhysics.pX[this.mRodCenterPartId], World.smPhysics.pY[this.mRodCenterPartId]);
        int n12 = PhysicsFP.distance(World.smPhysics.pX[this.mRodBottomPartId], World.smPhysics.pY[this.mRodBottomPartId], World.smPhysics.pX[this.mRodTopPartId], World.smPhysics.pY[this.mRodTopPartId]);
        int n13 = PhysicsFP.distance(World.smPhysics.pX[this.mRodBasePartId], World.smPhysics.pY[this.mRodBasePartId], World.smPhysics.pX[this.mRodTopPartId], World.smPhysics.pY[this.mRodTopPartId]);
        this.mConstraints[0] = World.smPhysics.addDistanceConstraint(this.mRodBottomPartId, this.mRodBasePartId, n8, 262144);
        this.mConstraints[4] = World.smPhysics.addDistanceConstraint(this.mRodBasePartId, this.mRodCenterPartId, n9, 262144);
        this.mConstraints[6] = World.smPhysics.addDistanceConstraint(this.mRodCenterPartId, this.mRodTopPartId, n10, 262144);
        World.smPhysics.addDistanceConstraint(this.mRodBottomPartId, this.mRodCenterPartId, n11, 262144);
        World.smPhysics.addDistanceConstraint(this.mRodBottomPartId, this.mRodTopPartId, n12, 262144);
        World.smPhysics.addDistanceConstraint(this.mRodBasePartId, this.mRodTopPartId, n13, 262144);
        int[] nArray = new int[]{this.mRodBottomPartId, this.mRodBasePartId, this.mRodCenterPartId, this.mRodTopPartId};
        this.mBackupRodSegmentX = new int[nArray.length];
        this.mBackupRodSegmentY = new int[nArray.length];
    }

    public void boatRefreshWordPos(int n, int n2) {
        this.mBoatWorldPosX = n;
        this.mBoatWorldPosY = n2;
        World.smPhysics.forceParticlePosition(this.mRodBottomPartId, FP.toFP(this.mBoatWorldPosX), FP.toFP(this.mBoatWorldPosY));
        this.boatSetRodAngle(this.mRodAngle);
    }

    public void boatLogicUpdate(int n) {
        this.mBoatBackSpr.logicUpdate(n);
        this.mBoatFrontSpr.logicUpdate(n);
        if (this.mCurrentFishermanAnim == 4 || this.mCurrentFishermanAnim == 3) {
            this.mFishermanSpr.logicUpdate(n);
            this.mFishermanHandsSpr.logicUpdate(n);
        }
        World.smPhysics.forceParticlePosition(this.mRodBottomPartId, FP.toFP(this.mBoatWorldPosX), FP.toFP(this.mBoatWorldPosY));
    }

    public void boatDraw(Graphics graphics, int n, int n2, boolean bl) {
        this.mCanvasBoatX = this.mBoatWorldPosX - n;
        this.mCanvasBoatY = this.mBoatWorldPosY + this.mBoatDisplaceY.getOffset() - n2;
        int n3 = Game.worldToPixel(this.mBoatWorldPosX - n);
        int n4 = Game.worldToPixel(this.mBoatWorldPosY + this.mBoatDisplaceY.getOffset() - n2);
        int[] nArray = new int[]{this.mRodBottomPartId, this.mRodBasePartId, this.mRodCenterPartId, this.mRodTopPartId};
        if (GameEngine.smIntroEnabled) {
            return;
        }
        if (bl) {
            this.mFishermanHandsSpr.draw(graphics, n3, n4);
            this.mBoatFrontSpr.draw(graphics, n3, n4);
        } else {
            int n5;
            int n6;
            int n7;
            this.mBoatBackSpr.draw(graphics, n3, n4);
            this.mFishermanSpr.draw(graphics, n3, n4);
            if (this.mHookState == 1 && this.mPowerbar != null) {
                this.mPowerbar.draw(graphics, n3, n4 - 28);
            }
            int n8 = Tuner.smRods[this.mLineLenType][1];
            int n9 = n8 >> 16 & 0xFF;
            int n10 = n8 >> 8 & 0xFF;
            int n11 = n8 >> 0 & 0xFF;
            int n12 = 0xE0E0F0;
            int n13 = n12 >> 16 & 0xFF;
            int n14 = n12 >> 8 & 0xFF;
            int n15 = n12 >> 0 & 0xFF;
            int n16 = (n9 * 20 + n13 * 80) / 100;
            int n17 = (n10 * 20 + n14 * 80) / 100;
            int n18 = (n11 * 20 + n15 * 80) / 100;
            int n19 = (n16 << 16) + (n17 << 8) + n18;
            for (n7 = 0; n7 < nArray.length - 1; ++n7) {
                graphics.setColor(n19);
                n6 = Game.worldToPixel(FP.toInt(World.smPhysics.pX[nArray[n7]]) - n + 1);
                n5 = Game.worldToPixel(FP.toInt(World.smPhysics.pY[nArray[n7]]) - n2);
                int n20 = Game.worldToPixel(FP.toInt(World.smPhysics.pX[nArray[n7 + 1]]) - n + 1);
                int n21 = Game.worldToPixel(FP.toInt(World.smPhysics.pY[nArray[n7 + 1]]) - n2);
                graphics.drawLine(n6, n5, n20, n21);
                graphics.setColor(n8);
                graphics.drawLine(--n6, n5, --n20, n21);
            }
            graphics.setColor(1907265);
            for (n7 = 0; n7 < nArray.length - 1; ++n7) {
                n6 = Game.worldToPixel(FP.toInt(World.smPhysics.pX[nArray[n7]]) - n);
                n5 = Game.worldToPixel(FP.toInt(World.smPhysics.pY[nArray[n7]]) - n2);
                graphics.fillRect(n6, n5, 2, 2);
            }
            n6 = Game.worldToPixel(FP.toInt(World.smPhysics.pX[nArray.length - 1]) - n);
            n5 = Game.worldToPixel(FP.toInt(World.smPhysics.pY[nArray.length - 1]) - n2);
            graphics.fillRect(n6, n5, 1, 1);
            if (this.mHookState == 1) {
                n8 = 0;
                for (n9 = 0; n9 < nArray.length; ++n9) {
                    if (this.mLaunchStrength <= 1000 * n9 / nArray.length) continue;
                    n8 = n9;
                }
            }
        }
    }

    public void rodSadFakeAnimStarts() {
        int[] nArray = new int[]{this.mRodBottomPartId, this.mRodBasePartId, this.mRodCenterPartId, this.mRodTopPartId};
        for (int i = 0; i < nArray.length; ++i) {
            this.mBackupRodSegmentX[i] = World.smPhysics.pX[nArray[i]];
            this.mBackupRodSegmentY[i] = World.smPhysics.pY[nArray[i]];
        }
        World.smPhysics.pX[nArray[1]] = 0x8C0000;
        World.smPhysics.pX[nArray[2]] = 0x3C0000;
        World.smPhysics.pX[nArray[3]] = 0;
    }

    public void rodSadFakeAnimEnds() {
        int[] nArray = new int[]{this.mRodBottomPartId, this.mRodBasePartId, this.mRodCenterPartId, this.mRodTopPartId};
        for (int i = 0; i < nArray.length; ++i) {
            World.smPhysics.pX[nArray[i]] = this.mBackupRodSegmentX[i];
            World.smPhysics.pY[nArray[i]] = this.mBackupRodSegmentY[i];
        }
    }

    public void fishermanSetAnim(int n) {
        this.mCurrentFishermanAnim = n;
        this.mFishermanSpr.setAnimation(n, 1, true);
        this.mFishermanHandsSpr.setAnimation(n, 1, true);
    }

    public void fishermanSetAnimFrame(int n) {
        this.mFishermanSpr.setAnimationFrame(n);
        this.mFishermanHandsSpr.setAnimationFrame(n);
    }

    public int fishermanGetAnimFrameCount() {
        return this.mFishermanSpr.getFrameCount();
    }

    public void boatSetRodAngle(int n) {
        int n2;
        this.mRodAngle = n < 182 ? 182 : (n > 220 ? 220 : n);
        int n3 = World.smPhysics.pX[this.mRodBottomPartId] + FP.toFP(Trigonometry.cos(this.mRodAngle) * 40 >> 10);
        int n4 = World.smPhysics.pY[this.mRodBottomPartId] + FP.toFP(Trigonometry.sin(this.mRodAngle) * 40 >> 10);
        World.smPhysics.forceParticlePosition(this.mRodBasePartId, n3, n4);
        if (this.mHookState == 1) {
            n2 = World.smPhysics.pX[this.mRodBasePartId] + FP.toFP(Trigonometry.cos(this.mRodAngle + 5) * 50 / 2 >> 10);
            int n5 = World.smPhysics.pY[this.mRodBasePartId] + FP.toFP(Trigonometry.sin(this.mRodAngle + 5) * 50 / 2 >> 10);
            World.smPhysics.forceParticlePosition(this.mRodCenterPartId, n2, n5);
            n2 = World.smPhysics.pX[this.mRodCenterPartId] + FP.toFP(Trigonometry.cos(this.mRodAngle + 10) * 50 / 3 >> 10);
            n5 = World.smPhysics.pY[this.mRodCenterPartId] + FP.toFP(Trigonometry.sin(this.mRodAngle + 10) * 50 / 3 >> 10);
            World.smPhysics.forceParticlePosition(this.mRodTopPartId, n2, n5);
            World.smPhysics.forceParticlePosition(this.mRopeParticle[0], World.smPhysics.pX[this.mRodTopPartId], World.smPhysics.pY[this.mRodTopPartId]);
        }
        if (this.mRodAngle > 220) {
            this.mRodAngle = 220;
        } else if (this.mRodAngle < 182) {
            this.mRodAngle = 182;
        }
        n2 = (this.mRodAngle - 182) * (this.mFishermanSpr.getFrameCount() - 1) / 38;
        this.fishermanSetAnimFrame(this.mFishermanSpr.getFrameCount() - 1 - n2);
    }

    public int boatGetColBoxXCoordInWorld() {
        CollisionBox collisionBox = this.mBoatBackSpr.getCollisionBox(0);
        return this.mBoatWorldPosX + collisionBox.getX();
    }

    public int boatGetColBoxYCoordInWorld() {
        CollisionBox collisionBox = this.mBoatBackSpr.getCollisionBox(0);
        return this.mBoatWorldPosY + collisionBox.getY();
    }

    public void ropeInit() {
        smRopeSegmentLength = FP.toFP(Tuner.smRods[this.mLineLenType][0]) / 30;
        this.mRopeLen = 0;
        this.mRopeActiveParticles = 0;
        this.mRopeActiveSegments = 0;
        for (int i = 0; i < 30; ++i) {
            if (i == 0) {
                this.mRopeParticle[i] = World.smPhysics.addParticle(World.smPhysics.pX[this.mRodTopPartId], World.smPhysics.pY[this.mRodTopPartId] + 262, 131072);
                World.smPhysics.pActive[this.mRopeParticle[i]] = true;
                this.mRopeSegment[i] = World.smPhysics.addDistanceConstraint(this.mRodTopPartId, this.mRopeParticle[i], FP.toFP(1), 262144);
                World.smPhysics.cActive[this.mRopeSegment[i]] = true;
                ++this.mRopeActiveParticles;
                ++this.mRopeActiveSegments;
                continue;
            }
            this.mRopeParticle[i] = World.smPhysics.addParticle(0, 0, 13107);
            World.smPhysics.pActive[this.mRopeParticle[i]] = false;
            this.mRopeSegment[i] = World.smPhysics.addDistanceConstraint(this.mRopeParticle[i - 1], this.mRopeParticle[i], smRopeSegmentLength, 262144);
            World.smPhysics.cActive[this.mRopeSegment[i]] = false;
        }
    }

    public void ropeReset() {
    }

    public void disableRopeConstraints() {
        for (int i = 0; i < this.mRopeActiveSegments; ++i) {
            World.smPhysics.cActive[this.mRopeSegment[i]] = false;
        }
    }

    public void enableRopeConstraints() {
        for (int i = 0; i < this.mRopeActiveSegments; ++i) {
            World.smPhysics.cActive[this.mRopeSegment[i]] = true;
        }
    }

    public void ropeProcessDrag(int n) {
        int n2 = 320;
        if (Toolkit.getScreenHeight() <= Toolkit.getScreenWidth()) {
            n2 = Toolkit.getScreenHeight() > 400 ? 300 : 240;
        }
        int n3 = n2 * 95 / 100 + -25;
        for (int i = 0; i < n; ++i) {
            int n4 = FP.toFP(World.smWorldAnchorPointY + Camera.smCameraMaxY + n3);
            for (int j = 0; j < this.mRopeActiveParticles; ++j) {
                if (World.smPhysics.pY[this.mRopeParticle[j]] > n4) {
                    World.smPhysics.pY[this.mRopeParticle[j]] = n4;
                    World.smPhysics.ppY[this.mRopeParticle[j]] = World.smPhysics.pY[this.mRopeParticle[j]];
                    World.smPhysics.ppX[this.mRopeParticle[j]] = World.smPhysics.pX[this.mRopeParticle[j]];
                    continue;
                }
                if (FP.toInt(World.smPhysics.pY[this.mRopeParticle[j]]) > World.mBackground.mWavesBottomWorldPosY) {
                    if (j == 0) {
                        World.smPhysics.setParticleDrag(this.mRopeParticle[j], 157286, 157286);
                        continue;
                    }
                    World.smPhysics.setParticleDrag(this.mRopeParticle[j], 157286, 262142);
                    continue;
                }
                World.smPhysics.setParticleDrag(this.mRopeParticle[j], 20971, 20971);
            }
        }
    }

    public void setRopeLength(int n) {
        if (n > FP.toFP(Tuner.smRods[this.mLineLenType][0])) {
            n = FP.toFP(Tuner.smRods[this.mLineLenType][0]);
        }
        if (n < 0) {
            n = 262;
        }
        int n2 = smRopeSegmentLength;
        if (this.mFishermanId == 0 && this.mIsPerfectThrow) {
            n2 = n2 * 25 / 10;
            this.mRopeLen = Math.max(this.mRopeLen, n);
        }
        this.mRopeLen = n;
        int n3 = this.mRopeActiveSegments * n2;
        int n4 = n3 - n2;
        if (n < n3) {
            if (n <= n4 && this.mRopeActiveSegments > 1) {
                World.smPhysics.pActive[this.mRopeParticle[this.mRopeActiveSegments - 1]] = false;
                World.smPhysics.cActive[this.mRopeSegment[this.mRopeActiveSegments - 1]] = false;
                World.smPhysics.cpA[this.mRopeSegment[this.mRopeActiveSegments - 2]] = this.mRodTopPartId;
                World.smPhysics.cL[this.mRopeSegment[this.mRopeActiveSegments - 2]] = n - n4 + n2;
                --this.mRopeActiveSegments;
                --this.mRopeActiveParticles;
            } else {
                World.smPhysics.cL[this.mRopeSegment[this.mRopeActiveSegments - 1]] = n - n4;
            }
        } else if (n > n3) {
            World.smPhysics.cL[this.mRopeSegment[this.mRopeActiveSegments - 1]] = n2;
            ++this.mRopeActiveSegments;
            ++this.mRopeActiveParticles;
            World.smPhysics.pActive[this.mRopeParticle[this.mRopeActiveSegments - 1]] = true;
            World.smPhysics.cActive[this.mRopeSegment[this.mRopeActiveSegments - 1]] = true;
            World.smPhysics.forceParticlePosition(this.mRopeParticle[this.mRopeActiveSegments - 1], World.smPhysics.pX[this.mRodTopPartId], World.smPhysics.pY[this.mRodTopPartId]);
            World.smPhysics.cpA[this.mRopeSegment[this.mRopeActiveSegments - 1]] = this.mRodTopPartId;
            World.smPhysics.cpB[this.mRopeSegment[this.mRopeActiveSegments - 1]] = this.mRopeParticle[this.mRopeActiveSegments - 1];
            World.smPhysics.cpA[this.mRopeSegment[this.mRopeActiveSegments - 2]] = this.mRopeParticle[this.mRopeActiveSegments - 1];
            World.smPhysics.cL[this.mRopeSegment[this.mRopeActiveSegments - 1]] = 262;
        } else {
            World.smPhysics.cL[this.mRopeSegment[this.mRopeActiveSegments - 1]] = n - n4;
        }
    }

    public void hookInit() {
        this.fishedTextInit();
        this.hookReset();
        this.fishermanSetAnim(0);
        this.mMustWaitEndTurn = false;
        this.mIsPerfectThrow = true;
        this.hookChangeState(-1);
    }

    public void hookReset() {
        this.mHookWasUnderWater = false;
        this.mHookIsUnderWater = false;
        this.mLaunchStrength = 0;
        this.mHookedFishID = -1;
        this.mIsLineBroken = false;
        this.mLineTension = 0;
        this.throwingLoops = 0;
        if (this.mFishermanId == 0) {
            Hud.disablePress5FeedBack();
            Hud.disableRelease5FeedBack();
        }
    }

    public void hookChangeState(int n) {
        this.mHookState = n;
    }

    public void hookLogicUpdate(int n) {
        if (this.mFishermanId != 0) {
            this.cpuPlayerAiLogicUpdate(n);
        }
        switch (this.mHookState) {
            case -1: {
                if (this.mActionButtonIsPressed || this.mMustWaitEndTurn) break;
                if (this.mFishermanId == 0) {
                    Hud.enablePress5FeedBack();
                    Hud.disableRelease5FeedBack();
                } else {
                    this.cpuPlayerAiInitTimer(0);
                }
                this.hookChangeState(0);
                break;
            }
            case 0: {
                if (this.mRodAngle < 220) {
                    this.boatSetRodAngle(this.mRodAngle + 2);
                } else {
                    this.mRodAngle = 220;
                    this.boatSetRodAngle(this.mRodAngle);
                }
                if (!this.mActionButtonIsPressed) break;
                this.cpuPlayerAiInitTimer(1);
                World.smPhysics.pM[this.mRodCenterPartId] = 0;
                World.smPhysics.pM[this.mRodTopPartId] = 0;
                World.smPhysics.pM[this.mRopeParticle[0]] = 0;
                this.mLaunchStrengthDir = 1;
                this.hookChangeState(1);
                break;
            }
            case 1: {
                if (this.mActionButtonIsPressed) {
                    this.mLaunchStrength += n * this.mLaunchStrengthDir;
                    if (this.mLaunchStrength > 1000) {
                        this.mLaunchStrength = 1000;
                        this.mLaunchStrengthDir = -1;
                    } else if (this.mLaunchStrength < 100) {
                        this.mLaunchStrength = 100;
                        this.mLaunchStrengthDir = 1;
                    } else if (this.mLaunchStrength > 700 && Hud.smIsDrawingPress5 && this.mFishermanId == 0) {
                        Hud.disablePress5FeedBack();
                        Hud.enableRelease5FeedBack();
                    }
                    int n2 = 220 - 38 * this.mLaunchStrength / 1000;
                    this.boatSetRodAngle(n2);
                    break;
                }
                this.cpuPlayerAiInitTimer(2);
                int n3 = 220 - this.mRodAngle;
                int n4 = Tuner.smRods[this.mLineLenType][2] + n3 * (Tuner.smRods[this.mLineLenType][3] - Tuner.smRods[this.mLineLenType][2]) / 38;
                int n5 = Tuner.smRods[this.mLineLenType][4] + n3 * (Tuner.smRods[this.mLineLenType][5] - Tuner.smRods[this.mLineLenType][4]) / 38;
                World.smPhysics.setParticleVelocity(this.mRopeParticle[0], FP.toFP(n4), FP.toFP(n5));
                this.fishermanSetAnim(1);
                World.smPhysics.pM[this.mRodCenterPartId] = 262144;
                World.smPhysics.pM[this.mRodTopPartId] = 262144;
                World.smPhysics.pM[this.mRopeParticle[0]] = 262144;
                this.hookChangeState(2);
                if (this.mFishermanId == 0) {
                    Hud.disableRelease5FeedBack();
                    Hud.disablePress5FeedBack();
                }
                if (this.mFishermanId != 0) break;
                int n6 = 38;
                if (n3 >= n6 * 98 / 100) {
                    World.smPhysics.setParticleVelocity(this.mRopeParticle[0], FP.toFP(n4 * 133 / 100), FP.toFP(n5));
                    this.mIsPerfectThrow = true;
                    Hud.setNewFeedbackMsg(-1, Toolkit.getText(21), this.mFishermanId);
                    break;
                }
                this.mIsPerfectThrow = false;
                break;
            }
            case 2: {
                if (this.mRodAngle < 220) {
                    this.boatSetRodAngle(this.mRodAngle + n / 2);
                }
                int n7 = World.smPhysics.pX[this.mRopeParticle[0]] - World.smPhysics.pX[this.mRodTopPartId];
                int n8 = World.smPhysics.pY[this.mRopeParticle[0]] - World.smPhysics.pY[this.mRodTopPartId];
                int n9 = PhysicsFP.distance(n7, n8);
                this.setRopeLength(n9);
                if (FP.toInt(World.smPhysics.pY[this.mRopeParticle[0]]) <= World.mBackground.mWavesBottomWorldPosY - 37) break;
                this.cpuPlayerAiInitTimer(3);
                this.fishermanSetAnim(2);
                this.hookChangeState(3);
                if (this.mFishermanId != 0) break;
                int n10 = FP.toInt(World.smPhysics.pX[this.mRopeParticle[0]] - World.smPhysics.pX[this.mRodTopPartId]) * 10 / 100;
                String string = Toolkit.replaceParameters(Toolkit.getText(20), new String[]{"" + n10});
                this.distanceFeedbackInit(string, FP.toInt(World.smPhysics.pX[this.mRopeParticle[0]]), Game.worldToPixel(FP.toInt(World.smPhysics.pY[this.mRopeParticle[0]]) - World.smScrollOffsetY), Toolkit.getScreenHeight() / 14);
                break;
            }
            case 3: {
                int n11;
                int n12;
                int n13;
                int n14;
                if (!this.mIsLineBroken && this.mHookedFishID != -1 && FP.toInt(World.smPhysics.pY[this.mRopeParticle[0]]) < World.mBackground.mWavesBottomWorldPosY && (n14 = (n13 = PhysicsFP.distance(n12 = World.smPhysics.pX[this.mRopeParticle[0]] - World.smPhysics.pX[this.mRodTopPartId], n11 = World.smPhysics.pY[this.mRopeParticle[0]] - World.smPhysics.pY[this.mRodTopPartId])) * 12 / 10) > 0 && this.mRopeLen > n14) {
                    this.setRopeLength(n14);
                }
                if (this.mActionButtonIsPressed) {
                    if (FP.toInt(World.smPhysics.pY[this.mRopeParticle[0]]) > World.mBackground.mWavesBottomWorldPosY) {
                        if (this.mHookedFishID == -1) {
                            n14 = 39321;
                            this.setRopeLength(this.mRopeLen - n14 * n);
                        } else {
                            n14 = World.mFishesOfStage[this.mHookedFishID].mWeight > 2600 ? 26214 : (World.mFishesOfStage[this.mHookedFishID].mWeight < 600 ? 39321 : 52428);
                            this.setRopeLength(this.mRopeLen - n14 * n);
                            int n15 = World.mFishesOfStage[this.mHookedFishID].mDifficulty * n / 100;
                            if (this.mFishermanId == 1 && Game.smTournamentToPlay == 2) {
                                n15 /= 2;
                            }
                            this.mLineTension += n15;
                            if (this.mLineTension > Tuner.strengthHook[this.mLineStrengthType]) {
                                if (this.mFishermanId == 0) {
                                    Hud.disablePress5FeedBack();
                                    Hud.disableRelease5FeedBack();
                                }
                                this.hookChangeState(5);
                            } else if (this.mLineTension > Tuner.strengthHook[this.mLineStrengthType] * 60 / 100 && Hud.smIsDrawingPress5 && this.mFishermanId == 0) {
                                Hud.disablePress5FeedBack();
                                Hud.enableRelease5FeedBack();
                            }
                        }
                    } else if (this.mHookedFishID == -1) {
                        n14 = 104857;
                        this.setRopeLength(this.mRopeLen - n14 * n);
                        this.mLineTension -= n * 2;
                        if (this.mLineTension < 0) {
                            this.mLineTension = 0;
                        }
                    } else {
                        n14 = 26214;
                        this.setRopeLength(this.mRopeLen - n14 * n);
                        if (World.mFishesOfStage[this.mHookedFishID].mState == 4) {
                            this.mLineTension += World.mFishesOfStage[this.mHookedFishID].mDifficulty * n / 100;
                            if (this.mLineTension > Tuner.strengthHook[this.mLineStrengthType]) {
                                if (this.mFishermanId == 0) {
                                    Hud.disablePress5FeedBack();
                                    Hud.disableRelease5FeedBack();
                                }
                                this.hookChangeState(5);
                            } else if (this.mLineTension > Tuner.strengthHook[this.mLineStrengthType] * 60 / 100 && Hud.smIsDrawingPress5 && this.mFishermanId == 0) {
                                Hud.disablePress5FeedBack();
                                Hud.enableRelease5FeedBack();
                            }
                        } else {
                            this.mLineTension -= n * 2;
                            if (this.mLineTension < 0) {
                                this.mLineTension = 0;
                            }
                        }
                    }
                } else {
                    if (this.mLineTension < Tuner.strengthHook[this.mLineStrengthType] * 30 / 100 && Hud.smIsDrawingRelease5 && this.mFishermanId == 0) {
                        Hud.enablePress5FeedBack();
                        Hud.disableRelease5FeedBack();
                    }
                    this.mLineTension -= n;
                    if (this.mLineTension < 0) {
                        this.mLineTension = 0;
                    }
                    n12 = World.smPhysics.pX[this.mRopeParticle[0]] - World.smPhysics.pX[this.mRodTopPartId];
                    n11 = World.smPhysics.pY[this.mRopeParticle[0]] - World.smPhysics.pY[this.mRodTopPartId];
                    if (FP.toInt(World.smPhysics.pY[this.mRopeParticle[0]]) > World.mBackground.mWavesBottomWorldPosY && this.mHookedFishID == -1) {
                        n13 = PhysicsFP.distance(n12, n11) + 786432;
                        this.setRopeLength(n13);
                    }
                }
                int n16 = n14 = this.mRopeLen <= smRopeSegmentLength / 2 ? 1 : 0;
                if (!this.mIsLineBroken && this.mHookedFishID != -1 && n14 != 0) {
                    if (this.mFishermanId == 0) {
                        Hud.disablePress5FeedBack();
                    }
                    this.hookChangeState(4);
                    World.mFishesOfStage[this.mHookedFishID].changeState(9);
                    break;
                }
                if (this.mRopeLen > 262144) break;
                if (this.mIsLineBroken) {
                    Hud.smTurnEnded = true;
                }
                if (this.mFishermanId == 0) {
                    Hud.disablePress5FeedBack();
                }
                this.hookReset();
                if (Tuner.smLevels[Hud.smCurrentLevel][0] == 0 || Tuner.smLevels[Hud.smCurrentLevel][0] == 1) {
                    this.mMustWaitEndTurn = true;
                }
                this.hookChangeState(-1);
                break;
            }
            case 4: {
                if (this.mRopeLen <= 262144) {
                    this.hookReset();
                    if (Tuner.smLevels[Hud.smCurrentLevel][0] == 0 || Tuner.smLevels[Hud.smCurrentLevel][0] == 1) {
                        this.mMustWaitEndTurn = true;
                    }
                    this.mActionButtonIsPressed = false;
                }
                if (this.mRopeLen <= 262144) break;
                this.setRopeLength(FP.toInt(this.mRopeLen) - 26214 * n);
                this.mLineTension = 0;
                break;
            }
            case 5: {
                this.hookChangeState(6);
                this.mActionButtonIsPressed = false;
                this.mIsLineBroken = true;
                if (this.mFishermanId == 0) {
                    if (World.mFishesOfStage[this.mHookedFishID].mSpecie == 27) {
                        Hud.setNewFeedbackMsg(-1, Hud.smHudText[18], this.mFishermanId);
                    } else {
                        Hud.setNewFeedbackMsg(-1, Hud.smHudText[17], this.mFishermanId);
                    }
                }
                this.mThiefFish = this.mHookedFishID;
                World.mFishesOfStage[this.mHookedFishID].scare();
                this.mHookedFishID = -1;
                break;
            }
            case 6: {
                if (this.mRopeLen > 262144) {
                    this.setRopeLength(this.mRopeLen - 104857 * n);
                    if (this.mRopeLen > 262144) break;
                    this.rodSadFakeAnimStarts();
                    this.fishermanSetAnim(3);
                    break;
                }
                if (!this.mFishermanSpr.isFinishedAnimation() && !this.mActionButtonIsPressed) break;
                this.rodSadFakeAnimEnds();
                this.fishermanSetAnim(0);
                Hud.smTurnEnded = true;
                if (this.mFishermanId == 0) {
                    Hud.disablePress5FeedBack();
                }
                this.hookReset();
                this.hookChangeState(-1);
                break;
            }
            case 7: {
                if (!this.mFishermanSpr.isFinishedAnimation() && !this.mActionButtonIsPressed) break;
                this.fishermanSetAnim(0);
                this.hookReset();
                this.hookChangeState(-1);
            }
        }
        boolean bl = this.mHookIsUnderWater = FP.toInt(World.smPhysics.pY[this.mRopeParticle[0]]) > World.mBackground.mWavesBottomWorldPosY;
        if (this.mFishermanId == 0 && smDistanceFeedbackStr != null) {
            this.distanceFeedbackLogicUpdate(n);
        }
        if (this.mHookIsUnderWater && !this.mHookWasUnderWater || !this.mHookIsUnderWater && this.mHookWasUnderWater) {
            World.mBackground.splashCreate(IngameBg.SPLASH_FIRST_FREE_POS, FP.toInt(World.smPhysics.pX[this.mRopeParticle[0]]), World.mBackground.mWavesBottomWorldPosY, 0);
            this.mHookWasUnderWater = this.mHookIsUnderWater;
        }
    }

    public void hookDoDraw(Graphics graphics, int n, int n2) {
        int n3;
        int n4;
        if (GameEngine.smIntroEnabled) {
            return;
        }
        int n5 = 0xEAEAEA;
        if (this.mIsLineBroken) {
            n5 = 0xFF0000;
        } else {
            n5 = 0xFF0000;
            n5 |= 255 - 255 * this.mLineTension / Tuner.strengthHook[this.mLineStrengthType] << 8;
            n5 |= 255 - 255 * this.mLineTension / Tuner.strengthHook[this.mLineStrengthType];
        }
        graphics.setColor(n5);
        for (n4 = 0; n4 < this.mRopeActiveSegments; ++n4) {
            n3 = Game.worldToPixel(FP.toInt(World.smPhysics.pX[World.smPhysics.cpA[this.mRopeSegment[n4]]]) - n);
            int n6 = Game.worldToPixel(FP.toInt(World.smPhysics.pY[World.smPhysics.cpA[this.mRopeSegment[n4]]]) - n2);
            int n7 = Game.worldToPixel(FP.toInt(World.smPhysics.pX[World.smPhysics.cpB[this.mRopeSegment[n4]]]) - n);
            int n8 = Game.worldToPixel(FP.toInt(World.smPhysics.pY[World.smPhysics.cpB[this.mRopeSegment[n4]]]) - n2);
            graphics.drawLine(n3, n6, n7, n8);
        }
        graphics.setColor(Tuner.colorBaits[this.mBaitType]);
        n4 = Game.worldToPixel(FP.toInt(World.smPhysics.pX[this.mRopeParticle[0]]) - n);
        n3 = Game.worldToPixel(FP.toInt(World.smPhysics.pY[this.mRopeParticle[0]]) - n2);
        graphics.fillRect(n4 - 2, n3 - 2, 5, 5);
        this.fishedTextDraw(graphics, Game.worldToPixel(-n), Game.worldToPixel(-n2));
    }

    public void distanceFeedbackInit(String string, int n, int n2, int n3) {
        smDistanceFeedbackStr = string;
        smDistanceFeedbackX = n;
        smDistanceFeedbackInitY = n2;
        smDistanceFeedbackFinalY = n3;
        smDistanceFeedbackY = smDistanceFeedbackInitY;
        this.mTimeElapsed = 0;
    }

    public void distanceFeedbackLogicUpdate(int n) {
        this.mTimeElapsed += n;
        smDistanceFeedbackY = smDistanceFeedbackInitY + (smDistanceFeedbackFinalY - smDistanceFeedbackInitY) * this.mTimeElapsed / 1000;
        if (smDistanceFeedbackY < smDistanceFeedbackFinalY) {
            smDistanceFeedbackStr = null;
        }
    }

    public static void distanceFeedbackDraw(Graphics graphics, int n) {
        if (smDistanceFeedbackStr != null) {
            Hud.smFeedbackFont.drawString(graphics, smDistanceFeedbackStr, Game.worldToPixel(smDistanceFeedbackX - n), Game.worldToPixel(smDistanceFeedbackY), 17);
        }
    }

    public static void distanceFeedbackFreeResources() {
        smDistanceFeedbackStr = null;
    }

    private void cpuPlayerAiInitTimer(int n) {
        this.mAiTimerElapsed = 0;
        this.mAiTimerState = n;
        block0 : switch (this.mAiTimerState) {
            case 0: {
                switch (Game.smTournamentToPlay) {
                    case 0: {
                        this.mAiTimerMax = 2000;
                        break;
                    }
                    case 1: {
                        this.mAiTimerMax = 1000;
                        break;
                    }
                    case 2: {
                        this.mAiTimerMax = 500;
                    }
                }
                break;
            }
            case 1: {
                switch (Game.smTournamentToPlay) {
                    case 0: {
                        this.mAiTimerMax = 600;
                        break;
                    }
                    case 1: {
                        this.mAiTimerMax = 700;
                        break;
                    }
                    case 2: {
                        this.mAiTimerMax = 900;
                    }
                }
                break;
            }
            case 3: {
                if (this.mActionButtonIsPressed) {
                    switch (Game.smTournamentToPlay) {
                        case 0: {
                            this.mAiTimerMax = 6000;
                            break;
                        }
                        case 1: {
                            this.mAiTimerMax = 4000;
                            break;
                        }
                        case 2: {
                            this.mAiTimerMax = 2000;
                        }
                    }
                    break;
                }
                switch (Game.smTournamentToPlay) {
                    case 0: {
                        this.mAiTimerMax = 4500;
                        break block0;
                    }
                    case 1: {
                        this.mAiTimerMax = 6500;
                        break block0;
                    }
                    case 2: {
                        this.mAiTimerMax = 8500;
                    }
                }
            }
        }
    }

    private void cpuPlayerAiLogicUpdate(int n) {
        switch (this.mAiTimerState) {
            case -1: 
            case 2: 
            case 4: 
            case 5: {
                this.mActionButtonIsPressed = false;
                break;
            }
            case 3: {
                if (this.mHasSomeFishBiting) {
                    this.mActionButtonIsPressed = true;
                    break;
                }
            }
            default: {
                this.mAiTimerElapsed += n;
                if (this.mAiTimerElapsed < this.mAiTimerMax) break;
                this.mAiTimerElapsed = 0;
                this.mActionButtonIsPressed = !this.mActionButtonIsPressed;
            }
        }
    }

    public void fishedTextInit() {
        this.mFishedTextDisplace = new Displace();
        this.mFishedTextEnabled = false;
    }

    public void fishedTextStart(int n, int n2, int n3) {
        this.mFishedTextStartX = n2;
        this.mFishedTextStartY = n3;
        this.mFishedTextStartId = n;
        this.mFishedTextDisplace.create(Toolkit.getScreenHeight() / 8, 750, true, 2);
        this.mFishedTextEnabled = true;
    }

    public void fishedTextDraw(Graphics graphics, int n, int n2) {
        if (this.mFishedTextEnabled) {
            int n3 = this.mFishedTextStartY + n2 - this.mFishedTextDisplace.getOffset();
            if (Game.toKg(World.mFishesOfStage[this.mFishedTextStartId].mWeight) != null) {
                Hud.smFeedbackFont.drawString(graphics, "+" + Game.toKg(World.mFishesOfStage[this.mFishedTextStartId].mWeight) + " " + Hud.smHudText[9], Game.worldToPixel(this.mFishedTextStartX + n) + 0, n3, 36);
            }
            if (this.mFishedTextDisplace.isFinished()) {
                Hud.scoreShowFeedback(this.mFishermanId, World.mFishesOfStage[this.mFishedTextStartId].mSpecie, World.mFishesOfStage[this.mFishedTextStartId].mWeight, World.mFishesOfStage[this.mFishedTextStartId].mDifficulty);
                this.mFishedTextEnabled = false;
            }
        }
    }

    public static SpriteObject loadSpriteObject(int[] nArray, boolean bl) {
        Animation[] animationArray = DavinciUtilities.loadAnimations(nArray);
        SpriteObject spriteObject = new SpriteObject(animationArray, bl);
        if (smSpriteObjectCache == null) {
            smSpriteObjectCache = new Vector();
        }
        smSpriteObjectCache.addElement(spriteObject);
        return spriteObject;
    }

    public static SpriteObject loadSpriteObject(int n, boolean bl) {
        return Fisherman.loadSpriteObject(new int[]{n}, bl);
    }

    public static void freeResources() {
        smDistanceFeedbackStr = null;
        if (smSpriteObjectCache != null) {
            for (int i = 0; i < smSpriteObjectCache.size(); ++i) {
                SpriteObject spriteObject = (SpriteObject)smSpriteObjectCache.elementAt(i);
                spriteObject.freeResources();
            }
            smSpriteObjectCache = null;
        }
    }
}

