/*
 * Decompiled with CFR 0.152.
 */
package com.alienfactory.javamappy.viewer;

import com.alienfactory.javamappy.AnimBlock;
import com.alienfactory.javamappy.Layer;
import com.alienfactory.javamappy.MapHeader;
import com.alienfactory.javamappy.util.ParameterChecker;
import javax.microedition.lcdui.Image;
import javax.microedition.lcdui.game.TiledLayer;

public class TiledLayerWrapper {
    private final Layer a;
    private final TiledLayer b;
    private final int[] c;
    private boolean d;

    public TiledLayerWrapper(Layer layer, int n, Image animBlockArray, boolean bl) {
        ParameterChecker.checkNotNull(layer, "layer");
        ParameterChecker.checkNotNull(animBlockArray, "tileSheetImage");
        this.a = layer;
        this.d = bl;
        MapHeader mapHeader = layer.getMapHeader();
        int n2 = mapHeader.getMapBlockWidth();
        int n3 = mapHeader.getMapBlockHeight();
        int n4 = mapHeader.getBlockWidth();
        int n5 = mapHeader.getBlockHeight();
        this.b = new TiledLayer(n2, n3, (Image)animBlockArray, n4, n5);
        animBlockArray = layer.getAnimBlocks();
        if (animBlockArray == null) {
            animBlockArray = new AnimBlock[]{};
        }
        this.c = new int[animBlockArray.length];
        for (n5 = 0; n5 < animBlockArray.length; ++n5) {
            this.c[n5] = n2 = this.b.createAnimatedTile(animBlockArray[n5].getCurrentFrame());
        }
        short[][] sArray = layer.getLayerData();
        for (int i = 0; i < sArray.length; ++i) {
            for (n3 = 0; n3 < sArray[i].length; ++n3) {
                if (layer.isAnimBlock(n3, i)) {
                    n5 = layer.getBlockIndex(n3, i);
                    n5 = this.c[-n5 - 1];
                } else {
                    n5 = layer.getBlock(n3, i).getImageIndex(n) + (bl ? 1 : 0);
                }
                this.b.setCell(n3, i, n5);
            }
        }
    }

    public Layer getLayer() {
        return this.a;
    }

    public TiledLayer getTiledLayer() {
        return this.b;
    }

    public void animateLayer() {
        AnimBlock[] animBlockArray = this.a.getAnimBlocks();
        if (animBlockArray == null) {
            return;
        }
        for (int i = 0; i < animBlockArray.length; ++i) {
            animBlockArray[i].updateAnimation();
            int n = animBlockArray[i].getCurrentFrame() + (this.d ? 1 : 0);
            this.b.setAnimatedTile(this.c[i], n);
        }
    }
}

