/*
 * Decompiled with CFR 0.152.
 */
package com.alienfactory.javamappy.loader;

import com.alienfactory.javamappy.JavaMappyException;
import com.alienfactory.javamappy.Map;
import com.alienfactory.javamappy.loader.ChunkLoadException;
import com.alienfactory.javamappy.loader.ChunkLoader;
import com.alienfactory.javamappy.loader.ChunkLoaderANDT;
import com.alienfactory.javamappy.loader.ChunkLoaderATHR;
import com.alienfactory.javamappy.loader.ChunkLoaderBGFX;
import com.alienfactory.javamappy.loader.ChunkLoaderBKDT;
import com.alienfactory.javamappy.loader.ChunkLoaderBODY;
import com.alienfactory.javamappy.loader.ChunkLoaderCMAP;
import com.alienfactory.javamappy.loader.ChunkLoaderFORM;
import com.alienfactory.javamappy.loader.ChunkLoaderMPHD;
import com.alienfactory.javamappy.loader.ChunkLoaderOBDT;
import com.alienfactory.javamappy.loader.ChunkLoaderTSTR;
import com.alienfactory.javamappy.loader.MapLoader$DefaultChunkLoader;
import com.alienfactory.javamappy.util.Logger;
import com.alienfactory.javamappy.util.ParameterChecker;
import java.io.InputStream;
import java.util.Hashtable;

public class MapLoader {
    private static final Logger a = Logger.createLogger("MapLoader");
    private Hashtable b = new Hashtable();

    public MapLoader() {
        MapLoader mapLoader = this;
        mapLoader.a("ANDT", new ChunkLoaderANDT());
        mapLoader.a("ATHR", new ChunkLoaderATHR());
        mapLoader.a("BGFX", new ChunkLoaderBGFX());
        mapLoader.a("BKDT", new ChunkLoaderBKDT());
        mapLoader.a("CMAP", new ChunkLoaderCMAP());
        mapLoader.a("FORM", new ChunkLoaderFORM());
        mapLoader.a("MPHD", new ChunkLoaderMPHD());
        mapLoader.a("OBDT", new ChunkLoaderOBDT());
        mapLoader.a("TSTR", new ChunkLoaderTSTR());
        ChunkLoaderBODY chunkLoaderBODY = new ChunkLoaderBODY();
        mapLoader.a("BODY", chunkLoaderBODY);
        mapLoader.a("LYR1", chunkLoaderBODY);
        mapLoader.a("LYR2", chunkLoaderBODY);
        mapLoader.a("LYR3", chunkLoaderBODY);
        mapLoader.a("LYR4", chunkLoaderBODY);
        mapLoader.a("LYR5", chunkLoaderBODY);
        mapLoader.a("LYR6", chunkLoaderBODY);
        mapLoader.a("LYR7", chunkLoaderBODY);
    }

    public static Map loadMap(InputStream inputStream) {
        return new MapLoader().a(inputStream);
    }

    private Map a(InputStream inputStream) {
        if (inputStream == null) {
            throw new IllegalArgumentException("Input parameter [inputStream] was null");
        }
        a.trace("loadMap() - Starting...");
        a.info("Loading Map from InputStream");
        Map map = new Map();
        try {
            ChunkLoader chunkLoader = this.b(inputStream);
            if (!chunkLoader.getChunkName().equals("FORM")) {
                throw new JavaMappyException("Map does not start with chunk [FORM] :: Chunk ID = [" + chunkLoader.getChunkName() + "]");
            }
            chunkLoader.loadChunk(null);
            long l = chunkLoader.getChunkLength() - 4;
            while (l > 0L) {
                chunkLoader = this.b(inputStream);
                chunkLoader.loadChunk(map);
                if (chunkLoader.getBytesRemaining() > 0) {
                    a.warn("Chunk [" + chunkLoader.getChunkName() + "] still has [" + chunkLoader.getBytesRemaining() + "] bytes remaining, skipping...");
                }
                l = l - 8L - (long)chunkLoader.getChunkLength();
            }
        }
        catch (JavaMappyException javaMappyException) {
            throw javaMappyException;
        }
        catch (Exception exception) {
            throw new JavaMappyException("Could not load map", exception);
        }
        a.trace("loadMap() - Done.");
        return map;
    }

    private ChunkLoader b(InputStream inputStream) {
        ParameterChecker.checkNotNull(inputStream, "inputStream");
        ChunkLoader chunkLoader = null;
        String string = null;
        a.trace("createChunkLoader() - Starting...");
        try {
            byte[] byArray = new byte[4];
            string = "Could not read the chunk ID.";
            MapLoader.a(inputStream, byArray, 4);
            String string2 = new String(byArray);
            string = "Could not read the chunk length for Chunk ID [" + string2 + "]";
            MapLoader.a(inputStream, byArray, 4);
            int n = 0;
            for (int i = 0; i < 4; ++i) {
                n = n << 8 | byArray[i] & 0xFF;
            }
            string = "Could not read the raw chunk data for Chunk ID [" + string2 + "]";
            byArray = new byte[n];
            if (string2.equals("FORM")) {
                MapLoader.a(inputStream, byArray, 4);
            } else {
                MapLoader.a(inputStream, byArray, n);
            }
            string = "Problem setting Default Chunk Loader attributes.";
            chunkLoader = new MapLoader$DefaultChunkLoader();
            chunkLoader.a(string2, byArray);
            string = "Could not find a ChunkLoader for ID=[" + string2 + "].";
            ChunkLoader chunkLoader2 = (ChunkLoader)this.b.get(string2);
            if (chunkLoader2 == null) {
                throw new RuntimeException();
            }
            chunkLoader = chunkLoader2;
            string = "Problem initialiising Chunk Loader.";
            chunkLoader.a(string2, byArray);
        }
        catch (Exception exception) {
            if (chunkLoader != null) {
                a.warn(string);
            }
            throw new ChunkLoadException(string, exception);
        }
        a.info(chunkLoader);
        a.trace("createChunkLoader() - Done.");
        return chunkLoader;
    }

    private void a(String string, ChunkLoader chunkLoader) {
        this.b.put(string, chunkLoader);
    }

    private static void a(InputStream inputStream, byte[] byArray, int n) {
        for (int i = 0; i >= 0 && i < n; i += inputStream.read(byArray, i, n - i)) {
        }
    }
}

