/*
 * Decompiled with CFR 0.152.
 */
public class Animation {
    private long m_loopStartTime = 0L;
    protected int m_loopcount = 0;
    protected int[] m_frametimeout = null;
    protected int m_frame_timeout_total = 0;

    public Animation(int fileID) {
        this.reuse(fileID);
    }

    protected Animation(int[] datas) {
        this.init(datas);
    }

    protected void init(int[] datas) {
        this.m_loopcount = datas[0];
        this.m_frame_timeout_total = 0;
        this.m_frametimeout = new int[datas.length - 1];
        for (int i = 0; i < datas.length - 1; ++i) {
            this.m_frame_timeout_total += datas[i + 1];
            this.m_frametimeout[i] = this.m_frame_timeout_total;
        }
        this.reset();
    }

    public void reset() {
        this.m_loopStartTime = DashResourceProvider.getAppTime();
    }

    public void reuse(int fileID) {
        Animation a = FS.getAnimation(fileID);
        if (a == null) {
            throw new RuntimeException("Animation::reuse id " + fileID + " could not find animation object attached.");
        }
        this.m_frame_timeout_total = a.m_frame_timeout_total;
        this.m_frametimeout = a.m_frametimeout;
        this.m_loopcount = a.m_loopcount;
        this.reset();
    }

    public boolean done() {
        return this.m_loopcount == -1;
    }

    public long duration() {
        if (this.m_frametimeout != null) {
            return this.m_frametimeout[this.m_frametimeout.length - 1];
        }
        return 0L;
    }

    public int getFrame() {
        int frame = 0;
        if (this.m_frametimeout != null) {
            long animtime;
            long currtime = DashResourceProvider.getAppTime();
            if (this.m_loopStartTime == 0L) {
                this.m_loopStartTime = currtime;
            }
            if ((animtime = currtime - this.m_loopStartTime) > (long)this.m_frametimeout[this.m_frametimeout.length - 1]) {
                this.m_loopStartTime = currtime - (animtime %= this.duration());
                if (this.m_loopcount > 0) {
                    this.m_loopcount = this.m_loopcount == 1 ? -1 : --this.m_loopcount;
                }
            }
            if (this.m_loopcount == -1) {
                frame = this.m_frametimeout.length - 1;
            } else {
                for (int i = 0; i < this.m_frametimeout.length; ++i) {
                    if ((long)this.m_frametimeout[i] <= animtime) continue;
                    frame = i;
                    break;
                }
            }
        }
        return frame;
    }
}

