/*
 * Decompiled with CFR 0.152.
 */
import java.util.Vector;
import javax.microedition.lcdui.Graphics;

public final class DashMenu
implements SPDefines {
    DashFont font = null;
    DashFont fontGrey = null;
    DashImage selector_image = null;
    DashMenuStyle m_style = null;
    int bgColor = 0;
    int borderColor = 0;
    int selectColor = 0;
    int px;
    int py;
    int dx;
    int dy;
    public boolean animateScroll;
    public boolean scrolling;
    public int itemYOffset;
    public int itemXOffset;
    public int numFrames;
    public int scrollDir;
    boolean m_hsStyle;
    int currItem = 0;
    Vector menuItems = new Vector(2, 1);
    private int m_last_pointerselect = -1;

    public DashMenu(AEERect area, int foregroundColor, int backgroundColor, DashFont fnt, int selectorImageID) {
        this.init(area, fnt);
        this.selector_image = DashResourceProvider.getImage(selectorImageID);
        this.bgColor = backgroundColor;
        this.borderColor = foregroundColor;
        this.selectColor = foregroundColor;
    }

    public DashMenu(AEERect area, int foregroundColor, int backgroundColor, DashFont fnt, DashFont fnt2, int selectorImageID) {
        this.init(area, fnt, fnt2);
        if (selectorImageID != -1) {
            this.selector_image = DashResourceProvider.getImage(selectorImageID);
        }
        this.bgColor = backgroundColor;
        this.borderColor = foregroundColor;
        this.selectColor = foregroundColor;
    }

    private void init(AEERect area, DashFont fnt) {
        this.font = fnt;
        this.px = area.x;
        this.py = area.y;
        this.dx = area.dx;
        this.dy = area.dy;
    }

    public void staticInit() {
        this.selector_image = null;
        this.m_style = null;
        this.font = null;
        this.bgColor = 0;
        this.borderColor = 0;
        this.selectColor = 0;
        this.currItem = 0;
        this.m_last_pointerselect = -1;
    }

    public void init(AEERect area, DashFont fnt, DashFont fnt2) {
        this.staticInit();
        this.font = fnt;
        this.fontGrey = fnt2;
        this.px = area.x;
        this.py = area.y;
        this.dx = area.dx;
        this.dy = area.dy;
        this.animateScroll = false;
        this.numFrames = 8;
        this.itemYOffset = 0;
        this.scrolling = false;
        this.m_hsStyle = false;
    }

    public void enableAnimation() {
        this.animateScroll = true;
        this.scrollDir = 0;
    }

    public DashMenu(AEERect area, DashMenuStyle style) {
        this.init(area, style.getFont());
        this.selector_image = style.getSelector();
        this.m_style = style;
    }

    public void setPosition(int newX, int newY) {
        this.px = newX;
        this.py = newY;
    }

    public void addMenuItem(DashMenuItem mi) {
        this.menuItems.addElement(mi);
        if (this.dy < mi.getHeight()) {
            this.py -= mi.getHeight() - this.dy;
            this.dy = mi.getHeight();
        }
    }

    public void addItem(String text, int id) {
        this.addMenuItem(new DashMenuItem(text, id, this.itemWidth(), this.font));
    }

    public void addItem(String text, int place, int score, int id) {
        this.m_hsStyle = true;
        this.addMenuItem(new DashMenuItem(text, id, this.itemWidth(), this.font, place, score));
    }

    public void setSelectedOption(int idx) {
        if (idx < 0 || idx >= this.menuItems.size()) {
            return;
        }
        if (((DashMenuItem)this.menuItems.elementAt(idx)).getCurrOptionID() == -2) {
            return;
        }
        this.currItem = idx;
    }

    public DashMenuItem getCurrentOption() {
        return (DashMenuItem)this.menuItems.elementAt(this.currItem);
    }

    public DashMenuItem getOption(int idx) {
        return (DashMenuItem)this.menuItems.elementAt(this.currItem);
    }

    public int HandleAction(int key) {
        if (this.scrollDir != 0 && this.animateScroll) {
            return -1;
        }
        if (this.menuItems.size() == 1 && this.animateScroll) {
            return -1;
        }
        switch (key) {
            case 0: {
                if (this.animateScroll) {
                    this.scrollDir = 1;
                    this.scrolling = true;
                    this.itemYOffset = 0;
                    break;
                }
                --this.currItem;
                if (this.currItem < 0) {
                    this.currItem = this.menuItems.size() - 1;
                }
                if (((DashMenuItem)this.menuItems.elementAt(this.currItem)).getCurrOptionID() == -2) {
                    return this.HandleAction(0);
                }
                return -1;
            }
            case 1: {
                if (this.animateScroll) {
                    this.scrollDir = 2;
                    this.scrolling = true;
                    this.itemYOffset = -(((DashMenuItem)this.menuItems.elementAt(0)).getHeight() * 3 / 2);
                } else {
                    ++this.currItem;
                    if (this.currItem == this.menuItems.size()) {
                        this.currItem = 0;
                    }
                    if (((DashMenuItem)this.menuItems.elementAt(this.currItem)).getCurrOptionID() == -2) {
                        return this.HandleAction(1);
                    }
                    return -1;
                }
            }
            case 2: 
            case 3: 
            case 4: {
                DashMenuItem mi = (DashMenuItem)this.menuItems.elementAt(this.currItem);
                if (key == 11) {
                    key = 2;
                }
                if (key == 13) {
                    key = 3;
                }
                if (key == 12) {
                    key = 4;
                }
                return mi.HandleAction(key);
            }
        }
        return -1;
    }

    public int KeyReleased(int key) {
        switch (key) {
            case 0: {
                if (this.animateScroll && this.scrollDir == 1) {
                    this.scrolling = false;
                }
                return -1;
            }
            case 1: {
                if (this.animateScroll && this.scrollDir == 2) {
                    this.scrolling = false;
                }
                return -1;
            }
        }
        return -1;
    }

    private int itemAt(int x, int y) {
        int total_height = 0;
        int selector_yoff = 0;
        int selector_height = 0;
        for (int i = 0; i < this.menuItems.size(); ++i) {
            int item_height = ((DashMenuItem)this.menuItems.elementAt(i)).getHeight();
            if (this.selector_image != null && item_height < this.selector_image.getHeight()) {
                item_height = this.selector_image.getHeight();
            }
            if (i == this.currItem) {
                selector_yoff = total_height;
                selector_height = item_height;
            }
            total_height += item_height;
        }
        selector_yoff = selector_yoff + selector_height / 2 < this.dy / 2 || total_height < this.dy ? 0 : (selector_yoff + selector_height / 2 > total_height - this.dy / 2 ? total_height - this.dy : (selector_yoff -= this.dy / 2 - selector_height / 2));
        int xoff = this.px + 8;
        if (this.selector_image != null) {
            xoff += this.selector_image.getWidth();
        }
        int yoff = -selector_yoff;
        for (int i = 0; i < this.menuItems.size(); ++i) {
            DashMenuItem item = (DashMenuItem)this.menuItems.elementAt(i);
            int item_height = item.getHeight();
            if (this.selector_image != null && item_height < this.selector_image.getHeight()) {
                item_height = this.selector_image.getHeight();
            }
            if (item_height + yoff < 0 || yoff > this.dy) {
                yoff += item_height;
                continue;
            }
            if (xoff < x && xoff + this.dx > x && this.py + yoff < y && this.py + yoff + item_height > y) {
                return i;
            }
            yoff += item_height;
        }
        return -1;
    }

    public void updateAnim() {
        if (this.scrollDir == 0) {
            return;
        }
        int move_height = ((DashMenuItem)this.menuItems.elementAt(0)).getHeight() * 3 / 2;
        if (this.scrollDir == 1) {
            if (Math.abs(move_height + this.itemYOffset) < move_height / this.numFrames) {
                ++this.currItem;
                if (this.currItem == this.menuItems.size()) {
                    this.currItem = 0;
                }
                if (!this.scrolling) {
                    this.scrollDir = 0;
                }
                this.itemYOffset = 0;
                this.itemXOffset = 0;
            } else {
                this.itemYOffset -= move_height / this.numFrames;
                this.itemXOffset += this.selector_image.getWidth() * 3 / 2 / this.numFrames;
            }
        } else if (this.scrollDir == 2) {
            if (Math.abs(this.itemYOffset) < move_height / this.numFrames) {
                --this.currItem;
                if (this.currItem < 0) {
                    this.currItem = this.menuItems.size() - 1;
                }
                if (!this.scrolling) {
                    this.scrollDir = 0;
                    this.itemYOffset = 0;
                } else {
                    this.itemYOffset = -(((DashMenuItem)this.menuItems.elementAt(0)).getHeight() * 3 / 2);
                }
                this.itemXOffset = 0;
            } else {
                this.itemYOffset += move_height / this.numFrames;
                this.itemXOffset += this.selector_image.getWidth() * 3 / 2 / this.numFrames;
            }
        }
    }

    public void draw(Graphics g, int align) {
        int clipx = g.getClipX();
        int clipy = g.getClipY();
        int clipw = g.getClipWidth();
        int cliph = g.getClipHeight();
        int oldColor = g.getColor();
        boolean draw_bottom_scroll_arrow = false;
        boolean draw_top_scroll_arrow = false;
        int total_height = 0;
        int selector_yoff = 0;
        int selector_height = 0;
        for (int i = 0; i < this.menuItems.size(); ++i) {
            int item_height = ((DashMenuItem)this.menuItems.elementAt(i)).getHeight();
            if (this.selector_image != null && item_height < this.selector_image.getHeight()) {
                item_height = this.selector_image.getHeight();
            }
            if (i == this.currItem) {
                selector_yoff = total_height;
                selector_height = item_height;
            }
            total_height += item_height;
        }
        if (selector_yoff + selector_height / 2 < this.dy / 2 || total_height < this.dy) {
            selector_yoff = 0;
            if (total_height >= this.dy) {
                draw_bottom_scroll_arrow = true;
            }
        } else if (selector_yoff + selector_height / 2 > total_height - this.dy / 2) {
            selector_yoff = total_height - this.dy;
            if (total_height > this.dy) {
                draw_top_scroll_arrow = true;
            }
        } else {
            selector_yoff -= this.dy / 2 - selector_height / 2;
            if (total_height > this.dy) {
                draw_bottom_scroll_arrow = true;
                draw_top_scroll_arrow = true;
            }
        }
        if (this.m_style != null) {
            this.m_style.drawWindow(g, this.px, this.py, this.dx, this.dy);
            if (draw_top_scroll_arrow || draw_bottom_scroll_arrow) {
                this.m_style.drawArrows(g, this.px, this.py, this.dx, this.dy, draw_top_scroll_arrow, draw_bottom_scroll_arrow);
            }
        } else {
            if (this.bgColor != 0xFF00FF) {
                g.setColor(this.bgColor);
                g.fillRect(this.px, this.py, this.dx, this.dy);
            }
            if (this.borderColor != 0xFF00FF) {
                g.setColor(this.borderColor);
                g.drawRect(this.px - 1, this.py - 1, this.dx + 1, this.dy + 1);
            }
            if (draw_top_scroll_arrow) {
                DashImage imgupArwicon = DashResourceProvider.getImage(96);
                imgupArwicon.draw(g, this.dx - 2, this.py + 2, 24);
            }
            if (draw_bottom_scroll_arrow) {
                DashImage imgdwnArwicon = DashResourceProvider.getImage(97);
                imgdwnArwicon.draw(g, this.dx - 2, this.py + this.dy - 2, 40);
            }
        }
        int xoff = this.px;
        g.setClip(this.px, this.py, this.dx, this.dy);
        int yoff = -selector_yoff;
        for (int i = 0; i < this.menuItems.size(); ++i) {
            DashMenuItem item = (DashMenuItem)this.menuItems.elementAt(i);
            int item_height = item.getHeight();
            int y_align_tweak = 0;
            if (this.selector_image != null && item_height < this.selector_image.getHeight()) {
                y_align_tweak = (this.selector_image.getHeight() - item_height) / 2;
                item_height = this.selector_image.getHeight();
            }
            if (item_height + yoff < 0 || yoff > this.dy) {
                yoff += item_height;
                continue;
            }
            if (i == this.currItem) {
                if (this.m_style != null) {
                    this.m_style.drawHighlight(g, this.px, this.py + yoff, this.dx, item_height);
                } else {
                    if (this.borderColor == 0xFF00FF) {
                        g.setColor(0x9B9B9B);
                    } else {
                        g.setColor(this.borderColor);
                    }
                    g.fillRect(this.px, this.py + yoff, this.dx, item_height);
                }
            }
            item.draw(g, xoff, this.py + yoff + y_align_tweak, align);
            yoff += item_height;
        }
        g.setClip(clipx, clipy, clipw, cliph);
        g.setColor(oldColor);
    }

    void drawCenterTheRightWay(Graphics g, int align) {
        int clipx = g.getClipX();
        int clipy = g.getClipY();
        int clipw = g.getClipWidth();
        int cliph = g.getClipHeight();
        int oldColor = g.getColor();
        g.setClip(this.px, this.py, this.dx, this.dy);
        int numItems = this.menuItems.size();
        if (numItems == 0) {
            return;
        }
        int currSelItem = this.currItem;
        if (this.scrollDir == 1) {
            ++currSelItem;
        }
        if (this.scrollDir == 2) {
            --currSelItem;
        }
        if (currSelItem < 0) {
            currSelItem = numItems - 1;
        }
        if (currSelItem >= this.menuItems.size()) {
            currSelItem = 0;
        }
        int item_height = ((DashMenuItem)this.menuItems.elementAt(0)).getHeight();
        for (int i = 1; i < numItems; ++i) {
            DashMenuItem item = (DashMenuItem)this.menuItems.elementAt(i);
            if (item.getHeight() <= item_height) continue;
            item_height = item.getHeight();
        }
        item_height = item_height * 3 / 2;
        DashMenuItem[] circleBuffer = new DashMenuItem[numItems];
        for (int i = 0; i < numItems; ++i) {
            circleBuffer[i] = (DashMenuItem)this.menuItems.elementAt((currSelItem + i) % numItems);
        }
        int numMarginItems = this.dy / item_height / 2 + 1;
        if (numMarginItems > numItems - 1) {
            numMarginItems = numItems - 1;
        }
        int selectionMarginX = this.selector_image.getWidth() * 3 / 2;
        int ipX = this.px;
        int ipY = this.py + this.dy / 2 - item_height / 2;
        int scrollOffX = selectionMarginX;
        int scrollOffY = 0;
        if (this.scrollDir == 1) {
            scrollOffY += this.itemYOffset + item_height;
            scrollOffX = this.itemXOffset;
        }
        if (this.scrollDir == 2) {
            scrollOffY += this.itemYOffset;
            scrollOffX = this.itemXOffset;
        }
        this.selector_image.draw(g, ipX, ipY + this.font.getHeight() / 2, this.scrollDir, 6);
        circleBuffer[0].drawSimple(g, ipX + scrollOffX, ipY + scrollOffY, align, this.scrollDir == 0 ? this.font : this.fontGrey);
        circleBuffer[0] = null;
        for (int m = 1; m < numMarginItems + 1; ++m) {
            int posDown;
            int posUp = numItems - m;
            if (circleBuffer[posUp] != null) {
                int itemOffX = 0;
                if (this.scrollDir == 1 && m == 1) {
                    itemOffX = selectionMarginX - this.itemXOffset;
                }
                if (ipY + scrollOffY - m * item_height > this.py) {
                    circleBuffer[posUp].drawSimple(g, ipX + itemOffX, ipY + scrollOffY - m * item_height, align, this.fontGrey);
                }
                circleBuffer[posUp] = null;
            }
            if (circleBuffer[posDown = m] == null) continue;
            int itemOffX = 0;
            if (this.scrollDir == 2 && m == 1) {
                itemOffX = selectionMarginX - this.itemXOffset;
            }
            if (ipY + scrollOffY + m * item_height > this.py) {
                circleBuffer[posDown].drawSimple(g, ipX + itemOffX, ipY + scrollOffY + m * item_height, align, this.fontGrey);
            }
            circleBuffer[posDown] = null;
        }
        circleBuffer = null;
        g.setClip(clipx, clipy, clipw, cliph);
        g.setColor(oldColor);
    }

    public int itemWidth() {
        int retval = this.dx;
        return retval;
    }

    public void expandUp() {
        int height = 0;
        for (int i = 0; i < this.menuItems.size(); ++i) {
            DashMenuItem item = (DashMenuItem)this.menuItems.elementAt(i);
            int item_height = item.getHeight();
            if (this.selector_image != null && item_height < this.selector_image.getHeight()) {
                item_height = this.selector_image.getHeight();
            }
            height += item_height;
        }
        if (this.dy < height) {
            this.py -= height - this.dy;
            this.dy = height;
        }
    }
}

