/*
 * Decompiled with CFR 0.152.
 */
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.Hashtable;
import javax.microedition.media.Manager;
import javax.microedition.media.Player;
import javax.microedition.media.PlayerListener;
import javax.microedition.media.control.VolumeControl;

public class SoundPlayer_MMAPI
implements SoundImplementation,
PlayerListener,
SPDefines {
    private String queuedFile = null;
    private byte[] queuedData = null;
    private boolean queuedLoop;
    private boolean queuedStop = false;
    private String m_loop_file = null;
    private boolean m_set_volume = true;
    private boolean m_manual_loop = false;
    static Object player = null;
    static Hashtable player_cache = new Hashtable();
    int step = -1;
    public static boolean deviceAvailable = true;

    public void play(String filename, boolean loop) {
        this.queuedFile = filename;
        this.m_loop_file = null;
        this.step = 0;
        this.queuedLoop = loop;
    }

    public void play(byte[] data, boolean loop) {
        this.queuedData = data;
        if (this.queuedData == null) {
            this.m_loop_file = null;
        }
        this.step = 0;
        this.queuedLoop = loop;
    }

    public void stop() {
        this.queuedFile = null;
        this.queuedData = null;
        this.queuedStop = true;
    }

    private void p_stop() {
        if (player == null) {
            return;
        }
        try {
            Player tmpPlayer = (Player)player;
            tmpPlayer.deallocate();
            if (!SoundOptions.buffered) {
                tmpPlayer.close();
            }
            player = null;
        }
        catch (Throwable s) {
            player = null;
            s.printStackTrace();
        }
    }

    private void p_start(Player p, boolean loop) throws Exception {
        p.realize();
        if (SoundOptions.prefetched) {
            p.prefetch();
        }
        p.addPlayerListener((PlayerListener)this);
        if (this.m_manual_loop) {
            p.setLoopCount(1);
            this.m_loop_file = loop ? this.queuedFile : null;
        } else {
            p.setLoopCount(loop ? -1 : 1);
        }
        p.start();
        player = p;
    }

    public void update() {
        if (this.queuedStop) {
            this.p_stop();
            this.queuedStop = false;
        }
        if (this.queuedFile == null && this.queuedData == null) {
            return;
        }
        if (!deviceAvailable) {
            return;
        }
        try {
            String extension = SoundOptions.filetype_name[SoundOptions.filetype];
            String mime = SoundOptions.filetype_mime[SoundOptions.filetype];
            String fullname = this.queuedFile;
            do {
                switch (this.step) {
                    case 0: {
                        this.p_stop();
                        ++this.step;
                        break;
                    }
                    case 1: {
                        InputStream inputStream = null;
                        Player tmpPlayer = null;
                        if (SoundOptions.buffered) {
                            tmpPlayer = (Player)player_cache.get(fullname);
                            if (tmpPlayer == null) {
                                if (this.queuedFile != null) {
                                    inputStream = this.getClass().getResourceAsStream(fullname);
                                } else if (this.queuedData != null) {
                                    inputStream = new ByteArrayInputStream(this.queuedData);
                                }
                                tmpPlayer = Manager.createPlayer((InputStream)inputStream, (String)mime);
                                player_cache.put(fullname, tmpPlayer);
                                if (SoundOptions.stepped) {
                                    break;
                                }
                            }
                        } else {
                            if (this.queuedFile != null) {
                                inputStream = this.getClass().getResourceAsStream(fullname);
                            } else if (this.queuedData != null) {
                                inputStream = new ByteArrayInputStream(this.queuedData);
                            }
                            tmpPlayer = Manager.createPlayer((InputStream)inputStream, (String)mime);
                        }
                        if (SoundOptions.threaded) {
                            final Player f_player = tmpPlayer;
                            final SoundPlayer_MMAPI f_lock = this;
                            new Thread(){

                                /*
                                 * WARNING - Removed try catching itself - possible behaviour change.
                                 */
                                public void run() {
                                    try {
                                        Object object = f_lock;
                                        synchronized (object) {
                                            SoundPlayer_MMAPI.this.p_start(f_player, SoundPlayer_MMAPI.this.queuedLoop);
                                        }
                                    }
                                    catch (Throwable s) {
                                        SoundPlayer_MMAPI.this.queuedFile = null;
                                        s.printStackTrace();
                                    }
                                }
                            }.start();
                        } else {
                            this.p_start(tmpPlayer, this.queuedLoop);
                            if (inputStream != null) {
                                inputStream.close();
                            }
                        }
                        ++this.step;
                        this.queuedFile = null;
                        this.queuedData = null;
                    }
                }
            } while ((this.queuedFile != null || this.queuedData != null) && !SoundOptions.stepped);
        }
        catch (Throwable s) {
            if ("device error".equals(s.getMessage()) || "error opening MIDI/tone device".equals(s.getMessage())) {
                deviceAvailable = false;
            } else if (!"Player.start failed".equals(s.getMessage())) {
                this.queuedFile = null;
            }
            s.printStackTrace();
        }
    }

    public void playerUpdate(Player player, String event, Object eventData) {
        if ("deviceUnavailable".equals(event)) {
            deviceAvailable = false;
        }
        if ("deviceAvailable".equals(event) || "closed".equals(event)) {
            deviceAvailable = true;
        }
        if (event == "endOfMedia" && this.m_loop_file != null) {
            try {
                if (this.m_set_volume) {
                    int m_volume = 100;
                    VolumeControl vc = (VolumeControl)player.getControl("VolumeControl");
                    if (vc != null) {
                        m_volume = vc.getLevel();
                    }
                    if (vc != null && m_volume != -1) {
                        vc.setLevel(m_volume);
                    }
                }
                this.play(this.m_loop_file, true);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}

