/*
 * Decompiled with CFR 0.152.
 */
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class DashFont {
    private int m_img;
    private String m_format;
    private int m_charWidth;
    private int m_charHeight;
    boolean m_useFilter;
    String m_filter;
    private boolean m_isSystemFont = false;
    private Font m_systemFont = null;
    private int m_sysFontColor = 0xFFFFFF;
    private ImageSlice m_slice = null;
    public boolean m_spacify = false;
    private static final int META_FONT_FORMAT = 0;
    private static final int META_FONT_FORCECASE = 1;
    public static int FORCE_CASE_NONE = 0;
    public static int FORCE_CASE_UPPER = 1;
    public static int FORCE_CASE_LOWER = 2;
    private int m_forceCase = FORCE_CASE_NONE;

    public void forceCase(int force) {
        this.m_forceCase = force;
    }

    public DashFont(int fileID) {
        this.init(fileID, (String)FS.getMeta(fileID, 0));
    }

    public DashFont(Font font) {
        this.m_isSystemFont = true;
        this.m_systemFont = font;
    }

    int getWidth(int frame) {
        if (this.m_slice != null) {
            return this.m_slice.frameData(frame)[2];
        }
        return 0;
    }

    private void init(int fileID, String format) {
        this.m_img = fileID;
        this.m_format = format;
        if (this.m_format == null) {
            throw new Error("null formatted font, fileid " + fileID);
        }
        Image tmp = FS.getImageRaw(this.m_img);
        if (tmp == null) {
            return;
        }
        this.m_charWidth = tmp.getWidth() / this.m_format.length();
        this.m_charHeight = tmp.getHeight();
        Integer meta_force_case = (Integer)FS.getMeta(fileID, 1);
        if (meta_force_case != null) {
            this.m_forceCase = meta_force_case;
        }
        this.m_slice = FS.getImageSlice(fileID);
    }

    public int getCharVarW(char letter) {
        int charWidth = 0;
        if (this.m_slice != null && this.isValidChar(letter)) {
            int[] data = this.m_slice.frameData(this.getIndex(letter));
            charWidth = data[2];
        }
        return charWidth;
    }

    public int indexedStringWidth(int[] idxs, int len) {
        int m_fntW = 0;
        if (this.m_slice != null) {
            m_fntW = this.m_slice.m_smoosh_meta[0][2];
            int retval = 0;
            for (int i = 0; i < len; ++i) {
                int frameTmp = idxs[i];
                if (frameTmp == -1) {
                    retval += m_fntW;
                    continue;
                }
                retval += this.m_slice.frameData(frameTmp)[2];
                if (!this.m_spacify) continue;
                ++retval;
            }
            return retval;
        }
        return len * m_fntW;
    }

    void setFilter(String filter) {
        this.m_useFilter = true;
        this.m_filter = filter;
    }

    void toggleFilter(boolean on) {
        this.m_useFilter = on;
    }

    public void setColor(int color) {
        this.m_sysFontColor = color;
    }

    public int getIndex(char ch) {
        if (this.m_forceCase != FORCE_CASE_NONE) {
            if (this.m_forceCase == FORCE_CASE_UPPER && ch > 'a' && ch < 'z') {
                ch = (char)(ch - 32);
            }
            if (this.m_forceCase == FORCE_CASE_LOWER && ch > 'A' && ch < 'Z') {
                ch = (char)(ch + 32);
            }
        }
        return this.m_format.indexOf(ch);
    }

    public boolean isValidChar(char ch) {
        if (this.m_useFilter && this.m_filter.indexOf(ch) == -1) {
            return false;
        }
        return this.getIndex(ch) != -1;
    }

    public boolean drawIndexedString(Graphics g, int[] textIndices, int numChars, int x, int y, int align) {
        int len = this.indexedStringWidth(textIndices, numChars);
        if ((align & 8) != 0) {
            x -= len;
        } else if ((align & 1) != 0) {
            x -= len / 2;
        }
        if ((align & 0x20) != 0) {
            y -= this.getHeight();
        } else if ((align & 2) != 0) {
            y -= this.getHeight() / 2;
        }
        for (int i = 0; i < numChars; ++i) {
            int idx = textIndices[i];
            if (idx == -1) {
                x += this.m_charWidth;
                continue;
            }
            if (this.m_slice != null) {
                int[] frame = this.m_slice.frameData(idx);
                Image img = FS.getImageRaw(this.m_img);
                DashImage.drawImage(g, img, x, frame[1] + y, frame[4], frame[5] + 0, frame[2], frame[3], 20);
                x += frame[2];
                if (!this.m_spacify) continue;
                ++x;
                continue;
            }
            DashImage img = DashResourceProvider.getImage(this.m_img);
            img.draw(g, x, y, idx, 0);
            x += this.m_charWidth;
            if (!this.m_spacify) continue;
            ++x;
        }
        return true;
    }

    public void drawString(Graphics g, String str, int x, int y, int align) {
        if (this.m_isSystemFont) {
            if (align == 0) {
                align = 20;
            }
            g.setFont(this.m_systemFont);
            int oldColor = g.getColor();
            g.setColor(this.m_sysFontColor);
            g.drawString(str, x, y, align);
            g.setColor(oldColor);
        } else {
            Image img = FS.getImageRaw(this.m_img);
            if (img == null) {
                g.drawString(str, x, y, align);
                return;
            }
            if ((align & 1) != 0) {
                x -= this.stringWidth(str) / 2;
            } else if ((align & 8) != 0) {
                x -= this.stringWidth(str);
            }
            if ((align & 2) != 0) {
                y -= this.m_charHeight / 2;
            } else if ((align & 0x20) != 0) {
                y -= this.m_charHeight;
            }
            if (this.m_forceCase != FORCE_CASE_NONE) {
                if (this.m_forceCase == FORCE_CASE_UPPER) {
                    str = str.toUpperCase();
                }
                if (this.m_forceCase == FORCE_CASE_LOWER) {
                    str = str.toLowerCase();
                }
            }
            for (int i = 0; i < str.length(); ++i) {
                int frameTmp = this.m_format.indexOf(str.charAt(i));
                if (frameTmp == -1) {
                    x += this.m_charWidth;
                    continue;
                }
                if (this.m_slice != null) {
                    int[] frame = this.m_slice.frameData(frameTmp);
                    DashImage.drawImage(g, img, x, frame[1] + y, frame[4], frame[5], frame[2], frame[3], 20);
                    x += frame[2] + 1;
                    continue;
                }
                DashImage.drawImage(g, img, x + i * this.m_charWidth, y, frameTmp * this.m_charWidth, 0, this.m_charWidth, this.m_charHeight, 20);
            }
        }
    }

    protected void drawString_faster(Graphics g, String str, int x, int y) {
        if (this.m_isSystemFont) {
            g.setFont(this.m_systemFont);
            int oldColor = g.getColor();
            g.setColor(this.m_sysFontColor);
            g.drawString(str, x, y, 20);
            g.setColor(oldColor);
        } else {
            Image img = FS.getImageRaw(this.m_img);
            for (int i = 0; i < str.length(); ++i) {
                int frameTmp = this.m_format.indexOf(str.charAt(i));
                if (frameTmp == -1 || this.m_slice != null) continue;
                int sx = x + i * this.m_charWidth;
                g.setClip(sx, y, this.m_charWidth, this.m_charHeight);
                g.drawImage(img, -(frameTmp * this.m_charWidth) + sx, y, 20);
            }
        }
    }

    public int stringWidth(String str) {
        if (this.m_isSystemFont) {
            return this.m_systemFont.stringWidth(str);
        }
        if (this.m_slice != null) {
            if (this.m_forceCase != FORCE_CASE_NONE) {
                if (this.m_forceCase == FORCE_CASE_UPPER) {
                    str = str.toUpperCase();
                }
                if (this.m_forceCase == FORCE_CASE_LOWER) {
                    str = str.toLowerCase();
                }
            }
            int retval = 0;
            for (int i = 0; i < str.length(); ++i) {
                int frameTmp = this.m_format.indexOf(str.charAt(i));
                if (frameTmp == -1) {
                    retval += this.m_charWidth;
                    continue;
                }
                retval += this.m_slice.frameData(frameTmp)[2] + 1;
            }
            if (this.m_spacify) {
                retval += str.length();
            }
            return retval;
        }
        return str.length() * this.m_charWidth;
    }

    public int getHeight() {
        if (this.m_isSystemFont) {
            return this.m_systemFont.getHeight();
        }
        return this.m_charHeight;
    }

    public String[] wrap(String text, int width) {
        if (this.m_forceCase != FORCE_CASE_NONE) {
            if (this.m_forceCase == FORCE_CASE_UPPER) {
                text = text.toUpperCase();
            }
            if (this.m_forceCase == FORCE_CASE_LOWER) {
                text = text.toLowerCase();
            }
        }
        String[] retval = WordWrap.WrapString(width, text, this);
        return retval;
    }
}

