/*
 * Decompiled with CFR 0.152.
 */
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import javax.microedition.io.Connector;
import javax.microedition.io.HttpConnection;

public class DashNetwork {
    private HttpConnection hc = null;
    private byte[] m_data = null;
    private int m_bytesRead = 0;
    private int m_length = -1;
    private boolean m_cancel = false;
    private String m_error = null;
    private Thread running = null;

    protected DashNetwork() {
    }

    public void fetch(final String url) {
        this.hc = null;
        this.m_data = null;
        this.m_bytesRead = 0;
        this.m_length = -1;
        this.m_cancel = false;
        this.m_error = null;
        new Thread(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                InputStream is = null;
                ByteArrayOutputStream baos = null;
                baos = new ByteArrayOutputStream();
                try {
                    if (DashNetwork.this.running != null) {
                        DashNetwork.this.m_cancel = true;
                        DashNetwork.this.running.join();
                        DashNetwork.this.m_cancel = false;
                    }
                    DashNetwork.this.running = this;
                    DashNetwork.this.hc = (HttpConnection)Connector.open((String)url);
                    is = DashNetwork.this.hc.openInputStream();
                    DashNetwork.this.m_length = (int)DashNetwork.this.hc.getLength();
                    int response = DashNetwork.this.hc.getResponseCode();
                    if (response >= 400) {
                        throw new Exception(" http response " + response);
                    }
                    byte[] tempdata = new byte[1024];
                    int bytesread = is.read(tempdata);
                    while (bytesread > 0 && !DashNetwork.this.m_cancel) {
                        DashNetwork.this.m_bytesRead += bytesread;
                        baos.write(tempdata, 0, bytesread);
                        bytesread = is.read(tempdata);
                        Thread.sleep(10L);
                    }
                    if (!DashNetwork.this.m_cancel) {
                        DashNetwork.access$502(DashNetwork.this, baos.toByteArray());
                    }
                }
                catch (Exception e) {
                    DashNetwork.this.m_error = "DashNetwork error " + e.getMessage();
                }
                finally {
                    try {
                        if (is != null) {
                            is.close();
                        }
                        if (DashNetwork.this.hc != null) {
                            DashNetwork.this.hc.close();
                        }
                    }
                    catch (Exception exception) {}
                }
                DashNetwork.this.hc = null;
                DashNetwork.this.running = null;
            }
        }.start();
    }

    public int poll() {
        if (this.m_error != null) {
            return -1;
        }
        if (this.m_data != null) {
            return 100;
        }
        if (this.m_length == -1) {
            return 0;
        }
        if (this.m_length != 0) {
            int retval = this.m_bytesRead * 100 / this.m_length;
            if (retval < 0) {
                retval = 0;
            }
            if (retval > 99) {
                retval = 99;
            }
            return retval;
        }
        return 50;
    }

    public byte[] data() {
        byte[] retval = this.m_data;
        this.m_data = null;
        return retval;
    }

    public String error() {
        String retval = this.m_error;
        this.m_error = null;
        return retval;
    }

    public void setError(String e) {
        this.m_error = e;
    }

    public void cancel() {
        this.m_cancel = true;
        this.m_error = "User cancelled";
    }

    public boolean active() {
        return this.hc != null || this.m_error != null || this.m_data != null;
    }

    static /* synthetic */ byte[] access$502(DashNetwork x0, byte[] x1) {
        x0.m_data = x1;
        return x1;
    }
}

