/*
 * Decompiled with CFR 0.152.
 */
import java.util.Random;
import javax.microedition.lcdui.Canvas;
import javax.microedition.lcdui.Font;

public class DashResourceProvider
extends FS
implements SPDefines {
    public static final int WIPE_COLOR = 0;
    private static DashNetwork m_network = null;
    protected static Canvas m_canvas = null;
    public static int currentLanguage = 0;
    private static AEERect m_rect;
    private long m_maxBytes;
    private static Random m_Random;
    public static final String[] SOUNDMODE_NAME;
    private static int m_soundMode;
    public static int m_currSound;
    public static int m_currNumLoops;
    boolean m_multiChannelEnabled = false;
    private static SoundPlayer soundPlayer;
    private static final int METADATA_SOUND_MIME = 0;
    protected static long[] m_timers;
    protected static long[] m_timerPauses;
    protected static int m_nNumTimers;

    public static DashNetwork getNetwork() {
        if (m_network == null) {
            m_network = new DashNetwork();
        }
        return m_network;
    }

    public DashResourceProvider(Canvas handler, String headerFile) throws Exception {
        m_canvas = handler;
        m_rect = new AEERect(0, 0, DashResourceProvider.getScreenWidth(), DashResourceProvider.getScreenHeight());
        DashResourceProvider.loadFS(headerFile);
        long appTime = System.currentTimeMillis();
        m_timers = new long[10];
        m_timerPauses = new long[10];
        DashResourceProvider.m_timers[0] = appTime;
        DashResourceProvider.m_timerPauses[0] = 0L;
        m_nNumTimers = 1;
        soundPlayer = new SoundPlayer();
    }

    public static int getScreenWidth() {
        if (m_canvas == null) {
            return 0;
        }
        return m_canvas.getWidth();
    }

    public static int getScreenHeight() {
        if (m_canvas == null) {
            return 0;
        }
        return m_canvas.getHeight();
    }

    public static void setScreenArea() {
        try {
            Thread.sleep(100L);
        }
        catch (Exception exception) {
            // empty catch block
        }
        m_rect = new AEERect(0, 0, DashResourceProvider.getScreenWidth(), DashResourceProvider.getScreenHeight());
    }

    public static AEERect getScreenArea() {
        return m_rect;
    }

    void setMaxBytesAllowed(long max) {
        this.m_maxBytes = max;
    }

    long getMaxBytesAllowed() {
        return this.m_maxBytes;
    }

    public static int getRand(int min, int max) {
        if (min > max) {
            int temp = min;
            min = max;
            max = temp;
        }
        int result = (m_Random.nextInt() & Integer.MAX_VALUE) % (max - min + 1);
        return result += min;
    }

    public static DashImage getImage(int fileID) {
        FS.FSNode file = DashResourceProvider.findFile(fileID);
        if (file == null) {
            return null;
        }
        file.accessTick = m_accessTick++;
        if (file.type == 0) {
            file.type = 2;
            file.dashObject = new DashImage(fileID);
            return (DashImage)file.dashObject;
        }
        if (file.type == 2) {
            return (DashImage)file.dashObject;
        }
        return null;
    }

    public static DashFont getFont(int fileID) {
        if (fileID == 999) {
            DashFont ret = new DashFont(Font.getFont((int)64, (int)0, (int)8));
            return ret;
        }
        FS.FSNode file = DashResourceProvider.findFile(fileID);
        if (file == null) {
            return null;
        }
        file.accessTick = m_accessTick++;
        if (file.type == 0) {
            file.type = 4;
            file.dashObject = new DashFont(fileID);
            return (DashFont)file.dashObject;
        }
        if (file.type == 4) {
            ((DashFont)file.dashObject).m_spacify = false;
            return (DashFont)file.dashObject;
        }
        return null;
    }

    public static byte[] getBinary(int fileID) {
        FS.FSNode file = DashResourceProvider.findFile(fileID);
        if (file == null) {
            return null;
        }
        file.accessTick = m_accessTick++;
        if (file.type == 0) {
            file.type = 1;
        }
        if (file.data == null) {
            file.data = DashResourceProvider.getFile("/" + fileID);
        }
        return file.data;
    }

    public static String[] getStringArray(int fileID) {
        FS.FSNode file = DashResourceProvider.findFile(fileID);
        if (file == null) {
            return null;
        }
        file.accessTick = m_accessTick++;
        if (file.type == 0) {
            file.type = 6;
        }
        if (file.rawObject == null) {
            if (file.data == null) {
                file.data = DashResourceProvider.getFile("/" + fileID);
            }
            String abc = new String(file.data);
            file.rawObject = DashResourceProvider.StringSplit(abc);
            file.data = null;
        }
        return (String[])file.rawObject;
    }

    private static String[] StringSplit(String input) {
        int lineCount = 0;
        char splitChar = '\n';
        if (input.indexOf(splitChar) == -1) {
            input = input.replace('\r', splitChar);
        }
        int strPos = 0;
        do {
            strPos = input.indexOf(splitChar, strPos) + 1;
            ++lineCount;
        } while (strPos != 0);
        String[] toReturn = new String[lineCount];
        strPos = 0;
        for (int i = 0; i < lineCount; ++i) {
            int endStrPos = input.indexOf(splitChar, strPos);
            toReturn[i] = endStrPos == -1 ? input.substring(strPos).trim() : input.substring(strPos, endStrPos).trim();
            strPos = endStrPos + 1;
        }
        return toReturn;
    }

    public static String getString(int fileID) {
        FS.FSNode file = DashResourceProvider.findFile(fileID);
        if (file == null) {
            return null;
        }
        file.accessTick = m_accessTick++;
        if (file.type == 0) {
            file.type = 5;
        }
        if (file.rawObject == null) {
            if (file.data == null) {
                file.data = DashResourceProvider.getFile("/" + fileID);
            }
            file.rawObject = new String(file.data);
            file.data = null;
        }
        return (String)file.rawObject;
    }

    public static boolean preloadImage(int fileID) {
        return DashResourceProvider.getImage(fileID) != null && DashResourceProvider.getImageRaw(fileID) != null;
    }

    public static boolean preloadFont(int fileID) {
        return DashResourceProvider.getFont(fileID) != null && DashResourceProvider.getImageRaw(fileID) != null;
    }

    public static void setSound(boolean soundmode) {
        m_soundMode = soundmode ? 1 : 0;
        if (m_soundMode == 0) {
            DashResourceProvider.stopSound();
        }
    }

    public static int getSoundMode() {
        return m_soundMode;
    }

    protected static void soundMainLoop() {
        soundPlayer.update();
    }

    public static void playSound(int fileID, boolean loop, boolean is_sound_effect) {
        if (fileID == m_currSound) {
            return;
        }
        if (m_soundMode == 0) {
            return;
        }
        if (is_sound_effect && m_soundMode == 1) {
            return;
        }
        if (!is_sound_effect && m_soundMode == 2) {
            return;
        }
        m_currSound = fileID;
        if (DashEngine.dlPack != 0 && fileID != 139) {
            DashResourceProvider.playSound(DashStorage.loadData(2 + fileID), loop, is_sound_effect);
        } else {
            soundPlayer.play("/" + fileID, loop);
        }
    }

    public static void playSound(byte[] data, boolean loop, boolean is_sound_effect) {
        if (m_soundMode == 0) {
            return;
        }
        if (is_sound_effect && m_soundMode == 1) {
            return;
        }
        if (!is_sound_effect && m_soundMode == 2) {
            return;
        }
        soundPlayer.play(data, loop);
    }

    public static void stopSound() {
        m_currSound = -1;
        soundPlayer.stop();
    }

    public static int getCurrSound() {
        return m_currSound;
    }

    public static boolean isSoundPlaying(int resID) {
        if (m_currSound == -1) {
            return false;
        }
        return m_currSound == resID;
    }

    public static long getAppTime() {
        return DashResourceProvider.getTime(0);
    }

    public static int addTimer() {
        if (m_nNumTimers == m_timers.length) {
            return -1;
        }
        long time = System.currentTimeMillis();
        int idx = m_nNumTimers;
        DashResourceProvider.m_timers[DashResourceProvider.m_nNumTimers] = time;
        DashResourceProvider.m_timerPauses[DashResourceProvider.m_nNumTimers++] = 0L;
        return idx;
    }

    public static void resetTimer(int timerID) {
        if (timerID < 0 || timerID >= m_nNumTimers) {
            return;
        }
        DashResourceProvider.m_timers[timerID] = System.currentTimeMillis();
        DashResourceProvider.m_timerPauses[timerID] = 0L;
    }

    public static long getTime(int timerID) {
        if (timerID < 0 || timerID >= m_nNumTimers) {
            return -1L;
        }
        if (m_timerPauses[timerID] != 0L) {
            return m_timerPauses[timerID] - m_timers[timerID];
        }
        return System.currentTimeMillis() - m_timers[timerID];
    }

    public static void pauseTimer(int timerID) {
        if (timerID < 0 || timerID >= m_nNumTimers) {
            return;
        }
        DashResourceProvider.m_timerPauses[timerID] = System.currentTimeMillis();
    }

    public static void resumeTimer(int timerID) {
        if (timerID < 0 || timerID >= m_nNumTimers) {
            return;
        }
        if (m_timerPauses[timerID] == 0L) {
            return;
        }
        long timerTime = m_timers[timerID];
        long delta = System.currentTimeMillis() - m_timerPauses[timerID];
        DashResourceProvider.m_timers[timerID] = timerTime + delta;
        DashResourceProvider.m_timerPauses[timerID] = 0L;
    }

    public static void pauseAllTimers() {
        long pauseTime = System.currentTimeMillis();
        for (int i = 0; i < m_nNumTimers; ++i) {
            if (m_timerPauses[i] != 0L) continue;
            DashResourceProvider.m_timerPauses[i] = pauseTime;
        }
    }

    public static void pauseAllTimers(long delay) {
        long pauseTime = System.currentTimeMillis() - delay;
        for (int i = 0; i < m_nNumTimers; ++i) {
            if (m_timerPauses[i] != 0L) continue;
            DashResourceProvider.m_timerPauses[i] = pauseTime;
        }
    }

    public static void resumeAllTimers() {
        long resumeTime = System.currentTimeMillis();
        for (int i = 0; i < m_nNumTimers; ++i) {
            long timerTime = m_timers[i];
            long delta = resumeTime - m_timerPauses[i];
            DashResourceProvider.m_timers[i] = timerTime + delta;
            DashResourceProvider.m_timerPauses[i] = 0L;
        }
    }

    public static boolean isTimerPaused(int timerID) {
        return m_timerPauses[timerID] != 0L;
    }

    public static int Fsqrt(int v) {
        int temp;
        int g = 0;
        if (v >= 0x40000000) {
            g = 32768;
            v -= 0x40000000;
        }
        if (v >= (temp = (g << 15) + 0x10000000)) {
            g += 16384;
            v -= temp;
        }
        if (v >= (temp = (g << 15) + 0x10000000)) {
            g += 16384;
            v -= temp;
        }
        if (v >= (temp = (g << 14) + 0x4000000)) {
            g += 8192;
            v -= temp;
        }
        if (v >= (temp = (g << 13) + 0x1000000)) {
            g += 4096;
            v -= temp;
        }
        if (v >= (temp = (g << 12) + 0x400000)) {
            g += 2048;
            v -= temp;
        }
        if (v >= (temp = (g << 11) + 0x100000)) {
            g += 1024;
            v -= temp;
        }
        if (v >= (temp = (g << 10) + 262144)) {
            g += 512;
            v -= temp;
        }
        if (v >= (temp = (g << 9) + 65536)) {
            g += 256;
            v -= temp;
        }
        if (v >= (temp = (g << 8) + 16384)) {
            g += 128;
            v -= temp;
        }
        if (v >= (temp = (g << 7) + 4096)) {
            g += 64;
            v -= temp;
        }
        if (v >= (temp = (g << 6) + 1024)) {
            g += 32;
            v -= temp;
        }
        if (v >= (temp = (g << 5) + 256)) {
            g += 16;
            v -= temp;
        }
        if (v >= (temp = (g << 4) + 64)) {
            g += 8;
            v -= temp;
        }
        if (v >= (temp = (g << 3) + 16)) {
            g += 4;
            v -= temp;
        }
        if (v >= (temp = (g << 2) + 4)) {
            g += 2;
            v -= temp;
        }
        if (v >= (temp = g + g + 1)) {
            ++g;
        }
        return g;
    }

    public static int INT_little_endian_TO_big_endian(int i) {
        return ((i & 0xFF) << 24) + ((i & 0xFF00) << 8) + ((i & 0xFF0000) >> 8) + (i >> 24 & 0xFF);
    }

    public static short SHORT_little_endian_TO_big_endian(short i) {
        return (short)(((i & 0xFF) << 8) + (i >> 8 & 0xFF));
    }

    public static int interpolateColors(int startRGB, int endRGB, long valueStart, long valueCurrent, long valueEnd) {
        if (valueStart >= valueEnd) {
            return startRGB;
        }
        if (valueCurrent >= valueEnd) {
            return endRGB;
        }
        if (valueCurrent <= valueStart) {
            return startRGB;
        }
        long startDiff = valueEnd - valueStart;
        long currDiff = valueCurrent - valueStart;
        long sR = (startRGB & 0xFF0000) >> 16;
        long sG = (startRGB & 0xFF00) >> 8;
        long sB = startRGB & 0xFF;
        long eR = (endRGB & 0xFF0000) >> 16;
        long eG = (endRGB & 0xFF00) >> 8;
        long eB = endRGB & 0xFF;
        boolean addR = true;
        boolean addG = true;
        boolean addB = true;
        if (eR < sR) {
            addR = false;
        }
        if (eG < sG) {
            addG = false;
        }
        if (eB < sB) {
            addB = false;
        }
        long nR = addR ? sR + (eR - sR) * currDiff / startDiff : sR - (sR - eR) * currDiff / startDiff;
        long nG = addG ? sG + (eG - sG) * currDiff / startDiff : sG - (sG - eG) * currDiff / startDiff;
        long nB = addB ? sB + (eB - sB) * currDiff / startDiff : sB - (sB - eB) * currDiff / startDiff;
        long ret = nR << 16;
        ret += nG << 8;
        return (int)(ret += nB);
    }

    public static boolean isMidWidescreen() {
        return false;
    }

    static {
        m_Random = new Random();
        SOUNDMODE_NAME = new String[]{"off", "music", "effects"};
        m_soundMode = 1;
        m_currSound = -1;
        soundPlayer = null;
        m_timers = new long[10];
        m_timerPauses = new long[10];
        m_nNumTimers = 0;
    }
}

