/*
 * Decompiled with CFR 0.152.
 */
package mainPackage;

import applicationPackage.CollisionHandler;
import applicationPackage.EnviromentGenerator;
import applicationPackage.GameController;
import applicationPackage.LevelCreator;
import com.jarbull.jbf.JBAction;
import com.jarbull.jbf.JBGameCanvas;
import com.jarbull.jbf.JBManager;
import com.jarbull.jbf.util.KeyCodeAdapter;
import domainPackage.Location;
import domainPackage.UserPlane;
import java.io.IOException;
import javax.microedition.lcdui.Canvas;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import javax.microedition.lcdui.game.Layer;
import javax.microedition.lcdui.game.Sprite;
import javax.microedition.lcdui.game.TiledLayer;
import mainPackage.DragonRage;
import mainPackage.HarryPotterProcessor;
import mainPackage.SoundCheckScreen;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
public class HarryPotterCanvas
extends JBGameCanvas
implements Runnable {
    public static boolean startScreen;
    public static boolean pointerPressed;
    public static int planeState;
    public static long clearLayersTime;
    public static long createLayersTime;
    public static LevelCreator levelCreator;
    public static DragonRage mainMidlet;
    public Sprite backGroundSprite;
    private int a;
    private final Image[] a;
    private HarryPotterProcessor a;
    private boolean b;
    private Location a;
    private TiledLayer a;
    private TiledLayer b;
    private TiledLayer c;
    private TiledLayer d;
    private TiledLayer e;
    private Graphics a;

    public HarryPotterCanvas(DragonRage dragonRage) {
        this.setFullScreenMode(true);
        mainMidlet = dragonRage;
        levelCreator = new LevelCreator();
        this.a = 50;
        planeState = 0;
        startScreen = false;
        this.b = false;
        pointerPressed = false;
        this.a = new Image[10];
        for (int i = 9; i >= 0; --i) {
            this.a[i] = JBManager.getInstance().getTextImage(Integer.toString(i), "font-score");
        }
        this.a = this.getGraphics();
        this.initializeProcessor();
        KeyCodeAdapter.getInstance().setCanvas((Canvas)this);
    }

    public void paintBackGround(Graphics graphics) {
        EnviromentGenerator.getInstance().managerSkyGround.paint(graphics, 0, 0);
        EnviromentGenerator.getInstance().managerCastleBoard.paint(graphics, 0, 32);
        EnviromentGenerator.getInstance().managerMagic1Board.paint(graphics, 0, 0);
        EnviromentGenerator.getInstance().managerMagic2Board.paint(graphics, 0, 0);
        EnviromentGenerator.getInstance().managerBackGround.paint(graphics, 0, 0);
        this.paintPlayer(graphics);
    }

    public void paintAirEnemy(Graphics object) {
        try {
            this.renderAirEnemy((Graphics)object);
            return;
        }
        catch (IOException iOException) {
            object = iOException;
            iOException.printStackTrace();
            return;
        }
    }

    public void paintExplosions(Graphics graphics) {
        if (CollisionHandler.getExplosionSprite() != null) {
            CollisionHandler.getExplosionSprite().paint(graphics);
        }
        if (CollisionHandler.getExplosionUserSprite() != null) {
            CollisionHandler.getExplosionUserSprite().paint(graphics);
        }
    }

    public void paintPlayer(Graphics object) {
        try {
            this.renderPlayer((Graphics)object);
            return;
        }
        catch (IOException iOException) {
            object = iOException;
            iOException.printStackTrace();
            return;
        }
    }

    public void paintScore(Graphics object) {
        try {
            this.renderScore((Graphics)object);
            return;
        }
        catch (IOException iOException) {
            object = iOException;
            iOException.printStackTrace();
            return;
        }
    }

    public void paintAll() {
        if (this.b) {
            this.a.setClip(0, 0, this.getWidth(), this.getHeight());
            this.a.setColor(0);
            this.a.fillRect(0, 0, 240, 320);
            this.a.drawImage(JBManager.getInstance().getTextImage("Loading...", "font-acilis"), 90, 150, 20);
            this.flushGraphics();
            return;
        }
        this.paintBackGround(this.a);
        this.paintAirEnemy(this.a);
        this.paintExplosions(this.a);
        this.paintScore(this.a);
    }

    public void renderScore(Graphics graphics) {
        String string = Integer.toString(EnviromentGenerator.getInstance().scorePoint);
        int n = 190;
        for (int i = 0; i < string.length(); ++i) {
            int n2 = Integer.parseInt(string.substring(i, i + 1));
            graphics.setColor(0xFFFFFF);
            graphics.drawRect(n, 2, this.a[n2].getWidth() + 3, this.a[n2].getHeight() + 3);
            graphics.setColor(0);
            graphics.fillRect(n, 2, this.a[n2].getWidth() + 3, this.a[n2].getHeight() + 3);
            graphics.drawImage(this.a[n2], n, 3, 20);
            n += this.a[n2].getWidth();
        }
    }

    public void renderPlayer(Graphics graphics) {
        if (UserPlane.getInstance() != null) {
            for (int i = 0; i < UserPlane.getInstance().spriteDragon.size(); ++i) {
                ((Sprite)UserPlane.getInstance().spriteDragon.elementAt(i)).paint(graphics);
            }
        }
    }

    public void renderAirEnemy(Graphics graphics) {
        GameController.getInstance().managerObstacle.paint(graphics, 0, 0);
    }

    public void checkKeys(int n) {
        this.a.a = this.getKeyStates();
    }

    public void keyPressed(int n) {
        this.a.b = KeyCodeAdapter.getInstance().adoptKeyCode(n);
    }

    public void pointerPressed(int n, int n2) {
        this.a.b = KeyCodeAdapter.getInstance().adoptKeyCode(this.getKeyCode(8));
        pointerPressed = true;
    }

    public void pointerReleased(int n, int n2) {
        pointerPressed = false;
    }

    public void createLayers() {
        long l = System.currentTimeMillis();
        this.a = EnviromentGenerator.getInstance().createBackGroundBoard(EnviromentGenerator.getInstance().createBackGroundMap1(EnviromentGenerator.getInstance().backGroundLayerIndex, EnviromentGenerator.getInstance().patternNumber));
        this.b = EnviromentGenerator.getInstance().createSkyBoard();
        this.c = EnviromentGenerator.getInstance().createMagicLayer1Board(EnviromentGenerator.getInstance().magicLayer1Index);
        this.d = EnviromentGenerator.getInstance().createMagicLayer2Board(EnviromentGenerator.getInstance().magicLayer2Index);
        this.e = EnviromentGenerator.getInstance().createCastleBoard();
        if (EnviromentGenerator.getInstance().managerBackGround == null && EnviromentGenerator.getInstance().managerSkyGround == null && EnviromentGenerator.getInstance().managerMagic1Board == null && EnviromentGenerator.getInstance().managerMagic2Board == null && EnviromentGenerator.getInstance().managerCastleBoard == null) {
            EnviromentGenerator.getInstance().createBackGroundManagers();
        }
        EnviromentGenerator.getInstance().managerBackGround.append((Layer)this.a);
        EnviromentGenerator.getInstance().managerSkyGround.append((Layer)this.b);
        EnviromentGenerator.getInstance().managerMagic1Board.append((Layer)this.c);
        EnviromentGenerator.getInstance().managerMagic2Board.append((Layer)this.d);
        EnviromentGenerator.getInstance().managerCastleBoard.append((Layer)this.e);
        createLayersTime = System.currentTimeMillis() - l;
    }

    public void clearLayers() {
        int n;
        long l = System.currentTimeMillis();
        if (EnviromentGenerator.getInstance().managerBackGround != null) {
            for (n = EnviromentGenerator.getInstance().managerBackGround.getSize() - 1; n >= 0; --n) {
                EnviromentGenerator.getInstance().managerBackGround.remove(EnviromentGenerator.getInstance().managerBackGround.getLayerAt(n));
            }
        }
        if (EnviromentGenerator.getInstance().managerSkyGround != null) {
            for (n = EnviromentGenerator.getInstance().managerSkyGround.getSize() - 1; n >= 0; --n) {
                EnviromentGenerator.getInstance().managerSkyGround.remove(EnviromentGenerator.getInstance().managerSkyGround.getLayerAt(n));
            }
        }
        if (EnviromentGenerator.getInstance().managerMagic1Board != null) {
            for (n = EnviromentGenerator.getInstance().managerMagic1Board.getSize() - 1; n >= 0; --n) {
                EnviromentGenerator.getInstance().managerMagic1Board.remove(EnviromentGenerator.getInstance().managerMagic1Board.getLayerAt(n));
            }
        }
        if (EnviromentGenerator.getInstance().managerMagic2Board != null) {
            for (n = EnviromentGenerator.getInstance().managerMagic2Board.getSize() - 1; n >= 0; --n) {
                EnviromentGenerator.getInstance().managerMagic2Board.remove(EnviromentGenerator.getInstance().managerMagic2Board.getLayerAt(n));
            }
        }
        if (EnviromentGenerator.getInstance().managerCastleBoard != null) {
            for (n = EnviromentGenerator.getInstance().managerCastleBoard.getSize() - 1; n >= 0; --n) {
                EnviromentGenerator.getInstance().managerCastleBoard.remove(EnviromentGenerator.getInstance().managerCastleBoard.getLayerAt(n));
            }
        }
        for (n = GameController.getInstance().managerObstacle.getSize() - 1; n >= 0; --n) {
            GameController.getInstance().managerObstacle.remove(GameController.getInstance().managerObstacle.getLayerAt(n));
        }
        for (n = GameController.getInstance().obstacleList.getNoItems() - 1; n >= 0; --n) {
            GameController.getInstance().obstacleList.deleteEnemyPlaneByIndex(n);
        }
        EnviromentGenerator.getInstance().backGroundLayerIndex = 0;
        UserPlane.getInstance().emptyDragonVector();
        UserPlane.getInstance().fillDragonVector();
        this.a = new Location(0 + 2 * UserPlane.getInstance().spriteDragon3.getWidth(), 160 - 3 * UserPlane.getInstance().spriteDragon2.getHeight(), UserPlane.getInstance().spriteDragon1.getWidth(), UserPlane.getInstance().spriteDragon1.getHeight());
        UserPlane.getInstance().setLocation(this.a, (Sprite)UserPlane.getInstance().spriteDragon.elementAt(0));
        this.a = new Location(0 + UserPlane.getInstance().spriteDragon2.getWidth(), 160 - 3 * UserPlane.getInstance().spriteDragon2.getHeight() + 22, UserPlane.getInstance().spriteDragon1.getWidth(), UserPlane.getInstance().spriteDragon1.getHeight());
        UserPlane.getInstance().setLocation(this.a, (Sprite)UserPlane.getInstance().spriteDragon.elementAt(1));
        this.a = new Location(0.0, 160 - 3 * UserPlane.getInstance().spriteDragon2.getHeight(), UserPlane.getInstance().spriteDragon1.getWidth(), UserPlane.getInstance().spriteDragon1.getHeight());
        UserPlane.getInstance().setLocation(this.a, (Sprite)UserPlane.getInstance().spriteDragon.elementAt(2));
        clearLayersTime = System.currentTimeMillis() - l;
    }

    public void clearManagers() {
        EnviromentGenerator.getInstance().managerBackGround = null;
        EnviromentGenerator.getInstance().managerSkyGround = null;
        EnviromentGenerator.getInstance().managerMagic1Board = null;
        EnviromentGenerator.getInstance().managerMagic2Board = null;
        EnviromentGenerator.getInstance().managerCastleBoard = null;
        this.a = null;
        this.b = null;
        this.c = null;
        this.d = null;
        this.e = null;
    }

    public void initializeProcessor() {
        if (this.a != null) {
            this.a.killThread = true;
        }
        this.a = new HarryPotterProcessor();
        this.a.start();
    }

    private boolean a() {
        if (CollisionHandler.getInstance().isUserDead()) {
            JBManager.getInstance().gameSettings.putAndSave("score:mylast", Integer.toString(EnviromentGenerator.getInstance().scorePoint));
            try {
                if (Integer.parseInt(JBManager.getInstance().gameSettings.get("score:mytop")) < EnviromentGenerator.getInstance().scorePoint) {
                    JBManager.getInstance().gameSettings.putAndSave("score:mytop", Integer.toString(EnviromentGenerator.getInstance().scorePoint));
                }
            }
            catch (Exception exception) {
                JBManager.getInstance().gameSettings.putAndSave("score:mytop", Integer.toString(EnviromentGenerator.getInstance().scorePoint));
            }
            JBManager.getInstance().gameSettings.remove("lastLevel");
            JBManager.getInstance().gameSettings.remove("lastScore");
            mainMidlet.openPauseMenu();
            JBManager.getInstance().addAction(new JBAction(this, "TOP:T0"));
            mainMidlet.c();
            return true;
        }
        return false;
    }

    public void executeGame() {
        while (DragonRage.isRunning && !CollisionHandler.getInstance().isUserDead() && !DragonRage.restartApp) {
            long l = System.currentTimeMillis();
            if (!DragonRage.pauseApp) {
                if (!CollisionHandler.getInstance().userDead) {
                    this.checkKeys(this.getKeyStates());
                }
                this.paintAll();
                this.flushGraphics();
            }
            try {
                Thread.sleep(Math.max(0L, (long)this.a - System.currentTimeMillis() + l));
            }
            catch (InterruptedException interruptedException) {
                InterruptedException interruptedException2 = interruptedException;
                interruptedException.printStackTrace();
            }
        }
    }

    public void run() {
        Object object;
        while (DragonRage.startApp && !this.a()) {
            if (!CollisionHandler.getInstance().isUserDead()) {
                object = null;
                startScreen = true;
                try {
                    object = new SoundCheckScreen(mainMidlet);
                }
                catch (IOException iOException) {
                    IOException iOException2 = iOException;
                    iOException.printStackTrace();
                }
                ((SoundCheckScreen)object).show();
                ((SoundCheckScreen)object).joinThread();
            }
            this.executeGame();
        }
        while (DragonRage.startSubmit && !this.a()) {
            this.b = true;
            this.paintAll();
            DragonRage.a.clearLayers();
            try {
                Thread.sleep(1000L + clearLayersTime);
            }
            catch (InterruptedException interruptedException) {
                object = interruptedException;
                interruptedException.printStackTrace();
            }
            if (startScreen) {
                Runtime.getRuntime().gc();
            }
            DragonRage.a.createLayers();
            try {
                Thread.sleep(createLayersTime);
            }
            catch (InterruptedException interruptedException) {
                object = interruptedException;
                interruptedException.printStackTrace();
            }
            DragonRage.restartApp = false;
            EnviromentGenerator.getInstance().scorePoint = 0;
            CollisionHandler.getInstance().userDead = false;
            this.b = false;
            this.executeGame();
        }
    }
}

