/*
 * Decompiled with CFR 0.152.
 */
package com.neonplay.paperglider.views;

import com.neonplay.helper.ImageItem;
import com.neonplay.helper.ImageLoader;
import com.neonplay.helper.MenuItem;
import com.neonplay.helper.SaveData;
import com.neonplay.helper.SoundItem;
import com.neonplay.paperglider.Main;
import com.neonplay.paperglider.view.components.AboutItem;
import com.neonplay.paperglider.view.components.BackItem;
import com.neonplay.paperglider.view.components.ExitItem;
import com.neonplay.paperglider.view.components.FacebookLikeItem;
import com.neonplay.paperglider.view.components.GetItItem;
import com.neonplay.paperglider.view.components.GetOnOviItem;
import com.neonplay.paperglider.view.components.HelpItem;
import com.neonplay.paperglider.view.components.OptionsItem;
import com.neonplay.paperglider.view.components.PlayItem;
import com.neonplay.paperglider.view.components.ScoreboardItem;
import com.neonplay.paperglider.view.components.SoundToggleItem;
import java.io.IOException;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import javax.microedition.lcdui.game.GameCanvas;

public class MenuView
extends GameCanvas
implements Runnable {
    public static final int MAIN_MENU = 0;
    public static final int OPTIONS_MENU = 1;
    public static final int SCOREBOARD_MENU = 2;
    public static final int TIME_UP_MENU = 3;
    public static final int HELP_MENU = 4;
    public static final int ABOUT_MENU = 5;
    private static final int PAPER_GLIDER_ITEM_X = 90;
    private static final int PAPER_GLIDER_ITEM_Y = 30;
    private static final int PLAY_ITEM_X = 80;
    private static final int PLAY_ITEM_Y = 200;
    private static final int OPTIONS_ITEM_X = 240;
    private static final int OPTIONS_ITEM_Y = 210;
    private static final int SCOREBOARD_ITEM_X = 390;
    private static final int SCOREBOARD_ITEM_Y = 210;
    private static final int ABOUT_ITEM_X = 269;
    private static final int ABOUT_ITEM_Y = 300;
    private static final int HELP_ITEM_X = 516;
    private static final int HELP_ITEM_Y = 300;
    private static final int EXIT_ITEM_X = 50;
    private static final int EXIT_ITEM_Y = 300;
    private static final int GET_ON_OVI_ITEM_X = 169;
    private static final int GET_ON_OVI_ITEM_Y = 300;
    private static final int PANEL_ITEM_X = 100;
    private static final int PANEL_ITEM_Y = 20;
    private static final int OPTIONS_TITLE_ITEM_X = 210;
    private static final int OPTIONS_TITLE_ITEM_Y = 40;
    private static final int SOUND_TOGGLE_ITEM_X = 230;
    private static final int SOUND_TOGGLE_ITEM_Y = 140;
    private static final int FACEBOOK_LIKE_ITEM_X = 200;
    private static final int FACEBOOK_LIKE_ITEM_Y = 210;
    private static final int BACK_ITEM_X = 100;
    private static final int BACK_ITEM_Y = 320;
    private static final int SCOREBOARD_TITLE_ITEM_X = 150;
    private static final int SCOREBOARD_TITLE_ITEM_Y = 40;
    private static final int TIME_UP_TITLE_ITEM_X = 115;
    private static final int TIME_UP_TITLE_ITEM_Y = 40;
    private static final int GET_IT_ITEM_X = 145;
    private static final int GET_IT_ITEM_Y = 230;
    private static final int HELP_TITLE_ITEM_X = 260;
    private static final int HELP_TITLE_ITEM_Y = 40;
    private static final int ABOUT_TITLE_ITEM_X = 230;
    private static final int ABOUT_TITLE_ITEM_Y = 40;
    protected Graphics g;
    protected Image doubleBuffer;
    protected volatile Thread gameThread;
    protected int currentMenu = 0;
    protected Image backgroundImage;
    protected float backgroundScrollX;
    protected ImageItem paperGliderItem;
    protected PlayItem playItem;
    protected OptionsItem optionsItem;
    protected ScoreboardItem scoreboardItem;
    protected GetOnOviItem getOnOviItem;
    protected HelpItem helpItem;
    protected AboutItem aboutItem;
    protected ExitItem exitItem;
    protected ImageItem panelItem;
    protected ImageItem optionsTitleItem;
    protected SoundToggleItem soundToggleItem;
    protected FacebookLikeItem facebookLikeItem;
    protected BackItem optionsBackItem;
    protected ImageItem scoreboardTitleItem;
    protected BackItem scoreboardBackItem;
    protected ImageItem timeUpTitleItem;
    protected GetItItem getItItem;
    protected ImageItem aboutTitleItem;
    protected BackItem aboutBackItem;
    protected ImageItem helpTitleItem;
    protected BackItem helpBackItem;
    protected long lastTime;
    protected long elapsedMillis;
    protected long currentTime;
    protected Font font;
    protected SoundItem selectSound;
    protected SoundItem backSound;
    protected MenuItem[] items;
    protected int currentActiveItem;

    public MenuView() {
        super(false);
        this.setFullScreenMode(true);
        System.out.println("MenuView cons");
        this.init();
        this.doubleBuffer = Image.createImage((int)this.getLandscapeWidth(), (int)this.getLandscapeHeight());
        System.out.println("Menu view constructed");
    }

    protected void init() {
        try {
            ImageLoader imageLoader = ImageLoader.getInstance();
            this.backgroundImage = imageLoader.loadImage("/bgcity.png");
        }
        catch (IOException iOException) {
            System.out.println("Image loading error.");
        }
        this.selectSound = new SoundItem("/paper scrunch forward.wav", false);
        this.backSound = new SoundItem("/paper scrunch back.wav", false);
        System.out.println("loading main menu items");
        this.paperGliderItem = new ImageItem("/paperglider_title.png");
        this.playItem = new PlayItem(this);
        this.optionsItem = new OptionsItem(this);
        this.scoreboardItem = new ScoreboardItem(this);
        this.getOnOviItem = new GetOnOviItem(this);
        this.aboutItem = new AboutItem(this);
        this.helpItem = new HelpItem(this);
        this.exitItem = new ExitItem(this);
        System.out.println("loading options menu items");
        this.panelItem = new ImageItem("/menupanel.png");
        this.optionsTitleItem = new ImageItem("/options_title.png");
        this.soundToggleItem = new SoundToggleItem(this);
        this.facebookLikeItem = new FacebookLikeItem(this);
        this.optionsBackItem = new BackItem(this);
        System.out.println("loading scoreboard menu items");
        this.scoreboardTitleItem = new ImageItem("/scoreboard_title.png");
        this.scoreboardBackItem = new BackItem(this);
        this.timeUpTitleItem = new ImageItem("/title_trialover.png");
        this.getItItem = new GetItItem(this);
        this.aboutTitleItem = new ImageItem("/about_title.png");
        this.aboutBackItem = new BackItem(this);
        this.helpTitleItem = new ImageItem("/help_title.png");
        this.helpBackItem = new BackItem(this);
        System.out.println("all menu items loaded");
        this.font = Font.getFont((int)64, (int)1, (int)16);
        this.setCurrentMenu(0);
    }

    public void setCurrentMenu(int n) {
        System.out.println("setting menu");
        if (this.items != null) {
            for (int i = 0; i < this.items.length; ++i) {
                MenuItem menuItem = this.items[i];
                this.items[this.currentActiveItem].setInactive();
            }
        }
        switch (this.currentMenu) {
            case 0: {
                this.paperGliderItem.setPosition(90, 30);
                this.paperGliderItem.animateTo(-550, 30, 0.5f);
                this.playItem.setPosition(80, 200);
                this.playItem.animateTo(-560, 200, 0.5f);
                this.optionsItem.setPosition(240, 210);
                this.optionsItem.animateTo(-400, 210, 0.5f);
                this.scoreboardItem.setPosition(390, 210);
                this.scoreboardItem.animateTo(-250, 210, 0.5f);
                this.exitItem.setPosition(50, 300);
                this.exitItem.animateTo(-590, 300, 0.5f);
                this.aboutItem.setPosition(269, 300);
                this.aboutItem.animateTo(-371, 300, 0.5f);
                this.helpItem.setPosition(516, 300);
                this.helpItem.animateTo(-124, 300, 0.5f);
                this.getOnOviItem.setPosition(169, 300);
                this.getOnOviItem.animateTo(-471, 300, 0.5f);
                break;
            }
            case 1: {
                this.panelItem.setPosition(100, 20);
                this.panelItem.animateTo(740, 20, 0.5f);
                this.optionsTitleItem.setPosition(210, 40);
                this.optionsTitleItem.animateTo(850, 40, 0.5f);
                this.soundToggleItem.setPosition(230, 140);
                this.soundToggleItem.animateTo(870, 140, 0.5f);
                this.facebookLikeItem.setPosition(200, 210);
                this.facebookLikeItem.animateTo(840, 210, 0.5f);
                this.optionsBackItem.setPosition(100, 320);
                this.optionsBackItem.animateTo(740, 320, 0.5f);
                break;
            }
            case 2: {
                this.panelItem.setPosition(100, 20);
                this.panelItem.animateTo(740, 20, 0.5f);
                this.scoreboardTitleItem.setPosition(150, 40);
                this.scoreboardTitleItem.animateTo(790, 40, 0.5f);
                this.scoreboardBackItem.setPosition(100, 320);
                this.scoreboardBackItem.animateTo(740, 320, 0.5f);
                break;
            }
            case 5: {
                this.panelItem.setPosition(100, 20);
                this.panelItem.animateTo(740, 20, 0.5f);
                this.aboutTitleItem.setPosition(230, 40);
                this.aboutTitleItem.animateTo(870, 40, 0.5f);
                this.aboutBackItem.setPosition(100, 320);
                this.aboutBackItem.animateTo(740, 320, 0.5f);
                break;
            }
            case 4: {
                this.helpTitleItem.setPosition(260, 40);
                this.helpTitleItem.animateTo(900, 40, 0.5f);
                this.helpBackItem.setPosition(100, 320);
                this.helpBackItem.animateTo(740, 320, 0.5f);
                break;
            }
            case 3: {
                this.panelItem.setPosition(100, 20);
                this.timeUpTitleItem.setPosition(115, 40);
                this.getItItem.setPosition(145, 230);
            }
        }
        this.currentMenu = n;
        switch (this.currentMenu) {
            case 0: {
                if (Main.getInstance().getMoreGamesStatus()) {
                    this.items = new MenuItem[7];
                    this.items[0] = this.playItem;
                    this.items[1] = this.optionsItem;
                    this.items[2] = this.scoreboardItem;
                    this.items[3] = this.exitItem;
                    this.items[4] = this.aboutItem;
                    this.items[5] = this.helpItem;
                    this.items[6] = this.getOnOviItem;
                } else {
                    this.items = new MenuItem[6];
                    this.items[0] = this.playItem;
                    this.items[1] = this.optionsItem;
                    this.items[2] = this.scoreboardItem;
                    this.items[3] = this.exitItem;
                    this.items[4] = this.aboutItem;
                    this.items[5] = this.helpItem;
                }
                this.paperGliderItem.setPosition(90, -90);
                this.paperGliderItem.animateTo(90, 90, 0.5f);
                this.playItem.setPosition(80, 380);
                this.playItem.animateTo(80, 200, 0.5f);
                this.optionsItem.setPosition(240, 390);
                this.optionsItem.animateTo(240, 210, 0.5f);
                this.scoreboardItem.setPosition(390, 390);
                this.scoreboardItem.animateTo(390, 210, 0.5f);
                this.exitItem.setPosition(50, 480);
                this.exitItem.animateTo(50, 300, 0.5f);
                this.aboutItem.setPosition(269, 480);
                this.aboutItem.animateTo(269, 300, 0.5f);
                this.helpItem.setPosition(516, 480);
                this.helpItem.animateTo(516, 300, 0.5f);
                this.getOnOviItem.setPosition(169, 480);
                this.getOnOviItem.animateTo(169, 300, 0.5f);
                break;
            }
            case 1: {
                this.items = new MenuItem[3];
                this.items[0] = this.soundToggleItem;
                this.items[1] = this.facebookLikeItem;
                this.items[2] = this.optionsBackItem;
                this.panelItem.setPosition(100, -340);
                this.panelItem.animateTo(100, 20, 0.5f);
                this.optionsTitleItem.setPosition(210, -320);
                this.optionsTitleItem.animateTo(210, 40, 0.5f);
                this.soundToggleItem.setPosition(230, -220);
                this.soundToggleItem.animateTo(230, 140, 0.5f);
                this.facebookLikeItem.setPosition(200, -150);
                this.facebookLikeItem.animateTo(200, 210, 0.5f);
                this.optionsBackItem.setPosition(100, -40);
                this.optionsBackItem.animateTo(100, 320, 0.5f);
                this.soundToggleItem.setToggled(SaveData.getInstance().soundOn);
                break;
            }
            case 2: {
                this.items = new MenuItem[1];
                this.items[0] = this.scoreboardBackItem;
                this.panelItem.setPosition(100, -340);
                this.panelItem.animateTo(100, 20, 0.5f);
                this.scoreboardTitleItem.setPosition(150, -320);
                this.scoreboardTitleItem.animateTo(150, 40, 0.5f);
                this.scoreboardBackItem.setPosition(100, -40);
                this.scoreboardBackItem.animateTo(100, 320, 0.5f);
                break;
            }
            case 5: {
                this.items = new MenuItem[1];
                this.items[0] = this.aboutBackItem;
                this.panelItem.setPosition(100, -340);
                this.panelItem.animateTo(100, 20, 0.5f);
                this.aboutTitleItem.setPosition(230, -320);
                this.aboutTitleItem.animateTo(230, 40, 0.5f);
                this.aboutBackItem.setPosition(100, -40);
                this.aboutBackItem.animateTo(100, 320, 0.5f);
                break;
            }
            case 4: {
                this.items = new MenuItem[1];
                this.items[0] = this.helpBackItem;
                this.helpTitleItem.setPosition(260, -320);
                this.helpTitleItem.animateTo(260, 40, 0.5f);
                this.helpBackItem.setPosition(100, -40);
                this.helpBackItem.animateTo(100, 320, 0.5f);
                break;
            }
            case 3: {
                this.items = new MenuItem[1];
                this.items[0] = this.getItItem;
                this.panelItem.setPosition(100, 20);
                this.timeUpTitleItem.setPosition(115, 40);
                this.getItItem.setPosition(145, 230);
            }
        }
        this.currentActiveItem = 0;
        System.out.println("set menu");
    }

    public void showNotify() {
        System.out.println("showNotify");
        this.lastTime = System.currentTimeMillis();
        this.g = this.getGraphics();
        this.gameThread = new Thread(this);
        this.gameThread.start();
    }

    protected void hideNotify() {
        System.out.println("hideNotify");
        this.gameThread = null;
    }

    public void run() {
        if (this.gameThread == null) {
            return;
        }
        this.currentTime = System.currentTimeMillis();
        this.elapsedMillis = this.currentTime - this.lastTime;
        float f = (float)this.elapsedMillis / 1000.0f;
        this.lastTime = this.currentTime;
        this.update(f);
        this.repaint();
        Display display = Main.getInstance().getDisplay();
        display.callSerially((Runnable)this);
    }

    protected void update(float f) {
        float f2 = 40.0f * f;
        this.backgroundScrollX += f2;
        while (this.backgroundScrollX > 512.0f) {
            this.backgroundScrollX -= 512.0f;
        }
        boolean bl = false;
        bl |= this.paperGliderItem.update(f);
        bl |= this.playItem.update(f);
        bl |= this.optionsItem.update(f);
        bl |= this.scoreboardItem.update(f);
        bl |= this.getOnOviItem.update(f);
        bl |= this.helpItem.update(f);
        bl |= this.aboutItem.update(f);
        bl |= this.exitItem.update(f);
        bl |= this.panelItem.update(f);
        bl |= this.optionsTitleItem.update(f);
        bl |= this.soundToggleItem.update(f);
        bl |= this.facebookLikeItem.update(f);
        bl |= this.optionsBackItem.update(f);
        bl |= this.scoreboardTitleItem.update(f);
        bl |= this.scoreboardBackItem.update(f);
        bl |= this.helpTitleItem.update(f);
        bl |= this.helpBackItem.update(f);
        bl |= this.aboutTitleItem.update(f);
        bl |= this.aboutBackItem.update(f);
    }

    public void paint(Graphics graphics) {
        int n;
        int n2;
        int n3 = this.getLandscapeWidth();
        int n4 = this.getLandscapeHeight();
        Graphics graphics2 = this.doubleBuffer.getGraphics();
        int n5 = (int)(this.backgroundScrollX * (float)n4 / 320.0f);
        graphics2.drawImage(this.backgroundImage, -n5, 0, 4 | 0x10);
        graphics2.drawImage(this.backgroundImage, -n5 + this.backgroundImage.getWidth(), 0, 4 | 0x10);
        graphics2.drawImage(this.backgroundImage, -n5 + 2 * this.backgroundImage.getWidth(), 0, 4 | 0x10);
        if (this.currentMenu == 0 || this.paperGliderItem.isAnimating()) {
            this.paperGliderItem.render(graphics2);
        }
        if (this.currentMenu == 0 || this.paperGliderItem.isAnimating()) {
            this.playItem.render(graphics2);
        }
        if (this.currentMenu == 0 || this.paperGliderItem.isAnimating()) {
            this.optionsItem.render(graphics2);
        }
        if (this.currentMenu == 0 || this.paperGliderItem.isAnimating()) {
            this.scoreboardItem.render(graphics2);
        }
        if (this.currentMenu == 0 || this.paperGliderItem.isAnimating()) {
            this.exitItem.render(graphics2);
        }
        if (this.currentMenu == 0 || this.paperGliderItem.isAnimating()) {
            this.aboutItem.render(graphics2);
        }
        if (this.currentMenu == 0 || this.paperGliderItem.isAnimating()) {
            this.helpItem.render(graphics2);
        }
        if ((this.currentMenu == 0 || this.paperGliderItem.isAnimating()) && Main.getInstance().getMoreGamesStatus()) {
            this.getOnOviItem.render(graphics2);
        }
        if (this.currentMenu == 1 || this.currentMenu == 2 || this.currentMenu == 3 || this.currentMenu == 5 || this.panelItem.isAnimating()) {
            this.panelItem.render(graphics2);
            if (this.currentMenu == 2) {
                n2 = this.panelItem.currentX();
                n = this.panelItem.currentY();
                for (int i = 0; i < 5; ++i) {
                    graphics2.drawString("" + (i + 1) + ".", n2 + 90, n + 95 + i * 30, 4 | 0x10);
                    graphics2.drawString("" + SaveData.getInstance().highNames[i], n2 + 130, n + 95 + i * 30, 4 | 0x10);
                    graphics2.drawString("" + SaveData.getInstance().highScores[i], n2 + 320, n + 95 + i * 30, 8 | 0x10);
                }
            }
        }
        if (this.currentMenu == 1 || this.optionsTitleItem.isAnimating()) {
            this.optionsTitleItem.render(graphics2);
        }
        if (this.currentMenu == 1 || this.soundToggleItem.isAnimating()) {
            this.soundToggleItem.render(graphics2);
        }
        if (this.currentMenu == 1 || this.facebookLikeItem.isAnimating()) {
            this.facebookLikeItem.render(graphics2);
        }
        if (this.currentMenu == 1 || this.optionsBackItem.isAnimating()) {
            this.optionsBackItem.render(graphics2);
        }
        if (this.currentMenu == 2 || this.scoreboardTitleItem.isAnimating()) {
            this.scoreboardTitleItem.render(graphics2);
        }
        if (this.currentMenu == 2 || this.scoreboardBackItem.isAnimating()) {
            this.scoreboardBackItem.render(graphics2);
        }
        if (this.currentMenu == 3) {
            this.timeUpTitleItem.render(graphics2);
            graphics2.drawString("SORRY! YOUR GAME TRIAL", 320, 140, 1 | 0x10);
            graphics2.drawString("IS NOW OVER", 320, 170, 1 | 0x10);
            this.getItItem.render(graphics2);
        }
        if (this.currentMenu == 4 || this.helpTitleItem.isAnimating()) {
            this.helpTitleItem.render(graphics2);
            n2 = this.helpTitleItem.currentX() - 103 + 30;
            n = this.helpTitleItem.currentY() + 30;
            graphics2.drawString("The aim of the game is to", n2, n + 50, 4 | 0x10);
            graphics2.drawString("fly as far as you can. Swipe", n2, n + 70, 4 | 0x10);
            graphics2.drawString("the plane at the correct", n2, n + 90, 4 | 0x10);
            graphics2.drawString("angle to launch. Tap the", n2, n + 110, 4 | 0x10);
            graphics2.drawString("screen when you need to", n2, n + 130, 4 | 0x10);
            graphics2.drawString("boost.", n2, n + 150, 4 | 0x10);
        }
        if (this.currentMenu == 4 || this.helpBackItem.isAnimating()) {
            this.helpBackItem.render(graphics2);
        }
        if (this.currentMenu == 5 || this.aboutTitleItem.isAnimating()) {
            this.aboutTitleItem.render(graphics2);
            n2 = this.panelItem.currentX();
            n = this.panelItem.currentY();
            graphics2.drawString("Application: Paper Glider", n2 + 40, n + 100, 4 | 0x10);
            graphics2.drawString("Developer: Neon Play", n2 + 46, n + 140, 4 | 0x10);
            graphics2.drawString("Version: 1.0", n2 + 52, n + 180, 4 | 0x10);
        }
        if (this.currentMenu == 5 || this.aboutBackItem.isAnimating()) {
            this.aboutBackItem.render(graphics2);
        }
        if (this.isLandscape()) {
            graphics.drawImage(this.doubleBuffer, 0, 0, 20);
        } else {
            graphics.drawRegion(this.doubleBuffer, 0, 0, this.getLandscapeWidth(), this.getLandscapeHeight(), 6, 0, 0, 20);
        }
    }

    public boolean isLandscape() {
        return this.getWidth() > this.getHeight();
    }

    public int getLandscapeWidth() {
        int n;
        int n2 = this.getWidth();
        return n2 > (n = this.getHeight()) ? n2 : n;
    }

    public int getLandscapeHeight() {
        int n = this.getWidth();
        int n2 = this.getHeight();
        return n2 < n ? n2 : n;
    }

    protected void pointerPressed(int n, int n2) {
        int n3;
        if (!this.isLandscape()) {
            n3 = n;
            n = this.getHeight() - n2;
            n2 = n3;
        }
        for (n3 = 0; n3 < this.items.length; ++n3) {
            MenuItem menuItem = this.items[n3];
            menuItem.pointerPressed(n, n2);
        }
    }

    protected void pointerReleased(int n, int n2) {
        int n3;
        if (!this.isLandscape()) {
            n3 = n;
            n = this.getHeight() - n2;
            n2 = n3;
        }
        for (n3 = 0; n3 < this.items.length; ++n3) {
            MenuItem menuItem = this.items[n3];
            menuItem.pointerReleased(n, n2);
        }
    }

    protected void keyPressed(int n) {
        switch (n) {
            case -3: 
            case -1: {
                this.items[this.currentActiveItem].setInactive();
                this.currentActiveItem = this.currentActiveItem == 0 ? this.items.length - 1 : --this.currentActiveItem;
                this.items[this.currentActiveItem].setActive();
                break;
            }
            case -4: 
            case -2: {
                this.items[this.currentActiveItem].setInactive();
                this.currentActiveItem = this.currentActiveItem == this.items.length - 1 ? 0 : ++this.currentActiveItem;
                this.items[this.currentActiveItem].setActive();
                break;
            }
            case -5: {
                this.items[this.currentActiveItem].onSelected();
                break;
            }
            case -7: {
                if (this.currentMenu != 0) {
                    this.setCurrentMenu(0);
                    break;
                }
                Main.getInstance().exit();
            }
        }
    }

    public void playSelectSound() {
        if (SaveData.getInstance().soundOn) {
            this.selectSound.play();
        }
    }

    public void playBackSound() {
        if (SaveData.getInstance().soundOn) {
            this.backSound.play();
        }
    }
}

