/*
 * Decompiled with CFR 0.152.
 */
package Objects;

import Basic.MIDPCanvas;
import Basic.Model;
import Objects.Trans;
import Utils.Util;
import com.jarbull.efw.controller.ImageHandler;
import com.jarbull.efw.game.EFLayer;
import com.jarbull.efw.game.EFLayerManager;
import com.jarbull.efw.game.EFSprite;
import com.jarbull.efw.game.EFTiledLayer;
import com.jarbull.efw.game.TimerHolder;
import java.util.Timer;
import java.util.TimerTask;
import java.util.Vector;

public class Lanes {
    public static Vector vecTransMan = new Vector();
    private Timer lanesTimer;
    private EFLayerManager lm;
    private Vector vecTrans;
    private Trans trans;
    private int[][] arrTransPos;
    private int[][] arrTransFrRight;
    private int[][] arrTransFrLeft;
    private int speedTrans;
    private int side;
    private int movieObjectType;
    private int arrIndex;
    private int repeatPx;
    private int startMs;
    private int bgrWidth;
    private int bgrHeight;

    public Lanes(MIDPCanvas canvas, EFLayerManager lm, int arrIndex, int[][] arrTransPos, int[][] arrTransFrRight, int[][] arrTransFrLeft, int startMs, int repeatPx, int bgrWidth, int bgrHeight) {
        this.lm = lm;
        this.arrIndex = arrIndex;
        this.arrTransPos = arrTransPos;
        this.arrTransFrRight = arrTransFrRight;
        this.arrTransFrLeft = arrTransFrLeft;
        this.startMs = startMs;
        this.repeatPx = repeatPx;
        this.bgrWidth = bgrWidth;
        this.bgrHeight = bgrHeight;
        this.speedTrans = 3;
        this.vecTrans = new Vector();
        this.createLanesTimer();
    }

    public void createLanesTimer() {
        this.lanesTimer = new Timer();
        TimerHolder.getInstance().addTimer(this.lanesTimer);
        this.lanesTimer.schedule(new TimerTask(){

            public void run() {
                if (Model.isPaused) {
                    return;
                }
                Lanes.this.choiceTrans(Lanes.this.arrIndex);
            }
        }, this.startMs);
    }

    public void setMovieObjectType(int movieObjectType) {
        this.movieObjectType = movieObjectType;
    }

    public void createTrans() {
        if (this.vecTrans.size() == 0) {
            return;
        }
        this.side = this.arrTransPos[1][this.arrIndex];
        Trans obj = (Trans)this.vecTrans.elementAt(this.vecTrans.size() - 1);
        switch (this.side) {
            case 0: {
                if (obj.getX() + obj.getWidth() >= this.bgrWidth - this.repeatPx) break;
                this.choiceTrans(this.arrIndex);
                break;
            }
            case 1: {
                if (obj.getX() <= this.repeatPx) break;
                this.choiceTrans(this.arrIndex);
            }
        }
    }

    public void deleteTimer() {
        this.lanesTimer.cancel();
    }

    public void choiceTrans(int indexArr) {
        this.trans = null;
        switch (this.movieObjectType) {
            case 0: {
                this.trans = new Trans("/image/car.png", ImageHandler.getInstance().getImage("/image/car.png").getWidth() / 14, ImageHandler.getInstance().getImage("/image/car.png").getHeight());
                this.trans.defineCollisionRectangle(0, 8, 53, 28);
                this.trans.setter(this.speedTrans, this.arrTransPos, this.bgrWidth, this.bgrHeight, indexArr, this.arrTransFrRight);
                vecTransMan.addElement(this.trans);
                break;
            }
            case 1: {
                this.trans = new Trans("/image/raft.png", ImageHandler.getInstance().getImage("/image/raft.png").getWidth() / 6, ImageHandler.getInstance().getImage("/image/raft.png").getHeight());
                this.trans.setter(this.speedTrans, this.arrTransPos, this.bgrWidth, this.bgrHeight, indexArr, this.arrTransFrRight);
                break;
            }
            case 2: {
                int frmWidth = ImageHandler.getInstance().getImage("/image/tram.png").getWidth() / 2;
                int frmHeight = ImageHandler.getInstance().getImage("/image/tram.png").getHeight();
                this.trans = new Trans("/image/tram.png", frmWidth, frmHeight);
                this.trans.defineCollisionRectangle(0, 50, frmWidth, frmHeight - 50);
                this.trans.setter(this.speedTrans, this.arrTransPos, this.bgrWidth, this.bgrHeight, indexArr, this.arrTransFrRight, this.arrTransFrLeft);
                vecTransMan.addElement(this.trans);
            }
        }
        this.trans.posCreate();
        this.vecTrans.addElement(this.trans);
        this.lm.append(this.trans);
    }

    public Vector getVecTrans() {
        return this.vecTrans;
    }

    public static void setCorrectDepth(EFLayerManager lm) {
        int i2;
        int[] arrCoordsY = new int[vecTransMan.size()];
        int[] arrRightDepths = new int[vecTransMan.size()];
        int cnt = vecTransMan.size();
        for (i2 = 0; i2 < cnt; ++i2) {
            if (vecTransMan.elementAt(i2) instanceof EFTiledLayer) {
                arrCoordsY[i2] = ((EFTiledLayer)vecTransMan.elementAt(i2)).getY() + ((EFTiledLayer)vecTransMan.elementAt(i2)).getHeight();
                continue;
            }
            if (!(vecTransMan.elementAt(i2) instanceof EFSprite)) continue;
            arrCoordsY[i2] = ((EFSprite)vecTransMan.elementAt(i2)).getY() + ((EFSprite)vecTransMan.elementAt(i2)).getHeight();
        }
        arrRightDepths = Util.bubleSort(arrCoordsY);
        for (i2 = cnt - 1; i2 >= 0; --i2) {
            EFLayer obj;
            if (vecTransMan.elementAt(arrRightDepths[i2]) instanceof EFTiledLayer) {
                obj = (EFTiledLayer)vecTransMan.elementAt(arrRightDepths[i2]);
                lm.insert(obj, cnt - 1 - i2);
                continue;
            }
            if (!(vecTransMan.elementAt(arrRightDepths[i2]) instanceof EFSprite)) continue;
            obj = (EFSprite)vecTransMan.elementAt(arrRightDepths[i2]);
            lm.insert(obj, cnt - 1 - i2);
        }
    }

    public void clearLM() {
        this.lm.removeAllLayers();
        vecTransMan.removeAllElements();
        this.vecTrans.removeAllElements();
    }

    public static void addElement(Object obj) {
        vecTransMan.addElement(obj);
    }

    public static void removeElement(Object obj) {
        vecTransMan.removeElement(obj);
    }
}

