/*
 * Decompiled with CFR 0.152.
 */
package Objects;

import Basic.Model;
import Utils.Util;
import com.jarbull.efw.game.EFSprite;
import com.jarbull.efw.game.TimerHolder;
import java.util.Random;
import java.util.Timer;
import java.util.TimerTask;

public class Man
extends EFSprite {
    public static final Random RND = new Random();
    private final double frictionRoad;
    private final double frictionIce;
    public int period;
    public boolean animate;
    private Timer manTimer;
    private Timer crashTimer;
    private int[][] arrMap;
    private int[][] arrDecor;
    private int[][] arrCoins;
    private int[] arrStopTile;
    private int[] arrFinishTile;
    private int[] arrSlideTile;
    private int[] arrManFrRight;
    private int[] arrManFrLeft;
    private int[] arrManFrUp;
    private int[] arrManFrDown;
    private int[] arrCrash;
    private boolean bFinish;
    private boolean isLife;
    private boolean isTimerCancel;
    private boolean isCrash;
    private boolean blnOnceThere;
    private boolean isLockedKey;
    private boolean isSlide;
    private int intPressed;
    private int repeatCrashTimer;
    private int speed;
    private double doubleVX;
    private double doubleVY;
    private int vx;
    private int vy;
    private int xManPos;
    private int yManPos;
    private int accountCoins;
    private int accountLife;
    private int width;
    private int height;
    private int boardWidth;
    private int boardHeight;
    private int wCell;
    private int hCell;

    public Man(String imagePath, int frameWidth, int frameHeight, int speed) {
        super(imagePath, frameWidth, frameHeight);
        this.frictionRoad = 1.0;
        this.frictionIce = 0.98;
        this.speed = speed;
        this.period = 200 / speed;
        this.bFinish = false;
        this.blnOnceThere = true;
        this.isLife = true;
        this.isLockedKey = false;
        this.isSlide = false;
        this.isCrash = false;
        this.doubleVX = 1.0;
        this.doubleVY = 1.0;
        this.intPressed = 0;
        this.accountCoins = 0;
        this.accountLife = 0;
        this.width = this.getWidth();
        this.height = this.getHeight();
        this.animate = false;
        this.createManTimer();
    }

    public void createManTimer() {
        this.manTimer = new Timer();
        TimerHolder.getInstance().addTimer(this.manTimer);
        this.manTimer.schedule(new TimerTask(){

            public void run() {
                if (Model.isPaused) {
                    return;
                }
                if (Man.this.animate) {
                    Man.this.nextFrame();
                }
            }
        }, 0L, (long)this.period);
    }

    public void deleteTimer() {
        this.manTimer.cancel();
    }

    public int getVX() {
        return this.vx;
    }

    public void setVX(int vx) {
        this.vx = vx;
    }

    public int getVY() {
        return this.vy;
    }

    public void setVY(int vy) {
        this.vy = vy;
    }

    public void setter(int[][] arrMap, int[][] arrDecor, int[][] arrCoins, int[] arrStopTile, int[] arrFinishTile, int wCell, int hCell, int[] arrManFrRight, int[] arrManFrLeft, int[] arrManFrUp, int[] arrManFrDown, int[] arrCrash, int[] arrSlideTile) {
        this.arrMap = arrMap;
        this.arrDecor = arrDecor;
        this.arrCoins = arrCoins;
        this.arrStopTile = arrStopTile;
        this.arrFinishTile = arrFinishTile;
        this.arrSlideTile = arrSlideTile;
        this.arrCrash = arrCrash;
        this.wCell = wCell;
        this.hCell = hCell;
        this.arrManFrRight = arrManFrRight;
        this.arrManFrLeft = arrManFrLeft;
        this.arrManFrUp = arrManFrUp;
        this.arrManFrDown = arrManFrDown;
    }

    public void setBoardSize(int boardWidth, int boardHeight) {
        this.boardWidth = boardWidth;
        this.boardHeight = boardHeight;
    }

    public void setPos(int xManPos, int yManPos) {
        this.xManPos = xManPos;
        this.yManPos = yManPos;
        this.setPosition(xManPos, yManPos);
    }

    public int getAccLife() {
        return this.accountLife;
    }

    public void setAccLife(int leftLife) {
        this.accountLife = leftLife;
    }

    public void checkCollide() {
        boolean blnColDecor = false;
        if (this.arrDecor != null) {
            blnColDecor = Util.tileCollide(this.getX() + 5, this.getY() + 15, 14, 10, this.vx, this.vy, this.wCell, this.hCell, this.arrStopTile, this.arrDecor);
        }
        if (Util.tileCollide(this.getX() + 5, this.getY() + 15, 14, 10, this.vx, this.vy, this.wCell, this.hCell, this.arrStopTile, this.arrMap) || blnColDecor) {
            this.vx = 0;
            this.vy = 0;
        } else {
            this.borderStop(this.vx, this.vy);
        }
    }

    private void borderStop(int vx, int vy) {
        if (this.getX() + vx < 0 || this.getX() + this.width + vx > this.boardWidth - (this.speed + 3)) {
            vx = 0;
        } else if (this.getY() + vy < 0 || this.getY() + this.height + vy > this.boardHeight - (this.speed + 2)) {
            vy = 0;
        }
        if (!this.isSlide) {
            this.doubleVX = vx;
            this.doubleVY = vy;
            this.movement();
        }
    }

    public void movement() {
        boolean blnColDecor = false;
        int row = Util.getCellColRow(this.getX() + this.width / 2, this.getY() + this.height - 4, this.wCell, this.hCell)[0];
        int col = Util.getCellColRow(this.getX() + this.width / 2, this.getY() + this.height - 4, this.wCell, this.hCell)[1];
        if (this.arrDecor != null) {
            blnColDecor = Util.checkHitWithTiles(row, col, this.arrSlideTile, this.arrDecor);
        }
        if (Util.checkHitWithTiles(row, col, this.arrSlideTile, this.arrMap) || blnColDecor) {
            this.setIsKeyLock(true);
            this.isSlide = true;
            this.slide();
        } else {
            this.setIsKeyLock(false);
            this.isSlide = false;
            this.doubleVX *= 1.0;
            this.doubleVY *= 1.0;
            this.vx = (int)this.doubleVX;
            this.vy = (int)this.doubleVY;
            this.move(this.vx, this.vy);
        }
    }

    public void slide() {
        this.doubleVX *= 0.98;
        this.doubleVY *= 0.98;
        this.vx = (int)this.doubleVX;
        this.vy = (int)this.doubleVY;
        if (this.vx != 0 || this.vy != 0) {
            this.animate = false;
            this.move(this.vx, this.vy);
        } else {
            this.setIsKeyLock(false);
            this.isSlide = false;
        }
    }

    public void setIsSlide(boolean isSlide) {
        this.isSlide = isSlide;
    }

    public boolean getIsSlide() {
        return this.isSlide;
    }

    public void moveLeft(int intPress) {
        if (this.intPressed != intPress) {
            this.intPressed = intPress;
            this.setFrameSequence(this.arrManFrLeft);
        }
        this.vx = -this.speed;
        this.vy = 0;
        this.animate = true;
        this.checkCollide();
    }

    public void moveRight(int intPress) {
        if (this.intPressed != intPress) {
            this.intPressed = intPress;
            this.setFrameSequence(this.arrManFrRight);
        }
        this.vx = this.speed;
        this.vy = 0;
        this.animate = true;
        this.checkCollide();
    }

    public void moveUp(int intPress) {
        if (this.intPressed != intPress) {
            this.intPressed = intPress;
            this.setFrameSequence(this.arrManFrUp);
        }
        this.vx = 0;
        this.vy = -this.speed;
        this.animate = true;
        this.checkCollide();
    }

    public void moveDown(int intPress) {
        if (this.intPressed != intPress) {
            this.intPressed = intPress;
            this.setFrameSequence(this.arrManFrDown);
        }
        this.vx = 0;
        this.vy = this.speed;
        this.animate = true;
        this.checkCollide();
    }

    public boolean finish() {
        boolean _bFinish = false;
        this.bFinish = Util.tileCollide(this.getX(), this.getY(), this.width, this.height, this.vx, this.vy, this.wCell, this.hCell, this.arrFinishTile, this.arrMap);
        if (this.bFinish && this.accountCoins == this.arrCoins.length) {
            _bFinish = true;
        } else {
            this.bFinish = false;
        }
        return _bFinish;
    }

    public void incCoins() {
        ++this.accountCoins;
    }

    public void decCoins() {
        --this.accountCoins;
    }

    public void resetAccCoins() {
        if (this.accountCoins > 0) {
            this.accountCoins = 0;
        }
    }

    public int getAccCoins() {
        return this.accountCoins;
    }

    public void incHealth() {
        ++this.accountLife;
    }

    public void crashPlay() {
        if (this.blnOnceThere) {
            this.blnOnceThere = false;
            this.repeatCrashTimer = this.arrCrash.length;
            this.isTimerCancel = false;
            this.setFrameSequence(this.arrCrash);
            this.createCrashTimer();
        }
    }

    private void createCrashTimer() {
        this.crashTimer = new Timer();
        this.crashTimer.schedule(new TimerTask(){

            public void run() {
                Man.this.repeatCrashTimer--;
                if (Man.this.repeatCrashTimer == 0) {
                    Man.this.isTimerCancel = true;
                    this.cancel();
                } else {
                    Man.this.nextFrame();
                }
            }
        }, 0L, 110L);
    }

    public boolean isTimerCancel() {
        return this.isTimerCancel;
    }

    public boolean isLife() {
        return this.isLife;
    }

    public boolean getIsCrash() {
        return this.isCrash;
    }

    public void setIsCrash(boolean isCrash) {
        this.isCrash = isCrash;
        this.setIsKeyLock(isCrash);
    }

    public void setIsKeyLock(boolean isKeyPress) {
        this.isLockedKey = isKeyPress;
    }

    public boolean getIsKeyLock() {
        return this.isLockedKey;
    }

    public void decHealth() {
        if (this.accountLife == 0) {
            this.isLife = false;
        } else {
            --this.accountLife;
            this.isLife = true;
            this.setPosition(this.xManPos, this.yManPos);
            this.isCrash = false;
            this.setIsKeyLock(this.isCrash);
            this.setFrameSequence(this.arrManFrDown);
            this.blnOnceThere = true;
        }
    }
}

