/*
 * Decompiled with CFR 0.152.
 */
package Utils;

import com.jarbull.efw.game.EFTiledLayer;
import java.io.IOException;

public class LEDlife {
    private EFTiledLayer tlLEDlife;
    private int[][] tiles;
    private int cntFrameInSequence;
    private int sequenceIndex = 0;
    private int animatedTileTlLEDlife;
    private int currLifeFrame;
    private int cntLife;
    private int[] FRAME_SEQUENCE;
    private int defaultLifeFrame;
    private int tileLedWidth;
    private int tileLedHeight;
    private int cntCol;
    private int cntRow;
    private int leftLife;
    private int screenWidth;

    public LEDlife(int columns, int rows, int tileLedWidth, int tileLedHeight, int leftLife, int defaultFrame, int[] frameSequence, int screenWidth) {
        this.leftLife = leftLife;
        this.cntCol = columns;
        this.cntRow = rows;
        this.tileLedWidth = tileLedWidth;
        this.tileLedHeight = tileLedHeight;
        this.defaultLifeFrame = defaultFrame;
        this.FRAME_SEQUENCE = frameSequence;
        this.screenWidth = screenWidth;
        this.cntFrameInSequence = this.FRAME_SEQUENCE.length;
        this.currLifeFrame = this.defaultLifeFrame;
        this.tiles = new int[this.cntRow][this.cntCol];
    }

    public EFTiledLayer getTlLEDlife() throws IOException {
        if (this.tlLEDlife == null) {
            this.tlLEDlife = new EFTiledLayer(this.cntCol, this.cntRow, "/image/LED_life.png", this.tileLedWidth, this.tileLedHeight);
            this.animatedTileTlLEDlife = this.tlLEDlife.createAnimatedTile(this.FRAME_SEQUENCE[0]);
            this.fillingArray(this.leftLife);
            this.tlLEDlife.setPosition(this.screenWidth - this.tlLEDlife.getWidth(), 0);
        }
        return this.tlLEDlife;
    }

    public void fillingArray(int leftLife) {
        this.cntLife = leftLife;
        for (int row = this.cntRow - 1; row >= 0; --row) {
            for (int col = this.cntCol - 1; col >= 0; --col) {
                if (this.cntLife > 0) {
                    this.currLifeFrame = -1;
                    --this.cntLife;
                } else {
                    this.currLifeFrame = this.defaultLifeFrame;
                }
                this.tiles[row][col] = this.currLifeFrame;
                this.tlLEDlife.setCell(col, row, this.tiles[row][col]);
            }
        }
    }

    public void animateTiles() {
        ++this.sequenceIndex;
        if (this.sequenceIndex > this.cntFrameInSequence - 1) {
            this.sequenceIndex = 0;
        }
        this.tlLEDlife.setAnimatedTile(this.animatedTileTlLEDlife, this.FRAME_SEQUENCE[this.sequenceIndex]);
    }
}

