/*
 * Decompiled with CFR 0.152.
 */
package bbs.framework.library;

import bbs.framework.helper.BBSFunctions;
import bbs.framework.interfaces.BBSIDisposable;
import bbs.framework.models.BBSGame;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public final class BBSTile
implements BBSIDisposable {
    public int guide;
    public int width;
    public int height;
    public int tileWidth;
    public int tileHeight;
    public int fullW;
    public int fullH;
    private boolean drawSubSprites;
    public boolean ready = false;
    private byte[] layers;
    private Image sets;
    private int spriteLayer;
    public int x;
    public int y;
    public int scw;
    public int sch;
    public int lx;
    public int ly;
    private long focusUntil = 0L;
    private int xfocus;
    private int yfocus;
    private int layerSize;
    private int tile;
    private int tw;
    private int th;
    private int sw;
    private int sh;
    private int rept;
    private int xs;
    private int ys;
    private int fx;
    private int fy;

    public void createTiles(BBSGame game, int stage, int guideLayer, int sx, int sy, int spriteLay, boolean cellSprites) {
        this.x = sx;
        this.y = sy;
        this.lx = this.x;
        this.ly = this.y;
        this.drawSubSprites = cellSprites;
        this.guide = guideLayer;
        this.scw = game.w;
        this.sch = game.h;
        this.layers = stage % 5 == 0 ? BBSFunctions.loadData(game, "tiles/stage5.til") : BBSFunctions.loadData(game, "tiles/stage" + stage % 5 + ".til");
        this.width = this.layers[0] & 0xFF;
        this.height = this.layers[1] & 0xFF;
        this.tileWidth = this.layers[2] & 0xFF;
        this.tileHeight = this.layers[3] & 0xFF;
        this.sets = stage % 5 == 0 ? game.loadImage("tilesets/tileset5.png") : game.loadImage("tilesets/tileset" + stage % 5 + ".png");
        this.layerSize = this.width * this.height;
        this.sw = this.scw / this.tileWidth + 1;
        this.sh = this.sch / this.tileHeight + 1;
        this.tw = this.sets.getWidth() / this.tileWidth;
        this.th = this.sets.getHeight() / this.tileHeight;
        this.fullW = this.width * this.tileWidth;
        this.fullH = this.height * this.tileHeight;
        this.spriteLayer = spriteLay;
        this.ready = true;
    }

    public void calcTile(BBSGame game) {
        if (this.ready) {
            this.scw = game.w;
            this.sch = game.h;
            this.sw = this.scw / this.tileWidth + 1;
            this.sh = this.sch / this.tileHeight + 1;
        }
    }

    public void doAnimation(int targetx, int targety, long currentTime) {
        if (this.ready) {
            if (currentTime < this.focusUntil) {
                targetx = this.xfocus;
                targety = this.yfocus;
            }
            if (targetx < this.x + 2 * this.scw / 5) {
                this.x += Math.min(-1, Math.max((targetx - this.x - 2 * this.scw / 5) / 8, -50));
            }
            if (targetx > this.x + 3 * this.scw / 5) {
                this.x += Math.max(1, Math.min((targetx - this.x - 3 * this.scw / 5) / 8, 50));
            }
            if (targety < this.y + 2 * this.sch / 5) {
                this.y += Math.min(-1, Math.max((targety - this.y - 2 * this.sch / 5) / 8, -50));
            }
            if (targety > this.y + 3 * this.sch / 5) {
                this.y += Math.max(1, Math.min((targety - this.y - 3 * this.sch / 5) / 8, 50));
            }
            this.x = Math.min(this.width * this.tileWidth - this.scw, Math.max(0, this.x));
            this.y = Math.min(this.height * this.tileHeight - this.sch, Math.max(0, this.y));
        }
    }

    public void focus(int xf, int yf, long fUntil) {
        this.xfocus = xf;
        this.yfocus = yf;
        this.focusUntil = fUntil;
    }

    public int checkCollision(int sx, int sy) {
        if (this.ready) {
            int cell;
            int tx = sx / this.tileWidth;
            int ty = sy / this.tileHeight;
            if (tx < 0 || ty < 0 || tx > this.width - 1 || ty > this.height - 1) {
                return 0;
            }
            if (ty >= 0 && ty < this.height && this.layers[5 + (this.guide - 1) * this.layerSize + ty * this.width + tx] != 0 && (cell = this.layers[5 + (this.guide - 1) * this.layerSize + ty * this.width + tx] & 0xFF) != 0) {
                return cell;
            }
        }
        return 0;
    }

    public void setLayerCell(int tx, int ty, int layer, byte value) {
        if (this.ready && tx >= 0 && ty >= 0 && tx < this.width && ty < this.height) {
            this.layers[5 + (layer - 1) * this.layerSize + ty * this.width + tx] = value;
        }
    }

    public void drawTiles(BBSGame game, Graphics g, int level) {
        if (this.ready) {
            this.lx = this.x;
            this.ly = this.y;
            this.xs = this.lx / this.tileWidth;
            this.ys = this.ly / this.tileHeight;
            this.fx = -this.lx % this.tileWidth;
            this.fy = -this.ly % this.tileHeight;
            for (int layer = 0; layer < this.guide - 1; ++layer) {
                this.rept = 1;
                if (layer == this.spriteLayer - 1) {
                    game.drawLayerSprites(g, -1);
                    if (this.drawSubSprites) {
                        this.rept = 2;
                    }
                }
                for (int rep = 1; rep <= this.rept; ++rep) {
                    for (int row = this.ys + this.sh + 4; row >= this.ys - 2; --row) {
                        block7: for (int col = this.xs + this.sw + 2; col >= this.xs - 2; --col) {
                            switch (rep) {
                                case 1: {
                                    if (col < this.xs || col > this.xs + this.sw || col < 0 || col >= this.width || row < 0 || row < this.ys || row > this.ys + this.sh || row >= this.height || (this.tile = this.layers[5 + layer * this.layerSize + row * this.width + col] & 0xFF) == 0) continue block7;
                                    g.drawRegion(this.sets, (this.tile - 1) % this.tw * this.tileWidth, (this.tile - 1) / this.tw * this.tileHeight, this.tileWidth, this.tileHeight, 0, this.fx + (col - this.xs) * this.tileWidth, this.fy + (row - this.ys) * this.tileHeight, 0);
                                    continue block7;
                                }
                                case 2: {
                                    game.drawSpriteLayerSprites(g, col, row);
                                }
                            }
                        }
                    }
                }
                if (layer != this.spriteLayer - 1 || this.rept != 1 && this.drawSubSprites) continue;
                game.drawLayerSprites(g, 1);
            }
            game.drawLayerSprites(g, 2);
        }
    }

    public void freeResources() {
        this.ready = false;
        this.sets = null;
        this.layers = null;
    }
}

