/*
 * Decompiled with CFR 0.152.
 */
package bbs.framework.helper;

import bbs.framework.helper.BBSFunctions;
import bbs.framework.helper.BBSKeys;
import bbs.framework.helper.BBSRecStore;
import bbs.framework.library.BBSCrypto;
import bbs.framework.models.BBSGame;
import java.util.Hashtable;
import javax.microedition.io.Connector;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import javax.wireless.messaging.Message;
import javax.wireless.messaging.MessageConnection;
import javax.wireless.messaging.TextMessage;

public class BBSPurchase {
    public Hashtable properties = new Hashtable();
    private String key = "kemerburgazlibarkan";
    private short state;
    private short selection = 0;
    public short mode;
    private static final short STATE_HIDE = 0;
    private static final short STATE_SHOW = 1;
    private static final short STATE_FORCE = 2;
    private static final short STATE_PURCHASE = 3;
    private static final short STATE_SUCCESS = 4;
    private static final short STATE_FAIL = 5;
    private static final short STATE_QUIT = 6;
    private static final short MODE_FULL = 3;
    private static final short MODE_DEMO = 2;
    private static final short MODE_ADS = 1;
    private Font fnt = Font.getFont((int)64, (int)0, (int)16);
    private Font tFnt = Font.getFont((int)64, (int)0, (int)0);
    private Font tFnt2 = Font.getFont((int)64, (int)0, (int)8);
    private String[][] menu = new String[][]{new String[0], {"buy-buygame", "buy-playgame", "buy-quit"}, {"buy-buygame", "buy-quit"}, {"buy-continue", "buy-quit"}, {"buy-ok"}, {"buy-ok"}, new String[0]};
    private int[][] pos = new int[][]{new int[0], {2, 3, 4}, {2, 3}, {2, 5}, {4}, {4}, new int[0]};
    private String[][] texts = new String[][]{new String[0], new String[0], new String[0], {"MIDlet-Name", "buy-desc", "buy-price"}, {"buy-success", "buy-success2", "buy-success3"}, {"buy-fail1", "buy-fail2"}, new String[0]};
    private int[][] tpos = new int[][]{new int[0], new int[0], new int[0], {1, 3, 4}, {1, 2, 5}, {2, 3}, new int[0]};
    private short stateInit;
    private String conSMS;
    private int tryCnt;
    private Image logo;

    public BBSPurchase(BBSGame game) {
        this.readProperties(game);
        this.logo = BBSFunctions.loadImage("/bbs/res/jarbull.png", false);
        this.state = 0;
        String mod = this.getPropText("mode");
        if (mod.equals("f")) {
            this.mode = (short)3;
        } else if (mod.equals("d")) {
            this.mode = (short)2;
            if (this.getPropText("buy-showdemoscreen").equals("true")) {
                this.show(false);
            }
        } else if (mod.equals("a")) {
            this.mode = 1;
        }
        if (this.mode != 3) {
            BBSRecStore rec = new BBSRecStore("game");
            if (!rec.read("purchased").equals("")) {
                this.mode = (short)3;
            }
            rec.close();
        }
    }

    private void readProperties(BBSGame game) {
        String[] propList = new String[]{"buy-buygame", "buy-continue", "buy-desc", "buy-fail", "buy-message", "buy-ok", "buy-phone", "buy-playgame", "buy-price", "buy-quit", "buy-showdemoscreen", "buy-success", "buy-success2", "buy-success3", "buy-trycount", "mode", "MIDlet-Name"};
        String[] defaults = new String[]{"Buy Game", "Continue", "Continue for instant activation.", "Message delivery failed. Please try again later.", "", "OK", "0|0|0|10|55|107|-35|-103|40|-37|-103|19|-91|118|56|-46|-82|-122|-78|-21", "Play Game", "0.99$", "Quit", "false", "Congratulations!", "Full version is activated.", "Have Fun!", "2", "d", "Game"};
        for (int cnt = 0; cnt < propList.length; ++cnt) {
            String value = game.instance.getAppProperty(propList[cnt]);
            if (value == null) {
                value = defaults[cnt];
            }
            if (propList[cnt].equals("buy-phone")) {
                BBSCrypto encoder = new BBSCrypto(this.key.getBytes());
                value = encoder.decode(value);
                this.conSMS = "sms://" + value;
                encoder = null;
            }
            if (propList[cnt].equals("buy-price")) {
                value = "Price : " + value;
            }
            if (propList[cnt].equals("buy-fail")) {
                this.properties.put("buy-fail1", value.substring(0, value.indexOf(".")));
                this.properties.put("buy-fail2", value.substring(value.indexOf(".") + 1));
                value = "";
            }
            if (propList[cnt].equals("buy-trycount")) {
                this.tryCnt = Integer.parseInt(value);
            }
            this.properties.put(propList[cnt], value);
        }
    }

    public void doAnimation(BBSGame game, int time) {
        if (this.state == 6) {
            game.quitApp();
        }
    }

    private String getPropText(String parameter) {
        return (String)this.properties.get(parameter);
    }

    public void show(boolean disablePlay) {
        this.state = disablePlay ? (short)2 : (short)1;
        this.stateInit = this.state;
    }

    public boolean check() {
        return this.state != 0;
    }

    public void keyPress(BBSKeys kcol) {
        if (kcol.released) {
            if (kcol.up && this.selection > 0) {
                this.selection = (short)(this.selection - 1);
            }
            if (kcol.down && this.selection < this.menu[this.state].length - 1) {
                this.selection = (short)(this.selection + 1);
            }
            if (kcol.fire) {
                switch (this.state) {
                    case 1: {
                        switch (this.selection) {
                            case 0: {
                                this.state = (short)3;
                                break;
                            }
                            case 1: {
                                this.state = 0;
                                this.logo = null;
                                break;
                            }
                            case 2: {
                                this.state = (short)6;
                            }
                        }
                        break;
                    }
                    case 2: {
                        switch (this.selection) {
                            case 0: {
                                this.state = (short)3;
                                break;
                            }
                            case 1: {
                                this.state = (short)6;
                            }
                        }
                        break;
                    }
                    case 3: {
                        switch (this.selection) {
                            case 0: {
                                boolean success;
                                for (int cnt = 0; !(success = this.sendSMS()) && cnt < this.tryCnt; ++cnt) {
                                }
                                if (success) {
                                    this.state = (short)4;
                                    this.mode = (short)3;
                                    BBSRecStore rec = new BBSRecStore("game");
                                    rec.write("purchased", "1");
                                    rec.close();
                                    break;
                                }
                                this.state = (short)5;
                                break;
                            }
                            case 1: {
                                this.state = this.stateInit;
                            }
                        }
                        break;
                    }
                    case 4: {
                        this.state = 0;
                        this.logo = null;
                        break;
                    }
                    case 5: {
                        this.state = this.stateInit;
                    }
                }
                this.selection = 0;
            }
        }
    }

    public void drawScreen(BBSGame game, Graphics g) {
        int cnt;
        g.setColor(0, 0, 0);
        g.fillRect(0, 0, game.w, game.h);
        if (this.logo != null) {
            g.drawImage(this.logo, game.w / 2, 10, 17);
        }
        g.setColor(150, 0, 0);
        g.fillRoundRect(game.w / 2 - Math.min(game.w / 2 - 2, 85), this.pos[this.state][this.selection] * game.h / 6, Math.min(game.w - 4, 170), 24, 8, 8);
        g.setColor(255, 255, 255);
        g.setFont(this.fnt);
        for (cnt = 0; cnt < this.menu[this.state].length; ++cnt) {
            g.drawString(this.getPropText(this.menu[this.state][cnt]), game.w / 2, this.pos[this.state][cnt] * game.h / 6 + (22 - g.getFont().getHeight()) / 2, 17);
        }
        if (game.w <= 240) {
            g.setFont(this.tFnt2);
        } else {
            g.setFont(this.tFnt);
        }
        for (cnt = 0; cnt < this.texts[this.state].length; ++cnt) {
            g.drawString(this.getPropText(this.texts[this.state][cnt]), game.w / 2, this.tpos[this.state][cnt] * game.h / 6 + (22 - g.getFont().getHeight()) / 2, 17);
        }
    }

    private boolean sendSMS() {
        try {
            MessageConnection smsconn = (MessageConnection)Connector.open((String)this.conSMS);
            TextMessage txtmessage = (TextMessage)smsconn.newMessage("text");
            txtmessage.setAddress(this.getPropText("buy-phone"));
            txtmessage.setPayloadText(this.getPropText("buy-message"));
            smsconn.send((Message)txtmessage);
            smsconn.close();
            return true;
        }
        catch (Exception ex) {
            return false;
        }
    }
}

