/*
 * Decompiled with CFR 0.152.
 */
package bbs.framework.helper;

import bbs.framework.models.BBSGame;
import java.io.InputStream;
import java.util.Hashtable;
import java.util.Vector;
import javax.microedition.media.Manager;
import javax.microedition.media.Player;
import javax.microedition.media.control.VolumeControl;

public class BBSSound {
    public static Hashtable sounds = new Hashtable();
    public static Vector sList = new Vector();
    public Player player;
    public long playTime = 0L;
    public boolean isMusic = false;

    public static void loadSound(BBSGame game, String file, boolean isMidi) {
        if (!sounds.containsKey(file)) {
            BBSSound sound = new BBSSound();
            sound.isMusic = isMidi;
            try {
                if (isMidi) {
                    sound.player = Manager.createPlayer((InputStream)((Object)((Object)game.instance)).getClass().getResourceAsStream("/res/sounds/" + file + ".mid"), (String)"audio/midi");
                    sound.player.setLoopCount(-1);
                } else {
                    sound.player = Manager.createPlayer((InputStream)((Object)((Object)game.instance)).getClass().getResourceAsStream("/res/sounds/" + file + ".wav"), (String)"audio/x-wav");
                }
                sound.player.prefetch();
                VolumeControl volumeControl = (VolumeControl)sound.player.getControl("VolumeControl");
                volumeControl.setLevel(80);
            }
            catch (Exception ex) {
                // empty catch block
            }
            if (sound.player != null) {
                sounds.put(file, sound);
                sList.addElement(file);
            }
        } else {
            try {
                ((BBSSound)BBSSound.sounds.get((Object)file)).player.setMediaTime(0L);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static void playSound(BBSGame game, String file) {
        try {
            ((BBSSound)BBSSound.sounds.get((Object)file)).playTime = game.currentTimeMillis;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void stopSound(BBSGame game, String file) {
        try {
            ((BBSSound)BBSSound.sounds.get((Object)file)).playTime = -1L;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void playSounds(BBSGame game) {
        for (int cnt = 0; cnt < sList.size(); ++cnt) {
            try {
                BBSSound sound = (BBSSound)sounds.get(sList.elementAt(cnt));
                if (sound.playTime < 0L) {
                    if (sound.player.getState() == 400) {
                        sound.player.stop();
                    }
                } else if (game.currentTimeMillis - sound.playTime < 400L && (game.music || game.soundfx) && sound.player.getState() != 400) {
                    sound.player.start();
                    while (!sound.isMusic && sound.player.getState() == 400) {
                        Thread.yield();
                    }
                }
                sound.playTime = 0L;
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static void stopSounds(BBSGame game) {
        for (int cnt = 0; cnt < sList.size(); ++cnt) {
            try {
                BBSSound sound = (BBSSound)sounds.get(sList.elementAt(cnt));
                if (sound.playTime >= 0L || sound.player.getState() != 400) continue;
                sound.playTime = 0L;
                sound.player.start();
                while (sound.player.getState() == 400) {
                    Thread.yield();
                }
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static void removeSounds(BBSGame game) {
        for (int cnt = 0; cnt < sList.size(); ++cnt) {
            BBSSound sTemp = (BBSSound)sounds.get(sList.elementAt(cnt));
            try {
                Player p = sTemp.player;
                p.stop();
                p.close();
                p.deallocate();
                p = null;
            }
            catch (Exception exception) {
                // empty catch block
            }
            sTemp.player = null;
        }
        sounds.clear();
        sList.removeAllElements();
    }
}

