/*
 * Decompiled with CFR 0.152.
 */
import java.io.IOException;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import javax.microedition.lcdui.game.Sprite;

public class Penguin {
    int birdX;
    int birdY;
    int birdForce;
    int birdFriction;
    int birdRadius;
    int birdOx;
    int birdOy;
    int birdWidth;
    int birdHeight;
    int birdAngle;
    int birdFrame;
    int level;
    public int bgY;
    public int WTX;
    public int WTY;
    public int WORLDWIDTH = 640;
    public int WORLDHEIGHT = -900;
    public int GAME_WIDTH = 640;
    public int GAME_HEIGHT = 360;
    int leftWall = 213;
    int rightWall = 428;
    int movingType;
    int straight = 0;
    int rotateL = 1;
    int rotateR = 2;
    Obstacles[] obstacle;
    boolean visible;
    DisplayableCanvas dc;
    Sprite[] dashSlide = new Sprite[10];
    Image[] tBlock = new Image[2];
    Image[] tHole = new Image[2];
    Image[] tSlide = new Image[3];
    Image[] tIce = new Image[3];
    public static final short[] sinValue = new short[]{0, 286, 572, 857, 1143, 1428, 1713, 1997, 2280, 2563, 2845, 3126, 3406, 3686, 3964, 4240, 4516, 4790, 5063, 5334, 5604, 5872, 6138, 6402, 6664, 6924, 7182, 7438, 7692, 7943, 8192, 8438, 8682, 8923, 9162, 9397, 9630, 9860, 10087, 10311, 10531, 10749, 10963, 11174, 11381, 11585, 11786, 11982, 12176, 12365, 12551, 12733, 12911, 13085, 13255, 13421, 13583, 13741, 13894, 14044, 14189, 14330, 14466, 14598, 14726, 14849, 14968, 15082, 15191, 15296, 15396, 15491, 15582, 15668, 15749, 15826, 15897, 15964, 16026, 16083, 16135, 16182, 16225, 16262, 16294, 16322, 16344, 16362, 16374, 16382, 16384};
    public static final short[] tanValue = new short[]{0, 18, 36, 54, 72, 90, 108, 126, 144, 162, 181, 199, 218, 236, 255, 274, 294, 313, 333, 353, 373, 393, 414, 435, 456, 477, 499, 522, 544, 568, 591, 615, 640, 665, 691, 717, 744, 772, 800, 829, 859, 890, 922, 955, 989, 1024};

    public Penguin(DisplayableCanvas canvas, int x, int y, int angle, int type, boolean visibility, int lvl) {
        this.dc = canvas;
        this.birdWidth = 44;
        this.birdHeight = 44;
        this.birdX = x;
        this.birdY = y;
        this.birdAngle = angle;
        this.movingType = type;
        this.visible = visibility;
        this.level = lvl;
        if (this.dashSlide[0] == null) {
            try {
                for (int i = 0; i < 10; ++i) {
                    this.dashSlide[i] = new Sprite(Image.createImage((String)("/res/game/dash/dash" + i + ".png")));
                    if (i <= 0) continue;
                    if (i < 3) {
                        this.tBlock[i - 1] = Image.createImage((String)("/res/game/obs/tvblk" + i + ".png"));
                        this.tHole[i - 1] = Image.createImage((String)("/res/game/obs/tvhole" + i + ".png"));
                    }
                    if (i >= 4) continue;
                    this.tSlide[i - 1] = Image.createImage((String)("/res/game/obs/tvslide" + i + ".png"));
                    this.tIce[i - 1] = Image.createImage((String)("/res/game/obs/tvice" + i + ".png"));
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            this.objectsXY();
        }
    }

    void objectsXY() {
        switch (this.level) {
            case 1: {
                break;
            }
            case 2: {
                this.obstacle = new Obstacles[1];
                this.obstacle[0] = new Obstacles(this.dc, 279, -189, this.tHole[0], 0);
                break;
            }
            case 3: {
                this.obstacle = new Obstacles[2];
                this.obstacle[0] = new Obstacles(this.dc, 234, -20, this.tHole[0], 0);
                this.obstacle[1] = new Obstacles(this.dc, 324, -490, this.tSlide[1], 1);
                break;
            }
            case 4: {
                this.obstacle = new Obstacles[4];
                this.obstacle[0] = new Obstacles(this.dc, 200, -250, this.tIce[0], 0);
                this.obstacle[1] = new Obstacles(this.dc, 355, -250, this.tIce[0], 0);
                this.obstacle[2] = new Obstacles(this.dc, 350, -550, this.tHole[1], 0);
                this.obstacle[3] = new Obstacles(this.dc, 205, -550, this.tHole[0], 0);
                break;
            }
            case 5: {
                this.obstacle = new Obstacles[3];
                this.obstacle[0] = new Obstacles(this.dc, 270, -500, this.tSlide[2], 2);
                this.obstacle[1] = new Obstacles(this.dc, 350, -85, this.tHole[1], 0);
                this.obstacle[2] = new Obstacles(this.dc, 205, -50, this.tHole[0], 0);
                break;
            }
            case 6: {
                this.obstacle = new Obstacles[2];
                this.obstacle[0] = new Obstacles(this.dc, 200, 0, this.tBlock[1], 0);
                this.obstacle[1] = new Obstacles(this.dc, 300, -490, this.tSlide[2], 2);
                break;
            }
            case 7: {
                this.obstacle = new Obstacles[2];
                this.obstacle[0] = new Obstacles(this.dc, 210, -50, this.tBlock[1], 0);
                this.obstacle[1] = new Obstacles(this.dc, 315, -550, this.tHole[1], 0);
                break;
            }
            case 8: {
                this.obstacle = new Obstacles[3];
                this.obstacle[0] = new Obstacles(this.dc, 245, -60, this.tIce[0], 0);
                this.obstacle[1] = new Obstacles(this.dc, 240, -249, this.tSlide[0], 1);
                this.obstacle[2] = new Obstacles(this.dc, 337, -564, this.tSlide[1], 1);
                break;
            }
            case 9: {
                this.obstacle = new Obstacles[2];
                this.obstacle[0] = new Obstacles(this.dc, 335, 0, this.tBlock[0], 0);
                this.obstacle[1] = new Obstacles(this.dc, 330, -520, this.tBlock[0], 0);
                break;
            }
            case 10: {
                this.obstacle = new Obstacles[2];
                this.obstacle[0] = new Obstacles(this.dc, 200, 0, this.tBlock[1], 0);
                this.obstacle[1] = new Obstacles(this.dc, 330, -450, this.tBlock[0], 0);
                break;
            }
            case 11: {
                this.obstacle = new Obstacles[1];
                this.obstacle[0] = new Obstacles(this.dc, 315, -390, this.tIce[2], 0);
                break;
            }
            case 12: {
                this.obstacle = new Obstacles[2];
                this.obstacle[0] = new Obstacles(this.dc, 249, -10, this.tIce[0], 0);
                this.obstacle[1] = new Obstacles(this.dc, 315, -550, this.tHole[1], 0);
                break;
            }
            case 13: {
                this.obstacle = new Obstacles[2];
                this.obstacle[0] = new Obstacles(this.dc, 218, 0, this.tIce[2], 0);
                this.obstacle[1] = new Obstacles(this.dc, 335, -550, this.tIce[1], 0);
                break;
            }
            case 14: {
                this.obstacle = new Obstacles[2];
                this.obstacle[0] = new Obstacles(this.dc, 315, -30, this.tHole[1], 0);
                this.obstacle[1] = new Obstacles(this.dc, 240, -550, this.tHole[0], 0);
                break;
            }
            case 15: {
                this.obstacle = new Obstacles[4];
                this.obstacle[0] = new Obstacles(this.dc, 200, -680, this.tBlock[1], 0);
                this.obstacle[1] = new Obstacles(this.dc, 327, -534, this.tSlide[1], 1);
                this.obstacle[2] = new Obstacles(this.dc, 235, -432, this.tIce[1], 0);
                this.obstacle[3] = new Obstacles(this.dc, 240, -54, this.tHole[0], 0);
            }
        }
    }

    public void setParams() {
        this.birdOx = this.birdX;
        this.birdOy = this.birdY;
    }

    public void penguinFrames() {
        if (this.birdForce > 1) {
            if (this.movingType == this.straight) {
                this.birdFrame = 0;
            } else if (this.movingType == this.rotateL) {
                ++this.birdFrame;
                if (this.birdFrame >= 9) {
                    this.birdFrame = 0;
                }
            } else if (this.movingType == this.rotateR) {
                --this.birdFrame;
                if (this.birdFrame <= 0) {
                    this.birdFrame = 9;
                }
            }
        } else {
            this.birdFrame = 0;
        }
    }

    public void movePenguin() {
        if (this.birdForce > 0) {
            ++this.birdFriction;
            if (this.birdForce > 5) {
                if (this.birdFriction % 8 == 0) {
                    --this.birdForce;
                }
            } else if (this.birdForce > 2) {
                if (this.birdFriction % 10 == 0) {
                    --this.birdForce;
                }
            } else if (this.birdFriction % 12 == 0) {
                --this.birdForce;
            }
            int speed = 0;
            int radius = this.birdRadius;
            while (speed < this.birdForce) {
                speed += 2;
                if (this.movingType == 0 || this.movingType == 1 || this.movingType == 2) {
                    this.birdRadius = radius + speed;
                    this.birdX = this.birdOx + (this.birdRadius * Penguin.cos(this.birdAngle) >> 14);
                    this.birdY = this.birdOy + (this.birdRadius * Penguin.sin(this.birdAngle) >> 14);
                }
                if (this.birdForce < 1) {
                    this.birdForce = 0;
                    this.birdFriction = 0;
                    this.birdReset();
                    continue;
                }
                if (!this.checkWallCollision()) continue;
                this.birdForce -= 2;
                if (this.birdForce < 0) {
                    this.birdForce = 0;
                    break;
                }
                if (this.birdForce >= 1) break;
                this.birdForce = 1;
                break;
            }
        }
        this.dashSlide[this.birdFrame].setPosition(this.birdX, this.birdY);
    }

    boolean checkWallCollision() {
        boolean wallCollided = false;
        if (this.birdX <= this.leftWall) {
            this.birdX = this.leftWall + 1;
            this.birdAngle = this.birdAngle > 180 ? 540 - this.birdAngle : 180 - this.birdAngle;
            wallCollided = true;
            this.movingType = this.rotateR;
        } else if (this.birdX + this.birdWidth >= this.rightWall) {
            this.birdX = this.rightWall - this.birdWidth - 1;
            this.birdAngle = this.birdAngle < 90 ? 180 - this.birdAngle : 540 - this.birdAngle;
            wallCollided = true;
            this.movingType = this.rotateL;
        }
        if (wallCollided) {
            this.birdOx = this.birdX;
            this.birdOy = this.birdY;
            this.birdRadius = 0;
        }
        return wallCollided;
    }

    void birdReset() {
        this.birdForce = 0;
        this.birdFriction = 0;
        this.birdOx = this.birdX;
        this.birdOy = this.birdY;
    }

    public void penguinRun() {
        this.translateMap();
        this.penguinFrames();
        this.movePenguin();
        if (this.obstacle != null) {
            for (int i = 0; i < this.obstacle.length; ++i) {
                this.obstacle[i].run(this);
            }
        }
    }

    public final void translateMap() {
        this.WTY = this.birdY > this.GAME_HEIGHT >> 1 ? 0 : (this.birdY < this.WORLDHEIGHT + (this.GAME_HEIGHT >> 1) ? this.WORLDHEIGHT : this.birdY - (this.GAME_HEIGHT >> 1));
        this.bgY = this.WTY / this.GAME_HEIGHT * this.GAME_HEIGHT;
    }

    public void obsPaint(Graphics g) {
        if (this.obstacle != null) {
            for (int i = 0; i < this.obstacle.length; ++i) {
                this.obstacle[i].paint(g);
            }
        }
    }

    public void paint(Graphics g) {
        if (this.visible) {
            this.dashSlide[this.birdFrame].paint(g);
        }
    }

    public static final int sin(int degree) {
        if (degree < 0) {
            degree = degree % 360 + 360;
        } else if (degree > 360) {
            degree %= 360;
        }
        if (degree < 91) {
            return sinValue[degree];
        }
        if (degree < 181) {
            return sinValue[180 - degree];
        }
        if (degree < 271) {
            return -sinValue[degree - 180];
        }
        return -sinValue[360 - degree];
    }

    public static int cos(int degree) {
        return Penguin.sin(90 - degree);
    }

    private static int distance_angle(int ox, int oy, int tx, int ty, int ang) {
        int temp = (ang + 45) % 360 / 90;
        if (temp == 0 || temp == 2) {
            return Math.abs((tx - ox << 14) / (Penguin.sin(90 - ang) == 0 ? 1 : Penguin.sin(90 - ang)));
        }
        return Math.abs((ty - oy << 14) / (Penguin.sin(ang) == 0 ? 1 : Penguin.sin(ang)));
    }

    public int distance(int ox, int oy, int tx, int ty) {
        int ang = this.angle(ox, oy, tx, ty);
        int temp = (ang + 45) % 360 / 90;
        int dist = 0;
        dist = temp == 0 || temp == 2 ? (tx - ox << 14) / Penguin.cos(ang) : (ty - oy << 14) / Penguin.sin(ang);
        return Math.abs(dist);
    }

    public int angle(int ox, int oy, int tx, int ty) {
        int dx = Math.abs(tx - ox);
        int dy = Math.abs(ty - oy);
        int result = 0;
        int ratio = dx >= dy ? (dy << 10) / dx : (dx << 10) / dy;
        switch (ratio) {
            case 0: {
                result = ratio;
                break;
            }
            case 1024: {
                result = 45;
                break;
            }
            default: {
                result = ratio < 181 ? 1 : (ratio < 353 ? 10 : (ratio < 544 ? 19 : (ratio < 772 ? 28 : 37)));
                while (ratio > tanValue[result]) {
                    ++result;
                }
                break block0;
            }
        }
        int n = result = dx >= dy ? result : 90 - result;
        if (tx < ox) {
            result = 180 - result;
        }
        if (ty < oy) {
            result = 360 - result;
        }
        return result;
    }
}

