/*
 * Decompiled with CFR 0.152.
 */
public class RectangleLineIntersect {
    private static final int OUT_LEFT = 1;
    private static final int OUT_TOP = 2;
    private static final int OUT_RIGHT = 4;
    private static final int OUT_BOTTOM = 8;

    private static int outcode(double pX, double pY, double rectX, double rectY, double rectWidth, double rectHeight) {
        int out = 0;
        if (rectWidth <= 0.0) {
            out |= 5;
        } else if (pX < rectX) {
            out |= 1;
        } else if (pX > rectX + rectWidth) {
            out |= 4;
        }
        if (rectHeight <= 0.0) {
            out |= 0xA;
        } else if (pY < rectY) {
            out |= 2;
        } else if (pY > rectY + rectHeight) {
            out |= 8;
        }
        return out;
    }

    public static boolean intersectsLine(double lineX1, double lineY1, double lineX2, double lineY2, double rectX, double rectY, double rectWidth, double rectHeight) {
        int out1;
        int out2 = RectangleLineIntersect.outcode(lineX2, lineY2, rectX, rectY, rectWidth, rectHeight);
        if (out2 == 0) {
            return true;
        }
        while ((out1 = RectangleLineIntersect.outcode(lineX1, lineY1, rectX, rectY, rectWidth, rectHeight)) != 0) {
            if ((out1 & out2) != 0) {
                return false;
            }
            if ((out1 & 5) != 0) {
                double x = rectX;
                if ((out1 & 4) != 0) {
                    x += rectWidth;
                }
                lineY1 += (x - lineX1) * (lineY2 - lineY1) / (lineX2 - lineX1);
                lineX1 = x;
                continue;
            }
            double y = rectY;
            if ((out1 & 8) != 0) {
                y += rectHeight;
            }
            lineX1 += (y - lineY1) * (lineX2 - lineX1) / (lineY2 - lineY1);
            lineY1 = y;
        }
        return true;
    }
}

