/*
 * Decompiled with CFR 0.152.
 */
package Game.ExtraClass;

import Game.ExtraClass.InitMapData;
import Game.ExtraClass.MapData;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.microedition.rms.RecordStore;
import javax.microedition.rms.RecordStoreException;

public class DataProvider {
    RecordStore rs_kingdom;
    RecordStore rs_area;
    Hashtable kingdom = new Hashtable();
    Hashtable area = new Hashtable();
    public static String kingdomData = "smartBallKingdom";
    public static String areaData = "smartBallArea";
    boolean isExist;

    public DataProvider() {
        try {
            this.rs_kingdom = RecordStore.openRecordStore((String)kingdomData, (boolean)true);
            this.rs_area = RecordStore.openRecordStore((String)areaData, (boolean)true);
            this.isExist = this.rs_kingdom.getNumRecords() != 0;
        }
        catch (RecordStoreException ex) {
            ex.printStackTrace();
        }
    }

    public boolean isfirstTime() {
        return !this.isExist;
    }

    public Hashtable getKingdom() {
        return this.kingdom;
    }

    public Hashtable getArea() {
        return this.area;
    }

    public void writeKingdom() {
        Enumeration element = this.kingdom.elements();
        while (element.hasMoreElements()) {
            KingdomRecord record = (KingdomRecord)element.nextElement();
            this.writeData(this.rs_kingdom, record.getData());
        }
    }

    public void writeArea() {
        Enumeration element = this.area.elements();
        while (element.hasMoreElements()) {
            AreaRecord record = (AreaRecord)element.nextElement();
            this.writeData(this.rs_area, record.getData());
        }
    }

    public void deleteAll() {
        try {
            this.rs_area.closeRecordStore();
            this.rs_kingdom.closeRecordStore();
            RecordStore.deleteRecordStore((String)areaData);
            RecordStore.deleteRecordStore((String)kingdomData);
            this.rs_area = RecordStore.openRecordStore((String)areaData, (boolean)true);
            this.rs_kingdom = RecordStore.openRecordStore((String)kingdomData, (boolean)true);
        }
        catch (RecordStoreException ex) {
            ex.printStackTrace();
        }
    }

    public void setAreaInfor(int id, int state, int score) {
        Enumeration element = this.area.elements();
        while (element.hasMoreElements()) {
            AreaRecord record = (AreaRecord)element.nextElement();
            int recordId = Integer.parseInt(record.id);
            if (recordId != id) continue;
            record.score = score;
            record.state = state;
            this.writeAreabyId(id, state, score);
            break;
        }
    }

    public void writeAreabyId(int id, int state, int score) {
        try {
            for (int i = 1; i <= this.rs_area.getNumRecords(); ++i) {
                int length;
                byte[] data = new byte[this.rs_area.getRecordSize(i)];
                String str = new String(data, 0, length = this.rs_area.getRecord(i, data, 0));
                AreaRecord area = new AreaRecord(str);
                int recordID = Integer.parseInt(area.getID());
                if (recordID != id) continue;
                String value = id + " " + state + " " + score;
                this.rs_area.setRecord(i, value.getBytes(), 0, value.length());
                break;
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void writeAll() {
        this.writeArea();
        this.writeKingdom();
    }

    public void reNew(MapData mapData) {
        if (mapData.getId() >= 100) {
            String str = mapData.getId() + " " + mapData.getState() + " 0";
            AreaRecord areaRecord = new AreaRecord(str);
            this.area.put(areaRecord.getID(), areaRecord);
            this.writeData(this.rs_area, str);
        } else {
            String str = mapData.getId() + " " + mapData.getState();
            KingdomRecord kingdomRecord = new KingdomRecord(str);
            this.kingdom.put(kingdomRecord.getID(), kingdomRecord);
            this.writeData(this.rs_kingdom, str);
            for (int i = 0; i < mapData.child.length; ++i) {
                this.reNew(mapData.child[i]);
            }
        }
    }

    public void init() {
        try {
            String str;
            int length;
            byte[] data;
            int i;
            int numberofRecord = this.rs_area.getNumRecords();
            for (i = 1; i <= numberofRecord; ++i) {
                data = new byte[this.rs_area.getRecordSize(i)];
                length = this.rs_area.getRecord(i, data, 0);
                str = new String(data, 0, length);
                AreaRecord areaRecord = new AreaRecord(str);
                this.area.put(areaRecord.getID(), areaRecord);
                if (InitMapData.FindData(Integer.parseInt(areaRecord.getID())).getState() != 0) continue;
                InitMapData.FindData(Integer.parseInt(areaRecord.getID())).setState(areaRecord.getState());
            }
            numberofRecord = this.rs_kingdom.getNumRecords();
            for (i = 1; i <= numberofRecord; ++i) {
                data = new byte[this.rs_kingdom.getRecordSize(i)];
                length = this.rs_kingdom.getRecord(i, data, 0);
                str = new String(data, 0, length);
                KingdomRecord kingdomRecord = new KingdomRecord(str);
                this.kingdom.put(kingdomRecord.getID(), kingdomRecord);
                if (InitMapData.FindData(Integer.parseInt(kingdomRecord.getID())).getState() != 0) continue;
                InitMapData.FindData(Integer.parseInt(kingdomRecord.getID())).setState(kingdomRecord.getState());
            }
        }
        catch (RecordStoreException ex) {
            ex.printStackTrace();
        }
    }

    private void writeData(RecordStore rs, String str) {
        byte[] rec = str.getBytes();
        try {
            rs.addRecord(rec, 0, rec.length);
        }
        catch (Exception e) {
            // empty catch block
        }
    }

    public class KingdomRecord {
        String id;
        int state;

        public KingdomRecord(String str) {
            int firstSpace = str.indexOf(32);
            this.id = str.substring(0, firstSpace);
            this.state = Integer.parseInt(str.substring(firstSpace + 1));
        }

        public String getID() {
            return this.id;
        }

        public String getData() {
            return this.id + " " + this.state;
        }

        public int getState() {
            return this.state;
        }
    }

    public class AreaRecord {
        String id;
        int state;
        int score;

        public AreaRecord(String str) {
            int firstSpace = str.indexOf(32);
            int lastSpace = str.lastIndexOf(32);
            this.id = str.substring(0, firstSpace);
            this.state = Integer.parseInt(str.substring(firstSpace + 1, lastSpace));
            this.score = Integer.parseInt(str.substring(lastSpace + 1));
        }

        public String getID() {
            return this.id;
        }

        public String getData() {
            return this.id + " " + this.state + " " + this.score;
        }

        public int getState() {
            return this.state;
        }

        public int getScore() {
            return this.score;
        }
    }
}

