/*
 * Decompiled with CFR 0.152.
 */
package Game.ExtraClass;

import Game.ExtraClass.AreaData;
import Game.ExtraClass.DynamicItem;
import Game.ExtraClass.GenericXmlParser;
import Game.ExtraClass.Point;
import Game.ExtraClass.XmlNode;
import Game.ExtraClass.globalVariable;
import Game.Item.Item;
import Game.Item.StaticItem;
import Game.Screen.GameManager;
import Game.Screen.ObjectLayer;
import Game.Screen.ScreenLayer;
import Game.Screen.TaskBarLayer;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import javax.microedition.lcdui.Image;
import org.kxml2.io.KXmlParser;
import org.xmlpull.v1.XmlPullParserException;

public class InitAreaData {
    public static AreaData getAreaData(GameManager manager) {
        AreaData areaData = InitAreaData.getAreaDatabyID(manager.getID());
        try {
            int i;
            Image image = Image.createImage((String)areaData.getImagePath());
            manager.setImageBackground(image);
            int screenWidth = image.getWidth();
            int screenHeight = image.getHeight();
            int widthBlock = (int)Math.floor(1.0 * (double)screenWidth / (double)GameManager.sizeBlock);
            int heightBlock = (int)Math.floor(1.0 * (double)screenHeight / (double)GameManager.sizeBlock);
            int[][] mapBlock = new int[widthBlock][];
            for (i = 0; i < widthBlock; ++i) {
                mapBlock[i] = new int[heightBlock];
            }
            for (i = 0; i < widthBlock; ++i) {
                for (int j = 0; j < heightBlock; ++j) {
                    mapBlock[i][j] = -1;
                }
            }
            manager.setMapBlock(mapBlock);
            manager.getLayers()[0] = new ScreenLayer(manager, screenWidth, screenHeight);
            ((ScreenLayer)manager.getLayers()[0]).setItems(areaData.getStaticObject());
            ((ScreenLayer)manager.getLayers()[0]).setHideObject(areaData.getNoShapeObject());
            manager.getLayers()[1] = new ObjectLayer(manager, screenWidth, screenHeight);
            manager.getLayers()[2] = new TaskBarLayer(manager, Image.createImage((String)"/Resource/Screen_Icon/taskbar.png"), areaData.getDynamic_Object());
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        System.gc();
        return areaData;
    }

    private static AreaData getAreaDatabyID(int id) {
        AreaData area = new AreaData();
        try {
            InputStream in = ((Object)((Object)globalVariable.midlet)).getClass().getResourceAsStream("/Resource/Data/area" + id + ".xml");
            InputStreamReader is = new InputStreamReader(in);
            KXmlParser parser = new KXmlParser();
            parser.setInput(is);
            GenericXmlParser gParser = new GenericXmlParser();
            XmlNode root = null;
            try {
                root = gParser.parseXML(parser, true);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            area.setId(Integer.parseInt(root.getAttribute("id")));
            area.setNumberofPlayer(Integer.parseInt(root.getAttribute("numberofPlay")));
            area.setTime(Long.parseLong(root.getAttribute("time")));
            XmlNode sizeTag = (XmlNode)root.children.elementAt(0);
            area.setWidth(Integer.parseInt(sizeTag.getAttribute("width")));
            area.setHeight(Integer.parseInt(sizeTag.getAttribute("height")));
            XmlNode ballTag = (XmlNode)root.children.elementAt(1);
            area.setBallSize(Integer.parseInt(ballTag.getAttribute("size")));
            area.setBallType(Integer.parseInt(ballTag.getAttribute("type")));
            int x = Integer.parseInt(ballTag.getAttribute("posX"));
            int y = Integer.parseInt(ballTag.getAttribute("posY"));
            area.setPosistionStart(new Point(x, y));
            XmlNode static_object = (XmlNode)root.children.elementAt(2);
            int length = static_object.children.size();
            Item[] staticItem = new Item[length];
            for (int i = 0; i < length; ++i) {
                XmlNode child = (XmlNode)static_object.children.elementAt(i);
                int childid = Integer.parseInt(child.getAttribute("id"));
                int childtype = Integer.parseInt(child.getAttribute("type"));
                int childdonay = Integer.parseInt(child.getAttribute("doNay"));
                int rotate = Integer.parseInt(child.getAttribute("rotation"));
                int childx = Integer.parseInt(child.getAttribute("x"));
                int childy = Integer.parseInt(child.getAttribute("y"));
                staticItem[i] = globalVariable.generationItembyID(childid, childtype, childx, childy);
                if (rotate == 90) {
                    staticItem[i].setRotate(5);
                }
                staticItem[i].UpdateState();
            }
            area.setStaticObject(staticItem);
            XmlNode dynamic_object = (XmlNode)root.children.elementAt(3);
            length = dynamic_object.children.size();
            DynamicItem[] objects = new DynamicItem[length];
            for (int i = 0; i < length; ++i) {
                XmlNode child = (XmlNode)dynamic_object.children.elementAt(i);
                int child_id = Integer.parseInt(child.getAttribute("id"));
                int child_total = Integer.parseInt(child.getAttribute("total"));
                objects[i] = new DynamicItem(child_id, child_total);
            }
            area.setDynamicObject(objects);
            XmlNode noShape = (XmlNode)root.children.elementAt(4);
            length = noShape.children.size();
            StaticItem[] no_shape = new StaticItem[length];
            for (int i = 0; i < length; ++i) {
                XmlNode noShapeChildTag = (XmlNode)noShape.children.elementAt(i);
                int childlength = noShapeChildTag.children.size();
                int type = Integer.parseInt(noShapeChildTag.getAttribute("type"));
                int donay = Integer.parseInt(noShapeChildTag.getAttribute("doNay"));
                Point[] pVertex = new Point[childlength];
                for (int j = 0; j < childlength; ++j) {
                    XmlNode noShapeChildPoint = (XmlNode)noShapeChildTag.children.elementAt(j);
                    int childx = Integer.parseInt(noShapeChildPoint.getAttribute("x"));
                    int childy = Integer.parseInt(noShapeChildPoint.getAttribute("y"));
                    pVertex[j] = new Point(childx, childy);
                }
                no_shape[i] = type == 0 ? new StaticItem(98, donay, pVertex, false) : new StaticItem(98, donay, pVertex, true);
            }
            area.setNoShapeObject(no_shape);
            XmlNode backgroundTag = (XmlNode)root.children.elementAt(5);
            String imagePath = backgroundTag.getAttribute("path").toString();
            area.setImagePath(imagePath);
            XmlNode scoreTag = (XmlNode)root.children.elementAt(6);
            int start = Integer.parseInt(scoreTag.getAttribute("start"));
            int lv1 = Integer.parseInt(scoreTag.getAttribute("lv1"));
            int lv2 = Integer.parseInt(scoreTag.getAttribute("lv2"));
            area.setScore(start);
            area.setLv1(lv1);
            area.setlv2(lv2);
            is.close();
            in.close();
            sizeTag = null;
            backgroundTag = null;
            dynamic_object = null;
            ballTag = null;
            noShape = null;
            sizeTag = null;
            parser = null;
            root = null;
            System.gc();
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        catch (XmlPullParserException ex) {
            ex.printStackTrace();
        }
        return area;
    }
}

