/*
 * Decompiled with CFR 0.152.
 */
package Game.Screen;

import Game.ExtraClass.AreaData;
import Game.ExtraClass.GameButton;
import Game.ExtraClass.InitAreaData;
import Game.ExtraClass.Point;
import Game.ExtraClass.SoundPlayer;
import Game.ExtraClass.globalVariable;
import Game.Screen.AbstractLayer;
import Game.Screen.Ball;
import Game.Screen.GameScreen;
import Game.Screen.Map;
import Game.Screen.MessageFail;
import Game.Screen.MessagePause;
import Game.Screen.MessageScreen;
import Game.Screen.MessageWinner;
import Game.Screen.ObjectLayer;
import Game.Screen.Score;
import Game.Screen.ScreenLayer;
import Game.Screen.TaskBarLayer;
import java.io.IOException;
import java.util.Vector;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import javax.microedition.lcdui.game.Layer;
import javax.microedition.lcdui.game.LayerManager;

public class GameManager {
    int id;
    private int screenWidth;
    private int screenHeight;
    private Point pDragged;
    private Point pPressed;
    private Point pReleased;
    private AbstractLayer[] layers;
    private int itemClicked;
    private GameButton[] gameButtons;
    private Image background;
    private Point pBackground;
    long timeOld;
    int[][] mapBlock;
    int widthBlock;
    int heightBlock;
    public static int sizeBlock = 16;
    int startGame = 0;
    int totalPlay;
    long coutertime = 0L;
    private Ball ball = null;
    Map map;
    private AreaData gameData;
    private Score score;
    private Score time;
    private GameScreen parentScreen;
    private LayerManager layerInformation;
    MessageScreen message;
    MessagePause messagePause;

    public GameManager(int id, GameScreen parent, long framePerSec) {
        this.id = id;
        this.parentScreen = parent;
        this.layers = new AbstractLayer[3];
        this.pBackground = new Point();
        this.pPressed = new Point();
        this.pReleased = new Point();
        this.pDragged = new Point();
        this.score = new Score();
        this.time = new Score(globalVariable.Width, 50);
        this.coutertime = 0L;
        this.itemClicked = -1;
        this.Init();
        this.totalPlay = this.gameData.getNumberofPlay();
        this.screenWidth = this.background.getWidth();
        this.screenHeight = this.background.getHeight();
        this.widthBlock = this.screenWidth / sizeBlock;
        this.heightBlock = this.screenHeight / sizeBlock;
        this.map = new Map(this.screenWidth, this.screenHeight);
        this.gameButtons = new GameButton[3];
        this.gameButtons[0] = new GameButton(globalVariable.iStart, globalVariable.iStart.getWidth(), globalVariable.iStart.getHeight() / 2, "Start", 2);
        this.gameButtons[0].setPosition(20 + globalVariable.iBack1.getWidth(), 10);
        this.gameButtons[1] = new GameButton(globalVariable.iRetry, globalVariable.iRetry.getWidth() / 3, globalVariable.iRetry.getHeight(), "Retry", 3);
        this.gameButtons[1].setPosition(20 + globalVariable.iBack1.getWidth(), 10);
        this.gameButtons[1].setShow(false);
        this.gameButtons[2] = new GameButton(globalVariable.iBack1, globalVariable.iBack1.getWidth(), globalVariable.iBack1.getHeight() / 2, "Pause", 2);
        this.gameButtons[2].setPosition(10, 10);
        for (int i = 0; i < 3; ++i) {
            this.gameButtons[i].addButtonListener(parent);
        }
        this.layerInformation = new LayerManager();
        this.layerInformation.append((Layer)this.gameButtons[0]);
        this.layerInformation.append((Layer)this.gameButtons[2]);
        try {
            this.ball = new Ball(this.screenWidth, this.screenHeight, framePerSec, this.map, this.gameData.getPositionStart(), this.pBackground);
            this.layers[1].append((Layer)this.ball);
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        this.messagePause = new MessagePause(parent);
    }

    public void Init() {
        this.gameData = InitAreaData.getAreaData(this);
    }

    public void restore() {
        int i;
        this.setSetPosistionBall(this.gameData.getPositionStart());
        for (i = 0; i < this.layers.length; ++i) {
            this.layers[i].clear();
        }
        for (i = 0; i < this.mapBlock.length; ++i) {
            for (int j = 0; j < this.mapBlock[i].length; ++j) {
                this.mapBlock[i][j] = -1;
            }
        }
        this.map.resetMap();
    }

    public void clear() {
        for (int i = 0; i < this.layers.length; ++i) {
            this.layers[i] = null;
        }
        this.layers = null;
        this.gameButtons = null;
        this.mapBlock = null;
        this.ball = null;
        this.map = null;
        this.gameData = null;
        this.score = null;
        this.time = null;
        this.message = null;
    }

    public AreaData getGameData() {
        return this.gameData;
    }

    public int getStartGame() {
        return this.startGame;
    }

    public void setSetPosistionBall(Point p) {
        if (this.ball != null) {
            this.ball.setRefPixelPosition(p.x, p.y);
        }
        this.gameData.setPosistionStart(p);
    }

    public int[][] getMapBlock() {
        return this.mapBlock;
    }

    public void setScore(int score) {
        this.gameData.setScore(score);
    }

    public int getScore() {
        return this.gameData.getScore();
    }

    public void setMapBlock(int[][] mapBlock) {
        this.mapBlock = mapBlock;
    }

    public void clearMapBlock() {
        for (int i = 0; i < this.widthBlock; ++i) {
            for (int j = 0; j < this.heightBlock; ++j) {
                this.mapBlock[i][j] = -1;
            }
        }
    }

    public Image getBackground() {
        return this.background;
    }

    public Point getPointBackground() {
        return this.pBackground;
    }

    public void setItemClick(int item) {
        this.itemClicked = item;
    }

    public int getItemClick() {
        return this.itemClicked;
    }

    public AbstractLayer getLayer(int index) {
        return this.layers[index];
    }

    public AbstractLayer[] getLayers() {
        return this.layers;
    }

    public Point getPointerPressed() {
        return this.pPressed;
    }

    public Point getPointerDragged() {
        return this.pDragged;
    }

    public Point getPointerReleased() {
        return this.pReleased;
    }

    public Vector getItems() {
        return ((ObjectLayer)this.layers[1]).getItem();
    }

    public int getID() {
        return this.id;
    }

    public void setImageBackground(Image image) {
        this.background = image;
    }

    public void pointerPressed(int x, int y) {
        if (this.message == null || !this.message.isActive) {
            int i;
            this.itemClicked = -1;
            for (i = 0; i < this.layers.length; ++i) {
                this.layers[i].pointerPressed(x, y);
            }
            for (i = 0; i < this.gameButtons.length; ++i) {
                this.gameButtons[i].pointerPressed(x, y);
            }
            this.pPressed.x = x;
            this.pPressed.y = y;
            this.pDragged.x = x;
            this.pDragged.y = y;
        } else {
            this.message.pointerPressed(x, y);
        }
    }

    public void pointerDragged(int x, int y) {
        if (this.message == null || !this.message.isActive) {
            int i;
            for (i = 0; i < this.layers.length && !this.layers[i].pointerDragged(x, y); ++i) {
            }
            if (i == this.layers.length) {
                this.pBackground.x += x - this.pDragged.x;
                this.pBackground.y += y - this.pDragged.y;
                if (this.pBackground.x > 0) {
                    this.pBackground.x = 0;
                }
                if (this.pBackground.x + this.background.getWidth() < globalVariable.Width) {
                    this.pBackground.x -= x - this.pDragged.x;
                }
                if (this.pBackground.y > 0) {
                    this.pBackground.y = 0;
                }
                if (this.pBackground.y + this.background.getHeight() < globalVariable.Height) {
                    this.pBackground.y -= y - this.pDragged.y;
                }
                for (int l = 0; l < this.layers.length; ++l) {
                    this.layers[l].setPositionBackground(this.pBackground);
                }
            }
            this.pDragged.x = x;
            this.pDragged.y = y;
            for (i = 0; i < this.gameButtons.length; ++i) {
                this.gameButtons[i].pointerDragged(x, y);
            }
        } else {
            this.message.pointerDragged(x, y);
        }
    }

    public void pointerReleased(int x, int y) {
        if (this.message == null || !this.message.isActive) {
            int i;
            this.pReleased.x = x;
            this.pReleased.y = y;
            for (i = 0; i < this.gameButtons.length; ++i) {
                this.gameButtons[i].pointerReleased(x, y);
            }
            for (i = this.layers.length - 1; i >= 0 && !this.layers[i].pointerReleased(x, y); --i) {
            }
            this.itemClicked = -1;
        } else {
            this.message.pointerReleased(x, y);
        }
    }

    void buttonClick(String btName) {
        if (btName.compareTo("Start") == 0) {
            if (this.startGame == 0) {
                for (int i = 0; i < this.layers.length; ++i) {
                    this.layers[i].DrawtoMap(this.map.getMapData());
                }
                this.ball.setPause(false);
                this.layers[1].append((Layer)this.ball);
                this.startGame = 1;
                this.layerInformation.remove((Layer)this.gameButtons[0]);
                this.layerInformation.append((Layer)this.gameButtons[1]);
                this.gameButtons[0].setShow(false);
                this.gameButtons[1].setShow(true);
                this.coutertime = 0L;
                System.gc();
                this.timeOld = System.currentTimeMillis();
            }
        } else if (btName.compareTo("Retry") == 0) {
            if (this.totalPlay > 1 && this.startGame == 1) {
                --this.totalPlay;
                if (this.totalPlay == 1) {
                    this.gameButtons[1].setActive(false);
                }
                this.layerInformation.remove((Layer)this.gameButtons[1]);
                this.layerInformation.append((Layer)this.gameButtons[0]);
                this.gameButtons[0].setShow(true);
                this.gameButtons[1].setShow(false);
                this.startGame = 0;
                this.ball.ReInit(this.gameData.getPositionStart());
                this.restore();
                System.gc();
            }
        } else if (btName.compareTo("Pause") == 0) {
            this.messagePause.restore();
            this.message = this.messagePause;
        }
    }

    public void advance(long timeNow) {
        int i;
        if (this.message != null && this.message.isActive) {
            this.message.advance(timeNow);
            if (this.message instanceof MessagePause) {
                this.timeOld = timeNow;
                return;
            }
        }
        if (this.startGame == 1) {
            this.coutertime += timeNow - this.timeOld;
            this.timeOld = timeNow;
        }
        if (this.startGame == 1 && this.coutertime >= this.gameData.getTime()) {
            if (this.totalPlay > 1) {
                --this.totalPlay;
                if (this.totalPlay == 1) {
                    this.gameButtons[1].setActive(false);
                }
                this.layerInformation.remove((Layer)this.gameButtons[1]);
                this.layerInformation.append((Layer)this.gameButtons[0]);
                this.gameButtons[0].setShow(true);
                this.gameButtons[1].setShow(false);
                this.startGame = 0;
                this.ball.ReInit(this.gameData.getPositionStart());
                this.restore();
            } else if (!(this.startGame != 1 || this.message != null && this.message.isActive)) {
                this.message = new MessageFail(this.parentScreen, this.id);
                SoundPlayer.playSong(5, 1);
                this.startGame = 0;
                return;
            }
        }
        for (i = 0; i < this.layers.length; ++i) {
            this.layers[i].Update(timeNow);
        }
        if (this.ball != null) {
            this.ball.advance(timeNow);
            if (this.ball.isMeetTarget() && this.startGame == 1 && (this.message == null || !this.message.isActive)) {
                for (i = 0; i < this.layers.length; ++i) {
                    if (!(this.layers[i] instanceof ScreenLayer)) continue;
                    ((ScreenLayer)this.layers[i]).removeTargetObject();
                }
                this.startGame = 2;
                this.message = new MessageWinner(this.parentScreen, this.id);
                SoundPlayer.playSong(7, 1);
                return;
            }
        }
    }

    public void paint(Graphics g) {
        int second;
        for (int i = 0; i < this.layers.length; ++i) {
            if (this.startGame == 0) {
                this.layers[i].paint(g, this.layers[i].getXScreen(), this.layers[i].getYScreen());
                continue;
            }
            if (this.layers[i] instanceof TaskBarLayer) continue;
            this.layers[i].paint(g, this.layers[i].getXScreen(), this.layers[i].getYScreen());
        }
        this.score.setScore(this.getScore(), g);
        this.layerInformation.paint(g, 0, 0);
        if (this.startGame == 1 && this.time != null && (second = (int)(this.gameData.getTime() - this.coutertime) / 1000) >= 0) {
            this.time.setScore(second, g);
        }
        if (this.message != null && this.message.isActive) {
            this.message.drawScreen(g);
        }
    }
}

