/*
 * Decompiled with CFR 0.152.
 */
package Game.Screen;

import Game.ExtraClass.ButtonListenner;
import Game.ExtraClass.GameButton;
import Game.ExtraClass.SoundPlayer;
import Game.ExtraClass.globalVariable;
import Game.Screen.AboutScreen;
import Game.Screen.AbstractScreen;
import Game.Screen.HelpScreen;
import Game.Screen.MapWorldScreen;
import Game.Screen.OptionScreen;
import java.io.IOException;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import javax.microedition.lcdui.game.Layer;
import javax.microedition.lcdui.game.LayerManager;
import javax.microedition.lcdui.game.Sprite;

public class MainMenuScreen
extends AbstractScreen
implements ButtonListenner {
    private GameButton[] menuButton;
    private int itemClicked;
    private LayerManager layer;
    private Sprite background;

    public void init() {
        try {
            int i;
            int width = globalVariable.Width;
            int height = globalVariable.Height;
            this.itemClicked = -1;
            this.iBackground = Image.createImage((String)"/Resource/Screen_Icon/MainMenuScreen.png");
            this.background = new Sprite(this.iBackground);
            this.menuButton = new GameButton[5];
            Image image = Image.createImage((String)"/Resource/Screen_Icon/Start.png");
            this.menuButton[0] = new GameButton(image, image.getWidth(), image.getHeight() / 2, "btStart", 2);
            image = Image.createImage((String)"/Resource/Screen_Icon/Option.png");
            this.menuButton[1] = new GameButton(image, image.getWidth(), image.getHeight() / 2, "btOption", 2);
            image = Image.createImage((String)"/Resource/Screen_Icon/Help.png");
            this.menuButton[2] = new GameButton(image, image.getWidth(), image.getHeight() / 2, "btHelp", 2);
            image = Image.createImage((String)"/Resource/Screen_Icon/About.png");
            this.menuButton[3] = new GameButton(image, image.getWidth(), image.getHeight() / 2, "btAbout", 2);
            image = Image.createImage((String)"/Resource/Screen_Icon/Quit.png");
            this.menuButton[4] = new GameButton(image, image.getWidth(), image.getHeight() / 2, "btQuit", 2);
            for (i = 0; i < this.menuButton.length; ++i) {
                this.menuButton[i].setRefPixelPosition(width / 2 - this.menuButton[i].getWidth() / 2, (3 + i) * height / 8 - this.menuButton[i].getHeight() / 2);
                this.menuButton[i].addButtonListener(this);
            }
            this.layer = new LayerManager();
            for (i = 0; i < this.menuButton.length; ++i) {
                this.layer.append((Layer)this.menuButton[i]);
            }
            this.layer.append((Layer)this.background);
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    public void start(boolean isInit) {
        if (isInit) {
            this.init();
        }
        this.itemClicked = -1;
        this.isLoading = false;
    }

    public void stop(boolean isDestroy) {
        this.itemClicked = -1;
        this.isLoading = false;
        if (isDestroy) {
            this.menuButton = null;
            this.iBackground = null;
            this.background = null;
            this.layer = null;
            System.gc();
        }
    }

    public void run(Graphics g, long time) {
        this.advance(time);
        if (!this.isLoading) {
            this.drawScreen(g);
        } else if (this.itemClicked != -1) {
            this.drawScreen(g);
        }
    }

    public void advance(long time) {
    }

    protected void pointerPressed(int x, int y) {
        for (int i = 0; i < this.menuButton.length; ++i) {
            this.menuButton[i].pointerPressed(x, y);
        }
    }

    protected void pointerDragged(int x, int y) {
        for (int i = 0; i < this.menuButton.length; ++i) {
            this.menuButton[i].pointerPressed(x, y);
        }
    }

    protected void pointerReleased(int x, int y) {
        for (int i = 0; i < this.menuButton.length; ++i) {
            this.menuButton[i].pointerReleased(x, y);
        }
    }

    private void drawScreen(Graphics g) {
        this.layer.paint(g, 0, 0);
    }

    public void buttonClick(String btName) {
        if (btName.compareTo("btStart") == 0) {
            for (int i = 0; i < globalVariable.screenManager.getScreens().size(); ++i) {
                if (!(globalVariable.screenManager.getScreens().elementAt(i) instanceof MapWorldScreen)) continue;
                MapWorldScreen mapWorldScreen = (MapWorldScreen)globalVariable.screenManager.getScreens().elementAt(i);
                mapWorldScreen.start(false);
                globalVariable.screenManager.setIndex(i);
                if (SoundPlayer.getPlayer()[0].getState() != 400) {
                    SoundPlayer.playSong(0, -1);
                }
                return;
            }
        } else if (btName.compareTo("btOption") == 0) {
            for (int i = 0; i < globalVariable.screenManager.getScreens().size(); ++i) {
                if (!(globalVariable.screenManager.getScreens().elementAt(i) instanceof OptionScreen)) continue;
                OptionScreen mainScreen = (OptionScreen)globalVariable.screenManager.getScreens().elementAt(i);
                globalVariable.screenManager.setIndex(i);
                return;
            }
        } else if (btName.compareTo("btHelp") == 0) {
            for (int i = 0; i < globalVariable.screenManager.getScreens().size(); ++i) {
                if (!(globalVariable.screenManager.getScreens().elementAt(i) instanceof HelpScreen)) continue;
                HelpScreen mainScreen = (HelpScreen)globalVariable.screenManager.getScreens().elementAt(i);
                mainScreen.Show();
                globalVariable.screenManager.setIndex(i);
                return;
            }
        } else if (btName.compareTo("btAbout") == 0) {
            AboutScreen aboutScreen = new AboutScreen();
            globalVariable.screenManager.getScreens().addElement(aboutScreen);
            globalVariable.screenManager.setIndex(globalVariable.screenManager.getScreens().size() - 1);
        } else if (btName.compareTo("btQuit") == 0) {
            globalVariable.midlet.destroyApp(true);
        }
    }
}

