/*
 * Decompiled with CFR 0.152.
 */
package Game.Screen;

import Game.ExtraClass.ButtonListenner;
import Game.ExtraClass.GameButton;
import Game.ExtraClass.InitMapData;
import Game.ExtraClass.MapData;
import Game.ExtraClass.Point;
import Game.ExtraClass.SoundPlayer;
import Game.ExtraClass.globalVariable;
import Game.Screen.AbstractScreen;
import Game.Screen.LocationSprite;
import Game.Screen.MapWorldScreen;
import java.io.IOException;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import javax.microedition.lcdui.game.Layer;
import javax.microedition.lcdui.game.LayerManager;
import javax.microedition.lcdui.game.Sprite;

public class MapAreaScreen
extends AbstractScreen
implements ButtonListenner {
    int id;
    MapData mapData;
    GameButton btBack;
    Point pImage = new Point();
    Point pDragged;
    Point pPressed = new Point();
    Point pReleased;
    LocationSprite[] areaSprite;
    LayerManager manager;
    int areaClick;
    int areaTotal;
    Sprite spriteLoading;

    public MapAreaScreen(int type) {
        this.pDragged = new Point();
        this.pReleased = new Point();
        this.id = type;
        this.mapData = InitMapData.FindData(type);
        this.areaTotal = this.mapData.getChild() == null ? 0 : this.mapData.getChild().length;
        try {
            this.iBackground = Image.createImage((String)this.mapData.getImagePath());
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        this.manager = new LayerManager();
        this.btBack = new GameButton(globalVariable.iBack, globalVariable.iBack.getWidth(), globalVariable.iBack.getHeight() / 2, "btBack", 2);
        this.btBack.addButtonListener(this);
        this.btBack.setRefPixelPosition(20, globalVariable.Height - this.btBack.getHeight() - 20);
        this.manager.insert((Layer)this.btBack, 0);
    }

    public void init() {
        this.areaSprite = new LocationSprite[this.areaTotal];
        for (int i = 0; i < this.areaTotal; ++i) {
            MapData node = this.mapData.getChild()[i];
            Image image = globalVariable.iStar[node.getState()];
            this.areaSprite[i] = new LocationSprite(this, node, image, image.getHeight(), image.getHeight());
        }
    }

    public void start(boolean isInit) {
        if (isInit) {
            this.init();
        }
        for (int i = 0; i < this.areaSprite.length; ++i) {
            if (this.areaSprite[i].getState() == 0) continue;
            Image image = globalVariable.iStar[this.areaSprite[i].getState()];
            this.areaSprite[i].setImage(image, image.getHeight(), image.getHeight());
            this.manager.insert((Layer)this.areaSprite[i], 0);
        }
        this.areaClick = -1;
        this.spriteLoading = null;
    }

    public void stop(boolean isDestroy) {
        this.areaClick = -1;
        for (int i = 0; i < this.areaSprite.length; ++i) {
            this.manager.remove((Layer)this.areaSprite[i]);
        }
        if (this.spriteLoading != null) {
            this.manager.remove((Layer)this.spriteLoading);
            this.spriteLoading = null;
        }
    }

    public void run(Graphics g, long time) {
        this.advance(time);
        if (this.spriteLoading == null) {
            this.drawScreen(g);
            if (this.areaClick != -1) {
                this.areaSprite[this.areaClick].transfer();
                Image imageLoading = null;
                try {
                    imageLoading = Image.createImage((String)"/Resource/Screen_Icon/loading.png");
                }
                catch (IOException ex) {
                    ex.printStackTrace();
                }
                this.spriteLoading = new Sprite(imageLoading, imageLoading.getWidth(), imageLoading.getHeight() / 4);
                this.spriteLoading.setRefPixelPosition(10, globalVariable.Height - imageLoading.getHeight() / 4 - 10);
                this.manager.insert((Layer)this.spriteLoading, 0);
            }
        } else if (this.areaClick != -1) {
            this.drawScreen(g);
            if (this.spriteLoading != null) {
                this.spriteLoading.nextFrame();
            }
        }
    }

    protected void pointerPressed(int x, int y) {
        if (this.areaClick != -1) {
            return;
        }
        this.pPressed.x = x;
        this.pPressed.y = y;
        this.pDragged = this.pPressed;
        if (this.areaSprite != null) {
            for (int i = 0; i < this.areaSprite.length; ++i) {
                if (!this.areaSprite[i].check(x, y)) continue;
                this.areaClick = i;
                break;
            }
        }
        this.btBack.pointerPressed(x, y);
    }

    protected void pointerDragged(int x, int y) {
        if (this.areaClick != -1) {
            return;
        }
        this.pImage.x += x - this.pDragged.x;
        this.pImage.y += y - this.pDragged.y;
        if (this.pImage.x <= globalVariable.Width - this.iBackground.getWidth()) {
            this.pImage.x -= x - this.pDragged.x;
        }
        if (this.pImage.x >= 0) {
            this.pImage.x = 0;
        }
        if (this.pImage.y <= globalVariable.Height - this.iBackground.getHeight()) {
            this.pImage.y -= y - this.pDragged.y;
        }
        if (this.pImage.y >= 0) {
            this.pImage.y = 0;
        }
        this.pDragged.x = x;
        this.pDragged.y = y;
        for (int i = 0; i < this.areaSprite.length; ++i) {
            this.areaSprite[i].SetBackgroundPosition(this.pImage);
        }
        this.btBack.pointerDragged(x, y);
    }

    protected void pointerReleased(int x, int y) {
        if (this.areaClick != -1) {
            return;
        }
        this.pReleased.x = x;
        this.pReleased.y = y;
        this.btBack.pointerReleased(x, y);
    }

    public void advance(long time) {
        for (int i = 0; i < this.areaSprite.length; ++i) {
            this.areaSprite[i].update(time);
        }
    }

    private void drawScreen(Graphics g) {
        g.drawImage(this.iBackground, this.pImage.x, this.pImage.y, 20);
        this.manager.paint(g, 0, 0);
    }

    public void buttonClick(String btName) {
        if (btName.compareTo("btBack") == 0) {
            for (int i = 0; i < globalVariable.screenManager.getScreens().size(); ++i) {
                if (!(globalVariable.screenManager.getScreens().elementAt(i) instanceof MapWorldScreen)) continue;
                MapWorldScreen mapWorldScreen = (MapWorldScreen)globalVariable.screenManager.getScreens().elementAt(i);
                mapWorldScreen.start(false);
                globalVariable.screenManager.setIndex(i);
                if (SoundPlayer.getPlayer()[0].getState() != 400) {
                    SoundPlayer.playSong(0, -1);
                }
                return;
            }
        }
    }
}

