/*
 * Decompiled with CFR 0.152.
 */
package elventales.avoider.window.component;

import elventales.avoider.Stage;
import elventales.hsalf.display.DisplayObject;
import java.io.IOException;
import java.util.Vector;
import javax.microedition.lcdui.Image;

public class HeadUpDisplay
extends DisplayObject {
    Vector speedTiles;
    DisplayObject miniHero;
    Image miniHeroImage;
    int speedScale;
    int progressScale;
    int speedOffsetX;
    int speedOffsetY;
    int progressOffsetX;
    int progressOffsetY;

    public void initialize() {
        super.initialize();
        try {
            if (Stage.isLandscape) {
                this.addChild(Image.createImage((String)"/gameplay/hud-landscape.png"));
                this.speedOffsetX = 45;
                this.speedOffsetY = 10;
                this.progressOffsetX = 10;
                this.progressOffsetY = 200;
            } else {
                this.addChild(Image.createImage((String)"/gameplay/hud-portrait.png"));
                this.y = 240;
                this.speedOffsetX = 20;
                this.speedOffsetY = 15;
                this.progressOffsetX = 5;
                this.progressOffsetY = 30;
            }
            this.speedTiles = new Vector();
            for (int i = 0; i < 20; ++i) {
                DisplayObject tile = null;
                tile = Stage.isLandscape ? new DisplayObject(Image.createImage((String)"/gameplay/speed-tile.png"), this.speedOffsetX, -20) : new DisplayObject(Image.createImage((String)"/gameplay/speed-tile.png"), -20, this.speedOffsetY);
                this.addChild(tile);
                this.speedTiles.addElement(tile);
            }
            this.miniHeroImage = Image.createImage((String)"/gameplay/mini-hero.png");
            this.miniHero = new DisplayObject(this.miniHeroImage, this.progressOffsetX, this.progressOffsetY);
            this.addChild(this.miniHero);
        }
        catch (IOException ex) {
            System.out.println("HeadUpDisplay " + ex.getMessage());
        }
    }

    public void update(float progress, float speed) {
        for (int i = 0; i < this.speedTiles.size(); ++i) {
            DisplayObject object = (DisplayObject)this.speedTiles.elementAt(i);
            this.speedScale = (int)(speed * 20.0f);
            if (i <= this.speedScale) {
                if (Stage.isLandscape) {
                    object.y = this.speedOffsetY + 190 - i * 10;
                    continue;
                }
                object.x = this.speedOffsetX + i * 10;
                continue;
            }
            if (Stage.isLandscape) {
                object.y = -20;
                continue;
            }
            object.x = -20;
        }
        if (Stage.isLandscape) {
            this.miniHero.y = this.progressOffsetY - (int)(progress * 200.0f);
        } else {
            this.miniHero.x = this.progressOffsetX + (int)(progress * 200.0f);
        }
    }
}

