/*
 * Decompiled with CFR 0.152.
 */
package elventales.avoider.window.gameplay.unit;

import elventales.avoider.Stage;
import elventales.avoider.window.gameplay.unit.HitBox;
import elventales.hsalf.display.DisplayObject;
import java.io.IOException;
import javax.microedition.lcdui.Image;
import javax.microedition.lcdui.game.Sprite;

public class Hero
extends DisplayObject {
    private Sprite heroSprite;
    private int tick = 0;
    private int xSpeed = 0;
    private int ySpeed = 0;
    private final int acceleration;
    private final int brake;
    private final int maxSpeed;
    private final int minSpeed;
    public boolean isDead = false;
    public HitBox hitbox;

    public Hero() {
        this.acceleration = 4;
        this.brake = 2;
        this.maxSpeed = 10;
        this.minSpeed = -10;
    }

    public void initialize() {
        super.initialize();
        this.hitbox = new HitBox(10, 10, 20, 20);
        this.addChild(this.hitbox);
        this.x = 100;
        this.y = 200;
        Image heroSpriteImage = null;
        try {
            heroSpriteImage = Image.createImage((String)"/gameplay/hero-sprites.png");
        }
        catch (IOException ex) {
            System.out.println("Hero : " + ex.getMessage());
        }
        this.heroSprite = new Sprite(heroSpriteImage, 40, 40);
        int[] heroSequence = new int[]{0, 1, 2, 1};
        this.heroSprite.setFrameSequence(heroSequence);
        this.addChild(this.heroSprite);
    }

    public void moveHero(boolean up, boolean down, boolean left, boolean right) {
        ++this.tick;
        if (this.tick == 3) {
            this.heroSprite.nextFrame();
            this.tick = 0;
        }
        if (up) {
            this.ySpeed -= 4;
        } else if (down) {
            this.ySpeed += 4;
        }
        if (left) {
            this.xSpeed -= 4;
        } else if (right) {
            this.xSpeed += 4;
        }
        if (this.xSpeed < 0) {
            this.xSpeed += 2;
        } else if (this.xSpeed > 0) {
            this.xSpeed -= 2;
        }
        if (this.ySpeed < 0) {
            this.ySpeed += 2;
        } else if (this.ySpeed > 0) {
            this.ySpeed -= 2;
        }
        if (this.xSpeed > 10) {
            this.xSpeed = 10;
        } else if (this.xSpeed < -10) {
            this.xSpeed = -10;
        }
        if (this.ySpeed > 10) {
            this.ySpeed = 10;
        } else if (this.ySpeed < -10) {
            this.ySpeed = -10;
        }
        this.x += this.xSpeed;
        this.y += this.ySpeed;
        if (Stage.isLandscape && this.x < 80) {
            this.x = 80;
        } else if (this.x < 0) {
            this.x = 0;
        }
        if (this.x > Stage.Width - 40) {
            this.x = Stage.Width - 40;
        }
        if (this.y < 0) {
            this.y = 0;
        } else if (this.y > 200) {
            this.y = 200;
        }
    }
}

