/*
 * Decompiled with CFR 0.152.
 */
package elventales.avoider.window.gameplay;

import elventales.avoider.Stage;
import elventales.avoider.util.KeyTranslator;
import elventales.avoider.util.RandomUtil;
import elventales.avoider.window.IRemover;
import elventales.avoider.window.Window;
import elventales.avoider.window.component.ForestBackground;
import elventales.avoider.window.component.GameplayBackground;
import elventales.avoider.window.component.HeadUpDisplay;
import elventales.avoider.window.component.HeroDefeat;
import elventales.avoider.window.gameplay.unit.Baloon;
import elventales.avoider.window.gameplay.unit.BlackZerosen;
import elventales.avoider.window.gameplay.unit.Hero;
import elventales.avoider.window.gameplay.unit.Kirov;
import elventales.avoider.window.gameplay.unit.LeftNyan;
import elventales.avoider.window.gameplay.unit.PowerUp;
import elventales.avoider.window.gameplay.unit.RedZerosen;
import elventales.avoider.window.gameplay.unit.RightNyan;
import elventales.avoider.window.gameplay.unit.Unit;
import elventales.hsalf.display.DisplayObject;
import java.io.IOException;
import java.util.Vector;
import javax.microedition.lcdui.Image;

public class Gameplay
extends Window
implements IRemover {
    public static final int RED_ZEROSEN = 0;
    public static final int BLACK_ZEROSEN = 1;
    public static final int LEFT_NYAN = 2;
    public static final int RIGHT_NYAN = 3;
    public static final int BALOON = 4;
    public static final int KIROV = 5;
    protected Hero hero;
    private boolean up;
    private boolean down;
    private boolean left;
    private boolean right;
    protected int[] enemyType;
    protected Vector enemies = new Vector();
    protected Vector powerups = new Vector();
    protected int enemyDelay;
    protected int enemyStaticDelay;
    protected int enemyVolatileDelay;
    protected int totalDistance;
    protected int elapsedDistance;
    protected float travelSpeed;
    float speedRatio;
    protected int powerupDelay = 40;
    protected int powerupStaticDelay = 30;
    protected int powerupVolatileDelay = 30;
    protected int powerupBlueGemChance = 5;
    protected int powerupBlueGemValue = 10;
    protected int powerupRedGemValue = 3;
    protected static final int maxTravelSpeed = 10;
    protected static final int minTravelSpeed = 3;
    protected HeadUpDisplay hud;
    protected GameplayBackground background;
    private boolean isPaused;
    public boolean isDefeated = false;
    private int defeatCountdown = 40;
    private int winCountdown = 40;
    private HeroDefeat hd;
    public boolean isWin;
    public int winSpeed;
    private DisplayObject pauseWindow;
    public boolean isBackFromPause;
    public int levelNumber;

    public void initialize() {
        if (Stage.isEnableSound) {
            Stage.soundUtil.play(0);
        }
        try {
            this.pauseWindow = new DisplayObject(Image.createImage((String)"/gameplay/pause.png"), -320, -320);
        }
        catch (IOException ex) {
            System.out.println("Gameplay" + ex);
        }
        this.hero = new Hero();
        this.hero.initialize();
        this.right = false;
        this.left = false;
        this.down = false;
        this.up = false;
        this.hud = new HeadUpDisplay();
        this.hud.initialize();
        this.travelSpeed = 0.0f;
        this.isPaused = false;
        this.initBackground();
        this.addChild(this.hero);
        this.addChild(this.hud);
        this.addChild(this.pauseWindow);
    }

    protected void loop() {
        if (this.isDefeated) {
            --this.defeatCountdown;
            if (this.defeatCountdown == 39) {
                this.hd = new HeroDefeat(this.hero.x, this.hero.y);
                this.removeChild(this.hero);
                this.addChild(this.hd);
            } else if (this.defeatCountdown == 0) {
                this.parent.removeDisplay(this);
            }
            this.hd.update();
        } else if (this.isWin) {
            --this.winCountdown;
            if (this.winCountdown == 39) {
                this.winSpeed = (int)Math.ceil((-40.0 - (double)this.hero.y) / 39.0);
                Stage.soundUtil.play(2);
            } else if (this.winCountdown == 0) {
                this.parent.removeDisplay(this);
            }
            this.hero.y += this.winSpeed;
        }
        if (this.isPaused) {
            if (!this.isDefeated) {
                this.pauseWindow.x = Stage.Width / 2 - 160;
                this.pauseWindow.y = Stage.Height - 320;
            }
            return;
        }
        super.loop();
        if (this.isWin) {
            return;
        }
        this.backgroundAndTravelSpeed();
        this.heroMove();
        this.winCheck();
        this.enemyFactory();
        this.loseCheck();
        this.updatePowerups();
        this.pauseWindow.x = -320;
        this.pauseWindow.y = -320;
    }

    protected void keyPressed(int keyCode) {
        super.keyPressed(keyCode);
        if (KeyTranslator.compareKey(keyCode, 2) || keyCode == 52) {
            this.left = true;
        }
        if (KeyTranslator.compareKey(keyCode, 5) || keyCode == 54) {
            this.right = true;
        }
        if (KeyTranslator.compareKey(keyCode, 1) || keyCode == 50) {
            this.up = true;
        }
        if (KeyTranslator.compareKey(keyCode, 6) || keyCode == 56) {
            this.down = true;
        }
        if (keyCode == -6) {
            if (!this.isPaused && !this.isDefeated) {
                this.isPaused = true;
            }
        } else if (this.isPaused && !this.isDefeated && keyCode == -7) {
            this.isPaused = false;
        } else if (this.isPaused && !this.isDefeated && (KeyTranslator.compareKey(keyCode, 8) || keyCode == 53)) {
            Stage.soundUtil.play(1);
            this.isBackFromPause = true;
            this.parent.removeDisplay(this);
        }
    }

    protected void keyReleased(int keyCode) {
        super.keyReleased(keyCode);
        if (KeyTranslator.compareKey(keyCode, 2) || keyCode == 52) {
            this.left = false;
        }
        if (KeyTranslator.compareKey(keyCode, 5) || keyCode == 54) {
            this.right = false;
        }
        if (KeyTranslator.compareKey(keyCode, 1) || keyCode == 50) {
            this.up = false;
        }
        if (KeyTranslator.compareKey(keyCode, 6) || keyCode == 56) {
            this.down = false;
        }
    }

    private void heroMove() {
        this.hero.moveHero(this.up, this.down, this.left, this.right);
    }

    protected void initBackground() {
        this.background = new ForestBackground();
        this.background.initialize();
        this.addChild(this.background);
    }

    public void removeDisplay(Object obj) {
        this.removeChild(obj);
        if (obj instanceof PowerUp) {
            this.powerups.removeElement(obj);
        } else {
            this.enemies.removeElement(obj);
        }
    }

    private void enemyFactory() {
        --this.enemyDelay;
        if (this.enemyDelay == 0) {
            int index = Math.abs(RandomUtil.getInstance().getRandom(this.enemyType.length));
            Unit e = this.getEnemy(this.enemyType[index]);
            this.addChildAt(e, 1);
            this.enemies.addElement(e);
            this.enemyDelay = e.safeDelay + this.enemyStaticDelay + RandomUtil.getInstance().getRandom(this.enemyVolatileDelay);
        }
    }

    private Unit getEnemy(int type) {
        Unit u = null;
        switch (type) {
            case 0: {
                u = new RedZerosen();
                break;
            }
            case 1: {
                u = new BlackZerosen();
                break;
            }
            case 2: {
                u = new LeftNyan();
                break;
            }
            case 3: {
                u = new RightNyan();
                break;
            }
            case 4: {
                u = new Baloon();
                break;
            }
            case 5: {
                u = new Kirov();
            }
        }
        u.initialize();
        u.initActualPosition(this.ActualX, this.ActualY);
        u.parent = this;
        return u;
    }

    private void backgroundAndTravelSpeed() {
        this.travelSpeed = (float)((double)this.travelSpeed - 0.025);
        if (this.travelSpeed < 3.0f) {
            this.travelSpeed = 3.0f;
        }
        this.background.scrollSpeed = (int)this.travelSpeed;
        this.elapsedDistance = (int)((float)this.elapsedDistance + this.travelSpeed);
        this.speedRatio = this.travelSpeed / 10.0f * 3.0f;
        this.hud.update((float)this.elapsedDistance / (float)this.totalDistance, this.travelSpeed / 10.0f);
    }

    private void winCheck() {
        if (this.elapsedDistance >= this.totalDistance) {
            System.out.println("you win");
            this.isWin = true;
        }
    }

    private void loseCheck() {
        for (int i = 0; i < this.enemies.size(); ++i) {
            Unit unit = (Unit)this.enemies.elementAt(i);
            unit.y = (int)((float)unit.y + this.speedRatio);
            boolean b = this.hero.hitbox.HitTest(unit.hitbox);
            if (!b) continue;
            System.out.println("You Lose, youve been hit by" + unit);
            this.isPaused = true;
            this.isDefeated = true;
            Stage.soundUtil.play(3);
        }
    }

    private void updatePowerups() {
        --this.powerupDelay;
        if (this.powerupDelay <= 0) {
            this.powerupDelay = this.powerupStaticDelay + Math.abs(RandomUtil.getInstance().getRandom(this.powerupVolatileDelay));
            PowerUp p = new PowerUp();
            p.powerupType = Math.abs(RandomUtil.getInstance().getRandom(100)) <= this.powerupBlueGemChance ? 1 : 0;
            p.parent = this;
            p.initialize();
            p.initActualPosition(this.ActualX, this.ActualY);
            this.addChildAt(p, 1);
            this.powerups.addElement(p);
        }
        for (int i = 0; i < this.powerups.size(); ++i) {
            PowerUp p = (PowerUp)this.powerups.elementAt(i);
            if (!this.hero.hitbox.HitTest(p.hitbox)) continue;
            this.travelSpeed = p.powerupType == 1 ? (this.travelSpeed += (float)this.powerupBlueGemValue) : (this.travelSpeed += (float)this.powerupRedGemValue);
            if (this.travelSpeed > 10.0f) {
                this.travelSpeed = 10.0f;
            }
            this.removeDisplay(p);
            --i;
        }
    }
}

