/*
 * Decompiled with CFR 0.152.
 */
package elventales.avoider.window.title;

import elventales.avoider.Stage;
import elventales.avoider.util.KeyTranslator;
import elventales.avoider.util.PlayerData;
import elventales.avoider.window.Window;
import elventales.avoider.window.component.ButtonBackground;
import elventales.avoider.window.component.MiddleButton;
import elventales.avoider.window.component.RightButton;
import elventales.hsalf.display.DisplayObject;
import java.io.IOException;
import javax.microedition.lcdui.Image;
import javax.microedition.lcdui.game.Sprite;

public class LevelSelect
extends Window {
    public boolean isBack = false;
    private Sprite[] cursorsSprite = new Sprite[7];
    private DisplayObject[] cursors = new DisplayObject[7];
    private DisplayObject[] checks = new DisplayObject[7];
    private final int[][] cursorPos = new int[][]{{75, 95}, {120, 80}, {210, 115}, {240, 145}, {220, 200}, {125, 210}, {80, 180}};
    public int selectedLevel = 0;

    public void initialize() {
        PlayerData.getInstance().Load();
        try {
            this.addChild(Image.createImage((String)"/levelselect/map.png"));
            block7: for (int i = 0; i < this.cursors.length; ++i) {
                this.cursorsSprite[i] = new Sprite(Image.createImage((String)"/levelselect/greenbox.png"), 30, 30);
                this.cursors[i] = new DisplayObject(this.cursorsSprite[i], 0, 0);
                this.checks[i] = new DisplayObject(Image.createImage((String)"/levelselect/check.png"), -20, -20);
                this.addChild(this.cursors[i]);
                this.addChild(this.checks[i]);
                switch (PlayerData.getInstance().levelState[i]) {
                    case 0: {
                        this.cursors[i].x = -30;
                        this.cursors[i].y = -30;
                        continue block7;
                    }
                    case 1: {
                        this.cursors[i].x = this.cursorPos[i][0];
                        this.cursors[i].y = this.cursorPos[i][1];
                        this.cursorsSprite[i].setFrame(0);
                        continue block7;
                    }
                    case 2: {
                        this.cursors[i].x = this.cursorPos[i][0];
                        this.cursors[i].y = this.cursorPos[i][1];
                        this.cursorsSprite[i].setFrame(0);
                        this.checks[i].x = this.cursorPos[i][0];
                        this.checks[i].y = this.cursorPos[i][1];
                    }
                }
            }
            ButtonBackground bbg = new ButtonBackground();
            MiddleButton mb = new MiddleButton();
            RightButton rb = new RightButton(false);
            this.addChild(bbg);
            this.addChild(mb);
            this.addChild(rb);
            this.adjustCursorPosition();
            if (Stage.isLandscape) {
                this.y = -80;
                bbg.y += 80;
                mb.y += 80;
                rb.y += 80;
            } else {
                this.x = -40;
                bbg.x += 40;
                mb.x += 40;
                rb.x += 40;
            }
        }
        catch (IOException ex) {
            System.out.println("Level Select Initialize IOException :" + ex.getMessage());
        }
    }

    protected void keyPressed(int keyCode) {
        int SelectedLevelTemp = this.selectedLevel;
        if (KeyTranslator.getKeyAction(keyCode) == 8 || keyCode == 53) {
            Stage.soundUtil.play(1);
            this.isBack = false;
            this.parent.removeDisplay(this);
        } else if (keyCode == 51 || keyCode == -7) {
            Stage.soundUtil.play(1);
            this.isBack = true;
            this.parent.removeDisplay(this);
        } else if (KeyTranslator.getKeyAction(keyCode) == 1 || keyCode == 50) {
            Stage.soundUtil.play(1);
            switch (this.selectedLevel) {
                case 0: 
                case 5: {
                    ++this.selectedLevel;
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    --this.selectedLevel;
                }
            }
        } else if (KeyTranslator.getKeyAction(keyCode) == 6 || keyCode == 56) {
            Stage.soundUtil.play(1);
            switch (this.selectedLevel) {
                case 2: 
                case 3: {
                    ++this.selectedLevel;
                    break;
                }
                case 6: {
                    --this.selectedLevel;
                }
            }
        } else if (KeyTranslator.getKeyAction(keyCode) == 2 || keyCode == 52) {
            Stage.soundUtil.play(1);
            switch (this.selectedLevel) {
                case 4: 
                case 5: {
                    ++this.selectedLevel;
                    break;
                }
                case 1: 
                case 2: {
                    --this.selectedLevel;
                }
            }
        } else if (KeyTranslator.getKeyAction(keyCode) == 5 || keyCode == 54) {
            Stage.soundUtil.play(1);
            switch (this.selectedLevel) {
                case 0: 
                case 1: 
                case 2: {
                    ++this.selectedLevel;
                    break;
                }
                case 4: 
                case 5: 
                case 6: {
                    --this.selectedLevel;
                }
            }
        }
        if (PlayerData.getInstance().levelState[this.selectedLevel] == 0) {
            this.selectedLevel = SelectedLevelTemp;
        }
        this.adjustCursorPosition();
        super.keyPressed(keyCode);
    }

    private void adjustCursorPosition() {
        for (int i = 0; i < this.cursorsSprite.length; ++i) {
            Sprite s = this.cursorsSprite[i];
            s.setFrame(0);
            if (this.selectedLevel != i) continue;
            s.setFrame(1);
        }
    }
}

