/*
 * Decompiled with CFR 0.152.
 */
package elventales.hsalf.display;

import java.util.Vector;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import javax.microedition.lcdui.game.Sprite;

public class DisplayObject {
    public int x = 0;
    public int y = 0;
    public boolean visible = true;
    private Vector displayList = new Vector();
    public int ActualX;
    public int ActualY;

    public DisplayObject() {
    }

    public DisplayObject(Image i, int x, int y) {
        this.addChild(i);
        this.x = x;
        this.y = y;
    }

    public DisplayObject(Sprite i, int x, int y) {
        this.addChild(i);
        this.x = x;
        this.y = y;
    }

    public void initialize() {
    }

    void draw(Graphics g, int xOffset, int yOffset) {
        this.ActualX = xOffset + this.x;
        this.ActualY = yOffset + this.y;
        if (!this.visible) {
            return;
        }
        for (int i = 0; i < this.displayList.size(); ++i) {
            if (this.displayList.elementAt(i) instanceof DisplayObject) {
                DisplayObject d = (DisplayObject)this.displayList.elementAt(i);
                d.draw(g, this.ActualX, this.ActualY);
                continue;
            }
            if (this.displayList.elementAt(i) instanceof Image) {
                Image m = (Image)this.displayList.elementAt(i);
                g.drawImage(m, this.ActualX, this.ActualY, 20);
                continue;
            }
            if (!(this.displayList.elementAt(i) instanceof Sprite)) continue;
            Sprite s = (Sprite)this.displayList.elementAt(i);
            s.setPosition(this.ActualX, this.ActualY);
            s.paint(g);
        }
    }

    protected void loop() {
        for (int i = 0; i < this.displayList.size(); ++i) {
            if (!(this.displayList.elementAt(i) instanceof DisplayObject)) continue;
            DisplayObject d = (DisplayObject)this.displayList.elementAt(i);
            d.loop();
        }
    }

    protected void keyPressed(int keyCode) {
        for (int i = 0; i < this.displayList.size(); ++i) {
            if (!(this.displayList.elementAt(i) instanceof DisplayObject)) continue;
            DisplayObject d = (DisplayObject)this.displayList.elementAt(i);
            d.keyPressed(keyCode);
        }
    }

    protected void keyReleased(int keyCode) {
        for (int i = 0; i < this.displayList.size(); ++i) {
            if (!(this.displayList.elementAt(i) instanceof DisplayObject)) continue;
            DisplayObject d = (DisplayObject)this.displayList.elementAt(i);
            d.keyReleased(keyCode);
        }
    }

    protected void keyRepeated(int keyCode) {
        for (int i = 0; i < this.displayList.size(); ++i) {
            if (!(this.displayList.elementAt(i) instanceof DisplayObject)) continue;
            DisplayObject d = (DisplayObject)this.displayList.elementAt(i);
            d.keyRepeated(keyCode);
        }
    }

    public final void addChild(Object child) {
        this.displayList.addElement(child);
    }

    public final void removeChild(Object child) {
        this.displayList.removeElement(child);
    }

    public final void addChildAt(Object child, int index) {
        this.displayList.insertElementAt(child, index);
    }

    public final Object getChildAt(int index) {
        return this.displayList.elementAt(index);
    }

    public final int getNumChildren() {
        return this.displayList.size();
    }
}

