/*
 * Decompiled with CFR 0.152.
 */
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.game.Sprite;

public class Bonuses {
    public static Bonuses sInstance = null;
    static final int MAX_BONUSES = 10;
    static final int SPEED_BONUS = 4;
    public static final int BONUS_GEARS_SPEED = 0;
    public static final int BONUS_ARMS_SPEED = 1;
    public static final int BONUS_BATTERY = 2;
    public static final int BONUS_POWER_UP = 3;
    public static final int BONUS_TIME = 4;
    private int[] iaBonusX;
    private int[] iaBonusY;
    private int[] iaBonusType;
    public int iBonusWidth;

    public static Bonuses CreateInstance() {
        if (sInstance != null) {
            return sInstance;
        }
        sInstance = new Bonuses();
        return sInstance;
    }

    public static void ReleaseInstance() {
        if (sInstance == null) {
            return;
        }
        sInstance.release();
        sInstance = null;
        System.gc();
    }

    Bonuses() {
        Debug.traceIn("> Bonuses.Bonuses()");
        this.iaBonusX = new int[10];
        this.iaBonusY = new int[10];
        this.iaBonusType = new int[10];
        this.iBonusWidth = Resources.sprBonuses.getWidth();
        this.reset();
        Debug.traceOut("< Bonuses.Bonuses()");
    }

    public void reset() {
        Debug.traceIn("> Bonuses.reset()");
        for (int i = this.iaBonusX.length - 1; i >= 0; --i) {
            this.iaBonusX[i] = -1979;
        }
        Debug.traceOut("< Bonuses.reset()");
    }

    public void release() {
        Debug.traceIn("> Bonuses.release()");
        this.iaBonusX = null;
        this.iaBonusY = null;
        this.iaBonusType = null;
        System.gc();
        Debug.traceOut("< Bonuses.release()");
    }

    public int createBonus(int iPosX, int iPosY, int iType) {
        Debug.traceIn("> Bonuses.createBonus(" + iPosX + "," + iPosY + "," + iType + ")");
        for (int i = this.iaBonusX.length - 1; i >= 0; --i) {
            if (this.iaBonusX[i] != -1979) continue;
            this.iaBonusX[i] = iPosX;
            this.iaBonusY[i] = iPosY;
            this.iaBonusType[i] = iType;
            Debug.traceOut("< Bonuses.createBonus() returns " + i);
            return i;
        }
        Debug.traceOut("< Bonuses.release() returns -1");
        return -1;
    }

    public void update() {
        Robot robot = Robot.sInstance;
        int iRobotPosY = robot.iPosY;
        int iRobotPosX = robot.getPosX();
        for (int i = this.iaBonusX.length - 1; i >= 0; --i) {
            if (this.iaBonusX[i] == -1979) continue;
            int n = i;
            this.iaBonusY[n] = this.iaBonusY[n] + 4;
            if (this.iaBonusY[i] < iRobotPosY) continue;
            if (this.iaBonusY[i] > Defines.HEIGHT) {
                this.iaBonusX[i] = -1979;
                continue;
            }
            if (this.iaBonusX[i] > iRobotPosX + Robot.WIDTH_ROBOT || this.iaBonusX[i] + this.iBonusWidth < iRobotPosX) continue;
            GameStateCommon gssCommon = GameStateCommon.sInstance;
            gssCommon.bonusTakenTime = 40;
            X.soundManager.Play(X.SOUND_BONUS_ID, 1);
            switch (this.iaBonusType[i]) {
                case 0: {
                    gssCommon.iGearsSpeed += 50;
                    gssCommon.iBonusGearsSpeedTime = 400;
                    break;
                }
                case 1: {
                    gssCommon.iArmsSpeed += 16;
                    gssCommon.iBonusArmsSpeedTime = 400;
                    break;
                }
                case 2: {
                    gssCommon.iBatteryPower = 100;
                    break;
                }
                case 3: {
                    gssCommon.iBonusPowerUpTime = 400;
                    break;
                }
                case 4: {
                    gssCommon.iBonusNoBlockTime = 400;
                }
            }
            this.iaBonusX[i] = -1979;
        }
    }

    public void paint(Graphics g) {
        Sprite spr = Resources.sprBonuses;
        for (int i = this.iaBonusX.length - 1; i >= 0; --i) {
            if (this.iaBonusX[i] == -1979) continue;
            spr.setPosition(this.iaBonusX[i], this.iaBonusY[i]);
            spr.setFrame(this.iaBonusType[i]);
            spr.paint(g);
        }
    }
}

