/*
 * Decompiled with CFR 0.152.
 */
package com.ximad.pvn.game.pandas;

import com.ximad.pvn.audio.SoundSystem;
import com.ximad.pvn.game.Box2d;
import com.ximad.pvn.game.Camera;
import com.ximad.pvn.game.CollisionSystem;
import com.ximad.pvn.game.MyWorld;
import com.ximad.pvn.game.PhysicalGameObject;
import com.ximad.pvn.game.Point;
import com.ximad.pvn.game.SpecialEffect;
import com.ximad.pvn.game.Textures;
import com.ximad.pvn.game.Timer;
import com.ximad.pvn.game.TraceEffect;
import com.ximad.pvn.game.XBody;
import com.ximad.pvn.game.pandas.Panda;
import com.ximad.pvn.utils.ArrayList;
import com.ximad.pvn.utils.Utils;

public class PandaExplode
extends Panda {
    int timer = 3000;
    int tick;
    boolean explosion = false;
    boolean showtimer = false;

    public void OnCollision(PhysicalGameObject obj, float force) {
        if (MyWorld.playerPanda != null && !this.isDying && this == MyWorld.playerPanda) {
            MyWorld.onFly = false;
            this.isDying = true;
            MyWorld.playerPanda = null;
        }
        if (obj.typeDinamicalObjects == 101) {
            Box2d.stopAngularVelocity(this.box2dId);
        }
    }

    public static void createPanda(int x, int y) {
        PandaExplode panda = new PandaExplode();
        panda.typeDinamicalObjects = 102;
        panda.isCircle = true;
        panda.restitution = 43;
        panda.friction = 3;
        panda.radius = 15;
        panda.density = 40;
        ArrayList shape = new ArrayList();
        shape.add(new Point(x, y));
        panda.setShape(shape, false, false);
        panda.frames = Textures.pandaKamikaze;
        panda.nFrames = 8;
        MyWorld.physicalGameObjects.add(panda);
        panda.mass = Box2d.getMass(panda.box2dId);
        panda.tick = 0;
        panda.trick = false;
        MyWorld.playerPanda = panda;
        Camera.setTarget(panda);
        panda.box2dId.setParent(panda);
        TraceEffect.createSpecialTrace(panda);
    }

    public static void launchPanda(int RawX, int RawY) {
        PandaExplode.createPanda(RawX, RawY);
        Box2d.applyForceToCenter(MyWorld.playerPanda.box2dId, Box2d.getMass(MyWorld.playerPanda.box2dId) * forceX, Box2d.getMass(MyWorld.playerPanda.box2dId) * forceY);
    }

    public void ability() {
        if (!this.trick) {
            this.trick = true;
            this.explosion = true;
            Timer.createTimer(this.timer);
        }
    }

    public void explosionAbility() {
        float max = 0.0f;
        float x = Box2d.getCenterX(this.box2dId);
        float y = Box2d.getCenterY(this.box2dId);
        float imp = 6000.0f;
        for (int j = 0; j < MyWorld.physicalGameObjects.size(); ++j) {
            PhysicalGameObject body;
            if (MyWorld.physicalGameObjects.get(j) == this || (body = (PhysicalGameObject)MyWorld.physicalGameObjects.get(j)) == null || body.isStatic) continue;
            XBody body_box2dId = body.box2dId;
            float bx = Box2d.getCenterX(body_box2dId);
            float by = Box2d.getCenterY(body_box2dId);
            float dx = x - bx;
            float dy = y - by;
            float d = (float)Math.sqrt(dx * dx + dy * dy);
            if ((double)Math.abs(bx - x) < 1.0E-4) {
                bx += 1.0E-4f;
            }
            float k = (by - y) / (bx - x);
            float atan = (float)Utils.atan(k);
            float sinA = (float)Math.sin(atan);
            if (d < 1.0f) {
                d = 1.0f;
            }
            float bodyImp = 2.0f * imp;
            int force = 0;
            if (d > (float)this.radius * 4.0f) {
                bodyImp = 0.9f * bodyImp;
                force = 151;
            }
            if (d > (float)this.radius * 6.0f) {
                bodyImp = 0.8f * bodyImp;
                force = 101;
            }
            if (d > (float)this.radius * 8.0f) {
                bodyImp = 0.7f * bodyImp;
                force = 56;
            }
            if (d > (float)this.radius * 10.0f) {
                bodyImp = 0.6f * bodyImp;
                force = 30;
            }
            if (d > (float)this.radius * 12.0f) {
                bodyImp = 0.5f * bodyImp;
                force = 15;
            }
            if (d > (float)this.radius * 14.0f) {
                bodyImp = 0.4f * bodyImp;
                force = 10;
            }
            if (d > (float)this.radius * 8.0f) {
                bodyImp = 1.0f;
                force = 5;
            }
            CollisionSystem.OnCollision(body_box2dId, body_box2dId, force);
            int py = (int)(bodyImp * sinA);
            int px = (int)(bodyImp * (1.0f - sinA * sinA));
            if (x > bx) {
                px = -px;
            }
            if (y < by) {
                py = -py;
            }
            Box2d.applyImpulseToCenter(body_box2dId, px, py);
            if (!(bodyImp > max)) continue;
            max = bodyImp;
        }
        SpecialEffect.createPandaExplosion(this);
        SoundSystem.SOUND_ON_PANDA_EXPLOSION.play();
        Box2d.moveBodyOutside(this.box2dId);
        MyWorld.playerPanda = null;
        MyWorld.onFly = false;
        Camera.isFollowing = false;
        Camera.isScrollingStart = true;
        Camera.canScrollStart = true;
        this.explosion = false;
    }

    public void update(long dt) {
        if (this.explosion) {
            Timer.position.set(Box2d.getX(this.box2dId) - 30, Box2d.getY(this.box2dId) - 50);
            this.timer = (int)((long)this.timer - dt);
            if (this.timer <= 0) {
                this.explosionAbility();
            }
        }
        if (this.trick) {
            this.tick = (int)((long)this.tick + dt);
            if (this.tick > 5000) {
                try {
                    MyWorld.physicalGameObjects.remove(this);
                    --MyWorld.livesDisapearedPanda;
                    Box2d.destroyGameObject(this.box2dId);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                MyWorld.checkEndLevel();
            }
        } else {
            this.checkDistance();
            this.checkDeadPanda(dt);
        }
        super.update(dt);
    }
}

