/*
 * Decompiled with CFR 0.152.
 */
package com.ximad.pvn.engine;

import com.ximad.pvn.audio.SoundSystem;
import com.ximad.pvn.engine.MainCanvas;
import com.ximad.pvn.engine.Screen;
import com.ximad.pvn.game.DataManager;
import com.ximad.pvn.game.Textures;
import com.ximad.pvn.screens.EndLevelScreen;
import com.ximad.pvn.screens.GameScreen;
import com.ximad.pvn.screens.HomeScreen;
import com.ximad.pvn.screens.LoadingScreen;
import com.ximad.pvn.screens.PauseScreen;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.midlet.MIDlet;

public class Application
extends MIDlet {
    public static MainCanvas canvas;
    private static Application instance;
    public static int screenWidth;
    public static int screenHeight;
    public static DataManager dataManager;
    public static boolean isForeground;
    public static Screen screen;
    private static Command quitCommand;

    public Application() {
        instance = this;
        canvas = new MainCanvas();
        canvas.setFullScreenMode(true);
    }

    public void startApp() {
        canvas.setFullScreenMode(true);
        canvas.start();
        Display.getDisplay((MIDlet)this).setCurrent((Displayable)canvas);
        Screen.sleep(50L);
        screenWidth = canvas.getWidth();
        screenHeight = canvas.getHeight();
        if (screenHeight > screenWidth) {
            screenWidth = canvas.getHeight();
            screenHeight = canvas.getWidth();
        }
        Application.setScreen(LoadingScreen.getInstance());
        isForeground = true;
        LoadingScreen.setState(1);
        Textures.initResources();
        LoadingScreen.setState(4);
        SoundSystem.init();
        LoadingScreen.setState(5);
        dataManager = new DataManager();
        SoundSystem.SOUND_MAIN_THEME.playInLoop();
        Application.setScreen(HomeScreen.getInstance());
    }

    public void pauseApp() {
    }

    public void destroyApp(boolean unconditional) {
        if (dataManager != null) {
            dataManager.saveSettings();
        }
        if (SoundSystem.isInited) {
            SoundSystem.release();
        }
        canvas.stop();
    }

    public static void setScreen(Screen screen) {
        if (Application.screen != null) {
            Application.screen.onHide();
        }
        Application.screen = screen;
        if (screen != null) {
            screen.onShow();
        }
    }

    public static Screen getScreen() {
        return screen;
    }

    public static void activate() {
        isForeground = true;
        if (screen != GameScreen.getInstance() && !(screen instanceof PauseScreen) && !(screen instanceof EndLevelScreen) && SoundSystem.SOUND_MAIN_THEME != null) {
            SoundSystem.SOUND_MAIN_THEME.playInLoop();
        }
        canvas.start();
    }

    public static void deactivate() {
        if (SoundSystem.SOUND_MAIN_THEME != null) {
            SoundSystem.SOUND_MAIN_THEME.stop();
        }
        canvas.stop();
        isForeground = false;
    }

    public static void quit() {
        instance.destroyApp(true);
        instance.notifyDestroyed();
    }

    public static MIDlet getInstance() {
        return instance;
    }

    static {
        isForeground = false;
    }
}

