/*
 * Decompiled with CFR 0.152.
 */
package com.ximad.pvn.game;

import at.emini.physics2D.Body;
import at.emini.physics2D.World;
import com.ximad.pvn.engine.Application;
import com.ximad.pvn.game.Background;
import com.ximad.pvn.game.Camera;
import com.ximad.pvn.game.CollisionSystem;
import com.ximad.pvn.game.Game;
import com.ximad.pvn.game.GameObject;
import com.ximad.pvn.game.Hud;
import com.ximad.pvn.game.Launcher;
import com.ximad.pvn.game.PandaSeeker;
import com.ximad.pvn.game.PandaSetup;
import com.ximad.pvn.game.PhysicalGameObject;
import com.ximad.pvn.game.Point;
import com.ximad.pvn.game.Score;
import com.ximad.pvn.game.WaitingPanda;
import com.ximad.pvn.game.Weather;
import com.ximad.pvn.game.XBody;
import com.ximad.pvn.game.pandas.Panda;
import com.ximad.pvn.utils.ArrayList;
import com.ximad.pvn.utils.Utils;
import javax.microedition.lcdui.Graphics;

public class MyWorld
extends World {
    public static final float ADD_RIGHT_BOUND = Application.screenWidth / 2 + 100;
    public static boolean paused = false;
    public static final boolean SHOW_SHAPES = false;
    public static final boolean SHOW_DEBUG = true;
    public static boolean SHOW_SCORE_AND_PAUSE = true;
    public static boolean pandaFirst = false;
    public static boolean onLevelStart = true;
    public static boolean onHit = false;
    public static boolean onLaunch = false;
    public static boolean onCharge = false;
    public static boolean ondeCharge = false;
    public static boolean onSetUp = false;
    public static boolean onShot = false;
    public static boolean onFly = false;
    public static boolean onPlay = true;
    public static boolean onWin = false;
    public static boolean onLost = false;
    public static boolean onTutorial = false;
    public static boolean onCompleteLost = false;
    public static boolean OnStartCheckCollision = false;
    public int offsetX = 0;
    public static Background background;
    public static Camera camera;
    public Game game;
    public CollisionSystem collisionSystem;
    public Body panda;
    public Body[] borders;
    public Body[] ninjas;
    public Body[] smallRects;
    public Body[] bigRects;
    public Body ball;
    public static int center;
    public static ArrayList physicalGameObjects;
    public static ArrayList gameObjects;
    public static PandaSetup shot_panda;
    public static Point playerCoord;
    public static Point levelStartCoord;
    public static float playerRad;
    public static int currentLevelInt;
    public static String currentLevelStr;
    public static int score;
    public static int highscore;
    public static int bronze;
    public static int silver;
    public static int gold;
    public static int lives;
    public static int livesDisapearedPanda;
    public static int livesDisapearedNinja;
    public static ArrayList wPandas;
    public static int floor;
    public static Panda playerPanda;
    public static int launcherObjectIndex;
    public static boolean endLevel;
    public static int currentPanda;
    public static boolean wind;
    public static Weather weather;

    public MyWorld() {
        lives = 0;
        score = 0;
        highscore = 0;
        onLaunch = false;
        onLevelStart = true;
        onSetUp = false;
        onShot = false;
        onFly = false;
        onPlay = true;
        onWin = false;
        onLost = false;
        onCharge = false;
        ondeCharge = false;
        onCompleteLost = false;
        this.game = new Game();
    }

    public void loadBackgroundImage() {
    }

    public void restart() {
        lives = 0;
        score = 0;
        highscore = 0;
        pandaFirst = false;
        onLevelStart = true;
        onHit = false;
        onLaunch = false;
        onSetUp = false;
        onShot = false;
        onFly = false;
        onPlay = true;
        onWin = false;
        onLost = false;
        onCharge = false;
        ondeCharge = false;
        onCompleteLost = false;
        OnStartCheckCollision = false;
        if (physicalGameObjects != null) {
            physicalGameObjects.clear();
        } else {
            physicalGameObjects = new ArrayList();
        }
        if (gameObjects != null) {
            gameObjects.clear();
        } else {
            gameObjects = new ArrayList();
        }
        if (wPandas != null) {
            wPandas.clear();
        } else {
            wPandas = new ArrayList();
        }
        PandaSetup.reset();
        playerPanda = null;
        launcherObjectIndex = -1;
        livesDisapearedPanda = 0;
        livesDisapearedNinja = 0;
        endLevel = false;
        this.game = new Game();
        center = 700;
        gold = 0;
        silver = 0;
        bronze = 0;
        Body[] bodies = this.getBodies();
        for (int i = bodies.length - 1; i >= 0; --i) {
            if (bodies[i] == null) continue;
            this.removeBody(bodies[i]);
        }
    }

    public void reset() {
        lives = 0;
        score = 0;
        highscore = 0;
        onLaunch = false;
        onFly = false;
        onPlay = false;
        onWin = false;
        onLost = false;
        onCharge = false;
        ondeCharge = false;
    }

    public void draw(Graphics g) {
        int i;
        background.farLayersDraw(g);
        weather.draw(g);
        if (Launcher.launcher != null) {
            Launcher.launcher.draw(g);
        }
        for (i = 0; i < physicalGameObjects.size(); ++i) {
            PhysicalGameObject pgo = (PhysicalGameObject)physicalGameObjects.get(i);
            if (pgo == null) continue;
            pgo.draw(g);
        }
        for (i = 0; i < gameObjects.size(); ++i) {
            GameObject go = (GameObject)gameObjects.get(i);
            if (go == null) continue;
            go.draw(g);
        }
        background.frontLayerDraw(g);
        PandaSeeker.mPS.draw(g);
        if (SHOW_SCORE_AND_PAUSE) {
            Hud.draw(g);
        }
        Game.draw(g);
    }

    public void update(long dt) {
        int i;
        camera.update(dt);
        this.collisionSystem.update(dt);
        weather.update(dt);
        for (i = 0; i < physicalGameObjects.size(); ++i) {
            PhysicalGameObject pgo = (PhysicalGameObject)physicalGameObjects.get(i);
            if (pgo == null) continue;
            pgo.update(dt);
        }
        Launcher.launcher.update(dt);
        for (i = 0; i < gameObjects.size(); ++i) {
            GameObject go = (GameObject)gameObjects.get(i);
            if (go == null) continue;
            go.update(dt);
        }
        WaitingPanda.updateSounds(dt);
        physicalGameObjects.clearDeleted();
        gameObjects.clearDeleted();
        Score.update();
        PandaSeeker.mPS.update(dt);
        this.check();
        try {
            this.tick();
        }
        catch (Exception e) {
            Utils.log("!! exception in world tick");
            e.printStackTrace();
            paused = true;
        }
        this.game.update(dt);
    }

    public static void checkEndLevel() {
        if (!onLost && !onWin) {
            if (livesDisapearedNinja == 0) {
                onWin = true;
                Camera.canScrollStart = false;
                onCompleteLost = false;
                Utils.log("!!! win");
            }
            if (livesDisapearedPanda == 0 && !onWin) {
                Camera.canScrollStart = false;
                onCompleteLost = true;
                Utils.log("!!! lost");
            }
        }
    }

    public void check() {
        Body[] mas = this.getBodies();
        for (int i = 0; i < mas.length; ++i) {
            if (!(mas[i] instanceof XBody)) continue;
            ((XBody)mas[i]).check();
        }
    }

    static {
        center = 700;
        physicalGameObjects = new ArrayList();
        gameObjects = new ArrayList();
        playerCoord = new Point();
        levelStartCoord = new Point();
        playerRad = 7.5f;
        wPandas = new ArrayList();
        playerPanda = null;
        launcherObjectIndex = -1;
        endLevel = false;
        wind = false;
        weather = new Weather();
    }
}

