/*
 * Decompiled with CFR 0.152.
 */
package com.ximad.pvn.game;

import com.ximad.pvn.game.Box2d;
import com.ximad.pvn.game.GameObject;
import com.ximad.pvn.game.MyWorld;
import com.ximad.pvn.game.Particle;
import com.ximad.pvn.game.ParticleSystem;
import com.ximad.pvn.game.PhysicalGameObject;
import com.ximad.pvn.game.Point;
import com.ximad.pvn.game.Textures;
import com.ximad.pvn.game.obstacles.Obstacle;
import com.ximad.pvn.game.obstacles.ObstacleBox;
import com.ximad.pvn.game.obstacles.ObstacleBrick;
import com.ximad.pvn.game.obstacles.ObstacleClay;
import com.ximad.pvn.game.obstacles.ObstacleDynamite;
import com.ximad.pvn.game.obstacles.ObstacleGlass;
import com.ximad.pvn.game.obstacles.ObstacleStone;
import com.ximad.pvn.game.obstacles.ObstacleWood;
import javax.microedition.lcdui.Graphics;

public class ParticleExplosion
extends GameObject {
    Point emmiterPosition = new Point();
    Particle[] mParticles;
    int count;
    int lifetime;
    float objAngle;
    float objectSquare;
    static final int COUNT_MULTIPLIER = 100;
    static final int TIME_TO_UPDATE = 10;
    int time;

    public static void createParticleExplosion(Obstacle pGO) {
        ParticleExplosion pEffect = new ParticleExplosion();
        pEffect.getCountFromSize(pGO);
        pEffect.mParticles = ParticleSystem.allocateParticles(pEffect.count);
        if (pEffect.mParticles != null) {
            int x = Box2d.getCenterX(pGO.box2dId);
            int y = Box2d.getCenterY(pGO.box2dId);
            int angle = Box2d.getAngle(pGO.box2dId);
            pEffect.emmiterPosition.set(x, y);
            pEffect.objAngle = angle;
            for (int i = 0; i < pEffect.count; ++i) {
                pEffect.mParticles[i].setOffset(pEffect.emmiterPosition);
                pEffect.mParticles[i].setSpread(pGO, pEffect.objAngle);
                pEffect.mParticles[i].setDirection();
                pEffect.mParticles[i].setGravity(0.3f, 0.3f);
                pEffect.mParticles[i].setSpeed(2.0f, 3.0f);
                if (pGO instanceof ObstacleDynamite) {
                    if (pGO.imageName.indexOf("red") != -1) {
                        pEffect.mParticles[i].setSprite(Textures.fireworks[1]);
                    }
                    if (pGO.imageName.indexOf("strip") != -1) {
                        pEffect.mParticles[i].setSprite(Textures.fireworks[4]);
                    }
                }
                if (pGO instanceof ObstacleBox) {
                    pEffect.mParticles[i].setSprite(Textures.fireworks);
                }
                if (pGO instanceof ObstacleBrick) {
                    pEffect.mParticles[i].setSprite(Textures.obstacleCrush[0]);
                }
                if (pGO instanceof ObstacleGlass) {
                    pEffect.mParticles[i].setSprite(Textures.obstacleCrush[1]);
                }
                if (pGO instanceof ObstacleWood) {
                    pEffect.mParticles[i].setSprite(Textures.obstacleCrush[2]);
                }
                if (pGO instanceof ObstacleStone) {
                    pEffect.mParticles[i].setSprite(Textures.obstacleCrush[3]);
                }
                if (pGO instanceof ObstacleClay) {
                    pEffect.mParticles[i].setSprite(Textures.obstacleCrush[4]);
                    if (pGO.imageName.indexOf("blue") != -1) {
                        pEffect.mParticles[i].setSprite(Textures.clayDestroy[1]);
                    }
                    if (pGO.imageName.indexOf("red") != -1) {
                        pEffect.mParticles[i].setSprite(Textures.clayDestroy[2]);
                    }
                    if (pGO.imageName.indexOf("green") != -1) {
                        pEffect.mParticles[i].setSprite(Textures.clayDestroy[3]);
                    }
                    if (pGO.imageName.indexOf("gold") != -1) {
                        pEffect.mParticles[i].setSprite(Textures.clayDestroy[4]);
                    }
                }
                pEffect.mParticles[i].setSpin(-2.0f, 2.0f);
                pEffect.mParticles[i].setRadialAcceleration(-0.5f, 0.5f);
            }
            pEffect.lifetime = 3000;
            pEffect.time = 0;
            MyWorld.gameObjects.add(pEffect);
        }
    }

    public void draw(Graphics g) {
        for (int i = 0; i < this.count; ++i) {
            this.mParticles[i].draw(g);
        }
    }

    public void getCountFromSize(PhysicalGameObject pGO) {
        this.objectSquare = pGO.isCircle ? (float)(Math.PI * (double)pGO.radius * (double)pGO.radius) : (float)(pGO.width * pGO.height);
        this.count = (int)(this.objectSquare / 100.0f);
        if (this.count <= 0) {
            this.count = 1;
        }
    }

    public void update(long dt) {
        if (this.time > 10) {
            if (this.lifetime > 0) {
                for (int i = 0; i < this.count; ++i) {
                    this.mParticles[i].update(dt);
                }
            } else {
                ParticleSystem.freeParticles(this.mParticles, this.count);
                MyWorld.gameObjects.remove(this);
            }
            this.lifetime = (int)((long)this.lifetime - dt);
            this.time -= 10;
        }
        this.time = (int)((long)this.time + dt);
    }
}

