/*
 * Decompiled with CFR 0.152.
 */
package com.ximad.pvn.game.obstacles;

import at.emini.physics2D.Body;
import at.emini.physics2D.util.FXVector;
import com.ximad.pvn.engine.Application;
import com.ximad.pvn.engine.Bitmap;
import com.ximad.pvn.game.Box2d;
import com.ximad.pvn.game.Camera;
import com.ximad.pvn.game.MyWorld;
import com.ximad.pvn.game.PhysicalGameObject;
import com.ximad.pvn.game.Point_system;
import com.ximad.pvn.game.SpecialEffect;
import com.ximad.pvn.game.obstacles.ObstacleBox;
import com.ximad.pvn.game.obstacles.ObstacleBrick;
import com.ximad.pvn.game.obstacles.ObstacleClay;
import com.ximad.pvn.game.obstacles.ObstacleDynamite;
import com.ximad.pvn.game.obstacles.ObstacleGlass;
import com.ximad.pvn.game.obstacles.ObstacleMetal;
import com.ximad.pvn.game.obstacles.ObstacleRubber;
import com.ximad.pvn.game.obstacles.ObstacleStone;
import com.ximad.pvn.game.obstacles.ObstacleWood;
import javax.microedition.lcdui.Graphics;

public class Obstacle
extends PhysicalGameObject {
    int damage;
    int durability;
    int score;
    public boolean isCrushable = true;
    public static boolean sstatic;
    public int type;
    public int maxWidthX;

    public Obstacle() {
        this.typeDinamicalObjects = 104;
    }

    public void OnCollision(PhysicalGameObject obj, float force) {
    }

    protected boolean isVisible() {
        int x = this.box2dId.positionFX().xAsInt();
        if (this.maxWidthX <= 0) {
            this.maxWidthX = (int)Math.sqrt(this.width * this.width + this.height * this.height);
        }
        return x + this.maxWidthX >= Camera.position && x - this.maxWidthX <= Camera.position + Application.screenWidth;
    }

    protected static void drawTriangle(Graphics g, Body b, int angle, Bitmap image) {
        FXVector[] ver = b.getVertices();
        int x0 = b.positionFX().xAsInt();
        int y0 = b.positionFX().yAsInt();
        int x1 = ver[0].xAsInt();
        int y1 = ver[0].yAsInt();
        int x2 = ver[1].xAsInt();
        int y2 = ver[1].yAsInt();
        int x3 = ver[2].xAsInt();
        int y3 = ver[2].yAsInt();
        int r1 = (x0 - x1) * (x0 - x1) + (y0 - y1) * (y0 - y1);
        int r2 = (x0 - x2) * (x0 - x2) + (y0 - y2) * (y0 - y2);
        int r3 = (x0 - x3) * (x0 - x3) + (y0 - y3) * (y0 - y3);
        int cx = 0;
        int cy = 0;
        if (r1 <= r2 && r1 <= r3) {
            cx = (x2 + x3) / 2;
            cy = (y2 + y3) / 2;
        }
        if (r2 <= r1 && r2 <= r3) {
            cx = (x1 + x3) / 2;
            cy = (y1 + y3) / 2;
        }
        if (r3 <= r1 && r3 <= r2) {
            cx = (x2 + x1) / 2;
            cy = (y2 + y1) / 2;
        }
        image.drawRotatedCenter(g, cx - Camera.position + 2, cy, angle);
    }

    public void draw(Graphics g) {
        if (!this.isVisible()) {
            return;
        }
        this.angle = (this.box2dId.rotation2FX() >> 105414356) * 360 / 100;
        if (this.isTriangle) {
            Obstacle.drawTriangle(g, this.box2dId, this.angle, this.frames[this.defaultFrame]);
        } else {
            int x = this.box2dId.positionFX().xAsInt();
            int y = this.box2dId.positionFX().yAsInt();
            if (this.isCircle) {
                this.frames[this.defaultFrame].drawRotatedCenterSquareImage(x - Camera.position, y, this.angle, g);
            } else {
                this.frames[this.defaultFrame].drawRotatedCenter(g, x - Camera.position, y, this.angle);
            }
        }
    }

    public void update(long dt) {
        if (this.onDestroy) {
            this.durability = 0;
        }
        if (this.durability != this.damage) {
            if (this.durability < 0) {
                this.durability = 0;
            }
            int point = (this.damage - this.durability) * this.score;
            Point_system.createPoints(this, point);
            MyWorld.score += point;
            this.damage = this.durability;
        }
    }

    public static void createObstacle(int type, int x1, int y1, int x2, int y2, int x3, int y3, int x4, int y4) {
        int offset = 0;
        switch (type) {
            case 5002: {
                ObstacleBrick.createObstacle(x1, offset + y1, x2, offset + y2, x3, offset + y3, x4, offset + y4);
                break;
            }
            case 5003: {
                ObstacleGlass.createObstacle(x1, offset + y1, x2, offset + y2, x3, offset + y3, x4, offset + y4);
                break;
            }
            case 5004: {
                ObstacleStone.createObstacle(x1, offset + y1, x2, offset + y2, x3, offset + y3, x4, offset + y4);
                break;
            }
            case 5001: {
                ObstacleWood.createObstacle(x1, offset + y1, x2, offset + y2, x3, offset + y3, x4, offset + y4);
                break;
            }
            case 5007: {
                ObstacleMetal.createObstacle(x1, offset + y1, x2, offset + y2, x3, offset + y3, x4, offset + y4);
                break;
            }
            case 5005: {
                ObstacleRubber.createObstacle(x1, offset + y1, x2, offset + y2, x3, offset + y3, x4, offset + y4);
                break;
            }
            case 5006: {
                ObstacleClay.createObstacle(x1, offset + y1, x2, offset + y2, x3, offset + y3, x4, offset + y4);
            }
        }
    }

    public static void createObstacle(int type, int x1, int y1, int x2, int y2, int x3, int y3, int x4, int y4, String imageName, int angle) {
        int offset = 0;
        if (5002 == type) {
            ObstacleBrick.createObstacle(x1, offset + y1, x2, offset + y2, x3, offset + y3, x4, offset + y4, imageName, angle);
        }
        if (5003 == type) {
            ObstacleGlass.createObstacle(x1, offset + y1, x2, offset + y2, x3, offset + y3, x4, offset + y4, imageName, angle);
        }
        if (5004 == type) {
            ObstacleStone.createObstacle(x1, offset + y1, x2, offset + y2, x3, offset + y3, x4, offset + y4, imageName, angle);
        }
        if (5001 == type) {
            ObstacleWood.createObstacle(x1, offset + y1, x2, offset + y2, x3, offset + y3, x4, offset + y4, imageName, angle);
        }
        if (5007 == type) {
            ObstacleMetal.createObstacle(x1, offset + y1, x2, offset + y2, x3, offset + y3, x4, offset + y4, imageName, angle);
        }
        if (5005 == type) {
            ObstacleRubber.createObstacle(x1, offset + y1, x2, offset + y2, x3, offset + y3, x4, offset + y4, imageName, angle);
        }
        if (5006 == type) {
            ObstacleClay.createObstacle(x1, offset + y1, x2, offset + y2, x3, offset + y3, x4, offset + y4, imageName, angle);
        }
        if (5009 == type) {
            ObstacleDynamite.createObstacle(x1, offset + y1, x2, offset + y2, x3, offset + y3, x4, offset + y4, imageName, angle);
        }
        if (5008 == type) {
            ObstacleBox.createObstacle(x1, offset + y1, x2, offset + y2, x3, offset + y3, x4, offset + y4, imageName, angle);
        }
    }

    public static void createObstacle(int type, int x, int y, int R, String imageName) {
        int offset = 0;
        if (5002 == type) {
            ObstacleBrick.createObstacle(x, offset + y, R);
        }
        if (5003 == type) {
            ObstacleGlass.createObstacle(x, offset + y, R);
        }
        if (5004 == type) {
            ObstacleStone.createObstacle(x, offset + y, R);
        }
        if (5001 == type) {
            ObstacleWood.createObstacle(x, offset + y, R);
        }
        if (5007 == type) {
            ObstacleMetal.createObstacle(x, offset + y, R);
        }
        if (5005 == type) {
            ObstacleRubber.createObstacle(x, offset + y, R);
        }
        if (5006 == type) {
            ObstacleClay.createObstacle(x, offset + y, R, imageName);
        }
    }

    public static void createObstacle(int type, int x1, int y1, int x2, int y2, int x3, int y3, String imageName, int angle) {
        int offset = 0;
        if (5002 == type) {
            ObstacleBrick.createObstacle(x1, offset + y1, x2, offset + y2, x3, offset + y3, imageName, angle);
        }
        if (5003 == type) {
            ObstacleGlass.createObstacle(x1, offset + y1, x2, offset + y2, x3, offset + y3, imageName, angle);
        }
        if (5004 == type) {
            ObstacleStone.createObstacle(x1, offset + y1, x2, offset + y2, x3, offset + y3, imageName, angle);
        }
        if (5001 == type) {
            ObstacleWood.createObstacle(x1, offset + y1, x2, offset + y2, x3, offset + y3, imageName, angle);
        }
        if (5005 == type) {
            ObstacleRubber.createObstacle(x1, offset + y1, x2, offset + y2, x3, offset + y3, imageName, angle);
        }
        if (5007 == type) {
            ObstacleMetal.createObstacle(x1, offset + y1, x2, offset + y2, x3, offset + y3, imageName, angle);
        }
        if (5006 == type) {
            ObstacleClay.createObstacle(x1, offset + y1, x2, offset + y2, x3, offset + y3, imageName, angle);
        }
    }

    public void destroyObstacle() {
        Box2d.destroyGameObject(this.box2dId);
        MyWorld.physicalGameObjects.set(MyWorld.physicalGameObjects.indexOf(this), null);
    }

    public void crushObstacle(Obstacle obj) {
        SpecialEffect.createDestroyObstacle(obj);
    }
}

