/*
 * Decompiled with CFR 0.152.
 */
package com.game.cannonball;

import com.game.cannonball.RectCoordinate;
import com.game.monster.Monster;
import com.game.sprite.SpriteX;
import com.game.util.Graphics2D;
import javax.microedition.lcdui.Image;

public class WateBoom
extends SpriteX {
    private RectCoordinate rect = null;
    private int[] arrayInt = new int[]{-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1};
    int time = 1;
    public boolean isDeath = false;
    private int hp;

    public WateBoom(String path, Image img, int x, int y, int hp) {
        super(path, img);
        this.setPosition(x, y);
        this.setAction(1);
        this.rect = new RectCoordinate();
        this.rect.setWidth(this.getWidth());
        this.rect.setHeight(this.getHeight());
        this.hp = hp;
    }

    public void paintWate(Graphics2D g) {
        if (this.getFrame() != this.getSequenceLength() - 1) {
            super.paint(g);
        } else {
            this.setFrame(this.getSequenceLength() - 1);
            super.paint(g);
        }
        if (this.time % 30 == 0) {
            this.visible = false;
            this.isDeath = true;
        } else {
            ++this.time;
        }
    }

    public boolean collisionWithMonster(Monster monster, int monsterIndex) {
        if (this.isDeath) {
            return false;
        }
        this.rect.setX(this.getX() - this.getWidth() / 2);
        this.rect.setY(this.getY() - this.getHeight() / 2);
        if (!this.rect.collisionWithMonster(monster.getRect())) {
            return false;
        }
        if (this.getFrame() != 2) {
            for (int i = 0; i < this.arrayInt.length; ++i) {
                if (this.arrayInt[i] == monsterIndex) {
                    return false;
                }
                if (this.arrayInt[i] != -1) continue;
                this.arrayInt[i] = monsterIndex;
                monster.changeState(4);
                monster.isDeath(this.hp);
                return false;
            }
        }
        return true;
    }
}

