/*
 * Decompiled with CFR 0.152.
 */
package com.ximad.zuminja.engine;

import com.ximad.zuminja.engine.DataManager;
import java.io.InputStream;
import javax.microedition.media.Manager;
import javax.microedition.media.MediaException;
import javax.microedition.media.Player;
import javax.microedition.media.control.VolumeControl;

public final class SoundHandler {
    private Player player;

    public void playSound(String soundPath) {
        if (!DataManager.getSoundState()) {
            return;
        }
        if (this.player != null) {
            try {
                this.player.stop();
                this.player.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.play(soundPath, "audio/mp3", false);
    }

    public void playSoundInLoop(String soundPath) {
        if (!DataManager.getSoundState()) {
            return;
        }
        if (this.player != null) {
            try {
                this.player.stop();
                this.player.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.play(soundPath, "audio/mp3", true);
    }

    private void play(String soundPath, String type, boolean loop) {
        try {
            InputStream is = this.getClass().getResourceAsStream(soundPath);
            if (is == null) {
                // empty if block
            }
            this.player = Manager.createPlayer((InputStream)is, (String)type);
            this.player.realize();
            this.player.prefetch();
            if (loop) {
                this.player.setLoopCount(-1);
            } else {
                this.player.setLoopCount(1);
            }
            VolumeControl tmp_control = (VolumeControl)this.player.getControl("VolumeControl");
            tmp_control.setLevel(DataManager.getCurrentSoundLvl());
            this.player.start();
        }
        catch (Exception e) {
            // empty catch block
        }
    }

    public void stopSound() {
        if (this.player != null) {
            if (this.player.getState() == 400) {
                try {
                    this.player.stop();
                    this.player.deallocate();
                }
                catch (MediaException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public void setSoundLvl(int lvl) throws MediaException {
        if (this.player != null && this.player.getState() == 400) {
            VolumeControl tmp_control = (VolumeControl)this.player.getControl("VolumeControl");
            tmp_control.setLevel(lvl);
        }
    }
}

