/*
 * Decompiled with CFR 0.152.
 */
package com.ximad.zuminja.game;

import com.ximad.zuminja.engine.Consts;
import com.ximad.zuminja.engine.DataManager;
import com.ximad.zuminja.engine.Utils;
import com.ximad.zuminja.game.Ball;
import com.ximad.zuminja.game.Game;
import com.ximad.zuminja.game.Level;
import com.ximad.zuminja.game.PackedGame;
import com.ximad.zuminja.game.Path;
import com.ximad.zuminja.game.Point;
import java.util.Vector;

public class Track {
    private Game game;
    private int deep;
    private int ballsLeft;
    private int ballsTotal;
    private Point pipePoint;
    private int pipeIndex;
    private Point bridgePoint;
    private int bridgeIndex;
    private int level;
    public double finishSpeed = -1.0;
    private Path path;
    private Vector ballsVector;
    private int levelIndex;
    private int portalState = 0;
    private boolean variable;

    public Path getPath() {
        return this.path;
    }

    public Vector getBallsVector() {
        return this.ballsVector;
    }

    public int getPipeIndex() {
        return this.pipeIndex;
    }

    public Point getPipePoint() {
        return this.pipePoint;
    }

    public Track(Game game, int level, int levelIndex, boolean loadGame) {
        this.game = game;
        this.levelIndex = levelIndex;
        this.level = level;
        if (loadGame) {
            this.loadGame();
        } else {
            this.newGame(level);
        }
    }

    public Ball getBall(int number) {
        return (Ball)this.ballsVector.elementAt(number);
    }

    public int getBallsCount() {
        return this.ballsVector.size();
    }

    public int getBallsLeft() {
        return this.ballsLeft;
    }

    public void deleteBalls(int number) {
        int left = number;
        int right = number;
        int type = this.getBall(number).getType();
        int i = number - 1;
        while (i >= 0 && this.getBall(i).getType() == type && Math.abs(this.getBall(i).getCurrentX() - this.getBall(i + 1).getCurrentX()) <= 36.0 && this.getBall(i).getState() == -1) {
            left = i--;
        }
        i = number + 1;
        while (i < this.getBallsCount() && this.getBall(i).getType() == type && Math.abs(this.getBall(i).getCurrentX() - this.getBall(i - 1).getCurrentX()) <= 36.0 && this.getBall(i).getState() == -1) {
            right = i++;
        }
        int length = right - left + 1;
        if (length >= 3) {
            for (int i2 = left; i2 <= right; ++i2) {
                this.getBall(i2).setState(0);
                if (this.getBall(i2).getBonus() == -1) continue;
                switch (this.getBall(i2).getBonus()) {
                    case 0: {
                        this.game.setSlowTick(250);
                        break;
                    }
                    case 1: {
                        this.game.destroyBalls(Ball.getPoint(this.path, this.getBall(i2).getCurrentX()));
                        break;
                    }
                    case 2: {
                        this.game.setX2Tick(300);
                        break;
                    }
                }
                this.getBall(i2).setBonus(-1);
                this.getBall(i2).setBonusTick(0);
            }
            int modifier = 1;
            if (this.game.getX2Tick() != 0) {
                modifier = 2;
            }
            this.game.setScore(this.game.getScore() + (long)(modifier * (length * this.deep * 2 - 3)));
            this.ballsLeft -= modifier * (length * this.deep * 2 - 3);
            this.ballsLeft = Math.max(0, this.ballsLeft);
            ++this.deep;
            DataManager.playDestroySound();
        }
    }

    public int getPortalState() {
        if (this.portalState == -1) {
            return -1;
        }
        return this.portalState;
    }

    public void tick() {
        double diff;
        Ball ball1;
        Ball ball2;
        int j;
        int i;
        double speed = 0.0;
        if (this.ballsVector.size() == 0) {
            return;
        }
        double lastX = -999.0;
        for (int i2 = this.getBallsCount() - 1; i2 >= 0; --i2) {
            if (this.getBall(i2).getState() != -1) continue;
            lastX = this.getBall(i2).getCurrentX();
        }
        double length = this.path.getLength();
        if (lastX > length * 0.2 || lastX == -999.0) {
            speed = Consts.SPEED_TOUCH[this.level];
            if (this.game.getSlowTick() != 0) {
                speed = speed >= 0.5 ? (speed -= 0.5) : (speed -= 0.25);
            }
        } else {
            speed = 7.0;
        }
        if (lastX > (double)(this.path.getLength() - 18) || this.game.isFinished()) {
            if (!this.game.isFinished()) {
                DataManager.playHoleSound();
            }
            if (this.portalState + 1 != 8) {
                if (this.portalState != -1) {
                    ++this.portalState;
                }
            } else {
                this.portalState = -1;
            }
            this.ballsLeft = 0;
            int last = this.ballsVector.size();
            for (int i3 = 0; i3 < this.ballsVector.size(); ++i3) {
                if (!(this.getBall(i3).getCurrentX() < 0.0)) continue;
                last = i3;
                break;
            }
            while (last < this.ballsVector.size()) {
                this.ballsVector.removeElementAt(last);
            }
            this.finishSpeed = this.finishSpeed == -1.0 ? (speed = 1.0) : (speed = this.finishSpeed + 1.0);
            this.game.finish();
        }
        int lastBall = 0;
        double diffX = speed;
        for (int j2 = this.ballsVector.size() - 1; j2 > 0; --j2) {
            Ball ball22 = this.getBall(j2 - 1);
            Ball ball12 = this.getBall(j2);
            diffX = ball22.getCurrentX() - ball12.getCurrentX();
            if (!(diffX > 36.0)) continue;
            lastBall = j2;
            break;
        }
        for (i = this.ballsVector.size() - 1; i >= lastBall; --i) {
            this.getBall(i).move(this.path, Math.min(speed, diffX));
        }
        if (lastBall < this.ballsVector.size() && lastBall > 0 && (diffX = this.getBall(lastBall - 1).getCurrentX() - this.getBall(lastBall).getCurrentX()) <= 36.0 && this.getBall(lastBall).getType() == this.getBall(lastBall - 1).getType()) {
            this.deleteBalls(lastBall);
        }
        for (i = 0; i < this.ballsVector.size(); ++i) {
            if (this.getBall(i).isMovable()) continue;
            this.ballsVector.removeElementAt(i);
            --i;
            if (this.ballsLeft <= 0 || 50 <= this.ballsVector.size()) continue;
            Ball newBall = this.ballsVector.size() == 0 ? new Ball(0.0, this.level / 5) : new Ball(this.getBall(this.ballsVector.size() - 1).getCurrentX() - 36.0, this.level / 5);
            this.ballsVector.addElement(newBall);
        }
        for (j = this.ballsVector.size() - 1; j > 0; --j) {
            ball2 = this.getBall(j - 1);
            ball1 = this.getBall(j);
            diff = ball2.getCurrentX() - ball1.getCurrentX();
            double diff2 = j > 1 ? this.getBall(j - 2).getCurrentX() - this.getBall(j - 1).getCurrentX() : 0.0;
            if (!(diff < 36.0)) continue;
            ball2.setCurrentX(ball2.getCurrentX() + Math.min(12.0, 36.0 - diff), this.path);
            if (!(diff2 > 36.0) || !(this.getBall(j - 2).getCurrentX() - this.getBall(j - 1).getCurrentX() <= 36.0)) continue;
            this.deleteBalls(j - 1);
        }
        for (j = 1; j < this.ballsVector.size(); ++j) {
            int k;
            ball2 = this.getBall(j - 1);
            ball1 = this.getBall(j);
            diff = ball2.getCurrentX() - ball1.getCurrentX();
            if (!(diff > 36.0) || ball2.getType() != ball1.getType()) continue;
            int fst = -1;
            for (k = j - 2; k >= 0; --k) {
                if (!(this.getBall(k).getCurrentX() - this.getBall(k + 1).getCurrentX() > 36.0)) continue;
                fst = k;
                break;
            }
            for (k = j - 1; k > fst; --k) {
                this.getBall(k).setCurrentX(this.getBall(k).getCurrentX() - Math.min(16.0, this.getBall(k).getCurrentX() - this.getBall(k + 1).getCurrentX() - 36.0), this.path);
            }
            diff = ball2.getCurrentX() - ball1.getCurrentX();
            if (!(diff <= 36.0)) continue;
            this.deleteBalls(j);
        }
        for (j = 0; j < this.ballsVector.size(); ++j) {
            if (!this.getBall(j).nextState()) continue;
            this.ballsVector.removeElementAt(j);
            --j;
        }
        if (this.ballsVector.size() == 0) {
            this.game.endLevel(this.levelIndex);
        }
        if (this.ballsLeft <= 0) {
            for (int a = 0; a < this.getBallsCount(); ++a) {
                if (!(this.getBall(a).getCurrentX() < 0.0)) continue;
                this.ballsVector.removeElementAt(a);
                --a;
            }
        }
        for (j = 0; j < this.ballsVector.size(); ++j) {
            this.getBall(j).nextTick();
        }
    }

    public void newGame(int level) {
        if (level >= 20) {
            level = 19;
        }
        Level thisLevel = DataManager.getLevelWithBackgroundAt(level).getLevel(this.levelIndex);
        this.pipeIndex = thisLevel.getPipeIndex();
        this.pipePoint = thisLevel.getPipePoint();
        this.bridgeIndex = thisLevel.getBridgeIndex();
        this.bridgePoint = thisLevel.getBridgePoint();
        this.ballsTotal = thisLevel.getBallsTotal();
        this.ballsLeft = this.ballsTotal = thisLevel.getBallsTotal();
        this.ballsVector = new Vector(this.ballsTotal);
        int startCount = Math.min(50, this.ballsLeft);
        for (int i = 0; i < startCount; ++i) {
            this.ballsVector.addElement(new Ball(18 * (-2 * i), level / 5));
        }
        this.deep = 1;
        this.path = thisLevel.getPath();
    }

    public void loadGame() {
        int i;
        if (!DataManager.isSavedGameEnabled()) {
            this.newGame(0);
            return;
        }
        PackedGame game = DataManager.loadLevel();
        if (game == null) {
            this.newGame(0);
            return;
        }
        if (game.level < 0) {
            this.newGame(-game.level);
            return;
        }
        Level thisLevel = DataManager.getLevelWithBackgroundAt(this.level).getLevel(this.levelIndex);
        this.pipeIndex = thisLevel.getPipeIndex();
        this.pipePoint = thisLevel.getPipePoint();
        this.bridgeIndex = thisLevel.getBridgeIndex();
        this.bridgePoint = thisLevel.getBridgePoint();
        this.ballsTotal = thisLevel.getBallsTotal();
        this.ballsLeft = game.ballsLeft[this.levelIndex];
        this.ballsVector = new Vector(game.ballsCount[this.levelIndex]);
        int startCount = game.ballsCount[this.levelIndex];
        this.path = thisLevel.getPath();
        this.deep = game.deep[this.levelIndex];
        int tempBallCount = 0;
        for (i = 0; i < this.levelIndex; ++i) {
            tempBallCount += game.ballsCount[i];
        }
        for (i = 0; i < startCount; ++i) {
            Ball ball = new Ball(game.coords[tempBallCount + i], game.types[tempBallCount + i], game.states[tempBallCount + i], game.visible[tempBallCount + i], game.movable[tempBallCount + i], this.path, game.bonus[tempBallCount + i], game.bonusTick[tempBallCount + i]);
            this.ballsVector.addElement(ball);
        }
    }

    public Point getLastPoint() {
        Point point = Ball.getPoint(this.path, this.path.length - 1);
        return point;
    }

    public void setDeep(int i) {
        this.deep = i;
    }

    public int getDeep() {
        return this.deep;
    }

    public int getBridgeIndex() {
        return this.bridgeIndex;
    }

    public Point getBridgePoint() {
        return this.bridgePoint;
    }

    public void addBonus(int bonus) {
        if (Utils.nextInt(50) * 3 / 2 > this.ballsVector.size()) {
            return;
        }
        int maxBall = -1;
        for (int i = 0; i < this.ballsVector.size(); ++i) {
            if (!(this.getBall(i).getCurrentX() >= 0.0)) continue;
            maxBall = i;
        }
        if (maxBall == -1) {
            return;
        }
        int ballNumber = Utils.nextInt(maxBall + 1);
        Ball ball = this.getBall(ballNumber);
        if (ball.getBonus() == -1 && ball.getState() == -1) {
            ball.setBonus(bonus);
            ball.setBonusTick(375);
        }
    }

    public void destroyBalls(Point point) {
        if (point == null) {
            return;
        }
        for (int i = 0; i < this.ballsVector.size(); ++i) {
            double distance;
            Point ballPoint = Ball.getPoint(this.path, this.getBall(i).getCurrentX());
            if (ballPoint == null || !((distance = Math.sqrt(Utils.sqr(point.x - ballPoint.x) + Utils.sqr(point.y - ballPoint.y))) <= 72.0)) continue;
            this.getBall(i).setState(0);
        }
    }
}

