/*
 * Decompiled with CFR 0.152.
 */
package com.ximad.zuminja.screen;

import com.ximad.zuminja.component.BitmapField;
import com.ximad.zuminja.component.CustomButton;
import com.ximad.zuminja.component.UiScreen;
import com.ximad.zuminja.engine.Application;
import com.ximad.zuminja.engine.DataManager;
import com.ximad.zuminja.engine.Resources;
import com.ximad.zuminja.screen.AboutScreen;
import com.ximad.zuminja.screen.ConfirmScreen;
import com.ximad.zuminja.screen.GameScreen;
import com.ximad.zuminja.screen.HelpScreen;
import com.ximad.zuminja.screen.ScoreBoardScreen;
import com.ximad.zuminja.screen.SelectLevelScreen;
import com.ximad.zuminja.screen.SettingsScreen;

public class MainMenuScreen
extends UiScreen {
    boolean isSavedGameEnabled;
    BitmapField resumeGameField;
    CustomButton fakeButton;
    CustomButton aboutButton;
    CustomButton resumeGameButton;
    CustomButton newGameButton;
    CustomButton settingsButton;
    CustomButton highScoresButton;
    CustomButton helpButton;
    CustomButton quitButton;
    CustomButton selectLevelButton;

    public void aboutClick() {
        this.openScreen(new AboutScreen());
    }

    private void resumeGameClick() {
        this.openScreen(new GameScreen(true, 0));
    }

    private void newGameClick() {
        if (!DataManager.isSavedGameEnabled()) {
            Application.setScreen(new GameScreen(false, 0));
            return;
        }
        Application.setScreen(new ConfirmScreen(Resources.confirmNewGame, 304){

            public void yesClick() {
                DataManager.removeLevelData();
                Application.setScreen(new GameScreen(false, 0));
            }

            public boolean onClose() {
                Application.setScreen(new MainMenuScreen());
                return false;
            }

            public void noClick() {
                Application.setScreen(new MainMenuScreen());
            }
        });
    }

    private void settingsClick() {
        Application.setScreen(new SettingsScreen());
    }

    private void highScoresClick() {
        Application.setScreen(new ScoreBoardScreen());
    }

    private void helpClick() {
        Application.setScreen(new HelpScreen());
    }

    private void selectLevelClick() {
        Application.setScreen(new SelectLevelScreen());
    }

    private void quitClick() {
        Application.setScreen(new ConfirmScreen(Resources.confirmQuit, 304){

            public void yesClick() {
                DataManager.stopSound();
                Application.quit();
            }

            public boolean onClose() {
                this.openScreen(new MainMenuScreen());
                return false;
            }

            public void noClick() {
                this.openScreen(new MainMenuScreen());
            }
        });
    }

    public MainMenuScreen() {
        DataManager.playMenuSound();
        this.backgroundBitmap = Resources.getMainMenuBackground();
        this.isSavedGameEnabled = DataManager.isSavedGameEnabled();
        if (this.isSavedGameEnabled) {
            this.resumeGameButton = new CustomButton(Resources.menuResumeOff, Resources.menuResumeOn, null){

                protected void touchAction() {
                    MainMenuScreen.this.resumeGameClick();
                }
            };
        } else {
            this.resumeGameField = new BitmapField(Resources.menuResumeUn);
        }
        this.newGameButton = new CustomButton(Resources.menuNewOff, Resources.menuNewOn, null){

            protected void touchAction() {
                MainMenuScreen.this.newGameClick();
            }
        };
        this.settingsButton = new CustomButton(Resources.menuSettingsOff, Resources.menuSettingsOn, null){

            protected void touchAction() {
                MainMenuScreen.this.settingsClick();
            }
        };
        this.highScoresButton = new CustomButton(Resources.menuScoreOff, Resources.menuScoreOn, null){

            protected void touchAction() {
                MainMenuScreen.this.highScoresClick();
            }
        };
        this.helpButton = new CustomButton(Resources.menuHelpOff, Resources.menuHelpOn, null){

            protected void touchAction() {
                MainMenuScreen.this.helpClick();
            }
        };
        this.selectLevelButton = new CustomButton(Resources.menuSelectOff, Resources.menuSelectOn, null){

            protected void touchAction() {
                MainMenuScreen.this.selectLevelClick();
            }
        };
        this.aboutButton = new CustomButton(Resources.menuAboutOff, Resources.menuAboutOn, null){

            protected void touchAction() {
                MainMenuScreen.this.aboutClick();
            }
        };
        this.quitButton = new CustomButton(Resources.menuExitOff, Resources.menuExitOn, null){

            protected void touchAction() {
                MainMenuScreen.this.quitClick();
            }
        };
        this.add(this.newGameButton, (360 - this.newGameButton.getWidth()) / 2, 46);
        if (this.isSavedGameEnabled) {
            this.add(this.resumeGameButton, (360 - this.resumeGameButton.getWidth()) / 2, 103);
        } else {
            this.add(this.resumeGameField, (360 - this.resumeGameField.getWidth()) / 2, 103);
        }
        this.add(this.selectLevelButton, (360 - this.selectLevelButton.getWidth()) / 2, 166);
        this.add(this.highScoresButton, (360 - this.highScoresButton.getWidth()) / 2, 233);
        this.add(this.settingsButton, (360 - this.settingsButton.getWidth()) / 2, 298);
        this.add(this.helpButton, (360 - this.helpButton.getWidth()) / 2, 360);
        this.add(this.aboutButton, (360 - this.aboutButton.getWidth()) / 2, 421);
        this.add(this.quitButton, (360 - this.quitButton.getWidth()) / 2, 480);
    }
}

