/*
 * Decompiled with CFR 0.152.
 */
package CatchCock;

import CatchCock.mMath;

public class Vector2D {
    public double x;
    public double y;
    float DBL_MAX = 1.79769f;

    Vector2D() {
        this.x = 0.0;
        this.y = 0.0;
    }

    Vector2D(float X, float Y) {
        this.x = X;
        this.y = Y;
    }

    Vector2D(float X, float Y, float l, float a2) {
        this.x = (float)((double)l * Math.cos(a2) + (double)X);
        this.y = (float)((double)l * Math.sin(a2) + (double)Y);
    }

    Vector2D(Vector2D v, float l, float a2) {
        this.x = (float)((double)l * Math.cos(a2) + v.x);
        this.y = (float)((double)l * Math.sin(a2) + v.y);
    }

    Vector2D add(Vector2D other) {
        this.x += other.x;
        this.y += other.y;
        return this;
    }

    Vector2D sub(Vector2D other) {
        this.x -= other.x;
        this.y -= other.y;
        return this;
    }

    Vector2D multiply(float l) {
        this.x *= (double)l;
        this.y *= (double)l;
        return this;
    }

    Vector2D pluseEq(Vector2D other) {
        this.x += other.x;
        this.y += other.y;
        return this;
    }

    Vector2D subEq(Vector2D other) {
        this.x -= other.x;
        this.y -= other.y;
        return this;
    }

    Vector2D multiEq(float l) {
        this.x *= (double)l;
        this.y *= (double)l;
        return this;
    }

    Vector2D signchange() {
        this.x = -1.0 * this.x;
        this.y = -1.0 * this.y;
        return this;
    }

    boolean EqEq(Vector2D other) {
        return this.x == other.x && this.y == other.y;
    }

    boolean notEq(Vector2D other) {
        return this.x != other.x && this.y != other.y;
    }

    void SetX(float X) {
        this.x = X;
    }

    void SetY(float Y) {
        this.y = Y;
    }

    void SetPolarCoordinates(float l, float a2) {
        this.x = (float)((double)l * Math.cos(a2));
        this.y = (float)((double)l * Math.sin(a2));
    }

    void SetLength(float l) {
        this.normalise();
        this.multiEq(l);
    }

    void SetAngle(float a2) {
        this.x = (float)((double)this.GetLength() * Math.cos(a2) + 0.0);
        this.y = (float)((double)this.GetLength() * Math.sin(a2) + 0.0);
    }

    void SetCartesian(float X, float Y) {
        this.x = X;
        this.y = Y;
    }

    void normalise() {
        if (this.x == 0.0 && this.y == 0.0) {
            this.y = 1.0;
            return;
        }
        float invLength = 1.0f / this.GetLength();
        this.x *= (double)invLength;
        this.y *= (double)invLength;
    }

    float GetLength() {
        return (float)Math.sqrt(this.GetLengthSquared());
    }

    void rotate(float a2) {
        float m1 = (float)Math.cos(a2);
        float m2 = (float)Math.sin(a2);
        this.x = (double)m1 * this.x - (double)m2 * this.y;
        this.y = (double)m1 * this.y + (double)m2 * this.x;
    }

    Vector2D rotation(float a2) {
        float m1 = (float)Math.cos(a2);
        float m2 = (float)Math.sin(a2);
        this.x = (double)m1 * this.x - (double)m2 * this.y;
        this.y = (double)m1 * this.y + (double)m2 * this.x;
        return this;
    }

    double GetX() {
        return this.x;
    }

    double GetY() {
        return this.y;
    }

    double GetLengthSquared() {
        return this.x * this.x + this.y * this.y;
    }

    double GetAngle() {
        if (this.x == 0.0) {
            return this.y >= 0.0 ? 1.5707963267948966 : -1.5707963267948966;
        }
        if (this.x > 0.0) {
            return mMath.atan(this.y / this.x);
        }
        return mMath.atan(this.y / this.x) + Math.PI;
    }

    float GetGradient() {
        return (float)(this.x == 0.0 ? (double)this.DBL_MAX : this.y / this.x);
    }

    Vector2D GetPerpendicular() {
        this.y = this.x = -this.y;
        return this;
    }

    Vector2D GetReciprocal() {
        this.x = -this.x;
        this.y = -this.y;
        return this;
    }

    Vector2D GetNormalised() {
        if (this.x == 0.0 && this.y == 0.0) {
            this.x = 0.0;
            this.y = 1.0;
            return this;
        }
        float invLength = 1.0f / this.GetLength();
        this.x = (double)invLength * this.x;
        this.y = (double)invLength * this.y;
        return this;
    }

    float dot(Vector2D other) {
        return (float)(this.x * other.x + this.y * other.y);
    }
}

